/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.frontend;

import weblogic.jms.common.MessageImpl;
import weblogic.jms.frontend.FEConsumer;
import weblogic.jms.frontend.FEProducer;
import weblogic.jms.frontend.FESession;

public final class UnackedMessage {
    private final FEConsumer consumer;
    private final FEProducer producer;
    private final long messageSize;
    private UnackedMessage next;
    private UnackedMessage prev;

    UnackedMessage(FEConsumer fEConsumer, FEProducer fEProducer, MessageImpl messageImpl) {
        this.consumer = fEConsumer;
        this.producer = fEProducer;
        this.messageSize = messageImpl.getPayloadSize() + (long)messageImpl.getUserPropertySize();
    }

    UnackedMessage getNext() {
        return this.next;
    }

    UnackedMessage getPrev() {
        return this.prev;
    }

    void setNext(UnackedMessage unackedMessage) {
        this.next = unackedMessage;
    }

    void setPrev(UnackedMessage unackedMessage) {
        this.prev = unackedMessage;
    }

    void commitTransactedStatistics(FESession fESession) {
        fESession.getStatistics().decrementPendingCount(this.messageSize);
        if (this.consumer != null) {
            this.consumer.statistics.decrementPendingCount(this.messageSize);
            this.consumer.statistics.incrementReceivedCount(this.messageSize);
            fESession.getStatistics().incrementReceivedCount(this.messageSize);
        } else {
            this.producer.decMessagesPendingCount(this.messageSize);
            this.producer.incMessagesSentCount(this.messageSize);
            fESession.getStatistics().incrementSentCount(this.messageSize);
        }
    }

    void rollbackTransactedStatistics(FESession fESession) {
        fESession.getStatistics().decrementPendingCount(this.messageSize);
        if (this.consumer != null) {
            this.consumer.statistics.decrementPendingCount(this.messageSize);
        } else {
            this.producer.decMessagesPendingCount(this.messageSize);
        }
    }
}

