/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.DestinationKeyBean;
import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.j2ee.descriptor.wl.GroupParamsBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.j2ee.descriptor.wl.TemplateBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.jms.extensions.JMSModuleHelper;
import weblogic.management.ManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.GenericBeanListener;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.FileUtils;

public abstract class JMSBeanHelper
extends JMSModuleHelper {
    public static final String INTEROP_APPLICATION_NAME = "interop-jms";
    private static final String DECORATION_SEPARATOR = "!";
    public static final HashMap destinationBeanSignatures;
    public static final HashMap destinationKeyBeanSignatures;
    public static final HashMap thresholdBeanSignatures;
    public static final HashMap deliveryOverridesSignatures;
    public static final HashMap deliveryFailureSignatures;
    public static final HashMap messageLoggingSignatures;
    public static final HashMap templateBeanSignatures;
    public static final HashMap multicastBeanSignatures;
    public static final HashMap distributedTopicBeanSignatures;
    public static final HashMap distributedTopicAdditionSignatures;
    public static final HashMap distributedQueueBeanSignatures;
    public static final HashMap distributedQueueAdditionSignatures;
    public static final HashMap uniformDistributedTopicBeanSignatures;
    public static final HashMap uniformDistributedQueueBeanSignatures;
    public static final HashMap localDestinationBeanSignatures;
    public static final HashMap localDeliveryFailureSignatures;
    private static final AuthenticatedSubject kernelId;
    private static final String DEFAULT_APPENDIX = "-jms.xml";

    public static void copyTemplateBean(TemplateBean templateBean, JMSBean jMSBean, TemplateBean templateBean2) throws ManagementException {
        GroupParamsBean[] groupParamsBeanArray;
        QuotaBean quotaBean;
        GenericBeanListener genericBeanListener = new GenericBeanListener((DescriptorBean)templateBean2, (Object)templateBean, (Map)templateBeanSignatures, false);
        genericBeanListener.initialize(false);
        genericBeanListener = new GenericBeanListener((DescriptorBean)templateBean2.getThresholds(), (Object)templateBean.getThresholds(), (Map)thresholdBeanSignatures, false);
        genericBeanListener.initialize(false);
        genericBeanListener = new GenericBeanListener((DescriptorBean)templateBean2.getDeliveryParamsOverrides(), (Object)templateBean.getDeliveryParamsOverrides(), (Map)deliveryOverridesSignatures, false);
        genericBeanListener.initialize(false);
        genericBeanListener = new GenericBeanListener((DescriptorBean)templateBean2.getDeliveryFailureParams(), (Object)templateBean.getDeliveryFailureParams(), (Map)deliveryFailureSignatures, false);
        genericBeanListener.initialize(false);
        genericBeanListener = new GenericBeanListener((DescriptorBean)templateBean2.getMulticast(), (Object)templateBean.getMulticast(), (Map)multicastBeanSignatures, false);
        genericBeanListener.initialize(false);
        genericBeanListener = new GenericBeanListener((DescriptorBean)templateBean2.getMessageLoggingParams(), (Object)templateBean.getMessageLoggingParams(), (Map)messageLoggingSignatures, false);
        genericBeanListener.initialize(false);
        if (templateBean2.isSet("Quota")) {
            quotaBean = templateBean2.getQuota();
            if (quotaBean == null) {
                templateBean.setQuota(null);
            } else {
                templateBean.setQuota(jMSBean.lookupQuota(quotaBean.getName()));
            }
        }
        if ((quotaBean = templateBean2.getDeliveryFailureParams()).isSet("ErrorDestination")) {
            groupParamsBeanArray = templateBean.getDeliveryFailureParams();
            DestinationBean destinationBean = quotaBean.getErrorDestination();
            if (destinationBean == null) {
                groupParamsBeanArray.setErrorDestination(null);
            } else if (destinationBean instanceof QueueBean) {
                groupParamsBeanArray.setErrorDestination((DestinationBean)jMSBean.lookupQueue(destinationBean.getName()));
            } else {
                groupParamsBeanArray.setErrorDestination((DestinationBean)jMSBean.lookupTopic(destinationBean.getName()));
            }
        }
        if ((groupParamsBeanArray = templateBean2.getGroupParams()) != null) {
            for (int i = 0; i < groupParamsBeanArray.length; ++i) {
                GroupParamsBean groupParamsBean = groupParamsBeanArray[i];
                GroupParamsBean groupParamsBean2 = templateBean.createGroupParams(groupParamsBean.getSubDeploymentName());
                groupParamsBean2.setErrorDestination(groupParamsBean.getErrorDestination());
            }
        }
    }

    public static void copyDestinationKeyBean(JMSBean jMSBean, JMSBean jMSBean2, String string) throws ManagementException {
        jMSBean.createDestinationKey(string);
        DestinationKeyBean destinationKeyBean = jMSBean2.lookupDestinationKey(string);
        DestinationKeyBean destinationKeyBean2 = jMSBean.lookupDestinationKey(string);
        GenericBeanListener genericBeanListener = new GenericBeanListener((DescriptorBean)destinationKeyBean, (Object)destinationKeyBean2, (Map)destinationKeyBeanSignatures, false);
        genericBeanListener.initialize(false);
    }

    public static JMSInteropModuleMBean getJMSInteropModule(DomainMBean domainMBean) {
        if (domainMBean == null) {
            return null;
        }
        JMSInteropModuleMBean[] jMSInteropModuleMBeanArray = domainMBean.getJMSInteropModules();
        if (jMSInteropModuleMBeanArray.length <= 0) {
            return null;
        }
        return jMSInteropModuleMBeanArray[0];
    }

    public static JMSInteropModuleMBean getJMSInteropModule() {
        return JMSBeanHelper.getJMSInteropModule(ManagementService.getRuntimeAccess(kernelId).getDomain());
    }

    public static JMSBean getInteropJMSBean(DomainMBean domainMBean) {
        if (domainMBean == null) {
            return null;
        }
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(domainMBean);
        if (jMSInteropModuleMBean == null) {
            return null;
        }
        return jMSInteropModuleMBean.getJMSResource();
    }

    public static JMSBean getInteropJMSBean() {
        return JMSBeanHelper.getInteropJMSBean(ManagementService.getRuntimeAccess(kernelId).getDomain());
    }

    public static JMSSystemResourceMBean addInteropApplication(DomainMBean domainMBean) {
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(domainMBean);
        if (jMSInteropModuleMBean == null) {
            jMSInteropModuleMBean = domainMBean.createJMSInteropModule(INTEROP_APPLICATION_NAME);
        }
        return jMSInteropModuleMBean;
    }

    public static JMSSystemResourceMBean addInteropApplication() {
        return JMSBeanHelper.addInteropApplication(ManagementService.getRuntimeAccess(kernelId).getDomain());
    }

    public static SubDeploymentMBean findSubDeployment(String string, BasicDeploymentMBean basicDeploymentMBean) {
        if (basicDeploymentMBean == null || string == null) {
            return null;
        }
        SubDeploymentMBean[] subDeploymentMBeanArray = basicDeploymentMBean.getSubDeployments();
        if (subDeploymentMBeanArray == null) {
            return null;
        }
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            SubDeploymentMBean subDeploymentMBean = subDeploymentMBeanArray[i];
            if (!string.equals(subDeploymentMBean.getName())) continue;
            return subDeploymentMBean;
        }
        return null;
    }

    public static String getDecoratedName(String string, String string2) {
        if (string == null || INTEROP_APPLICATION_NAME.equals(string)) {
            return string2;
        }
        return string + DECORATION_SEPARATOR + string2;
    }

    public static TargetMBean[] getSubDeploymentTargets(String string, BasicDeploymentMBean basicDeploymentMBean) {
        SubDeploymentMBean[] subDeploymentMBeanArray = basicDeploymentMBean.getSubDeployments();
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            if (!string.equals(subDeploymentMBeanArray[i].getName())) continue;
            return subDeploymentMBeanArray[i].getTargets();
        }
        return new TargetMBean[0];
    }

    public static DomainMBean getDomain(WebLogicMBean webLogicMBean) throws IllegalArgumentException {
        DescriptorBean descriptorBean = (DescriptorBean)webLogicMBean;
        DescriptorBean descriptorBean2 = descriptorBean.getDescriptor().getRootBean();
        if (!(descriptorBean2 instanceof DomainMBean)) {
            throw new IllegalArgumentException("could not get DomainMbean from " + webLogicMBean.getName() + ".  My root has type " + descriptorBean2.getClass().getName());
        }
        return (DomainMBean)descriptorBean2;
    }

    public static String constructDefaultJMSSystemFilename(String string) {
        String string2 = string.toLowerCase().trim();
        if (string2.endsWith("-jms")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        String string3 = "jms/" + FileUtils.mapNameToFileName((String)string2) + DEFAULT_APPENDIX;
        return string3;
    }

    public static void destroyDestination(JMSBean jMSBean, DestinationBean destinationBean) {
        if (destinationBean instanceof QueueBean) {
            jMSBean.destroyQueue((QueueBean)destinationBean);
        } else {
            jMSBean.destroyTopic((TopicBean)destinationBean);
        }
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        destinationBeanSignatures = new HashMap();
        destinationKeyBeanSignatures = new HashMap();
        thresholdBeanSignatures = new HashMap();
        deliveryOverridesSignatures = new HashMap();
        deliveryFailureSignatures = new HashMap();
        messageLoggingSignatures = new HashMap();
        templateBeanSignatures = new HashMap();
        multicastBeanSignatures = new HashMap();
        distributedTopicBeanSignatures = new HashMap();
        distributedTopicAdditionSignatures = new HashMap();
        distributedQueueBeanSignatures = new HashMap();
        distributedQueueAdditionSignatures = new HashMap();
        uniformDistributedTopicBeanSignatures = new HashMap();
        uniformDistributedQueueBeanSignatures = new HashMap();
        localDestinationBeanSignatures = new HashMap();
        localDeliveryFailureSignatures = new HashMap();
        destinationBeanSignatures.put("DestinationKeys", String[].class);
        destinationBeanSignatures.put("AttachSender", String.class);
        destinationBeanSignatures.put("ProductionPausedAtStartup", Boolean.TYPE);
        destinationBeanSignatures.put("InsertionPausedAtStartup", Boolean.TYPE);
        destinationBeanSignatures.put("ConsumptionPausedAtStartup", Boolean.TYPE);
        destinationBeanSignatures.put("MaximumMessageSize", Integer.TYPE);
        destinationBeanSignatures.put("MessagingPerformancePreference", Integer.TYPE);
        destinationBeanSignatures.put("JNDIName", String.class);
        destinationBeanSignatures.put("LocalJNDIName", String.class);
        destinationBeanSignatures.put("JMSCreateDestinationIdentifier", String.class);
        destinationBeanSignatures.put("DefaultUnitOfOrder", Boolean.TYPE);
        destinationBeanSignatures.put("SAFExportPolicy", String.class);
        destinationBeanSignatures.put("UnitOfWorkHandlingPolicy", String.class);
        destinationBeanSignatures.put("IncompleteWorkExpirationTime", Integer.TYPE);
        destinationBeanSignatures.put("DefaultTargetingEnabled", Boolean.TYPE);
        destinationKeyBeanSignatures.put("Property", String.class);
        destinationKeyBeanSignatures.put("KeyType", String.class);
        destinationKeyBeanSignatures.put("SortOrder", String.class);
        thresholdBeanSignatures.put("BytesHigh", Long.TYPE);
        thresholdBeanSignatures.put("BytesLow", Long.TYPE);
        thresholdBeanSignatures.put("MessagesHigh", Long.TYPE);
        thresholdBeanSignatures.put("MessagesLow", Long.TYPE);
        deliveryOverridesSignatures.put("DeliveryMode", String.class);
        deliveryOverridesSignatures.put("TimeToDeliver", String.class);
        deliveryOverridesSignatures.put("TimeToLive", Long.TYPE);
        deliveryOverridesSignatures.put("Priority", Integer.TYPE);
        deliveryOverridesSignatures.put("RedeliveryDelay", Long.TYPE);
        deliveryFailureSignatures.put("RedeliveryLimit", Integer.TYPE);
        deliveryFailureSignatures.put("ExpirationPolicy", String.class);
        deliveryFailureSignatures.put("ExpirationLoggingPolicy", String.class);
        messageLoggingSignatures.put("MessageLoggingFormat", String.class);
        messageLoggingSignatures.put("MessageLoggingEnabled", Boolean.TYPE);
        templateBeanSignatures.put("DestinationKeys", String[].class);
        templateBeanSignatures.put("AttachSender", String.class);
        templateBeanSignatures.put("ProductionPausedAtStartup", Boolean.TYPE);
        templateBeanSignatures.put("InsertionPausedAtStartup", Boolean.TYPE);
        templateBeanSignatures.put("ConsumptionPausedAtStartup", Boolean.TYPE);
        templateBeanSignatures.put("MaximumMessageSize", Integer.TYPE);
        templateBeanSignatures.put("MessagingPerformancePreference", Integer.TYPE);
        multicastBeanSignatures.put("MulticastAddress", String.class);
        multicastBeanSignatures.put("MulticastPort", Integer.TYPE);
        multicastBeanSignatures.put("MulticastTimeToLive", Integer.TYPE);
        distributedTopicBeanSignatures.put("JNDIName", String.class);
        distributedTopicBeanSignatures.put("LoadBalancingPolicy", String.class);
        distributedTopicBeanSignatures.put("UnitOfOrderRouting", String.class);
        distributedTopicBeanSignatures.put("SAFExportPolicy", String.class);
        distributedTopicAdditionSignatures.put("DistributedTopicMembers", DistributedDestinationMemberBean.class);
        distributedQueueBeanSignatures.put("JNDIName", String.class);
        distributedQueueBeanSignatures.put("LoadBalancingPolicy", String.class);
        distributedQueueBeanSignatures.put("UnitOfOrderRouting", String.class);
        distributedQueueBeanSignatures.put("ForwardDelay", Integer.TYPE);
        distributedQueueBeanSignatures.put("SAFExportPolicy", String.class);
        distributedQueueAdditionSignatures.put("DistributedQueueMembers", DistributedDestinationMemberBean.class);
        uniformDistributedTopicBeanSignatures.put("JNDIName", String.class);
        uniformDistributedTopicBeanSignatures.put("LoadBalancingPolicy", String.class);
        uniformDistributedTopicBeanSignatures.put("ForwardingPolicy", String.class);
        uniformDistributedTopicBeanSignatures.put("UnitOfOrderRouting", String.class);
        uniformDistributedTopicBeanSignatures.put("SAFExportPolicy", String.class);
        uniformDistributedQueueBeanSignatures.put("JNDIName", String.class);
        uniformDistributedQueueBeanSignatures.put("LoadBalancingPolicy", String.class);
        uniformDistributedQueueBeanSignatures.put("UnitOfOrderRouting", String.class);
        uniformDistributedQueueBeanSignatures.put("ForwardDelay", Integer.TYPE);
        uniformDistributedQueueBeanSignatures.put("SAFExportPolicy", String.class);
        localDestinationBeanSignatures.put("Quota", QuotaBean.class);
        localDeliveryFailureSignatures.put("ErrorDestination", DestinationBean.class);
    }
}

