/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.jms.JMSLogger;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.MBeanConverter;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ForeignJMSServerMBean;
import weblogic.management.configuration.JMSConnectionFactoryMBean;
import weblogic.management.configuration.JMSConstants;
import weblogic.management.configuration.JMSDestinationKeyMBean;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.management.configuration.JMSDistributedQueueMBean;
import weblogic.management.configuration.JMSDistributedTopicMBean;
import weblogic.management.configuration.JMSQueueMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.JMSTemplateMBean;
import weblogic.management.configuration.JMSTopicMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;

public class JMSConfigurationProcessor
implements ConfigurationProcessor {
    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        TargetMBean[] targetMBeanArray;
        ArrayList arrayList;
        HashMap hashMap;
        DeploymentMBean deploymentMBean;
        int n;
        JMSTemplateMBean[] jMSTemplateMBeanArray;
        JMSDistributedTopicMBean[] jMSDistributedTopicMBeanArray;
        JMSConstants[] jMSConstantsArray;
        JMSDestinationMBean[] jMSDestinationMBeanArray;
        ForeignJMSServerMBean[] foreignJMSServerMBeanArray;
        JMSConnectionFactoryMBean[] jMSConnectionFactoryMBeanArray;
        boolean bl = false;
        JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray = domainMBean.getJMSDestinationKeys();
        if (jMSDestinationKeyMBeanArray != null && jMSDestinationKeyMBeanArray.length > 0) {
            bl = true;
        }
        if ((jMSConnectionFactoryMBeanArray = domainMBean.getJMSConnectionFactories()) != null && jMSConnectionFactoryMBeanArray.length > 0) {
            bl = true;
        }
        if ((foreignJMSServerMBeanArray = domainMBean.getForeignJMSServers()) != null && foreignJMSServerMBeanArray.length > 0) {
            bl = true;
        }
        JMSServerMBean[] jMSServerMBeanArray = domainMBean.getJMSServers();
        LinkedList<JMSDestinationMBean> linkedList = new LinkedList<JMSDestinationMBean>();
        LinkedList<JMSConstants> linkedList2 = new LinkedList<JMSConstants>();
        if (jMSServerMBeanArray != null) {
            for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
                jMSDestinationMBeanArray = jMSServerMBeanArray[i].getJMSQueues();
                if (jMSDestinationMBeanArray != null) {
                    for (int j = 0; j < jMSDestinationMBeanArray.length; ++j) {
                        bl = true;
                        linkedList.add(jMSDestinationMBeanArray[j]);
                    }
                }
                if ((jMSConstantsArray = jMSServerMBeanArray[i].getJMSTopics()) == null) continue;
                for (int j = 0; j < jMSConstantsArray.length; ++j) {
                    bl = true;
                    linkedList2.add(jMSConstantsArray[j]);
                }
            }
        }
        JMSQueueMBean[] jMSQueueMBeanArray = null;
        if (linkedList.size() > 0) {
            jMSQueueMBeanArray = new JMSQueueMBean[linkedList.size()];
            jMSQueueMBeanArray = linkedList.toArray(jMSQueueMBeanArray);
        }
        jMSDestinationMBeanArray = null;
        if (linkedList2.size() > 0) {
            jMSDestinationMBeanArray = new JMSTopicMBean[linkedList2.size()];
            jMSDestinationMBeanArray = (JMSTopicMBean[])linkedList2.toArray(jMSDestinationMBeanArray);
        }
        if ((jMSConstantsArray = domainMBean.getJMSDistributedQueues()) != null && jMSConstantsArray.length > 0) {
            bl = true;
        }
        if ((jMSDistributedTopicMBeanArray = domainMBean.getJMSDistributedTopics()) != null && jMSDistributedTopicMBeanArray.length > 0) {
            bl = true;
        }
        if ((jMSTemplateMBeanArray = domainMBean.getJMSTemplates()) != null && jMSTemplateMBeanArray.length > 0) {
            bl = true;
        }
        if (!bl) {
            return;
        }
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(domainMBean);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        if (jMSDestinationKeyMBeanArray != null) {
            for (n = 0; n < jMSDestinationKeyMBeanArray.length; ++n) {
                MBeanConverter.addDestinationKey(jMSBean, jMSDestinationKeyMBeanArray[n]);
            }
        }
        if (jMSConnectionFactoryMBeanArray != null) {
            for (n = 0; n < jMSConnectionFactoryMBeanArray.length; ++n) {
                deploymentMBean = jMSConnectionFactoryMBeanArray[n];
                hashMap = MBeanConverter.splitDeployment(deploymentMBean);
                if (hashMap.size() >= 1) {
                    JMSLogger.logSplitDeployment((String)"JMSConnectionFactory", (String)deploymentMBean.getName());
                    for (String string : hashMap.keySet()) {
                        arrayList = (ArrayList)hashMap.get(string);
                        targetMBeanArray = arrayList.toArray(new TargetMBean[0]);
                        MBeanConverter.addJMSConnectionFactory(jMSBean, jMSSystemResourceMBean, (JMSConnectionFactoryMBean)deploymentMBean, string, targetMBeanArray);
                    }
                    continue;
                }
                MBeanConverter.addJMSConnectionFactory(jMSBean, jMSSystemResourceMBean, (JMSConnectionFactoryMBean)deploymentMBean, deploymentMBean.getName(), deploymentMBean.getTargets());
            }
        }
        if (foreignJMSServerMBeanArray != null) {
            for (n = 0; n < foreignJMSServerMBeanArray.length; ++n) {
                deploymentMBean = foreignJMSServerMBeanArray[n];
                hashMap = MBeanConverter.splitDeployment(deploymentMBean);
                if (hashMap.size() >= 1) {
                    JMSLogger.logSplitDeployment((String)"ForeignJMSServer", (String)deploymentMBean.getName());
                    for (String string : hashMap.keySet()) {
                        arrayList = (ArrayList)hashMap.get(string);
                        targetMBeanArray = arrayList.toArray(new TargetMBean[0]);
                        MBeanConverter.addForeignJMSServer(jMSBean, jMSSystemResourceMBean, (ForeignJMSServerMBean)deploymentMBean, string, targetMBeanArray);
                    }
                    continue;
                }
                MBeanConverter.addForeignJMSServer(jMSBean, jMSSystemResourceMBean, (ForeignJMSServerMBean)deploymentMBean, deploymentMBean.getName(), deploymentMBean.getTargets());
            }
        }
        if (jMSQueueMBeanArray != null) {
            for (n = 0; n < jMSQueueMBeanArray.length; ++n) {
                MBeanConverter.addQueue(jMSBean, jMSSystemResourceMBean, jMSQueueMBeanArray[n]);
            }
        }
        if (jMSDestinationMBeanArray != null) {
            for (n = 0; n < jMSDestinationMBeanArray.length; ++n) {
                MBeanConverter.addTopic(jMSBean, jMSSystemResourceMBean, (JMSTopicMBean)jMSDestinationMBeanArray[n]);
            }
        }
        if (jMSConstantsArray != null) {
            for (n = 0; n < jMSConstantsArray.length; ++n) {
                MBeanConverter.addDistributedQueue(jMSBean, jMSSystemResourceMBean, (JMSDistributedQueueMBean)jMSConstantsArray[n]);
            }
        }
        if (jMSDistributedTopicMBeanArray != null) {
            for (n = 0; n < jMSDistributedTopicMBeanArray.length; ++n) {
                MBeanConverter.addDistributedTopic(jMSBean, jMSSystemResourceMBean, jMSDistributedTopicMBeanArray[n]);
            }
        }
        if (jMSTemplateMBeanArray != null) {
            for (n = 0; n < jMSTemplateMBeanArray.length; ++n) {
                MBeanConverter.addTemplate(jMSBean, jMSTemplateMBeanArray[n]);
            }
        }
    }
}

