/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.io.File;
import weblogic.application.Deployment;
import weblogic.application.Module;
import weblogic.application.internal.SingleModuleDeployment;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.jms.module.JMSModule;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;

public final class JMSDeployment
extends SingleModuleDeployment
implements Deployment {
    public JMSDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        super(appDeploymentMBean, JMSDeployment.createModule(appDeploymentMBean), file);
    }

    public JMSDeployment(SystemResourceMBean systemResourceMBean, File file) throws DeploymentException {
        super(systemResourceMBean, JMSDeployment.createModule(systemResourceMBean), file);
    }

    private static Module createModule(AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        if (appDeploymentMBean == null) {
            throw new DeploymentException("AppDepoymentMBean cannot be null. Please check the server log related error messages");
        }
        SubDeploymentMBean[] subDeploymentMBeanArray = appDeploymentMBean.getSubDeployments();
        if (subDeploymentMBeanArray != null) {
            for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
                SubDeploymentMBean[] subDeploymentMBeanArray2 = subDeploymentMBeanArray[i].getSubDeployments();
                if (subDeploymentMBeanArray2 == null || subDeploymentMBeanArray2.length <= 0) continue;
                throw new DeploymentException("Application " + ApplicationVersionUtils.getDisplayName(appDeploymentMBean) + " is a not a stand alone JMS deployment, it contains nested sub deployments.");
            }
        }
        return new JMSModule(appDeploymentMBean.getSourcePath());
    }

    private static Module createModule(SystemResourceMBean systemResourceMBean) throws DeploymentException {
        if (systemResourceMBean == null) {
            throw new DeploymentException("SystemResourceMBean cannot be null. Please check the server log related error messages");
        }
        String string = systemResourceMBean.getDescriptorFileName();
        if (string == null) {
            throw new DeploymentException("JMSSystemResource " + ApplicationVersionUtils.getDisplayName(systemResourceMBean) + " does not have a descriptor file name");
        }
        return new JMSModule(string);
    }
}

