/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.io.File;
import java.io.IOException;
import weblogic.application.Deployment;
import weblogic.application.DeploymentFactory;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.module.JMSDeployment;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.SystemResourceMBean;

public final class JMSDeploymentFactory
implements DeploymentFactory {
    private boolean isJMS(File file) throws IOException {
        if (file.isDirectory()) {
            return false;
        }
        return file.getName().endsWith("-jms.xml");
    }

    public Deployment createDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        try {
            if (!this.isJMS(file)) {
                return null;
            }
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("Creating a standalone JMS Module with file : " + file.getAbsolutePath());
            }
            return new JMSDeployment(appDeploymentMBean, file);
        }
        catch (IOException iOException) {
            throw new DeploymentException(iOException);
        }
    }

    public Deployment createDeployment(SystemResourceMBean systemResourceMBean, File file) throws DeploymentException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Creating a system resource JMS Module with file : " + file.getAbsolutePath());
        }
        if (systemResourceMBean instanceof JMSSystemResourceMBean) {
            return new JMSDeployment(systemResourceMBean, file);
        }
        return null;
    }
}

