/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.security.AccessController;
import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class JMSDeploymentHelper {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static String getMemberName(String string, DistributedDestinationMemberBean distributedDestinationMemberBean) {
        String string2 = distributedDestinationMemberBean.getPhysicalDestinationName();
        if ("interop-jms".equals(string)) {
            return string2;
        }
        return string + "!" + string2;
    }

    public static String getMigratableTargetName(String string) {
        JMSServerMBean jMSServerMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().lookupJMSServer(string);
        if (jMSServerMBean == null) {
            return null;
        }
        TargetMBean[] targetMBeanArray = jMSServerMBean.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            return null;
        }
        if (!(targetMBeanArray[0] instanceof MigratableTargetMBean)) {
            return null;
        }
        return targetMBeanArray[0].getName();
    }

    public static String getDomainName() {
        if (ManagementService.getRuntimeAccess(KERNEL_ID) != null) {
            return ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().getName();
        }
        return null;
    }
}

