/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ModuleException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorUpdateFailedException;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.NamedEntityBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.TargetableBean;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEDDEntityProvider;
import weblogic.jms.backend.BEUDDEntityProvider;
import weblogic.jms.backend.DestinationEntityProvider;
import weblogic.jms.common.EntityName;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.foreign.ForeignJMSEntityProvider;
import weblogic.jms.frontend.JmsConnectionFactoryEntityProvider;
import weblogic.jms.module.JMSModuleManagedEntity;
import weblogic.jms.module.JMSModuleManagedEntityProvider;
import weblogic.jms.module.JMSParser;
import weblogic.jms.module.ModuleCoordinator;
import weblogic.jms.module.TargetingHelper;
import weblogic.jms.module.UpdateInformation;
import weblogic.jms.module.validators.JMSModuleValidator;
import weblogic.jms.saf.ErrorHandlingProvider;
import weblogic.jms.saf.JMSSAFImportedDestinationsEntityProvider;
import weblogic.jms.saf.RemoteContextProvider;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.utils.StackTraceUtils;

public class JMSModule
extends ModuleCoordinator {
    private static final JMSModuleManagedEntityProvider DESTINATION_PROVIDER = new DestinationEntityProvider();
    private static final JMSModuleManagedEntityProvider DD_PROVIDER = new BEDDEntityProvider();
    private static final JMSModuleManagedEntityProvider UDD_PROVIDER = new BEUDDEntityProvider();
    private static final JMSModuleManagedEntityProvider SAF_PROVIDER = new JMSSAFImportedDestinationsEntityProvider();
    private static final JMSModuleManagedEntityProvider CONN_PROVIDER = new JmsConnectionFactoryEntityProvider();
    private static final JMSModuleManagedEntityProvider FOREIGN_PROVIDER = new ForeignJMSEntityProvider();
    private static final ErrorHandlingProvider ERROR_HANDLING_PROVIDER = new ErrorHandlingProvider();
    private static final RemoteContextProvider REMOTE_CONTEXT_PROVIDER = new RemoteContextProvider();
    private static final int NONEXISTENT_TYPE = 0;
    private static final int TARGETED_TYPE = 1;
    private static final int UBIQUITOUS_TARGETED_TYPE = 2;
    private static final int UBIQUITOUS_NONTARGETED_TYPE = 3;
    private static final int QUEUE_TYPE = 0;
    private static final int TOPIC_TYPE = 1;
    private static final int DISTRIBUTED_QUEUE_TYPE = 2;
    private static final int DISTRIBUTED_TOPIC_TYPE = 3;
    private static final int UNIFORM_DISTRIBUTED_QUEUE_TYPE = 4;
    private static final int UNIFORM_DISTRIBUTED_TOPIC_TYPE = 5;
    private static final int REMOTE_CONTEXT_TYPE = 6;
    private static final int JMS_SAF_IMPORTED_DESTINATIONS_TYPE = 7;
    private static final int ERROR_HANDLING_TYPE = 8;
    private static final int JMS_CONNECTION_FACTORY_TYPE = 9;
    private static final int FOREIGN_TYPE = 10;
    static final int MAX_TYPE = 11;
    private static final String QUOTA_STRING = "Quotas";
    private static final String QUEUE_STRING = "Queues";
    private static final String TOPIC_STRING = "Topics";
    private static final String FOREIGN_STRING = "ForeignServers";
    private static final String DISTRIBUTED_QUEUE_STRING = "DistributedQueues";
    private static final String DISTRIBUTED_TOPIC_STRING = "DistributedTopics";
    private static final String JMS_CONNECTION_FACTORY_STRING = "ConnectionFactories";
    private static final String SAF_IMPORTED_DESTINATIONS_STRING = "SAFImportedDestinations";
    private static final String SAF_REMOTE_CONTEXT_STRING = "SAFRemoteContexts";
    private static final String SAF_ERROR_HANDLING_STRING = "SAFErrorHandlings";
    private static final String UNIFORM_DISTRIBUTED_QUEUE_STRING = "UniformDistributedQueues";
    private static final String UNIFORM_DISTRIBUTED_TOPIC_STRING = "UniformDistributedTopics";
    private static final String TEMPLATE_STRING = "Templates";
    private static final String DESTINATION_KEY_STRING = "DestinationKeys";
    private static final int INIT_STATE = 0;
    private static final int PREP_STATE = 1;
    private static final int ACTI_STATE = 2;
    private static final int DONE_STATE = 3;
    private static final int DEAD_STATE = 4;
    private static final int CHNG_STATE = 5;
    private LinkedList[] allEntities;
    private JMSBean wholeModule;
    private Context applicationNamingContext;
    private JMSModuleListener moduleListener;
    private static final HashMap indexInfo = new HashMap();

    JMSModule(String string, String string2) {
        super(string2, string);
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule:constructor paramUri: " + string + " paramModule: " + string2);
        }
        this.allEntities = new LinkedList[11];
        for (int i = 0; i < 11; ++i) {
            this.allEntities[i] = new LinkedList();
        }
    }

    JMSModule(String string) {
        this(string, null);
    }

    protected DescriptorBean getModuleDescriptor() {
        return (DescriptorBean)this.wholeModule;
    }

    protected void initializeModule(ApplicationContextInternal applicationContextInternal, DomainMBean domainMBean) throws ModuleException {
        BasicDeploymentMBean basicDeploymentMBean = this.getBasicDeployment(domainMBean);
        this.wholeModule = JMSParser.createJMSDescriptor(applicationContextInternal, basicDeploymentMBean, this.getId());
        AppDeploymentMBean appDeploymentMBean = applicationContextInternal.getAppDeploymentMBean();
        if (appDeploymentMBean != null) {
            try {
                JMSModuleValidator.validateTargeting(this.wholeModule, appDeploymentMBean, this.getTargetingBean(domainMBean));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ModuleException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
        this.targeter = new TargetingHelper(this, domainMBean, this.moduleName.getEARModuleName(), applicationContextInternal.getApplicationId());
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("=== JMSModule:internalInit(): from application " + this.getId() + " Tree === ");
            DescriptorUtils.writeAsXML((DescriptorBean)this.wholeModule);
        }
        this.processEntities(null, null, domainMBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void prepare(DomainMBean domainMBean) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule:prepare() called in " + this.moduleName);
        }
        LinkedList<EntityState> linkedList = new LinkedList<EntityState>();
        boolean bl = false;
        try {
            LinkedList[] linkedListArray = this.allEntities;
            synchronized (this.allEntities) {
                for (int i = 0; i < 11; ++i) {
                    for (EntityState entityState : this.allEntities[i]) {
                        entityState.setState(1);
                        linkedList.addFirst(entityState);
                    }
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (bl) throw throwable;
            for (EntityState entityState : linkedList) {
                try {
                    entityState.setState(0);
                }
                catch (ModuleException moduleException) {
                    JMSLogger.logUnprepareFailedInPrepare((String)entityState.getName(), (String)this.moduleName.toString(), (String)moduleException.toString());
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void activate(DomainMBean domainMBean) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule:activate() called in " + this.moduleName);
        }
        this.targeter.activate();
        LinkedList<EntityState> linkedList = new LinkedList<EntityState>();
        boolean bl = false;
        try {
            DescriptorBean descriptorBean = this.allEntities;
            synchronized (descriptorBean) {
                for (int i = 0; i < 11; ++i) {
                    for (EntityState entityState : this.allEntities[i]) {
                        entityState.setState(2);
                        linkedList.addFirst(entityState);
                    }
                }
            }
            this.moduleListener = new JMSModuleListener();
            descriptorBean = (DescriptorBean)this.wholeModule;
            descriptorBean.addBeanUpdateListener((BeanUpdateListener)this.moduleListener);
            return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (bl) throw throwable;
            for (EntityState entityState : linkedList) {
                try {
                    entityState.setState(1);
                }
                catch (ModuleException moduleException) {
                    JMSLogger.logDeactivateFailedInActivate((String)entityState.getName(), (String)this.moduleName.toString(), (String)moduleException.toString());
                }
            }
            throw throwable;
        }
    }

    public void adminToProduction() {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule:adminToProduction() called in " + this.moduleName);
        }
        this.targeter.adminToProduction();
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule:gracefulProductionToAdmin() called in " + this.moduleName);
        }
        this.targeter.productionToAdmin();
    }

    public void forceProductionToAdmin() throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule:forceProductionToAdmin() called in " + this.moduleName);
        }
        this.targeter.productionToAdmin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(DomainMBean domainMBean) throws ModuleException {
        Object object;
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule:deactivate() called in " + this.moduleName);
        }
        this.targeter.deactivate();
        if (this.moduleListener != null) {
            object = (DescriptorBean)this.wholeModule;
            object.removeBeanUpdateListener((BeanUpdateListener)this.moduleListener);
            this.moduleListener = null;
        }
        object = null;
        LinkedList[] linkedListArray = this.allEntities;
        synchronized (this.allEntities) {
            for (int i = 10; i >= 0; --i) {
                ListIterator listIterator = this.allEntities[i].listIterator(this.allEntities[i].size());
                while (listIterator.hasPrevious()) {
                    EntityState entityState = (EntityState)listIterator.previous();
                    try {
                        entityState.setState(1);
                    }
                    catch (ModuleException moduleException) {
                        if (object != null) continue;
                        object = moduleException;
                    }
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (object != null) {
                throw object;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unprepare(DomainMBean domainMBean) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule:unprepare() called in " + this.moduleName);
        }
        ModuleException moduleException = null;
        this.targeter.unprepare();
        LinkedList[] linkedListArray = this.allEntities;
        synchronized (this.allEntities) {
            for (int i = 10; i >= 0; --i) {
                ListIterator listIterator = this.allEntities[i].listIterator(this.allEntities[i].size());
                while (listIterator.hasPrevious()) {
                    EntityState entityState = (EntityState)listIterator.previous();
                    try {
                        entityState.setState(0);
                    }
                    catch (ModuleException moduleException2) {
                        if (moduleException != null) continue;
                        moduleException = moduleException2;
                    }
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (moduleException != null) {
                throw moduleException;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(DomainMBean domainMBean) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule:destroy() called in " + this.moduleName);
        }
        ModuleException moduleException = null;
        LinkedList[] linkedListArray = this.allEntities;
        synchronized (this.allEntities) {
            for (int i = 10; i >= 0; --i) {
                ListIterator listIterator = this.allEntities[i].listIterator(this.allEntities[i].size());
                while (listIterator.hasPrevious()) {
                    EntityState entityState = (EntityState)listIterator.previous();
                    try {
                        entityState.setState(3);
                    }
                    catch (ModuleException moduleException2) {
                        if (moduleException != null) continue;
                        moduleException = moduleException2;
                    }
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (moduleException != null) {
                throw moduleException;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DomainMBean domainMBean) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule:remove() called in " + this.moduleName);
        }
        ModuleException moduleException = null;
        LinkedList[] linkedListArray = this.allEntities;
        synchronized (this.allEntities) {
            for (int i = 10; i >= 0; --i) {
                ListIterator listIterator = this.allEntities[i].listIterator(this.allEntities[i].size());
                while (listIterator.hasPrevious()) {
                    EntityState entityState = (EntityState)listIterator.previous();
                    try {
                        entityState.setState(4);
                    }
                    catch (ModuleException moduleException2) {
                        if (moduleException != null) continue;
                        moduleException = moduleException2;
                    }
                }
                this.allEntities[i].clear();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (moduleException != null) {
                throw moduleException;
            }
            return;
        }
    }

    protected Object prepareUpdate(DomainMBean domainMBean) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule: prepareUpdate called in " + this.moduleName);
        }
        TargetInfoMBean targetInfoMBean = this.getTargetingBean(domainMBean);
        TargetMBean[] targetMBeanArray = null;
        if (targetInfoMBean != null) {
            targetMBeanArray = targetInfoMBean.getTargets();
        }
        UpdateInformation updateInformation = new UpdateInformation(11);
        updateInformation.setDefaultTargets(targetMBeanArray);
        BasicDeploymentMBean basicDeploymentMBean = this.getBasicDeployment(domainMBean);
        JMSBean jMSBean = JMSParser.createJMSDescriptor(this.getAppCtx(), basicDeploymentMBean, this.getId());
        if (this.getModuleType() == 0) {
            try {
                JMSModuleValidator.validateTargeting(jMSBean, basicDeploymentMBean, this.getTargetingBean(domainMBean));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ModuleException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("=== Module " + this.getId() + " Tree === ");
            DescriptorUtils.writeAsXML((DescriptorBean)jMSBean);
        }
        Descriptor descriptor = ((DescriptorBean)jMSBean).getDescriptor();
        this.targeter.prepareUpdate(basicDeploymentMBean, updateInformation, this.getAppCtx());
        updateInformation.setProposedDomain(domainMBean);
        DescriptorBean descriptorBean = (DescriptorBean)this.wholeModule;
        Descriptor descriptor2 = descriptorBean.getDescriptor();
        this.moduleListener.setInfo(updateInformation);
        try {
            descriptor2.prepareUpdate(descriptor, false);
        }
        catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
            this.moduleListener.setInfo(null);
            throw new ModuleException(descriptorUpdateRejectedException.getMessage(), descriptorUpdateRejectedException);
        }
        if (TargetingHelper.hasTargetingChanged(updateInformation)) {
            this.processEntities(jMSBean, updateInformation, domainMBean);
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule: prepareUpdate finished in " + this.moduleName);
        }
        return updateInformation;
    }

    protected void rollbackUpdate(DomainMBean domainMBean, Object object) {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule: rollbackUpdate called in " + this.moduleName);
        }
        UpdateInformation updateInformation = (UpdateInformation)object;
        this.targeter.rollbackUpdate(updateInformation);
        DescriptorBean descriptorBean = (DescriptorBean)this.wholeModule;
        Descriptor descriptor = descriptorBean.getDescriptor();
        descriptor.rollbackUpdate();
        this.moduleListener.setInfo(null);
        LinkedList[] linkedListArray = updateInformation.getAddedEntities();
        LinkedList[] linkedListArray2 = updateInformation.getChangedEntities();
        for (int i = 10; i >= 0; --i) {
            EntityState entityState;
            ListIterator listIterator = linkedListArray[i].listIterator(linkedListArray[i].size());
            while (listIterator.hasPrevious()) {
                entityState = (EntityState)listIterator.previous();
                try {
                    entityState.takeDown();
                }
                catch (ModuleException moduleException) {
                    JMSLogger.logDeactivateFailedInRollbackUpdate((String)entityState.getName(), (String)this.moduleName.toString(), (String)moduleException.toString());
                }
            }
            listIterator = linkedListArray2[i].listIterator(linkedListArray2[i].size());
            while (listIterator.hasPrevious()) {
                entityState = (EntityState)listIterator.previous();
                try {
                    entityState.setState(2, null, null, false);
                }
                catch (ModuleException moduleException) {
                    JMSLogger.logRollbackChangedFailedInRollbackUpdate((String)entityState.getName(), (String)this.moduleName.toString(), (String)moduleException.toString());
                }
            }
        }
        updateInformation.close();
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule: rollbackUpdate finished in " + this.moduleName);
        }
    }

    private static void printThrowable(String string, Throwable throwable) {
        int n = 0;
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            JMSDebug.JMSModule.debug(string + " level=" + n);
            JMSDebug.JMSModule.debug(StackTraceUtils.throwable2StackTrace((Throwable)throwable2));
            ++n;
        }
    }

    private static void printDUFE(String string, DescriptorUpdateFailedException descriptorUpdateFailedException) {
        JMSModule.printThrowable("ERROR in " + string, descriptorUpdateFailedException);
        Exception[] exceptionArray = descriptorUpdateFailedException.getExceptionList();
        if (exceptionArray == null) {
            return;
        }
        for (int i = 0; i < exceptionArray.length; ++i) {
            JMSModule.printThrowable("ERROR in " + string + " inner cause=" + i, exceptionArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateUpdate(DomainMBean domainMBean, Object object) throws ModuleException {
        ModuleException moduleException = null;
        UpdateInformation updateInformation = (UpdateInformation)object;
        this.targeter.activateUpdate(updateInformation);
        DescriptorBean descriptorBean = (DescriptorBean)this.wholeModule;
        Descriptor descriptor = descriptorBean.getDescriptor();
        try {
            descriptor.activateUpdate();
        }
        catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSModule.printDUFE(this.moduleName.toString(), descriptorUpdateFailedException);
            }
            moduleException = new ModuleException(descriptorUpdateFailedException.getMessage(), descriptorUpdateFailedException);
        }
        this.moduleListener.setInfo(null);
        LinkedList[] linkedListArray = updateInformation.getAddedEntities();
        LinkedList[] linkedListArray2 = updateInformation.getDeletedEntities();
        LinkedList[] linkedListArray3 = updateInformation.getChangedEntities();
        LinkedList[] linkedListArray4 = this.allEntities;
        synchronized (this.allEntities) {
            int n;
            for (n = 0; n < 11; ++n) {
                for (EntityState entityState : linkedListArray[n]) {
                    entityState.setState(2);
                    this.allEntities[n].add(entityState);
                }
                for (EntityState entityState : linkedListArray3[n]) {
                    entityState.setState(2, null, null, true);
                }
            }
            for (n = 10; n >= 0; --n) {
                for (EntityState entityState : linkedListArray2[n]) {
                    String string = entityState.getName();
                    Iterator iterator = this.allEntities[n].iterator();
                    while (iterator.hasNext()) {
                        EntityState entityState2 = (EntityState)iterator.next();
                        if (!entityState2.getName().equals(string)) continue;
                        entityState2.setDoRemove(entityState.isDoRemove());
                        try {
                            entityState2.takeDown();
                        }
                        catch (ModuleException moduleException2) {
                            if (moduleException == null) {
                                moduleException = moduleException2;
                            }
                            JMSLogger.logDeactivateFailedInActivateUpdate((String)entityState2.getName(), (String)this.moduleName.toString(), (String)moduleException2.toString());
                        }
                        iterator.remove();
                    }
                }
                linkedListArray2[n].clear();
            }
            // ** MonitorExit[var10_11] (shouldn't be in output)
            updateInformation.close();
            if (moduleException != null) {
                throw moduleException;
            }
            return;
        }
    }

    private void addEntity(BeanUpdateEvent.PropertyUpdate propertyUpdate, JMSBean jMSBean, UpdateInformation updateInformation) throws BeanUpdateRejectedException {
        Object object = propertyUpdate.getAddedObject();
        String string = propertyUpdate.getPropertyName();
        Stuff stuff = (Stuff)indexInfo.get(string);
        if (stuff == null) {
            throw new BeanUpdateRejectedException(JMSExceptionLogger.logAddUnknownTypeLoggable((String)this.moduleName.toString(), (String)string).getMessage());
        }
        if (stuff.getType() == 0) {
            return;
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            NamedEntityBean namedEntityBean = (NamedEntityBean)object;
            JMSDebug.JMSModule.debug("Adding a named entity " + namedEntityBean.getName() + " of type " + string + " in module " + this.moduleName);
        }
        this.addEntity(string, (NamedEntityBean)object, jMSBean, updateInformation, null, updateInformation.getProposedDomain());
    }

    private void addEntity(String string, NamedEntityBean namedEntityBean, JMSBean jMSBean, UpdateInformation updateInformation, EntityState entityState, DomainMBean domainMBean) throws BeanUpdateRejectedException {
        JMSModuleManagedEntityProvider jMSModuleManagedEntityProvider = null;
        EntityState entityState2 = entityState;
        LinkedList[] linkedListArray = updateInformation.getAddedEntities();
        HashMap[] hashMapArray = updateInformation.getAddedEntitiesHash();
        Stuff stuff = (Stuff)indexInfo.get(string);
        if (stuff == null) {
            throw new BeanUpdateRejectedException(JMSExceptionLogger.logAddUnknownTypeLoggable((String)this.moduleName.toString(), (String)string).getMessage());
        }
        jMSModuleManagedEntityProvider = stuff.getProvider();
        int n = stuff.getType();
        if (jMSModuleManagedEntityProvider == null || n == 0) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("Entity " + namedEntityBean.getName() + " of type " + string + " in module " + this.moduleName + " has no associated factory, no need to add");
            }
            return;
        }
        LinkedList linkedList = linkedListArray[stuff.getIndex()];
        HashMap hashMap = hashMapArray[stuff.getIndex()];
        if (entityState2 == null) {
            JMSModuleManagedEntity jMSModuleManagedEntity;
            List list = null;
            switch (n) {
                case 1: {
                    TargetableBean targetableBean = (TargetableBean)namedEntityBean;
                    list = this.targeter.getTarget(this.getTargetingBean(domainMBean), targetableBean, targetableBean.getSubDeploymentName(), updateInformation, false);
                    break;
                }
                case 2: {
                    TargetableBean targetableBean = (TargetableBean)namedEntityBean;
                    list = this.targeter.getTarget(this.getTargetingBean(domainMBean), targetableBean, targetableBean.getSubDeploymentName(), updateInformation, true);
                    break;
                }
            }
            if (n == 1 && (list == null || list.size() <= 0)) {
                if (JMSDebug.JMSModule.isDebugEnabled()) {
                    JMSDebug.JMSModule.debug("Entity " + namedEntityBean.getName() + " of type " + string + " in module " + this.moduleName + " with subdeployment " + ((TargetableBean)namedEntityBean).getSubDeploymentName() + " is not targeted locally: " + list);
                }
                return;
            }
            try {
                EntityName entityName = new EntityName(this.moduleName, namedEntityBean.getName());
                jMSModuleManagedEntity = jMSModuleManagedEntityProvider.createEntity(this.getAppCtx(), entityName, this.applicationNamingContext, jMSBean, namedEntityBean, list, domainMBean);
            }
            catch (ModuleException moduleException) {
                throw new BeanUpdateRejectedException(JMSExceptionLogger.logErrorAddingTypeLoggable((String)this.moduleName.toString(), (String)string, (String)namedEntityBean.getName()).getMessage(), (Throwable)((Object)moduleException));
            }
            entityState2 = new EntityState(jMSModuleManagedEntity);
        }
        try {
            entityState2.setState(1);
        }
        catch (ModuleException moduleException) {
            try {
                entityState2.takeDown();
            }
            catch (ModuleException moduleException2) {
                JMSLogger.logDestroyFailedInAdd((String)entityState2.getName(), (String)this.moduleName.toString(), (String)moduleException2.toString());
            }
            throw new BeanUpdateRejectedException(moduleException.getMessage(), (Throwable)((Object)moduleException));
        }
        linkedList.add(entityState2);
        hashMap.put(entityState2.getName(), entityState2);
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Entity " + namedEntityBean.getName() + " of type " + string + " in module " + this.moduleName + " was succesfully added");
        }
    }

    private void removeEntity(NamedEntityBean namedEntityBean, String string, UpdateInformation updateInformation, boolean bl) throws BeanUpdateRejectedException {
        Stuff stuff;
        String string2 = namedEntityBean.getName();
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Removing a named entity named " + string2);
        }
        if ((stuff = (Stuff)indexInfo.get(string)) == null) {
            throw new BeanUpdateRejectedException(JMSExceptionLogger.logDeleteUnknownTypeLoggable((String)this.moduleName.toString(), (String)string).getMessage());
        }
        int n = stuff.getIndex();
        if (n < 0) {
            return;
        }
        LinkedList[] linkedListArray = updateInformation.getDeletedEntities();
        LinkedList linkedList = linkedListArray[n];
        HashMap[] hashMapArray = updateInformation.getDeletedEntitiesHash();
        HashMap hashMap = hashMapArray[n];
        if (hashMap.containsKey(string2)) {
            return;
        }
        EntityState entityState = new EntityState(string2);
        entityState.setDoRemove(bl);
        linkedList.add(entityState);
        hashMap.put(string2, entityState);
    }

    private void changeEntity(TargetableBean targetableBean, int n, String string, int n2, DomainMBean domainMBean, UpdateInformation updateInformation) throws ModuleException {
        String string2 = targetableBean.getName();
        LinkedList linkedList = null;
        LinkedList[] linkedListArray = null;
        switch (n2) {
            case 3: {
                linkedListArray = updateInformation.getChangedEntities();
                break;
            }
            case 1: {
                linkedListArray = updateInformation.getAddedEntities();
                break;
            }
            case 2: {
                linkedListArray = updateInformation.getChangedEntities();
                break;
            }
            default: {
                throw new AssertionError((Object)("realChangeState is UNCHANGED for " + targetableBean.getName() + " type " + string + " change state=" + n2));
            }
        }
        Stuff stuff = (Stuff)indexInfo.get(string);
        if (stuff == null) {
            throw new ModuleException(JMSExceptionLogger.logDeleteUnknownTypeLoggable((String)this.moduleName.toString(), (String)string).getMessage());
        }
        int n3 = stuff.getIndex();
        if (n3 < 0) {
            return;
        }
        linkedList = linkedListArray[n3];
        LinkedList linkedList2 = this.allEntities[n3];
        Iterator iterator = linkedList2.iterator();
        EntityState entityState = null;
        while (iterator.hasNext()) {
            EntityState entityState2 = (EntityState)iterator.next();
            if (!entityState2.getName().equals(string2)) continue;
            entityState = entityState2;
            break;
        }
        if (entityState == null) {
            throw new AssertionError((Object)("A changed entity must have an entity.  Module=" + this.moduleName + " entity=" + string2));
        }
        boolean bl = n == 2;
        List list = n2 == 2 ? null : this.targeter.getTarget(this.getTargetingBean(domainMBean), targetableBean, targetableBean.getSubDeploymentName(), updateInformation, bl);
        entityState.setState(5, list, domainMBean, true);
        linkedList.add(entityState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processEntities(JMSBean jMSBean, UpdateInformation updateInformation, DomainMBean domainMBean) throws ModuleException {
        Object object;
        HashMap[] hashMapArray;
        LinkedList[] linkedListArray;
        block81: {
            JMSBean jMSBean2;
            HashMap[] hashMapArray2;
            boolean bl = false;
            linkedListArray = new LinkedList[11];
            for (int i = 0; i < 11; ++i) {
                linkedListArray[i] = new LinkedList();
            }
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("JMSModule:processEntities called in " + this.moduleName + (jMSBean == null ? " for initialization" : " for update"));
            }
            hashMapArray = jMSBean != null ? updateInformation.getAddedEntitiesHash() : null;
            HashMap[] hashMapArray3 = hashMapArray2 = jMSBean != null ? updateInformation.getDeletedEntitiesHash() : null;
            if (jMSBean == null) {
                this.initializeNamingContext();
                jMSBean2 = this.wholeModule;
            } else {
                jMSBean2 = jMSBean;
            }
            QueueBean[] queueBeanArray = null;
            LinkedList linkedList = null;
            String string = null;
            TargetInfoMBean targetInfoMBean = domainMBean == null ? null : this.getTargetingBean(domainMBean);
            boolean bl2 = targetInfoMBean == null ? false : targetInfoMBean instanceof BasicDeploymentMBean;
            HashSet<String> hashSet = null;
            try {
                for (int i = 0; i < 11; ++i) {
                    linkedList = linkedListArray[i];
                    switch (i) {
                        case 0: {
                            queueBeanArray = jMSBean2.getQueues();
                            string = QUEUE_STRING;
                            break;
                        }
                        case 1: {
                            queueBeanArray = jMSBean2.getTopics();
                            string = TOPIC_STRING;
                            break;
                        }
                        case 10: {
                            queueBeanArray = jMSBean2.getForeignServers();
                            string = FOREIGN_STRING;
                            break;
                        }
                        case 2: {
                            queueBeanArray = jMSBean2.getDistributedQueues();
                            string = DISTRIBUTED_QUEUE_STRING;
                            break;
                        }
                        case 3: {
                            queueBeanArray = jMSBean2.getDistributedTopics();
                            string = DISTRIBUTED_TOPIC_STRING;
                            break;
                        }
                        case 4: {
                            queueBeanArray = jMSBean2.getUniformDistributedQueues();
                            string = UNIFORM_DISTRIBUTED_QUEUE_STRING;
                            break;
                        }
                        case 5: {
                            queueBeanArray = jMSBean2.getUniformDistributedTopics();
                            string = UNIFORM_DISTRIBUTED_TOPIC_STRING;
                            break;
                        }
                        case 9: {
                            queueBeanArray = jMSBean2.getConnectionFactories();
                            string = JMS_CONNECTION_FACTORY_STRING;
                            break;
                        }
                        case 7: {
                            queueBeanArray = jMSBean2.getSAFImportedDestinations();
                            string = SAF_IMPORTED_DESTINATIONS_STRING;
                            break;
                        }
                        case 6: {
                            queueBeanArray = jMSBean2.getSAFRemoteContexts();
                            string = SAF_REMOTE_CONTEXT_STRING;
                            break;
                        }
                        case 8: {
                            queueBeanArray = jMSBean2.getSAFErrorHandlings();
                            string = SAF_ERROR_HANDLING_STRING;
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("ERROR: processEntities in module " + this.moduleName + " got unknown type " + i));
                        }
                    }
                    Stuff stuff = (Stuff)indexInfo.get(string);
                    block52: for (int j = 0; j < queueBeanArray.length; ++j) {
                        int n;
                        int n2;
                        Object object2;
                        Object object3;
                        Object object4;
                        Object object5;
                        int n3;
                        List list;
                        QueueBean queueBean;
                        block82: {
                            queueBean = queueBeanArray[j];
                            list = null;
                            n3 = stuff.getType();
                            block21 : switch (n3) {
                                case 1: 
                                case 2: {
                                    object5 = (TargetableBean)queueBean;
                                    object4 = object5.getSubDeploymentName();
                                    if (targetInfoMBean != null) {
                                        if (hashSet == null) {
                                            hashSet = new HashSet<String>();
                                        }
                                        if (!hashSet.contains(object4)) {
                                            hashSet.add((String)object4);
                                            if (bl2) {
                                                object3 = (BasicDeploymentMBean)targetInfoMBean;
                                                object2 = object3.lookupSubDeployment((String)object4);
                                            } else {
                                                object3 = (SubDeploymentMBean)targetInfoMBean;
                                                object2 = object3.lookupSubDeployment((String)object4);
                                            }
                                            if (!(object2 != null || stuff.isDefaultTargetingEnabled() && object5.isDefaultTargetingEnabled())) {
                                                JMSLogger.logInvalidJMSModuleSubDeploymentConfiguration((String)this.moduleName.toString(), (String)object4, (String)queueBean.getName(), (String)string);
                                            }
                                        }
                                    }
                                    if (n3 == 2) {
                                        n = n2 = this.targeter.getGroupTargetChangeStatus((TargetableBean)object5, (String)object4, updateInformation, true);
                                        list = this.targeter.getTarget(targetInfoMBean, (TargetableBean)object5, (String)object4, updateInformation, true);
                                        switch (n) {
                                            case 1: {
                                                if (jMSBean == null) break block21;
                                                object2 = hashMapArray[stuff.getIndex()];
                                                if (((HashMap)object2).containsKey(queueBean.getName())) {
                                                    n2 = 0;
                                                    break block21;
                                                }
                                                n2 = 3;
                                                break block21;
                                            }
                                            case 2: {
                                                object2 = hashMapArray2[stuff.getIndex()];
                                                if (((HashMap)object2).containsKey(queueBean.getName())) break block21;
                                                n2 = 3;
                                                break block21;
                                            }
                                            case 0: {
                                                if (jMSBean != null) break block21;
                                                n2 = 1;
                                                break block21;
                                            }
                                            case 3: {
                                                object2 = hashMapArray[stuff.getIndex()];
                                                if (!((HashMap)object2).containsKey(queueBean.getName())) break block21;
                                                n2 = 0;
                                                break block21;
                                            }
                                            default: {
                                                throw new AssertionError((Object)("Unknown change status: " + n));
                                            }
                                        }
                                    }
                                    n = n2 = this.targeter.getGroupTargetChangeStatus((TargetableBean)object5, (String)object4, updateInformation, false);
                                    list = this.targeter.getTarget(targetInfoMBean, (TargetableBean)object5, (String)object4, updateInformation, false);
                                    switch (n) {
                                        case 1: {
                                            if (jMSBean != null) {
                                                object2 = hashMapArray[stuff.getIndex()];
                                                if (!((HashMap)object2).containsKey(queueBean.getName())) break block21;
                                                n2 = 0;
                                                break;
                                            }
                                            break block82;
                                        }
                                        case 2: {
                                            object2 = hashMapArray2[stuff.getIndex()];
                                            if (!((HashMap)object2).containsKey(queueBean.getName())) break block21;
                                            n2 = 0;
                                            break;
                                        }
                                    }
                                    break;
                                }
                                case 3: {
                                    if (jMSBean != null) {
                                        n2 = 0;
                                        n = 0;
                                        break;
                                    }
                                    n2 = 1;
                                    n = 1;
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)("An entity of this type " + string + " should not have type " + n3));
                                }
                            }
                        }
                        switch (n2) {
                            case 0: {
                                continue block52;
                            }
                            case 1: {
                                object5 = stuff.getProvider();
                                object4 = new EntityName(this.moduleName, queueBean.getName());
                                object2 = object5.createEntity(this.getAppCtx(), (EntityName)object4, this.applicationNamingContext, jMSBean2, (NamedEntityBean)queueBean, list, domainMBean);
                                object3 = new EntityState((JMSModuleManagedEntity)object2);
                                linkedList.add(object3);
                                if (jMSBean == null) continue block52;
                                try {
                                    this.addEntity(string, (NamedEntityBean)queueBean, jMSBean, updateInformation, (EntityState)object3, domainMBean);
                                }
                                catch (BeanUpdateRejectedException beanUpdateRejectedException) {
                                    Throwable throwable = beanUpdateRejectedException.getCause();
                                    if (throwable == null || !(throwable instanceof ModuleException)) throw new ModuleException(JMSExceptionLogger.logAddFailedLoggable((String)this.moduleName.toString(), (String)((EntityState)object3).getName()).getMessage(), beanUpdateRejectedException);
                                    throw (ModuleException)((Object)throwable);
                                }
                                HashMap hashMap = hashMapArray[stuff.getIndex()];
                                hashMap.put(((EntityState)object3).getName(), object3);
                                continue block52;
                            }
                            case 2: {
                                try {
                                    this.removeEntity((NamedEntityBean)queueBean, string, updateInformation, false);
                                    continue block52;
                                }
                                catch (BeanUpdateRejectedException beanUpdateRejectedException) {
                                    throw new ModuleException(JMSExceptionLogger.logRemoveFailedLoggable((String)this.moduleName.toString(), (String)queueBean.getName()).getMessage(), beanUpdateRejectedException);
                                }
                            }
                            case 3: {
                                if (!(queueBean instanceof TargetableBean)) {
                                    throw new AssertionError((Object)("The named entity " + queueBean.getName() + " of type " + string + " must be targeteable to have its targets changed in " + this.moduleName + ".  It is of class " + queueBean.getClass().getName()));
                                }
                                this.changeEntity((TargetableBean)queueBean, n3, string, n, domainMBean, updateInformation);
                                continue block52;
                            }
                            default: {
                                throw new AssertionError((Object)("ERROR: processEntities in module " + this.moduleName + " got unknown change state " + n2));
                            }
                        }
                    }
                }
                bl = true;
                Object var30_32 = null;
                if (!bl) break block81;
                if (jMSBean != null) return;
                LinkedList[] linkedListArray2 = this.allEntities;
            }
            catch (Throwable throwable) {
                Object var30_33 = null;
                if (bl) {
                    if (jMSBean != null) throw throwable;
                    LinkedList[] linkedListArray3 = this.allEntities;
                    synchronized (this.allEntities) {
                        this.allEntities = linkedListArray;
                        // ** MonitorExit[var31_38] (shouldn't be in output)
                        throw throwable;
                    }
                } else {
                    Object object6;
                    if (jMSBean != null) {
                        for (int i = 0; i < 11; ++i) {
                            hashMapArray[i].clear();
                        }
                        LinkedList[] linkedListArray4 = updateInformation.getChangedEntities();
                        for (int i = 10; i >= 0; --i) {
                            object6 = linkedListArray4[i].listIterator(linkedListArray4[i].size());
                            while (object6.hasPrevious()) {
                                EntityState entityState = (EntityState)object6.previous();
                                try {
                                    entityState.setState(2, null, null, false);
                                }
                                catch (ModuleException moduleException) {
                                    JMSLogger.logRollbackChangeFailedInInit((String)entityState.getName(), (String)this.moduleName.toString(), (String)moduleException.toString());
                                }
                            }
                        }
                    }
                    for (int i = 10; i >= 0; --i) {
                        ListIterator listIterator = linkedListArray[i].listIterator(linkedListArray[i].size());
                        while (listIterator.hasPrevious()) {
                            object6 = (EntityState)listIterator.previous();
                            try {
                                ((EntityState)object6).takeDown();
                            }
                            catch (ModuleException moduleException) {
                                JMSLogger.logDeactivateFailedInInit((String)((EntityState)object6).getName(), (String)this.moduleName.toString(), (String)moduleException.toString());
                            }
                        }
                    }
                }
                throw throwable;
            }
            synchronized (this.allEntities) {
                this.allEntities = linkedListArray;
                // ** MonitorExit[var31_34] (shouldn't be in output)
                return;
            }
        }
        if (jMSBean != null) {
            for (int i = 0; i < 11; ++i) {
                hashMapArray[i].clear();
            }
            LinkedList[] linkedListArray5 = updateInformation.getChangedEntities();
            for (int i = 10; i >= 0; --i) {
                object = linkedListArray5[i].listIterator(linkedListArray5[i].size());
                while (object.hasPrevious()) {
                    EntityState entityState = (EntityState)object.previous();
                    try {
                        entityState.setState(2, null, null, false);
                    }
                    catch (ModuleException moduleException) {
                        JMSLogger.logRollbackChangeFailedInInit((String)entityState.getName(), (String)this.moduleName.toString(), (String)moduleException.toString());
                    }
                }
            }
        }
        for (int i = 10; i >= 0; --i) {
            ListIterator listIterator = linkedListArray[i].listIterator(linkedListArray[i].size());
            while (listIterator.hasPrevious()) {
                object = (EntityState)listIterator.previous();
                try {
                    ((EntityState)object).takeDown();
                }
                catch (ModuleException moduleException) {
                    JMSLogger.logDeactivateFailedInInit((String)((EntityState)object).getName(), (String)this.moduleName.toString(), (String)moduleException.toString());
                }
            }
        }
        return;
    }

    private void initializeNamingContext() throws ModuleException {
        Context context = JMSService.getContext(true);
        Context context2 = null;
        try {
            context2 = (Context)context.lookup("weblogic");
        }
        catch (NamingException namingException) {
            throw new ModuleException("ERROR: Could not lookup the weblogic context in module " + this.moduleName + " of application " + this.getAppCtx().getApplicationId(), namingException);
        }
        try {
            this.applicationNamingContext = context2.createSubcontext(this.getAppCtx().getApplicationId());
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
        }
        catch (NamingException namingException) {
            throw new ModuleException("ERROR: Could not create the application context in module " + this.moduleName + " of application " + this.getAppCtx().getApplicationId(), namingException);
        }
    }

    static {
        indexInfo.put(QUEUE_STRING, new Stuff(DESTINATION_PROVIDER, 0, 1, false));
        indexInfo.put(TOPIC_STRING, new Stuff(DESTINATION_PROVIDER, 1, 1, false));
        indexInfo.put(FOREIGN_STRING, new Stuff(FOREIGN_PROVIDER, 10, 1, true));
        indexInfo.put(DISTRIBUTED_QUEUE_STRING, new Stuff(DD_PROVIDER, 2, 3, false));
        indexInfo.put(DISTRIBUTED_TOPIC_STRING, new Stuff(DD_PROVIDER, 3, 3, false));
        indexInfo.put(JMS_CONNECTION_FACTORY_STRING, new Stuff(CONN_PROVIDER, 9, 1, true));
        indexInfo.put(SAF_IMPORTED_DESTINATIONS_STRING, new Stuff(SAF_PROVIDER, 7, 2, true));
        indexInfo.put(SAF_REMOTE_CONTEXT_STRING, new Stuff(REMOTE_CONTEXT_PROVIDER, 6, 3, false));
        indexInfo.put(SAF_ERROR_HANDLING_STRING, new Stuff(ERROR_HANDLING_PROVIDER, 8, 3, false));
        indexInfo.put(UNIFORM_DISTRIBUTED_QUEUE_STRING, new Stuff(UDD_PROVIDER, 4, 2, true));
        indexInfo.put(UNIFORM_DISTRIBUTED_TOPIC_STRING, new Stuff(UDD_PROVIDER, 5, 2, true));
        indexInfo.put(TEMPLATE_STRING, new Stuff(null, -1, 0, false));
        indexInfo.put(DESTINATION_KEY_STRING, new Stuff(null, -1, 0, false));
        indexInfo.put(QUOTA_STRING, new Stuff(null, -1, 0, false));
    }

    private class EntityState {
        private JMSModuleManagedEntity entity;
        private String name;
        private int state = 0;
        private boolean doRemove = false;

        private EntityState(String string) {
            this.name = string;
        }

        private EntityState(JMSModuleManagedEntity jMSModuleManagedEntity) {
            this.entity = jMSModuleManagedEntity;
            this.name = this.entity.getEntityName();
        }

        private String stateToString(int n) {
            switch (n) {
                case 0: {
                    return "INITIALIZED";
                }
                case 1: {
                    return "PREPARED";
                }
                case 2: {
                    return "ACTIVE";
                }
                case 3: {
                    return "FINISHED";
                }
                case 4: {
                    return "DEAD";
                }
                case 5: {
                    return "CHANGED";
                }
            }
            return "UNKNOWN STATE: " + n;
        }

        private void invalidStateTransition(int n, int n2) {
            throw new AssertionError((Object)("ERROR: An invalid state transition was requested in module " + JMSModule.this.moduleName + " for entity " + this.name + ".  The transition requested was from " + this.stateToString(n) + " to " + this.stateToString(n2)));
        }

        private void setState(int n) throws ModuleException {
            this.setState(n, null, null, true);
        }

        private void setState(int n, List list, DomainMBean domainMBean, boolean bl) throws ModuleException {
            boolean bl2 = false;
            try {
                block1 : switch (n) {
                    case 0: {
                        switch (this.state) {
                            case 1: {
                                bl2 = true;
                                this.entity.unprepare();
                                break block1;
                            }
                        }
                        this.invalidStateTransition(this.state, n);
                        break;
                    }
                    case 1: {
                        switch (this.state) {
                            case 0: {
                                this.entity.prepare();
                                break block1;
                            }
                            case 2: {
                                bl2 = true;
                                this.entity.deactivate();
                                break block1;
                            }
                        }
                        this.invalidStateTransition(this.state, n);
                        break;
                    }
                    case 2: {
                        switch (this.state) {
                            case 1: {
                                this.entity.activate(JMSModule.this.wholeModule);
                                break block1;
                            }
                            case 5: {
                                bl2 = true;
                                if (bl) {
                                    this.entity.activateChangeOfTargets();
                                    break block1;
                                }
                                this.entity.rollbackChangeOfTargets();
                                break block1;
                            }
                        }
                        this.invalidStateTransition(this.state, n);
                        break;
                    }
                    case 3: {
                        switch (this.state) {
                            case 0: {
                                bl2 = true;
                                this.entity.destroy();
                                break block1;
                            }
                        }
                        this.invalidStateTransition(this.state, n);
                        break;
                    }
                    case 4: {
                        switch (this.state) {
                            case 3: {
                                bl2 = true;
                                this.entity.remove();
                                break block1;
                            }
                        }
                        this.invalidStateTransition(this.state, n);
                        break;
                    }
                    case 5: {
                        switch (this.state) {
                            case 2: {
                                this.entity.prepareChangeOfTargets(list, domainMBean);
                                break block1;
                            }
                            case 5: {
                                break block1;
                            }
                        }
                        this.invalidStateTransition(this.state, n);
                        break;
                    }
                    default: {
                        this.invalidStateTransition(this.state, n);
                        break;
                    }
                }
            }
            catch (ModuleException moduleException) {
                if (JMSDebug.JMSModule.isDebugEnabled()) {
                    JMSDebug.JMSModule.debug("ERROR: Entity " + this.entity.getEntityName() + " in module " + JMSModule.this.moduleName + "failed to go from state " + this.stateToString(this.state) + " to state " + this.stateToString(n) + " due to " + moduleException.getMessage());
                    moduleException.printStackTrace();
                }
                if (bl2) {
                    this.state = n;
                }
                throw moduleException;
            }
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: Entity " + this.entity.getEntityName() + " in module " + JMSModule.this.moduleName + " changed from state " + this.stateToString(this.state) + " to state " + this.stateToString(n));
            }
            this.state = n;
        }

        private void takeDown() throws ModuleException {
            ModuleException moduleException;
            block19: {
                block18: {
                    block17: {
                        block16: {
                            moduleException = null;
                            if (this.state == 5) {
                                try {
                                    this.setState(2, null, null, false);
                                }
                                catch (ModuleException moduleException2) {
                                    moduleException = moduleException2;
                                }
                            }
                            if (this.state == 2) {
                                try {
                                    this.setState(1);
                                }
                                catch (ModuleException moduleException3) {
                                    if (moduleException == null) break block16;
                                    moduleException = moduleException3;
                                }
                            }
                        }
                        if (this.state == 1) {
                            try {
                                this.setState(0);
                            }
                            catch (ModuleException moduleException4) {
                                if (moduleException == null) break block17;
                                moduleException = moduleException4;
                            }
                        }
                    }
                    if (this.state == 0) {
                        try {
                            this.setState(3);
                        }
                        catch (ModuleException moduleException5) {
                            if (moduleException == null) break block18;
                            moduleException = moduleException5;
                        }
                    }
                }
                if (this.doRemove && this.state == 3) {
                    try {
                        this.setState(4);
                    }
                    catch (ModuleException moduleException6) {
                        if (moduleException == null) break block19;
                        moduleException = moduleException6;
                    }
                }
            }
            if (moduleException != null) {
                throw moduleException;
            }
        }

        private String getName() {
            return this.name;
        }

        private void setDoRemove(boolean bl) {
            this.doRemove = bl;
        }

        private boolean isDoRemove() {
            return this.doRemove;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof EntityState)) {
                return false;
            }
            EntityState entityState = (EntityState)object;
            return this.name.equals(entityState.name);
        }
    }

    private static class Stuff {
        private JMSModuleManagedEntityProvider myProvider;
        private int myIndex;
        private int myType;
        private boolean myDefaultTargetingEnabled;

        private Stuff(JMSModuleManagedEntityProvider jMSModuleManagedEntityProvider, int n, int n2, boolean bl) {
            this.myProvider = jMSModuleManagedEntityProvider;
            this.myIndex = n;
            this.myType = n2;
            this.myDefaultTargetingEnabled = bl;
        }

        private JMSModuleManagedEntityProvider getProvider() {
            return this.myProvider;
        }

        private int getIndex() {
            return this.myIndex;
        }

        private int getType() {
            return this.myType;
        }

        private boolean isDefaultTargetingEnabled() {
            return this.myDefaultTargetingEnabled;
        }
    }

    private class JMSModuleListener
    implements BeanUpdateListener {
        private UpdateInformation info;

        private JMSModuleListener() {
        }

        private void setInfo(UpdateInformation updateInformation) {
            this.info = updateInformation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
            boolean bl;
            block13: {
                block12: {
                    bl = false;
                    try {
                        if (JMSDebug.JMSModule.isDebugEnabled()) {
                            JMSDebug.JMSModule.debug("INFO: Got module listener prepareUpdate in " + JMSModule.this.moduleName);
                        }
                        if (this.info == null) {
                            Object var7_3 = null;
                            if (bl) return;
                            this.info = null;
                            return;
                        }
                        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
                        if (propertyUpdateArray == null) {
                            if (JMSDebug.JMSModule.isDebugEnabled()) {
                                JMSDebug.JMSModule.debug("INFO: module listener prepareUpdate exits with no events in " + JMSModule.this.moduleName);
                            }
                            break block12;
                        }
                        JMSBean jMSBean = (JMSBean)beanUpdateEvent.getProposedBean();
                        block6: for (int i = 0; i < propertyUpdateArray.length; ++i) {
                            switch (propertyUpdateArray[i].getUpdateType()) {
                                case 2: {
                                    JMSModule.this.addEntity(propertyUpdateArray[i], jMSBean, this.info);
                                    continue block6;
                                }
                                case 3: {
                                    JMSModule.this.removeEntity((NamedEntityBean)propertyUpdateArray[i].getRemovedObject(), propertyUpdateArray[i].getPropertyName(), this.info, true);
                                    continue block6;
                                }
                            }
                        }
                        if (JMSDebug.JMSModule.isDebugEnabled()) {
                            JMSDebug.JMSModule.debug("INFO: module listener prepareUpdate exits normally in " + JMSModule.this.moduleName);
                        }
                        bl = true;
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        if (bl) throw throwable;
                        this.info = null;
                        throw throwable;
                    }
                }
                Object var7_4 = null;
                if (bl) return;
                this.info = null;
                return;
            }
            Object var7_5 = null;
            if (bl) return;
            this.info = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
            try {
                if (JMSDebug.JMSModule.isDebugEnabled()) {
                    JMSDebug.JMSModule.debug("INFO: Got module listener rollback event: " + beanUpdateEvent + " in " + JMSModule.this.moduleName);
                }
                Object var3_2 = null;
                this.info = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.info = null;
                throw throwable;
            }
        }

        public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
            this.info = null;
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: Got module listener activateUpdate, nothing to do in" + JMSModule.this.moduleName);
            }
        }
    }
}

