/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ModuleException;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.VersionMunger;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.jms.common.JMSDebug;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class JMSParser {
    public static JMSBean createJMSDescriptor(String string, String string2) throws ModuleException {
        DeploymentPlanBean deploymentPlanBean;
        if (string == null) {
            throw new ModuleException("Null URI specified");
        }
        if (string2 == null) {
            try {
                return JMSParser.createJMSDescriptor(null, null, string);
            }
            catch (Exception exception) {
                throw new ModuleException("Could not create the JMS descriptor", exception);
            }
        }
        File file = new File(string);
        File file2 = new File(string2);
        DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(file2);
        try {
            deploymentPlanBean = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
        }
        catch (IOException iOException) {
            throw new ModuleException(iOException.getMessage(), iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ModuleException(xMLStreamException.getMessage(), xMLStreamException);
        }
        try {
            return JMSParser.createJMSDescriptor(file, file.getParentFile(), deploymentPlanBean, string, string);
        }
        catch (IOException iOException) {
            throw new ModuleException(iOException.getMessage(), iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ModuleException(xMLStreamException.getMessage(), xMLStreamException);
        }
    }

    public static JMSBean createJMSDescriptor(String string) throws ModuleException {
        return JMSParser.createJMSDescriptor(string, null);
    }

    static JMSBean createJMSDescriptor(ApplicationContextInternal applicationContextInternal, BasicDeploymentMBean basicDeploymentMBean, String string) throws ModuleException {
        DeploymentPlanBean deploymentPlanBean = null;
        String string2 = null;
        AbstractDescriptorLoader2 abstractDescriptorLoader2 = null;
        File file = null;
        if (string == null) {
            throw new ModuleException("Null URI specified");
        }
        if (basicDeploymentMBean != null) {
            BasicDeploymentMBean basicDeploymentMBean2;
            if (basicDeploymentMBean instanceof AppDeploymentMBean) {
                if (applicationContextInternal.isEar() && ((BasicDeploymentMBean)(basicDeploymentMBean2 = applicationContextInternal.getEar().getModuleRoots(string))).length <= 0) {
                    throw new ModuleException("Could not find the JMS module file \"" + string + "\" in application \"" + applicationContextInternal.getApplicationId() + "\"");
                }
                basicDeploymentMBean2 = (AppDeploymentMBean)basicDeploymentMBean;
                deploymentPlanBean = basicDeploymentMBean2.getDeploymentPlanDescriptor();
                if (basicDeploymentMBean2.getPlanDir() != null) {
                    file = new File(basicDeploymentMBean2.getLocalPlanDir());
                }
                string2 = basicDeploymentMBean2.getName();
                if (abstractDescriptorLoader2 == null) {
                    if (JMSDebug.JMSModule.isDebugEnabled()) {
                        JMSDebug.JMSModule.debug("Creating jms descriptor from deployment at " + JMSParser.getCanonicalPath(applicationContextInternal, string));
                    }
                    String string3 = JMSParser.getModuleName((AppDeploymentMBean)basicDeploymentMBean2, string);
                    String string4 = JMSParser.getModuleUri((AppDeploymentMBean)basicDeploymentMBean2, string);
                    abstractDescriptorLoader2 = JMSParser.createDescriptorLoader(new File(JMSParser.getCanonicalPath(applicationContextInternal, string)), file, deploymentPlanBean, string3, string4);
                }
            } else {
                basicDeploymentMBean2 = (SystemResourceMBean)basicDeploymentMBean;
                if (basicDeploymentMBean2 == null) {
                    throw new ModuleException("Application was neither a system resource nor a deployment");
                }
                string2 = basicDeploymentMBean2.getName();
                if (abstractDescriptorLoader2 == null) {
                    if (JMSDebug.JMSModule.isDebugEnabled()) {
                        JMSDebug.JMSModule.debug("Creating jms descriptor from system resource at " + JMSParser.getCanonicalPath(applicationContextInternal, string));
                    }
                    abstractDescriptorLoader2 = JMSParser.createDescriptorLoader(new File(JMSParser.getCanonicalPath(applicationContextInternal, string)), null, null, string2, string);
                }
            }
        } else if (abstractDescriptorLoader2 == null) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("Creating jms descriptor offline for " + string);
            }
            abstractDescriptorLoader2 = JMSParser.createDescriptorLoader(new File(string), null, null, null, string);
        }
        try {
            return JMSParser.getJMSBean(abstractDescriptorLoader2);
        }
        catch (Exception exception) {
            throw new ModuleException("Could not create the JMS descriptor", exception);
        }
    }

    public AbstractDescriptorLoader2 getJmsDescriptorLoader(File file, String string) throws IOException, XMLStreamException {
        return JMSParser.createDescriptorLoader(file, null, null, null, string);
    }

    public AbstractDescriptorLoader2 getJmsDescriptorLoader(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLStreamException {
        return JMSParser.createDescriptorLoader(file, file2, deploymentPlanBean, string, string2);
    }

    private static String getModuleUri(AppDeploymentMBean appDeploymentMBean, String string) {
        if (appDeploymentMBean.getSourcePath() != null && appDeploymentMBean.getSourcePath().endsWith(".xml")) {
            return ".";
        }
        return string;
    }

    private static String getModuleName(AppDeploymentMBean appDeploymentMBean, String string) {
        if (appDeploymentMBean.getSourcePath() != null) {
            return new File(appDeploymentMBean.getSourcePath()).getName();
        }
        return string;
    }

    private static JMSBean createJMSDescriptor(VirtualJarFile virtualJarFile, String string, String string2, String string3) throws ModuleException {
        File file = null;
        DeploymentPlanBean deploymentPlanBean = null;
        ApplicationContextInternal applicationContextInternal = null;
        AbstractDescriptorLoader2 abstractDescriptorLoader2 = null;
        if (string != null) {
            applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(string);
        }
        if (applicationContextInternal != null) {
            AppDeploymentMBean appDeploymentMBean = applicationContextInternal.getAppDeploymentMBean();
            deploymentPlanBean = appDeploymentMBean.getDeploymentPlanDescriptor();
            if (appDeploymentMBean.getPlanDir() != null) {
                file = new File(appDeploymentMBean.getLocalPlanDir());
            }
        }
        abstractDescriptorLoader2 = JMSParser.createDescriptorLoader(virtualJarFile, file, deploymentPlanBean, string2, string3);
        try {
            return JMSParser.getJMSBean(abstractDescriptorLoader2);
        }
        catch (Exception exception) {
            throw new ModuleException("Could not create the JMS descriptor", exception);
        }
    }

    public static JMSBean createJMSDescriptor(InputStream inputStream, DescriptorManager descriptorManager, List list, boolean bl) throws ModuleException {
        AbstractDescriptorLoader2 abstractDescriptorLoader2 = JMSParser.createDescriptorLoader(inputStream, descriptorManager, list, bl);
        try {
            return JMSParser.getJMSBean(abstractDescriptorLoader2);
        }
        catch (Exception exception) {
            throw new ModuleException("Could not create the JMS descriptor", exception);
        }
    }

    public static JMSBean createJMSDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLStreamException {
        AbstractDescriptorLoader2 abstractDescriptorLoader2 = JMSParser.createDescriptorLoader(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, string2);
        return JMSParser.getJMSBean(abstractDescriptorLoader2);
    }

    private static JMSBean createJMSDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLStreamException {
        AbstractDescriptorLoader2 abstractDescriptorLoader2 = JMSParser.createDescriptorLoader(file, file2, deploymentPlanBean, string, string2);
        return JMSParser.getJMSBean(abstractDescriptorLoader2);
    }

    private static String getCanonicalPath(ApplicationContextInternal applicationContextInternal, String string) {
        if (applicationContextInternal.isEar()) {
            File file = applicationContextInternal.getEar().getModuleRoots(string)[0];
            return file.getAbsolutePath().replace(File.separatorChar, '/');
        }
        return applicationContextInternal.getStagingPath();
    }

    private static JMSBean getJMSBean(AbstractDescriptorLoader2 abstractDescriptorLoader2) throws IOException, XMLStreamException {
        return (JMSBean)abstractDescriptorLoader2.loadDescriptorBean();
    }

    private static AbstractDescriptorLoader2 createDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        return new AbstractDescriptorLoader2(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, string2){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                return JMSParser.createVersionMunger(inputStream, this);
            }
        };
    }

    private static AbstractDescriptorLoader2 createDescriptorLoader(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        return new AbstractDescriptorLoader2(file, file2, deploymentPlanBean, string, string2){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                return JMSParser.createVersionMunger(inputStream, this);
            }
        };
    }

    private static AbstractDescriptorLoader2 createDescriptorLoader(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        return new AbstractDescriptorLoader2(virtualJarFile, file, deploymentPlanBean, string, string2){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                return JMSParser.createVersionMunger(inputStream, this);
            }
        };
    }

    private static AbstractDescriptorLoader2 createDescriptorLoader(InputStream inputStream, DescriptorManager descriptorManager, List list, boolean bl) {
        return new AbstractDescriptorLoader2(inputStream, descriptorManager, list, bl){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                return JMSParser.createVersionMunger(inputStream, this);
            }
        };
    }

    private static VersionMunger createVersionMunger(InputStream inputStream, AbstractDescriptorLoader2 abstractDescriptorLoader2) throws XMLStreamException {
        String string = "weblogic.j2ee.descriptor.wl.JMSBeanImpl$SchemaHelper2";
        return new VersionMunger(inputStream, abstractDescriptorLoader2, string, "http://xmlns.oracle.com/weblogic/weblogic-jms");
    }

    public static void main(String[] stringArray) throws Exception {
        block20: {
            if (stringArray.length < 1) {
                JMSParser.usage();
            }
            String string = stringArray[0];
            String string2 = null;
            if (stringArray.length == 2) {
                string2 = stringArray[1];
            }
            String string3 = null;
            String string4 = null;
            File file = null;
            JMSBean jMSBean = null;
            try {
                file = new File(string);
                if (file.getName().endsWith(".ear")) {
                    JarFile jarFile = new JarFile(string);
                    VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((JarFile)jarFile);
                    if (string2 == null) {
                        Iterator iterator = virtualJarFile.entries();
                        while (iterator.hasNext()) {
                            ZipEntry zipEntry = (ZipEntry)iterator.next();
                            if (!zipEntry.getName().endsWith("-jms.xml")) continue;
                            string2 = zipEntry.getName();
                            System.out.println("\n\n... getting JMSBean from EAR for uri " + string2 + ":\n\n");
                            try {
                                jMSBean = JMSParser.createJMSDescriptor(virtualJarFile, string3, string4, string2);
                                if (jMSBean == null) continue;
                                DescriptorUtils.writeAsXML((DescriptorBean)jMSBean);
                            }
                            catch (Throwable throwable) {
                                JMSParser.logValidationError(throwable);
                            }
                        }
                        break block20;
                    }
                    System.out.println("\n\n... getting JMSBean from EAR for uri " + string2 + ":\n\n");
                    try {
                        jMSBean = JMSParser.createJMSDescriptor(virtualJarFile, string3, string4, string2);
                        if (jMSBean != null) {
                            DescriptorUtils.writeAsXML((DescriptorBean)jMSBean);
                        }
                        break block20;
                    }
                    catch (Throwable throwable) {
                        JMSParser.logValidationError(throwable);
                    }
                    break block20;
                }
                if (file.getPath().endsWith("-jms.xml")) {
                    if (stringArray.length == 1) {
                        System.out.println("\n\n... getting JMSBean from JMSMD:\n\n");
                        try {
                            jMSBean = JMSParser.createJMSDescriptor(stringArray[0]);
                            if (jMSBean != null) {
                                DescriptorUtils.writeAsXML((DescriptorBean)jMSBean);
                            }
                            break block20;
                        }
                        catch (Throwable throwable) {
                            JMSParser.logValidationError(throwable);
                        }
                        break block20;
                    }
                    if (!stringArray[1].endsWith("plan.xml")) break block20;
                    System.out.println("\n\n... plan:");
                    try {
                        jMSBean = JMSParser.createJMSDescriptor(stringArray[0], stringArray[1]);
                        if (jMSBean != null) {
                            DescriptorUtils.writeAsXML((DescriptorBean)jMSBean);
                        }
                        break block20;
                    }
                    catch (Throwable throwable) {
                        JMSParser.logValidationError(throwable);
                    }
                    break block20;
                }
                JMSParser.usage();
            }
            catch (Throwable throwable) {
                JMSParser.logValidationError(throwable);
            }
        }
    }

    private static void logValidationError(Throwable throwable) {
        System.out.println(throwable.toString());
        throwable.printStackTrace();
    }

    private static void usage() {
        System.err.println("usage: java weblogic.jms.module.JMSParser <JMS Module descriptor | J2EE Application Archive>");
        System.err.println("\n\n example:\n java weblogic.jms.module.JMSParser my-jms.xml");
        System.err.println("\n\n example:\n java weblogic.jms.module.JMSParser myapp.ear <Any JMS module URI inside this EAR>");
        System.exit(0);
    }
}

