/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.management.InvalidAttributeValueException;
import weblogic.j2ee.descriptor.wl.ClientParamsBean;
import weblogic.j2ee.descriptor.wl.DefaultDeliveryParamsBean;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.DestinationKeyBean;
import weblogic.j2ee.descriptor.wl.DistributedDestinationBean;
import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.j2ee.descriptor.wl.DistributedQueueBean;
import weblogic.j2ee.descriptor.wl.DistributedTopicBean;
import weblogic.j2ee.descriptor.wl.FlowControlParamsBean;
import weblogic.j2ee.descriptor.wl.ForeignConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ForeignDestinationBean;
import weblogic.j2ee.descriptor.wl.ForeignJNDIObjectBean;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.JMSConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.LoadBalancingParamsBean;
import weblogic.j2ee.descriptor.wl.PropertyBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.j2ee.descriptor.wl.TemplateBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.j2ee.descriptor.wl.TransactionParamsBean;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.JMSLogger;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ForeignJMSConnectionFactoryMBean;
import weblogic.management.configuration.ForeignJMSDestinationMBean;
import weblogic.management.configuration.ForeignJMSServerMBean;
import weblogic.management.configuration.ForeignJNDIObjectMBean;
import weblogic.management.configuration.JMSConnectionFactoryMBean;
import weblogic.management.configuration.JMSDestinationKeyMBean;
import weblogic.management.configuration.JMSDestinationMBean;
import weblogic.management.configuration.JMSDistributedDestinationMBean;
import weblogic.management.configuration.JMSDistributedDestinationMemberMBean;
import weblogic.management.configuration.JMSDistributedQueueMBean;
import weblogic.management.configuration.JMSDistributedQueueMemberMBean;
import weblogic.management.configuration.JMSDistributedTopicMBean;
import weblogic.management.configuration.JMSDistributedTopicMemberMBean;
import weblogic.management.configuration.JMSQueueMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.JMSTemplateMBean;
import weblogic.management.configuration.JMSTopicMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.UpdateException;

public abstract class MBeanConverter {
    private static final int STORE_DEFAULT = 0;
    private static final int STORE_TRUE = 1;
    private static final int STORE_FALSE = 2;
    private static final int DMO_UNSET = 0;
    private static final int DMO_PERSISTENT = 1;
    private static final int DMO_NONPERSISTENT = 2;

    public static JMSConnectionFactoryBean addJMSConnectionFactory(JMSBean jMSBean, JMSSystemResourceMBean jMSSystemResourceMBean, JMSConnectionFactoryMBean jMSConnectionFactoryMBean, String string, TargetMBean[] targetMBeanArray) {
        JMSConnectionFactoryBean jMSConnectionFactoryBean = jMSBean.lookupConnectionFactory(string);
        if (jMSConnectionFactoryBean != null) {
            return jMSConnectionFactoryBean;
        }
        jMSConnectionFactoryBean = jMSBean.createConnectionFactory(string);
        MBeanConverter.fillInJMSConnectionFactory(jMSSystemResourceMBean, jMSConnectionFactoryBean, jMSConnectionFactoryMBean, targetMBeanArray);
        return jMSConnectionFactoryBean;
    }

    private static void fillInJMSConnectionFactory(JMSSystemResourceMBean jMSSystemResourceMBean, JMSConnectionFactoryBean jMSConnectionFactoryBean, JMSConnectionFactoryMBean jMSConnectionFactoryMBean, TargetMBean[] targetMBeanArray) {
        String string;
        if (jMSConnectionFactoryMBean.getNotes() != null) {
            jMSConnectionFactoryBean.setNotes(jMSConnectionFactoryMBean.getNotes());
        }
        if ((string = jMSConnectionFactoryMBean.getJNDIName()) != null) {
            jMSConnectionFactoryBean.setJNDIName(string);
        }
        if (jMSSystemResourceMBean != null) {
            SubDeploymentMBean subDeploymentMBean = jMSSystemResourceMBean.lookupSubDeployment(jMSConnectionFactoryBean.getName());
            if (subDeploymentMBean == null) {
                subDeploymentMBean = jMSSystemResourceMBean.createSubDeployment(jMSConnectionFactoryBean.getName());
            }
            try {
                subDeploymentMBean.setTargets(targetMBeanArray);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new AssertionError((Object)("ERROR: Could not set the targets of JMS connection factory " + jMSConnectionFactoryBean.getName() + " due to " + invalidAttributeValueException));
            }
            catch (DistributedManagementException distributedManagementException) {
                throw new AssertionError((Object)("WARN: Could not set the targets of JMS connection factory " + jMSConnectionFactoryBean.getName() + " due to " + (Object)((Object)distributedManagementException)));
            }
        }
        MBeanConverter.fillInDefaultDeliveryParams(jMSConnectionFactoryBean, jMSConnectionFactoryMBean);
        MBeanConverter.fillInClientParams(jMSConnectionFactoryBean, jMSConnectionFactoryMBean);
        MBeanConverter.fillInTransactionParams(jMSConnectionFactoryBean, jMSConnectionFactoryMBean);
        MBeanConverter.fillInFlowControlParams(jMSConnectionFactoryBean, jMSConnectionFactoryMBean);
        MBeanConverter.fillInLoadBalancingParams(jMSConnectionFactoryBean, jMSConnectionFactoryMBean);
    }

    private static void fillInDefaultDeliveryParams(JMSConnectionFactoryBean jMSConnectionFactoryBean, JMSConnectionFactoryMBean jMSConnectionFactoryMBean) {
        long l;
        int n;
        DefaultDeliveryParamsBean defaultDeliveryParamsBean = jMSConnectionFactoryBean.getDefaultDeliveryParams();
        String string = jMSConnectionFactoryMBean.getDefaultDeliveryMode();
        if (string != null && !string.equals("Persistent")) {
            defaultDeliveryParamsBean.setDefaultDeliveryMode(string);
        }
        if ((n = jMSConnectionFactoryMBean.getDefaultPriority()) != 4) {
            defaultDeliveryParamsBean.setDefaultPriority(n);
        }
        if ((l = jMSConnectionFactoryMBean.getDefaultTimeToDeliver()) != 0L) {
            defaultDeliveryParamsBean.setDefaultTimeToDeliver(new Long(l).toString());
        }
        if ((l = jMSConnectionFactoryMBean.getDefaultTimeToLive()) != 0L) {
            defaultDeliveryParamsBean.setDefaultTimeToLive(l);
        }
        if ((l = jMSConnectionFactoryMBean.getSendTimeout()) != 10L) {
            defaultDeliveryParamsBean.setSendTimeout(l);
        }
        if ((l = jMSConnectionFactoryMBean.getDefaultRedeliveryDelay()) != 0L) {
            defaultDeliveryParamsBean.setDefaultRedeliveryDelay(l);
        }
    }

    private static void fillInClientParams(JMSConnectionFactoryBean jMSConnectionFactoryBean, JMSConnectionFactoryMBean jMSConnectionFactoryMBean) {
        boolean bl;
        int n;
        ClientParamsBean clientParamsBean = jMSConnectionFactoryBean.getClientParams();
        String string = jMSConnectionFactoryMBean.getClientId();
        if (string != null) {
            clientParamsBean.setClientId(string);
        }
        if ((n = jMSConnectionFactoryMBean.getMessagesMaximum()) != 10) {
            clientParamsBean.setMessagesMaximum(n);
        }
        if ((string = jMSConnectionFactoryMBean.getOverrunPolicy()) != null && !string.equals("KeepOld")) {
            clientParamsBean.setMulticastOverrunPolicy(string);
        }
        if ((string = jMSConnectionFactoryMBean.getAcknowledgePolicy()) != null && !string.equals("All")) {
            clientParamsBean.setAcknowledgePolicy(string);
        }
        if (bl = jMSConnectionFactoryMBean.getAllowCloseInOnMessage()) {
            clientParamsBean.setAllowCloseInOnMessage(bl);
        }
    }

    private static void fillInTransactionParams(JMSConnectionFactoryBean jMSConnectionFactoryBean, JMSConnectionFactoryMBean jMSConnectionFactoryMBean) {
        boolean bl;
        TransactionParamsBean transactionParamsBean = jMSConnectionFactoryBean.getTransactionParams();
        long l = jMSConnectionFactoryMBean.getTransactionTimeout();
        if (l != 3600L) {
            transactionParamsBean.setTransactionTimeout(l);
        }
        if (bl = jMSConnectionFactoryMBean.isXAConnectionFactoryEnabled()) {
            transactionParamsBean.setXAConnectionFactoryEnabled(bl);
        }
        bl = jMSConnectionFactoryMBean.isUserTransactionsEnabled();
        transactionParamsBean.setXAConnectionFactoryEnabled(transactionParamsBean.isXAConnectionFactoryEnabled() || bl);
        bl = jMSConnectionFactoryMBean.isXAServerEnabled();
        transactionParamsBean.setXAConnectionFactoryEnabled(transactionParamsBean.isXAConnectionFactoryEnabled() || bl);
    }

    private static void fillInFlowControlParams(JMSConnectionFactoryBean jMSConnectionFactoryBean, JMSConnectionFactoryMBean jMSConnectionFactoryMBean) {
        int n;
        FlowControlParamsBean flowControlParamsBean = jMSConnectionFactoryBean.getFlowControlParams();
        boolean bl = jMSConnectionFactoryMBean.isFlowControlEnabled();
        if (!bl) {
            flowControlParamsBean.setFlowControlEnabled(bl);
        }
        if ((n = jMSConnectionFactoryMBean.getFlowMinimum()) != 50) {
            flowControlParamsBean.setFlowMinimum(n);
        }
        if ((n = jMSConnectionFactoryMBean.getFlowMaximum()) != 500) {
            flowControlParamsBean.setFlowMaximum(n);
        }
        if ((n = jMSConnectionFactoryMBean.getFlowInterval()) != 60) {
            flowControlParamsBean.setFlowInterval(n);
        }
        if ((n = jMSConnectionFactoryMBean.getFlowSteps()) != 10) {
            flowControlParamsBean.setFlowSteps(n);
        }
    }

    private static void fillInLoadBalancingParams(JMSConnectionFactoryBean jMSConnectionFactoryBean, JMSConnectionFactoryMBean jMSConnectionFactoryMBean) {
        LoadBalancingParamsBean loadBalancingParamsBean = jMSConnectionFactoryBean.getLoadBalancingParams();
        boolean bl = jMSConnectionFactoryMBean.isLoadBalancingEnabled();
        if (!bl) {
            loadBalancingParamsBean.setLoadBalancingEnabled(bl);
        }
        if (!(bl = jMSConnectionFactoryMBean.isServerAffinityEnabled())) {
            loadBalancingParamsBean.setServerAffinityEnabled(bl);
        }
    }

    public static ForeignServerBean addForeignJMSServer(JMSBean jMSBean, ForeignJMSServerMBean foreignJMSServerMBean) {
        return MBeanConverter.addForeignJMSServer(jMSBean, null, foreignJMSServerMBean, foreignJMSServerMBean.getName(), foreignJMSServerMBean.getTargets());
    }

    public static ForeignServerBean addForeignJMSServer(JMSBean jMSBean, JMSSystemResourceMBean jMSSystemResourceMBean, ForeignJMSServerMBean foreignJMSServerMBean, String string, TargetMBean[] targetMBeanArray) {
        ForeignServerBean foreignServerBean = jMSBean.lookupForeignServer(string);
        if (foreignServerBean != null) {
            return foreignServerBean;
        }
        foreignServerBean = jMSBean.createForeignServer(string);
        MBeanConverter.fillInForeignServer(jMSSystemResourceMBean, foreignServerBean, foreignJMSServerMBean, targetMBeanArray);
        return foreignServerBean;
    }

    private static void fillInForeignServer(JMSSystemResourceMBean jMSSystemResourceMBean, ForeignServerBean foreignServerBean, ForeignJMSServerMBean foreignJMSServerMBean, TargetMBean[] targetMBeanArray) {
        Object object;
        Properties properties;
        Object object2;
        if (foreignJMSServerMBean.getNotes() != null) {
            foreignServerBean.setNotes(foreignJMSServerMBean.getNotes());
        }
        if (jMSSystemResourceMBean != null) {
            object2 = jMSSystemResourceMBean.lookupSubDeployment(foreignServerBean.getName());
            if (object2 == null) {
                object2 = jMSSystemResourceMBean.createSubDeployment(foreignServerBean.getName());
            }
            try {
                object2.setTargets(targetMBeanArray);
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new AssertionError((Object)("ERROR: Could not set the targets of JMS foreign server " + foreignServerBean.getName() + " due to " + invalidAttributeValueException));
            }
            catch (DistributedManagementException distributedManagementException) {
                throw new AssertionError((Object)("WARN: Could not set the targets of JMS foreign server " + foreignServerBean.getName() + " due to " + (Object)((Object)distributedManagementException)));
            }
        }
        if ((object2 = foreignJMSServerMBean.getInitialContextFactory()) != null && !((String)object2).equals("weblogic.jndi.WLInitialContextFactory")) {
            foreignServerBean.setInitialContextFactory((String)object2);
        }
        if ((object2 = foreignJMSServerMBean.getConnectionURL()) != null) {
            foreignServerBean.setConnectionURL((String)object2);
        }
        if ((properties = foreignJMSServerMBean.getJNDIProperties()) != null) {
            object = properties.keySet().iterator();
            while (object.hasNext()) {
                PropertyBean propertyBean = null;
                String string = (String)object.next();
                propertyBean = foreignServerBean.createJNDIProperty(string);
                propertyBean.setValue(properties.getProperty(string));
            }
        }
        object = foreignJMSServerMBean.getForeignJMSDestinations();
        for (int i = 0; i < ((Object)object).length; ++i) {
            MBeanConverter.addForeignDestination(foreignServerBean, (ForeignJMSDestinationMBean)object[i]);
        }
        ForeignJMSConnectionFactoryMBean[] foreignJMSConnectionFactoryMBeanArray = foreignJMSServerMBean.getForeignJMSConnectionFactories();
        for (int i = 0; i < foreignJMSConnectionFactoryMBeanArray.length; ++i) {
            MBeanConverter.addForeignConnectionFactory(foreignServerBean, foreignJMSConnectionFactoryMBeanArray[i]);
        }
    }

    public static ForeignDestinationBean addForeignDestination(ForeignServerBean foreignServerBean, ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        ForeignDestinationBean foreignDestinationBean = foreignServerBean.lookupForeignDestination(foreignJMSDestinationMBean.getName());
        if (foreignDestinationBean != null) {
            return foreignDestinationBean;
        }
        foreignDestinationBean = foreignServerBean.createForeignDestination(foreignJMSDestinationMBean.getName());
        MBeanConverter.fillInForeignDestination(foreignDestinationBean, foreignJMSDestinationMBean);
        return foreignDestinationBean;
    }

    private static void fillInForeignDestination(ForeignDestinationBean foreignDestinationBean, ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        MBeanConverter.fillInForeignJNDIObject((ForeignJNDIObjectBean)foreignDestinationBean, foreignJMSDestinationMBean);
    }

    public static ForeignConnectionFactoryBean addForeignConnectionFactory(ForeignServerBean foreignServerBean, ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        ForeignConnectionFactoryBean foreignConnectionFactoryBean = foreignServerBean.lookupForeignConnectionFactory(foreignJMSConnectionFactoryMBean.getName());
        if (foreignConnectionFactoryBean != null) {
            return foreignConnectionFactoryBean;
        }
        foreignConnectionFactoryBean = foreignServerBean.createForeignConnectionFactory(foreignJMSConnectionFactoryMBean.getName());
        MBeanConverter.fillInForeignConnectionFactory(foreignConnectionFactoryBean, foreignJMSConnectionFactoryMBean);
        return foreignConnectionFactoryBean;
    }

    private static void fillInForeignConnectionFactory(ForeignConnectionFactoryBean foreignConnectionFactoryBean, ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        MBeanConverter.fillInForeignJNDIObject((ForeignJNDIObjectBean)foreignConnectionFactoryBean, foreignJMSConnectionFactoryMBean);
        String string = foreignJMSConnectionFactoryMBean.getUsername();
        if (string != null) {
            foreignConnectionFactoryBean.setUsername(string);
        }
        if ((string = foreignJMSConnectionFactoryMBean.getPassword()) != null) {
            foreignConnectionFactoryBean.setPassword(string);
        }
    }

    private static void fillInForeignJNDIObject(ForeignJNDIObjectBean foreignJNDIObjectBean, ForeignJNDIObjectMBean foreignJNDIObjectMBean) {
        if (foreignJNDIObjectMBean.getNotes() != null) {
            foreignJNDIObjectBean.setNotes(foreignJNDIObjectMBean.getNotes());
        }
        foreignJNDIObjectBean.setLocalJNDIName(foreignJNDIObjectMBean.getLocalJNDIName());
        foreignJNDIObjectBean.setRemoteJNDIName(foreignJNDIObjectMBean.getRemoteJNDIName());
    }

    public static DistributedQueueBean addDistributedQueue(JMSBean jMSBean, JMSSystemResourceMBean jMSSystemResourceMBean, JMSDistributedQueueMBean jMSDistributedQueueMBean) throws UpdateException {
        DistributedQueueBean distributedQueueBean = jMSBean.lookupDistributedQueue(jMSDistributedQueueMBean.getName());
        if (distributedQueueBean != null) {
            return distributedQueueBean;
        }
        distributedQueueBean = jMSBean.createDistributedQueue(jMSDistributedQueueMBean.getName());
        MBeanConverter.fillInDistributedDestination(jMSSystemResourceMBean, (DistributedDestinationBean)distributedQueueBean, jMSDistributedQueueMBean);
        MBeanConverter.fillInDistributedQueue(jMSBean, distributedQueueBean, jMSDistributedQueueMBean);
        return distributedQueueBean;
    }

    public static DistributedTopicBean addDistributedTopic(JMSBean jMSBean, JMSSystemResourceMBean jMSSystemResourceMBean, JMSDistributedTopicMBean jMSDistributedTopicMBean) throws UpdateException {
        DistributedTopicBean distributedTopicBean = jMSBean.lookupDistributedTopic(jMSDistributedTopicMBean.getName());
        if (distributedTopicBean != null) {
            return distributedTopicBean;
        }
        distributedTopicBean = jMSBean.createDistributedTopic(jMSDistributedTopicMBean.getName());
        MBeanConverter.fillInDistributedDestination(jMSSystemResourceMBean, (DistributedDestinationBean)distributedTopicBean, jMSDistributedTopicMBean);
        MBeanConverter.fillInDistributedTopic(jMSBean, distributedTopicBean, jMSDistributedTopicMBean);
        return distributedTopicBean;
    }

    public static DistributedDestinationMemberBean addDistributedQueueMember(JMSBean jMSBean, DistributedQueueBean distributedQueueBean, JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) throws UpdateException {
        DistributedDestinationMemberBean distributedDestinationMemberBean = distributedQueueBean.lookupDistributedQueueMember(jMSDistributedQueueMemberMBean.getName());
        if (distributedDestinationMemberBean != null) {
            return distributedDestinationMemberBean;
        }
        distributedDestinationMemberBean = distributedQueueBean.createDistributedQueueMember(jMSDistributedQueueMemberMBean.getName());
        MBeanConverter.fillInDistributedDestinationMember(distributedDestinationMemberBean, jMSDistributedQueueMemberMBean);
        MBeanConverter.fillInDistributedQueueMember(jMSBean, distributedDestinationMemberBean, jMSDistributedQueueMemberMBean);
        return distributedDestinationMemberBean;
    }

    public static DistributedDestinationMemberBean addDistributedTopicMember(JMSBean jMSBean, DistributedTopicBean distributedTopicBean, JMSDistributedTopicMemberMBean jMSDistributedTopicMemberMBean) throws UpdateException {
        DistributedDestinationMemberBean distributedDestinationMemberBean = distributedTopicBean.lookupDistributedTopicMember(jMSDistributedTopicMemberMBean.getName());
        if (distributedDestinationMemberBean != null) {
            return distributedDestinationMemberBean;
        }
        distributedDestinationMemberBean = distributedTopicBean.createDistributedTopicMember(jMSDistributedTopicMemberMBean.getName());
        MBeanConverter.fillInDistributedDestinationMember(distributedDestinationMemberBean, jMSDistributedTopicMemberMBean);
        MBeanConverter.fillInDistributedTopicMember(jMSBean, distributedDestinationMemberBean, jMSDistributedTopicMemberMBean);
        return distributedDestinationMemberBean;
    }

    private static void fillInDistributedDestination(JMSSystemResourceMBean jMSSystemResourceMBean, DistributedDestinationBean distributedDestinationBean, JMSDistributedDestinationMBean jMSDistributedDestinationMBean) {
        JMSTemplateMBean jMSTemplateMBean;
        String string;
        String string2;
        if (jMSDistributedDestinationMBean.getNotes() != null) {
            distributedDestinationBean.setNotes(jMSDistributedDestinationMBean.getNotes());
        }
        if ((string2 = jMSDistributedDestinationMBean.getJNDIName()) != null && string2.length() > 0) {
            distributedDestinationBean.setJNDIName(string2);
        }
        if ((string = jMSDistributedDestinationMBean.getLoadBalancingPolicy()) != null && !string.equals("Round-Robin")) {
            distributedDestinationBean.setLoadBalancingPolicy(string);
        }
        if ((jMSTemplateMBean = jMSDistributedDestinationMBean.getJMSTemplate()) != null) {
            JMSLogger.logTemplateOnDDNotSupported((String)jMSDistributedDestinationMBean.getName(), (String)jMSTemplateMBean.getName());
        }
        if ((jMSTemplateMBean = jMSDistributedDestinationMBean.getTemplate()) != null) {
            JMSLogger.logTemplateOnDDNotSupported((String)jMSDistributedDestinationMBean.getName(), (String)jMSTemplateMBean.getName());
        }
        if (jMSSystemResourceMBean != null) {
            String string3 = distributedDestinationBean.getName();
            SubDeploymentMBean subDeploymentMBean = jMSSystemResourceMBean.lookupSubDeployment(string3);
            if (subDeploymentMBean == null) {
                subDeploymentMBean = jMSSystemResourceMBean.createSubDeployment(string3);
            }
            try {
                subDeploymentMBean.setTargets(jMSDistributedDestinationMBean.getTargets());
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new AssertionError((Object)("ERROR: Could not set the targets of JMS distributed destination " + distributedDestinationBean.getName() + " due to " + invalidAttributeValueException));
            }
            catch (DistributedManagementException distributedManagementException) {
                throw new AssertionError((Object)("ERROR: Could not set the targets of JMS distributed destination " + distributedDestinationBean.getName() + " due to" + (Object)((Object)distributedManagementException)));
            }
        }
    }

    private static void fillInDistributedQueue(JMSBean jMSBean, DistributedQueueBean distributedQueueBean, JMSDistributedQueueMBean jMSDistributedQueueMBean) throws UpdateException {
        int n;
        JMSDistributedQueueMemberMBean[] jMSDistributedQueueMemberMBeanArray = jMSDistributedQueueMBean.getJMSDistributedQueueMembers();
        if (jMSDistributedQueueMemberMBeanArray != null) {
            for (n = 0; n < jMSDistributedQueueMemberMBeanArray.length; ++n) {
                MBeanConverter.addDistributedQueueMember(jMSBean, distributedQueueBean, jMSDistributedQueueMemberMBeanArray[n]);
            }
        }
        if ((n = jMSDistributedQueueMBean.getForwardDelay()) != -1) {
            distributedQueueBean.setForwardDelay(n);
        }
    }

    private static void fillInDistributedTopic(JMSBean jMSBean, DistributedTopicBean distributedTopicBean, JMSDistributedTopicMBean jMSDistributedTopicMBean) throws UpdateException {
        JMSDistributedTopicMemberMBean[] jMSDistributedTopicMemberMBeanArray = jMSDistributedTopicMBean.getJMSDistributedTopicMembers();
        if (jMSDistributedTopicMemberMBeanArray != null) {
            for (int i = 0; i < jMSDistributedTopicMemberMBeanArray.length; ++i) {
                MBeanConverter.addDistributedTopicMember(jMSBean, distributedTopicBean, jMSDistributedTopicMemberMBeanArray[i]);
            }
        }
    }

    private static void fillInDistributedDestinationMember(DistributedDestinationMemberBean distributedDestinationMemberBean, JMSDistributedDestinationMemberMBean jMSDistributedDestinationMemberMBean) {
        int n;
        if (jMSDistributedDestinationMemberMBean.getNotes() != null) {
            distributedDestinationMemberBean.setNotes(jMSDistributedDestinationMemberMBean.getNotes());
        }
        if ((n = jMSDistributedDestinationMemberMBean.getWeight()) != 1) {
            distributedDestinationMemberBean.setWeight(n);
        }
    }

    private static void fillInDistributedQueueMember(JMSBean jMSBean, DistributedDestinationMemberBean distributedDestinationMemberBean, JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) throws UpdateException {
        JMSQueueMBean jMSQueueMBean = jMSDistributedQueueMemberMBean.getJMSQueue();
        if (jMSQueueMBean != null) {
            String string = jMSQueueMBean.getName();
            if (JMSBeanHelper.findDestinationBean(string, jMSBean) == null) {
                MBeanConverter.addQueue(jMSBean, jMSQueueMBean);
            }
            distributedDestinationMemberBean.setPhysicalDestinationName(string);
        }
    }

    private static void fillInDistributedTopicMember(JMSBean jMSBean, DistributedDestinationMemberBean distributedDestinationMemberBean, JMSDistributedTopicMemberMBean jMSDistributedTopicMemberMBean) throws UpdateException {
        JMSTopicMBean jMSTopicMBean = jMSDistributedTopicMemberMBean.getJMSTopic();
        if (jMSTopicMBean != null) {
            String string = jMSTopicMBean.getName();
            if (JMSBeanHelper.findDestinationBean(string, jMSBean) == null) {
                MBeanConverter.addTopic(jMSBean, jMSTopicMBean);
            }
            distributedDestinationMemberBean.setPhysicalDestinationName(string);
        }
    }

    public static DestinationKeyBean addDestinationKey(JMSBean jMSBean, JMSDestinationKeyMBean jMSDestinationKeyMBean) {
        String string;
        String string2;
        String string3;
        DestinationKeyBean destinationKeyBean = jMSBean.createDestinationKey(jMSDestinationKeyMBean.getName());
        if (jMSDestinationKeyMBean.getNotes() != null) {
            destinationKeyBean.setNotes(jMSDestinationKeyMBean.getNotes());
        }
        if ((string3 = jMSDestinationKeyMBean.getProperty()) != null && !"JMSMessageID".equals(string3)) {
            destinationKeyBean.setProperty(string3);
        }
        if ((string2 = jMSDestinationKeyMBean.getKeyType()) != null && !"String".equals(string2)) {
            destinationKeyBean.setKeyType(string2);
        }
        if ((string = jMSDestinationKeyMBean.getDirection()) != null && !"Ascending".equals(string)) {
            destinationKeyBean.setSortOrder(string);
        }
        return destinationKeyBean;
    }

    public static QueueBean addQueue(JMSBean jMSBean, JMSQueueMBean jMSQueueMBean) throws UpdateException {
        return MBeanConverter.addQueue(jMSBean, null, jMSQueueMBean);
    }

    public static QueueBean addQueue(JMSBean jMSBean, JMSSystemResourceMBean jMSSystemResourceMBean, JMSQueueMBean jMSQueueMBean) throws UpdateException {
        boolean bl = false;
        String string = null;
        QueueBean queueBean = jMSBean.lookupQueue(jMSQueueMBean.getName());
        if (queueBean != null) {
            String string2;
            TargetMBean[] targetMBeanArray = MBeanConverter.getTargetsFromDestination(jMSQueueMBean);
            JMSServerMBean jMSServerMBean = null;
            if (targetMBeanArray.length > 0) {
                jMSServerMBean = (JMSServerMBean)targetMBeanArray[0];
                string = jMSServerMBean.getName();
            }
            if ((string2 = queueBean.getSubDeploymentName()) != null && string2.equals(string)) {
                return queueBean;
            }
            JMSLogger.logDestinationNameConflict((String)"JMSQueue", (String)jMSQueueMBean.getName());
            bl = true;
        }
        queueBean = bl ? jMSBean.createQueue(jMSQueueMBean.getName() + "_" + string) : jMSBean.createQueue(jMSQueueMBean.getName());
        MBeanConverter.fillInDestination(jMSBean, jMSSystemResourceMBean, (DestinationBean)queueBean, jMSQueueMBean, bl);
        return queueBean;
    }

    public static TopicBean addTopic(JMSBean jMSBean, JMSTopicMBean jMSTopicMBean) throws UpdateException {
        return MBeanConverter.addTopic(jMSBean, null, jMSTopicMBean);
    }

    public static TopicBean addTopic(JMSBean jMSBean, JMSSystemResourceMBean jMSSystemResourceMBean, JMSTopicMBean jMSTopicMBean) throws UpdateException {
        int n;
        Object object;
        boolean bl = false;
        String string = null;
        TopicBean topicBean = jMSBean.lookupTopic(jMSTopicMBean.getName());
        if (topicBean != null) {
            String string2;
            object = MBeanConverter.getTargetsFromDestination(jMSTopicMBean);
            JMSServerMBean jMSServerMBean = null;
            if (((TargetMBean[])object).length > 0) {
                jMSServerMBean = (JMSServerMBean)object[0];
                string = jMSServerMBean.getName();
            }
            if ((string2 = topicBean.getSubDeploymentName()) != null && string2.equals(string)) {
                return topicBean;
            }
            JMSLogger.logDestinationNameConflict((String)"JMSTopic", (String)jMSTopicMBean.getName());
            bl = true;
        }
        topicBean = bl ? jMSBean.createTopic(jMSTopicMBean.getName() + "_" + string) : jMSBean.createTopic(jMSTopicMBean.getName());
        MBeanConverter.fillInDestination(jMSBean, jMSSystemResourceMBean, (DestinationBean)topicBean, jMSTopicMBean, bl);
        object = jMSTopicMBean.getMulticastAddress();
        if (object != null) {
            topicBean.getMulticast().setMulticastAddress((String)object);
        }
        if ((n = jMSTopicMBean.getMulticastPort()) != 6001) {
            topicBean.getMulticast().setMulticastPort(n);
        }
        if ((n = jMSTopicMBean.getMulticastTTL()) != 1) {
            topicBean.getMulticast().setMulticastTimeToLive(n);
        }
        return topicBean;
    }

    public static String constructQuotaNameFromDestinationName(String string) {
        return string + ".Quota";
    }

    private static TargetMBean[] getTargetsFromDestination(JMSDestinationMBean jMSDestinationMBean) {
        WebLogicMBean webLogicMBean = jMSDestinationMBean.getParent();
        if (webLogicMBean instanceof JMSServerMBean) {
            TargetMBean[] targetMBeanArray = new TargetMBean[]{(TargetMBean)webLogicMBean};
            return targetMBeanArray;
        }
        return new TargetMBean[0];
    }

    private static void warnDeliveryModeOverrideChange(String string, JMSServerMBean jMSServerMBean, String string2) {
        String string3 = jMSServerMBean == null ? "<none>" : jMSServerMBean.getName();
        JMSLogger.logChangingDeliveryModeOverride((String)string, (String)string3, (String)string2, (String)"Non-Persistent");
    }

    private static String errorDeliveryModeOverride(String string, JMSServerMBean jMSServerMBean) {
        String string2 = jMSServerMBean == null ? "<none>" : jMSServerMBean.getName();
        return JMSExceptionLogger.logDeliveryModeMismatchLoggable((String)string, (String)string2).getMessage();
    }

    private static void fillInDestination(JMSBean jMSBean, JMSSystemResourceMBean jMSSystemResourceMBean, DestinationBean destinationBean, JMSDestinationMBean jMSDestinationMBean, boolean bl) throws UpdateException {
        TemplateBean templateBean;
        JMSTemplateMBean jMSTemplateMBean;
        String string;
        JMSDestinationMBean jMSDestinationMBean2;
        String string2;
        int n;
        long l;
        JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray;
        if (jMSDestinationMBean.getNotes() != null) {
            destinationBean.setNotes(jMSDestinationMBean.getNotes());
        }
        if ((jMSDestinationKeyMBeanArray = jMSDestinationMBean.getDestinationKeys()) != null) {
            String[] stringArray = new String[jMSDestinationKeyMBeanArray.length];
            for (int i = 0; i < jMSDestinationKeyMBeanArray.length; ++i) {
                String string3;
                stringArray[i] = string3 = jMSDestinationKeyMBeanArray[i].getName();
                if (jMSBean.lookupDestinationKey(string3) != null) continue;
                MBeanConverter.addDestinationKey(jMSBean, jMSDestinationKeyMBeanArray[i]);
            }
            destinationBean.setDestinationKeys(stringArray);
        }
        if ((l = jMSDestinationMBean.getBytesThresholdHigh()) >= 0L) {
            destinationBean.getThresholds().setBytesHigh(l);
        }
        if ((l = jMSDestinationMBean.getBytesThresholdLow()) >= 0L) {
            destinationBean.getThresholds().setBytesLow(l);
        }
        if ((l = jMSDestinationMBean.getMessagesThresholdHigh()) >= 0L) {
            destinationBean.getThresholds().setMessagesHigh(l);
        }
        if ((l = jMSDestinationMBean.getMessagesThresholdLow()) >= 0L) {
            destinationBean.getThresholds().setMessagesLow(l);
        }
        if ((n = jMSDestinationMBean.getPriorityOverride()) >= 0) {
            destinationBean.getDeliveryParamsOverrides().setPriority(n);
        }
        if ((string2 = jMSDestinationMBean.getTimeToDeliverOverride()) != null && !string2.equals("-1")) {
            destinationBean.getDeliveryParamsOverrides().setTimeToDeliver(string2);
        }
        if ((l = jMSDestinationMBean.getRedeliveryDelayOverride()) >= 0L) {
            destinationBean.getDeliveryParamsOverrides().setRedeliveryDelay(l);
        }
        if ((jMSDestinationMBean2 = jMSDestinationMBean.getErrorDestination()) != null) {
            string = jMSDestinationMBean2.getName();
            DestinationBean destinationBean2 = JMSBeanHelper.findDestinationBean(string, jMSBean);
            if (destinationBean2 == null) {
                if (jMSDestinationMBean2 instanceof JMSQueueMBean) {
                    destinationBean2 = MBeanConverter.addQueue(jMSBean, (JMSQueueMBean)jMSDestinationMBean2);
                } else if (jMSDestinationMBean2 instanceof JMSTopicMBean) {
                    destinationBean2 = MBeanConverter.addTopic(jMSBean, (JMSTopicMBean)jMSDestinationMBean2);
                } else {
                    throw new AssertionError((Object)("ERROR: Error destination " + string + " for destination " + jMSDestinationMBean.getName() + " is neither queue nor topic"));
                }
            }
            destinationBean.getDeliveryFailureParams().setErrorDestination(destinationBean2);
        }
        if ((n = jMSDestinationMBean.getRedeliveryLimit()) >= 0) {
            destinationBean.getDeliveryFailureParams().setRedeliveryLimit(n);
        }
        if ((l = jMSDestinationMBean.getTimeToLiveOverride()) >= 0L) {
            destinationBean.getDeliveryParamsOverrides().setTimeToLive(l);
        }
        if ((string2 = jMSDestinationMBean.getExpirationPolicy()) != null && !string2.equals("Discard")) {
            destinationBean.getDeliveryFailureParams().setExpirationPolicy(string2);
        }
        if ((string2 = jMSDestinationMBean.getExpirationLoggingPolicy()) != null) {
            destinationBean.getDeliveryFailureParams().setExpirationLoggingPolicy(string2);
        }
        if ((n = jMSDestinationMBean.getMaximumMessageSize()) != Integer.MAX_VALUE) {
            destinationBean.setMaximumMessageSize(n);
        }
        if ((string = jMSDestinationMBean.getJNDIName()) != null && string.length() > 0) {
            boolean bl2 = jMSDestinationMBean.isJNDINameReplicated();
            if (bl2) {
                destinationBean.setJNDIName(string);
            } else {
                destinationBean.setLocalJNDIName(string);
            }
        }
        TargetMBean[] targetMBeanArray = MBeanConverter.getTargetsFromDestination(jMSDestinationMBean);
        JMSServerMBean jMSServerMBean = null;
        if (targetMBeanArray.length > 0) {
            jMSServerMBean = (JMSServerMBean)targetMBeanArray[0];
            String string4 = targetMBeanArray[0].getName();
            destinationBean.setSubDeploymentName(string4);
            if (bl) {
                destinationBean.setJMSCreateDestinationIdentifier(jMSDestinationMBean.getName());
            }
            if (jMSSystemResourceMBean != null) {
                SubDeploymentMBean subDeploymentMBean = jMSSystemResourceMBean.lookupSubDeployment(string4);
                if (subDeploymentMBean == null) {
                    subDeploymentMBean = jMSSystemResourceMBean.createSubDeployment(string4);
                }
                try {
                    subDeploymentMBean.setTargets(targetMBeanArray);
                }
                catch (InvalidAttributeValueException invalidAttributeValueException) {
                    throw new AssertionError((Object)("ERROR: Could not set the targets of JMS destination " + destinationBean.getName() + " due to " + invalidAttributeValueException));
                }
                catch (DistributedManagementException distributedManagementException) {
                    throw new AssertionError((Object)("ERROR: Could not set the targets of JMS destination " + destinationBean.getName() + " due to" + (Object)((Object)distributedManagementException)));
                }
            }
        }
        int n2 = (string2 = jMSDestinationMBean.getStoreEnabled()) == null || string2.equalsIgnoreCase("default") ? 0 : (string2.equalsIgnoreCase("true") ? 1 : 2);
        string2 = jMSDestinationMBean.getDeliveryModeOverride();
        int n3 = string2 == null || string2.equalsIgnoreCase("No-Delivery") ? 0 : (string2.equalsIgnoreCase("Persistent") ? 1 : 2);
        boolean bl3 = jMSServerMBean == null || jMSServerMBean.getStore() != null || jMSServerMBean.getPersistentStore() != null;
        block1 : switch (n2) {
            case 0: {
                switch (n3) {
                    case 0: {
                        if (bl3) break block1;
                        MBeanConverter.warnDeliveryModeOverrideChange(destinationBean.getName(), jMSServerMBean, "No-Delivery");
                        destinationBean.getDeliveryParamsOverrides().setDeliveryMode("Non-Persistent");
                        break block1;
                    }
                    case 1: {
                        if (bl3) {
                            destinationBean.getDeliveryParamsOverrides().setDeliveryMode("Persistent");
                            break block1;
                        }
                        MBeanConverter.warnDeliveryModeOverrideChange(destinationBean.getName(), jMSServerMBean, "Persistent");
                        destinationBean.getDeliveryParamsOverrides().setDeliveryMode("Non-Persistent");
                        break block1;
                    }
                    case 2: {
                        destinationBean.getDeliveryParamsOverrides().setDeliveryMode("Non-Persistent");
                        break block1;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown deliveryModeOverride=" + n3 + " storeValue=" + n2));
                    }
                }
            }
            case 1: {
                switch (n3) {
                    case 0: {
                        if (bl3) break block1;
                        throw new UpdateException(MBeanConverter.errorDeliveryModeOverride(destinationBean.getName(), jMSServerMBean));
                    }
                    case 1: {
                        if (bl3) {
                            destinationBean.getDeliveryParamsOverrides().setDeliveryMode("Persistent");
                            break block1;
                        }
                        throw new UpdateException(MBeanConverter.errorDeliveryModeOverride(destinationBean.getName(), jMSServerMBean));
                    }
                    case 2: {
                        if (bl3) {
                            destinationBean.getDeliveryParamsOverrides().setDeliveryMode("Non-Persistent");
                            break block1;
                        }
                        throw new UpdateException(MBeanConverter.errorDeliveryModeOverride(destinationBean.getName(), jMSServerMBean));
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown deliveryModeOverride=" + n3 + " storeValue=" + n2));
                    }
                }
            }
            case 2: {
                switch (n3) {
                    case 0: {
                        MBeanConverter.warnDeliveryModeOverrideChange(destinationBean.getName(), jMSServerMBean, "No-Delivery");
                        destinationBean.getDeliveryParamsOverrides().setDeliveryMode("Non-Persistent");
                        break block1;
                    }
                    case 1: {
                        MBeanConverter.warnDeliveryModeOverrideChange(destinationBean.getName(), jMSServerMBean, "Persistent");
                        destinationBean.getDeliveryParamsOverrides().setDeliveryMode("Non-Persistent");
                        break block1;
                    }
                    case 2: {
                        destinationBean.getDeliveryParamsOverrides().setDeliveryMode("Non-Persistent");
                        break block1;
                    }
                }
                throw new AssertionError((Object)("Unknown deliveryModeOverride=" + n3 + " storeValue=" + n2));
            }
            default: {
                throw new AssertionError((Object)("Unknown storeValue=" + n2));
            }
        }
        if ((jMSTemplateMBean = jMSDestinationMBean.getTemplate()) != null) {
            templateBean = MBeanConverter.addTemplate(jMSBean, jMSTemplateMBean);
            destinationBean.setTemplate(templateBean);
        }
        if (jMSDestinationMBean.getBytesMaximum() != -1L || jMSDestinationMBean.getMessagesMaximum() != -1L) {
            templateBean = MBeanConverter.addQuota(jMSBean, MBeanConverter.constructQuotaNameFromDestinationName(jMSDestinationMBean.getName()), jMSDestinationMBean.getBytesMaximum(), jMSDestinationMBean.getMessagesMaximum());
            destinationBean.setQuota((QuotaBean)templateBean);
        }
    }

    private static QuotaBean addQuota(JMSBean jMSBean, String string, long l, long l2) {
        QuotaBean quotaBean = jMSBean.lookupQuota(string);
        if (quotaBean != null) {
            return quotaBean;
        }
        quotaBean = jMSBean.createQuota(string);
        if (l >= 0L) {
            quotaBean.setBytesMaximum(l);
        }
        if (l2 >= 0L) {
            quotaBean.setMessagesMaximum(l2);
        }
        quotaBean.setShared(false);
        return quotaBean;
    }

    public static TemplateBean addTemplate(JMSBean jMSBean, JMSTemplateMBean jMSTemplateMBean) throws UpdateException {
        String string;
        JMSDestinationMBean jMSDestinationMBean;
        String string2;
        int n;
        long l;
        JMSDestinationKeyMBean[] jMSDestinationKeyMBeanArray;
        TemplateBean templateBean = jMSBean.lookupTemplate(jMSTemplateMBean.getName());
        if (templateBean != null) {
            return templateBean;
        }
        templateBean = jMSBean.createTemplate(jMSTemplateMBean.getName());
        if (jMSTemplateMBean.getNotes() != null) {
            templateBean.setNotes(jMSTemplateMBean.getNotes());
        }
        if ((jMSDestinationKeyMBeanArray = jMSTemplateMBean.getDestinationKeys()) != null) {
            String[] stringArray = new String[jMSDestinationKeyMBeanArray.length];
            for (int i = 0; i < jMSDestinationKeyMBeanArray.length; ++i) {
                String string3;
                stringArray[i] = string3 = jMSDestinationKeyMBeanArray[i].getName();
                if (jMSBean.lookupDestinationKey(string3) != null) continue;
                MBeanConverter.addDestinationKey(jMSBean, jMSDestinationKeyMBeanArray[i]);
            }
            templateBean.setDestinationKeys(stringArray);
        }
        if ((l = jMSTemplateMBean.getBytesThresholdHigh()) >= 0L) {
            templateBean.getThresholds().setBytesHigh(l);
        }
        if ((l = jMSTemplateMBean.getBytesThresholdLow()) >= 0L) {
            templateBean.getThresholds().setBytesLow(l);
        }
        if ((l = jMSTemplateMBean.getMessagesThresholdHigh()) >= 0L) {
            templateBean.getThresholds().setMessagesHigh(l);
        }
        if ((l = jMSTemplateMBean.getMessagesThresholdLow()) >= 0L) {
            templateBean.getThresholds().setMessagesLow(l);
        }
        if ((n = jMSTemplateMBean.getPriorityOverride()) >= 0) {
            templateBean.getDeliveryParamsOverrides().setPriority(n);
        }
        if ((string2 = jMSTemplateMBean.getTimeToDeliverOverride()) != null && !string2.equals("-1")) {
            templateBean.getDeliveryParamsOverrides().setTimeToDeliver(string2);
        }
        if ((l = jMSTemplateMBean.getRedeliveryDelayOverride()) >= 0L) {
            templateBean.getDeliveryParamsOverrides().setRedeliveryDelay(l);
        }
        if ((jMSDestinationMBean = jMSTemplateMBean.getErrorDestination()) != null) {
            string = jMSDestinationMBean.getName();
            DestinationBean destinationBean = JMSBeanHelper.findDestinationBean(string, jMSBean);
            if (destinationBean == null) {
                if (jMSDestinationMBean instanceof JMSQueueMBean) {
                    destinationBean = MBeanConverter.addQueue(jMSBean, (JMSQueueMBean)jMSDestinationMBean);
                } else if (jMSDestinationMBean instanceof JMSTopicMBean) {
                    destinationBean = MBeanConverter.addTopic(jMSBean, (JMSTopicMBean)jMSDestinationMBean);
                } else {
                    throw new AssertionError((Object)("ERROR: Error destination " + string + " of template " + jMSTemplateMBean.getName() + " is neither queue nor topic"));
                }
            }
            templateBean.getDeliveryFailureParams().setErrorDestination(destinationBean);
        }
        if ((n = jMSTemplateMBean.getRedeliveryLimit()) >= 0) {
            templateBean.getDeliveryFailureParams().setRedeliveryLimit(n);
        }
        if ((l = jMSTemplateMBean.getTimeToLiveOverride()) >= 0L) {
            templateBean.getDeliveryParamsOverrides().setTimeToLive(l);
        }
        if ((string2 = jMSTemplateMBean.getDeliveryModeOverride()) != null && !string2.equals("No-Delivery")) {
            templateBean.getDeliveryParamsOverrides().setDeliveryMode(string2);
        }
        if ((string2 = jMSTemplateMBean.getExpirationPolicy()) != null) {
            templateBean.getDeliveryFailureParams().setExpirationPolicy(string2);
        }
        if ((string2 = jMSTemplateMBean.getExpirationLoggingPolicy()) != null) {
            templateBean.getDeliveryFailureParams().setExpirationLoggingPolicy(string2);
        }
        if ((n = jMSTemplateMBean.getMaximumMessageSize()) != Integer.MAX_VALUE) {
            templateBean.setMaximumMessageSize(n);
        }
        string = MBeanConverter.addQuota(jMSBean, MBeanConverter.constructQuotaNameFromDestinationName(jMSTemplateMBean.getName()), jMSTemplateMBean.getBytesMaximum(), jMSTemplateMBean.getMessagesMaximum());
        if (jMSTemplateMBean.getBytesMaximum() >= 0L || jMSTemplateMBean.getMessagesMaximum() >= 0L) {
            templateBean.setQuota((QuotaBean)string);
        }
        return templateBean;
    }

    public static JMSDestinationMBean findErrorQueue(DomainMBean domainMBean, String string) {
        if (domainMBean == null || string == null) {
            return null;
        }
        JMSServerMBean[] jMSServerMBeanArray = domainMBean.getJMSServers();
        if (jMSServerMBeanArray == null) {
            return null;
        }
        for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
            JMSServerMBean jMSServerMBean = jMSServerMBeanArray[i];
            JMSQueueMBean[] jMSQueueMBeanArray = jMSServerMBean.getJMSQueues();
            for (int j = 0; j < jMSQueueMBeanArray.length; ++j) {
                JMSQueueMBean jMSQueueMBean = jMSQueueMBeanArray[j];
                if (!string.equals(jMSQueueMBean.getName())) continue;
                return jMSQueueMBean;
            }
            JMSTopicMBean[] jMSTopicMBeanArray = jMSServerMBean.getJMSTopics();
            for (int j = 0; j < jMSTopicMBeanArray.length; ++j) {
                JMSTopicMBean jMSTopicMBean = jMSTopicMBeanArray[j];
                if (!string.equals(jMSTopicMBean.getName())) continue;
                return jMSTopicMBean;
            }
        }
        return null;
    }

    public static HashMap splitDeployment(DeploymentMBean deploymentMBean) {
        HashMap hashMap = new HashMap();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap<String, TargetMBean> hashMap3 = new HashMap<String, TargetMBean>();
        HashMap<String, ClusterMBean> hashMap4 = new HashMap<String, ClusterMBean>();
        HashMap<String, ServerMBean> hashMap5 = new HashMap<String, ServerMBean>();
        TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
        if (targetMBeanArray != null && targetMBeanArray.length > 1) {
            Object object;
            Object object2;
            Object object3;
            int n;
            for (n = 0; n < targetMBeanArray.length; ++n) {
                if (!(targetMBeanArray[n] instanceof ClusterMBean) || hashMap4.containsValue((ClusterMBean)targetMBeanArray[n])) continue;
                hashMap4.put(targetMBeanArray[n].getName(), (ClusterMBean)targetMBeanArray[n]);
                object3 = deploymentMBean.getName() + "_" + targetMBeanArray[n].getName();
                object2 = new ArrayList();
                ((ArrayList)object2).add(targetMBeanArray[n]);
                hashMap.put(object3, object2);
            }
            for (n = 0; n < targetMBeanArray.length; ++n) {
                if (!(targetMBeanArray[n] instanceof ServerMBean)) continue;
                object3 = ((ServerMBean)targetMBeanArray[n]).getCluster();
                if (object3 != null) {
                    if (hashMap4.containsValue(object3)) continue;
                    hashMap2.put(targetMBeanArray[n].getName(), object3);
                    hashMap3.put(targetMBeanArray[n].getName(), targetMBeanArray[n]);
                    continue;
                }
                if (hashMap5.containsValue((ServerMBean)targetMBeanArray[n])) continue;
                hashMap5.put(targetMBeanArray[n].getName(), (ServerMBean)targetMBeanArray[n]);
                object2 = deploymentMBean.getName() + "_" + targetMBeanArray[n].getName();
                object = new ArrayList<TargetMBean>();
                ((ArrayList)object).add(targetMBeanArray[n]);
                hashMap.put(object2, object);
            }
            Iterator iterator = hashMap2.values().iterator();
            object3 = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = new ArrayList<TargetMBean>();
                object = null;
                ClusterMBean clusterMBean = (ClusterMBean)iterator.next();
                while (object3.hasNext()) {
                    String string = (String)object3.next();
                    ClusterMBean clusterMBean2 = (ClusterMBean)hashMap2.get(string);
                    if (!clusterMBean2.getName().equals(clusterMBean.getName())) continue;
                    TargetMBean targetMBean = (TargetMBean)hashMap3.get(string);
                    ((ArrayList)object2).add(targetMBean);
                    if (object != null) {
                        object = object + "_" + string;
                        continue;
                    }
                    object = deploymentMBean.getName() + "_" + string;
                }
                if (object == null) continue;
                hashMap.put(object, object2);
            }
        }
        return hashMap;
    }
}

