/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.cluster.migration.Migratable;
import weblogic.cluster.migration.MigrationException;
import weblogic.cluster.migration.MigrationManager;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorUpdateEvent;
import weblogic.descriptor.DescriptorUpdateListener;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSTargetsListener;
import weblogic.jms.common.ModuleName;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.JMSComponent;
import weblogic.jms.module.TargetingHelper;
import weblogic.jms.saf.SAFService;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.utils.GenericBeanListener;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.classloaders.GenericClassLoader;

public abstract class ModuleCoordinator
implements Module,
UpdateListener,
DescriptorUpdateListener {
    public TargetingHelper targeter;
    private static final String DOT = ".";
    protected static final int MOD_TYPE_DEPLOYMENT = 0;
    protected static final int MOD_TYPE_SYSTEM = 1;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String earModuleName;
    private String uri;
    private ApplicationContextInternal appCtx;
    protected ModuleName moduleName;
    private JMSComponent jmsComponent;
    private int moduleType;
    private DeploymentListener deploymentListener = new DeploymentListener();
    private GenericBeanListener targetingAdditionsListener;
    private GenericBeanListener earBasicListener;
    private JMSTargetsListener jmsListener = new JMSTargetsListenerImpl();
    private JMSTargetsListener safListener = new JMSTargetsListenerImpl();
    private HashMap targetingListenees = new HashMap();
    private HashMap registeredMigratableTargets = new HashMap();
    private boolean hasUpdate = false;
    private Object update;
    private boolean hasCalledPrepareUpdate = false;
    private String hasGottenModulePrepareUpdate = null;
    private boolean hasMigratableUpdate = false;
    private DomainMBean hasMigratableUpdateDomain = null;
    private boolean hasCalledMigratablePrepareUpdate = false;
    private boolean isActive = false;
    private static final HashMap deploymentAdditions = new HashMap();
    private ASMActivateHandler asmActivateHandler = null;
    private ASMDeactivateHandler asmDeactivateHandler = null;

    protected ModuleCoordinator(String string, String string2) {
        this.earModuleName = string;
        this.uri = string2;
    }

    protected abstract DescriptorBean getModuleDescriptor();

    protected abstract void initializeModule(ApplicationContextInternal var1, DomainMBean var2) throws ModuleException;

    protected abstract void prepare(DomainMBean var1) throws ModuleException;

    protected abstract void activate(DomainMBean var1) throws ModuleException;

    protected abstract void deactivate(DomainMBean var1) throws ModuleException;

    protected abstract void unprepare(DomainMBean var1) throws ModuleException;

    protected abstract void destroy(DomainMBean var1) throws ModuleException;

    protected abstract void remove(DomainMBean var1) throws ModuleException;

    protected abstract Object prepareUpdate(DomainMBean var1) throws ModuleException;

    protected abstract void activateUpdate(DomainMBean var1, Object var2) throws ModuleException;

    protected abstract void rollbackUpdate(DomainMBean var1, Object var2);

    protected int getModuleType() {
        return this.moduleType;
    }

    public String getId() {
        return this.uri;
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[]{this.jmsComponent};
    }

    public DescriptorBean[] getDescriptors() {
        DescriptorBean[] descriptorBeanArray = new DescriptorBean[]{this.getModuleDescriptor()};
        return descriptorBeanArray;
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.internalInit((ApplicationContextInternal)applicationContext, registration);
        return genericClassLoader;
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.internalInit((ApplicationContextInternal)applicationContext, registration);
    }

    public void prepare() throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module prepare called in " + this.moduleName);
        }
        DomainMBean domainMBean = this.getDomainFromAppCtx();
        this.prepare(domainMBean);
    }

    public void activate() throws ModuleException {
        int n;
        ConfigurationMBean[] configurationMBeanArray;
        BasicDeploymentMBean basicDeploymentMBean;
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module activate called in " + this.moduleName);
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.activate(domainMBean);
        TargetInfoMBean targetInfoMBean = this.getTargetingBean(domainMBean);
        if (targetInfoMBean != null && targetInfoMBean instanceof BasicDeploymentMBean) {
            basicDeploymentMBean = (BasicDeploymentMBean)targetInfoMBean;
            configurationMBeanArray = basicDeploymentMBean.getSubDeployments();
            for (n = 0; n < configurationMBeanArray.length; ++n) {
                SubDeploymentMBean subDeploymentMBean;
                SubDeploymentMBean subDeploymentMBean2 = subDeploymentMBean = configurationMBeanArray[n];
                subDeploymentMBean2.addBeanUpdateListener(this.deploymentListener);
                this.targetingListenees.put(subDeploymentMBean.getName(), subDeploymentMBean);
            }
            this.targetingAdditionsListener = new GenericBeanListener(basicDeploymentMBean, this, null, deploymentAdditions, true);
        } else {
            if (targetInfoMBean != null) {
                this.activateSubDeploymentListener((SubDeploymentMBean)targetInfoMBean);
                this.targetingAdditionsListener = new GenericBeanListener(targetInfoMBean, this, null, deploymentAdditions, true);
            }
            basicDeploymentMBean = this.getBasicDeployment(domainMBean);
            this.earBasicListener = new GenericBeanListener(basicDeploymentMBean, new EARSubDeploymentListener(), null, deploymentAdditions, true);
        }
        basicDeploymentMBean = domainMBean.getDescriptor();
        basicDeploymentMBean.addUpdateListener(this);
        this.asmActivateHandler = new ASMActivateHandler();
        this.asmDeactivateHandler = new ASMDeactivateHandler();
        configurationMBeanArray = domainMBean.getMigratableTargets();
        for (n = 0; n < configurationMBeanArray.length; ++n) {
            if (this.registeredMigratableTargets.get(configurationMBeanArray[n].getName()) != null) continue;
            try {
                if (JMSDebug.JMSModule.isDebugEnabled()) {
                    JMSDebug.JMSModule.debug("INFO: Registering JMS module =" + this.getName() + " for MT =" + configurationMBeanArray[n].getName());
                }
                MigrationManager.singleton().register(this.asmActivateHandler, (MigratableTargetMBean)configurationMBeanArray[n]);
                MigrationManager.singleton().register(this.asmDeactivateHandler, (MigratableTargetMBean)configurationMBeanArray[n]);
                this.registeredMigratableTargets.put(configurationMBeanArray[n].getName(), configurationMBeanArray[n]);
                continue;
            }
            catch (MigrationException migrationException) {
                throw new ModuleException(migrationException);
            }
        }
        JMSService.getJMSService().addJMSServerListener(this.jmsListener);
        SAFService.getSAFService().getDeployer().addSAFAgentListener(this.safListener);
        this.isActive = true;
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module activate finished in " + this.moduleName);
        }
    }

    private void activateSubDeploymentListener(SubDeploymentMBean subDeploymentMBean) {
        SubDeploymentMBean[] subDeploymentMBeanArray = subDeploymentMBean.getSubDeployments();
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            SubDeploymentMBean subDeploymentMBean2 = subDeploymentMBeanArray[i];
            SubDeploymentMBean subDeploymentMBean3 = subDeploymentMBeanArray[i];
            subDeploymentMBean3.addBeanUpdateListener(this.deploymentListener);
            this.targetingListenees.put(subDeploymentMBean2.getName(), subDeploymentMBean2);
        }
    }

    public void start() throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("JMSModule: module start called in " + this.moduleName);
        }
    }

    public void deactivate() throws ModuleException {
        Object object;
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module deactivate called in " + this.moduleName);
        }
        this.isActive = false;
        JMSService.getJMSService().removeJMSServerListener(this.jmsListener);
        SAFService.getSAFService().getDeployer().removeSAFAgentListener(this.safListener);
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        Descriptor descriptor = domainMBean.getDescriptor();
        descriptor.removeUpdateListener((DescriptorUpdateListener)this);
        Iterator iterator = this.registeredMigratableTargets.values().iterator();
        while (iterator.hasNext()) {
            object = (MigratableTargetMBean)iterator.next();
            try {
                if (JMSDebug.JMSModule.isDebugEnabled()) {
                    JMSDebug.JMSModule.debug("INFO: Unregistering JMS module =" + this.getName() + " for MT =" + object.getName());
                }
                MigrationManager.singleton().unregister(this.asmActivateHandler, (MigratableTargetMBean)object);
                MigrationManager.singleton().unregister(this.asmDeactivateHandler, (MigratableTargetMBean)object);
                iterator.remove();
            }
            catch (MigrationException migrationException) {
                throw new ModuleException(migrationException);
            }
        }
        if (this.earBasicListener != null) {
            this.earBasicListener.close();
            this.earBasicListener = null;
        }
        this.deactivateSubDeploymentListener();
        if (this.hasCalledPrepareUpdate) {
            this.hasUpdate = false;
            object = this.update;
            this.update = null;
            this.hasCalledPrepareUpdate = false;
            this.hasGottenModulePrepareUpdate = null;
            this.rollbackUpdate(domainMBean, object);
        } else if (this.hasCalledMigratablePrepareUpdate) {
            this.hasMigratableUpdate = false;
            object = this.update;
            this.update = null;
            this.hasCalledMigratablePrepareUpdate = false;
            this.hasGottenModulePrepareUpdate = null;
            this.rollbackUpdate(domainMBean, object);
        }
        this.deactivate(domainMBean);
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module deactivate finished in " + this.moduleName);
        }
    }

    public void deactivateSubDeploymentListener() {
        if (this.targetingAdditionsListener != null) {
            this.targetingAdditionsListener.close();
            this.targetingAdditionsListener = null;
        }
        for (String string : this.targetingListenees.keySet()) {
            DescriptorBean descriptorBean = (DescriptorBean)this.targetingListenees.get(string);
            descriptorBean.removeBeanUpdateListener((BeanUpdateListener)this.deploymentListener);
        }
        this.targetingListenees.clear();
    }

    public void unprepare() throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module unprepare called in " + this.moduleName);
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.unprepare(domainMBean);
    }

    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module destroy called in " + this.moduleName);
        }
        registration.removeUpdateListener(this);
        this.closeJMSComponent();
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.destroy(domainMBean);
    }

    public void remove() throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module remove called in " + this.moduleName);
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.remove(domainMBean);
    }

    public void adminToProduction() {
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws ModuleException {
    }

    public void forceProductionToAdmin() throws ModuleException {
    }

    public boolean acceptURI(String string) {
        if (string == null || this.uri.equals(string) || DOT.equals(string)) {
            return true;
        }
        if (this.targetingListenees.containsKey(string)) {
            return true;
        }
        if (this.earModuleName != null && string.startsWith(this.earModuleName)) {
            return true;
        }
        DomainMBean domainMBean = this.appCtx.getProposedDomain();
        if (domainMBean == null) {
            return false;
        }
        BasicDeploymentMBean basicDeploymentMBean = this.getBasicDeployment(domainMBean);
        SubDeploymentMBean[] subDeploymentMBeanArray = basicDeploymentMBean.getSubDeployments();
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            SubDeploymentMBean subDeploymentMBean = subDeploymentMBeanArray[i];
            if (this.earModuleName == null) {
                if (!subDeploymentMBean.getName().equals(string)) continue;
                return true;
            }
            if (!this.earModuleName.equals(subDeploymentMBean.getName())) continue;
            SubDeploymentMBean[] subDeploymentMBeanArray2 = subDeploymentMBean.getSubDeployments();
            for (int j = 0; j < subDeploymentMBeanArray2.length; ++j) {
                SubDeploymentMBean subDeploymentMBean2 = subDeploymentMBeanArray2[j];
                if (!subDeploymentMBean2.getName().equals(string)) continue;
                return true;
            }
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: Saying no because no criteria matched " + this.moduleName + " with proposed uri=\"" + string + "\" local uri=\"" + this.uri + "\" ear name=\"" + this.earModuleName + "\"");
        }
        return false;
    }

    public void prepareUpdate(String string) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module prepareUpdate called in " + this.moduleName + " with uri " + string + " globalURI=" + this.uri);
        }
        if (!this.isActive) {
            StackTraceUtils.dumpStack();
            throw new AssertionError((Object)("We got a prepareUpdate call, but we are not in the ACTIVE state in module " + this.moduleName));
        }
        if (this.hasCalledPrepareUpdate) {
            if (this.hasGottenModulePrepareUpdate == null) {
                this.hasGottenModulePrepareUpdate = string;
            }
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: module prepareUpdate exits, work already done for " + this.moduleName);
            }
            return;
        }
        this.update = this.prepareUpdate(this.getProposedDomain());
        this.hasUpdate = true;
        this.hasCalledPrepareUpdate = true;
        this.hasGottenModulePrepareUpdate = string;
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module prepareUpdate exits normally in " + this.moduleName);
        }
    }

    public void activateUpdate(String string) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module activateUpdate called in " + this.moduleName);
        }
        if (!this.hasUpdate) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: module activateUpdate exiting with no updates in " + this.moduleName);
            }
            return;
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.hasUpdate = false;
        Object object = this.update;
        this.update = null;
        this.hasCalledPrepareUpdate = false;
        this.hasGottenModulePrepareUpdate = null;
        this.activateUpdate(domainMBean, object);
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module activateUpdate exiting successfully in " + this.moduleName);
        }
    }

    public void rollbackUpdate(String string) {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module rollbackUpdate called in " + this.moduleName);
        }
        if (!this.hasUpdate) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: module rollbackUpdate exiting with no updates in " + this.moduleName);
            }
            return;
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.hasUpdate = false;
        Object object = this.update;
        this.update = null;
        this.hasCalledPrepareUpdate = false;
        this.hasGottenModulePrepareUpdate = null;
        this.rollbackUpdate(domainMBean, object);
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module rollbackUpdate exiting successfully in " + this.moduleName);
        }
    }

    private void prepareMigratableUpdate() throws DescriptorUpdateRejectedException {
        if (!this.hasMigratableUpdate || this.hasMigratableUpdateDomain == null) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: finisher prepareMigratableUpdate exits with no updates in " + this.moduleName);
            }
            return;
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: finisher prepareMigratableUpdate called in " + this.moduleName);
        }
        if (!this.hasCalledMigratablePrepareUpdate) {
            try {
                this.update = this.prepareUpdate(this.hasMigratableUpdateDomain);
                this.hasCalledMigratablePrepareUpdate = true;
            }
            catch (ModuleException moduleException) {
                throw new DescriptorUpdateRejectedException(moduleException.getMessage(), (Throwable)((Object)moduleException));
            }
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: finisher prepareMigratableUpdate exits in " + this.moduleName);
        }
    }

    public void prepareUpdate(DescriptorUpdateEvent descriptorUpdateEvent) throws DescriptorUpdateRejectedException {
        if (!this.hasUpdate) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: finisher prepareUpdate exits with no updates in " + this.moduleName);
            }
            return;
        }
        Descriptor descriptor = descriptorUpdateEvent.getProposedDescriptor();
        DescriptorBean descriptorBean = descriptor.getRootBean();
        DomainMBean domainMBean = (DomainMBean)descriptorBean;
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: finisher prepareUpdate called in " + this.moduleName);
        }
        if (!this.hasCalledPrepareUpdate) {
            try {
                this.update = this.prepareUpdate(domainMBean);
                this.hasCalledPrepareUpdate = true;
            }
            catch (ModuleException moduleException) {
                throw new DescriptorUpdateRejectedException(moduleException.getMessage(), (Throwable)((Object)moduleException));
            }
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: finisher prepareUpdate exits in " + this.moduleName);
        }
    }

    private void activateMigratableUpdate() {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: finisher activateMigratableUpdate called in " + this.moduleName);
        }
        if (!this.hasMigratableUpdate) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: finisher activateMigratableUpdate exiting with no changes in " + this.moduleName + " hasUpdate=" + this.hasMigratableUpdate + " hasGottenModulePrepareUpdate=" + this.hasGottenModulePrepareUpdate);
            }
            return;
        }
        this.hasMigratableUpdate = false;
        this.resetMigratableUpdateInfo();
        Object object = this.update;
        this.update = null;
        this.hasCalledMigratablePrepareUpdate = false;
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        try {
            this.activateUpdate(domainMBean, object);
        }
        catch (ModuleException moduleException) {
            JMSLogger.logActivateFailedDuringTargetingChange((String)this.moduleName.toString(), (String)moduleException.toString());
        }
    }

    public void activateUpdate(DescriptorUpdateEvent descriptorUpdateEvent) {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: finisher activateUpdate called in " + this.moduleName);
        }
        if (!this.hasUpdate || this.hasGottenModulePrepareUpdate != null) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: finisher activateUpdate exiting with no changes in " + this.moduleName + " hasUpdate=" + this.hasUpdate + " hasGottenModulePrepareUpdate=" + this.hasGottenModulePrepareUpdate);
            }
            return;
        }
        this.hasUpdate = false;
        Object object = this.update;
        this.update = null;
        this.hasCalledPrepareUpdate = false;
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        try {
            this.activateUpdate(domainMBean, object);
        }
        catch (ModuleException moduleException) {
            JMSLogger.logActivateFailedDuringTargetingChange((String)this.moduleName.toString(), (String)moduleException.toString());
        }
    }

    private void rollbackMigratableUpdate() {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: finisher rollbackMigratableUpdate called in " + this.moduleName);
        }
        if (!this.hasMigratableUpdate) {
            return;
        }
        this.hasMigratableUpdate = false;
        this.resetMigratableUpdateInfo();
        Object object = this.update;
        this.update = null;
        this.hasCalledMigratablePrepareUpdate = false;
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.rollbackUpdate(domainMBean, object);
    }

    public void rollbackUpdate(DescriptorUpdateEvent descriptorUpdateEvent) {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: finisher rollbackUpdate called in " + this.moduleName);
        }
        if (!this.hasUpdate) {
            return;
        }
        this.hasUpdate = false;
        Object object = this.update;
        this.update = null;
        this.hasCalledPrepareUpdate = false;
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.rollbackUpdate(domainMBean, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migratableUpdate() throws MigrationException {
        ModuleCoordinator moduleCoordinator = this;
        synchronized (moduleCoordinator) {
            try {
                if (JMSDebug.JMSModule.isDebugEnabled()) {
                    JMSDebug.JMSModule.debug("INFO: Calling prepareMigratableUpdate for " + this);
                }
                this.prepareMigratableUpdate();
            }
            catch (Exception exception) {
                this.resetMigratableUpdateInfo();
                throw new MigrationException(exception);
            }
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: Calling activateMigratableUpdate for " + this);
            }
            try {
                this.activateMigratableUpdate();
            }
            catch (Exception exception) {
                this.rollbackMigratableUpdate();
                this.resetMigratableUpdateInfo();
                throw new MigrationException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetMigratableUpdateInfo() {
        ModuleCoordinator moduleCoordinator = this;
        synchronized (moduleCoordinator) {
            if (this.hasMigratableUpdateDomain != null) {
                this.hasMigratableUpdateDomain = null;
            }
            if (this.targeter != null) {
                TargetingHelper targetingHelper = this.targeter;
                synchronized (targetingHelper) {
                    this.targeter.setUpdateAction(-1);
                    this.targeter.setHasUpdate(false);
                    this.targeter.setUpdatedTargetMBean(null);
                }
            }
        }
    }

    private void openJMSComponent() throws ModuleException {
        try {
            this.jmsComponent = new JMSComponent(this.moduleName.toString(), this.getId(), this.appCtx);
            this.jmsComponent.open();
        }
        catch (ManagementException managementException) {
            throw new ModuleException(managementException.getMessage(), managementException);
        }
    }

    private void closeJMSComponent() {
        if (this.jmsComponent != null) {
            try {
                this.jmsComponent.close();
            }
            catch (ManagementException managementException) {
                JMSLogger.logComponentCloseFailure((String)this.moduleName.toString(), (String)managementException.toString());
            }
            this.jmsComponent = null;
        }
    }

    private String getEARModuleName() {
        return this.earModuleName;
    }

    ApplicationContextInternal getAppCtx() {
        return this.appCtx;
    }

    private void internalInit(ApplicationContextInternal applicationContextInternal, UpdateListener.Registration registration) throws ModuleException {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: module internalInit called in " + this.moduleName);
        }
        if (JMSService.getJMSService().getFrontEnd() == null) {
            throw new ModuleException(JMSExceptionLogger.logJMSServiceNotInitialized2Loggable().getMessage());
        }
        this.appCtx = applicationContextInternal;
        registration.addUpdateListener(this);
        this.moduleName = new ModuleName(this.appCtx.getApplicationId(), this.getEARModuleName());
        this.moduleType = this.getModuleTypeFromAppCtx();
        this.openJMSComponent();
        DomainMBean domainMBean = this.getDomainFromAppCtx();
        this.initializeModule(this.appCtx, domainMBean);
    }

    private int getModuleTypeFromAppCtx() throws ModuleException {
        if (this.appCtx.getAppDeploymentMBean() != null) {
            return 0;
        }
        if (this.appCtx.getSystemResourceMBean() != null) {
            return 1;
        }
        throw new ModuleException(JMSExceptionLogger.logUnknownJMSModuleTypeLoggable((String)this.moduleName.toString()).getMessage());
    }

    private DomainMBean getDomainFromAppCtx() {
        BasicDeploymentMBean basicDeploymentMBean = null;
        switch (this.moduleType) {
            case 0: {
                basicDeploymentMBean = this.appCtx.getAppDeploymentMBean();
                break;
            }
            case 1: {
                basicDeploymentMBean = this.appCtx.getSystemResourceMBean();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown module type: " + this.moduleType));
            }
        }
        return JMSBeanHelper.getDomain(basicDeploymentMBean);
    }

    protected TargetInfoMBean getTargetingBean(DomainMBean domainMBean) {
        switch (this.moduleType) {
            case 0: {
                AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
                appDeploymentMBean = domainMBean.lookupAppDeployment(appDeploymentMBean.getName());
                if (appDeploymentMBean != null && this.earModuleName != null) {
                    return appDeploymentMBean.lookupSubDeployment(this.earModuleName);
                }
                return appDeploymentMBean;
            }
            case 1: {
                SystemResourceMBean systemResourceMBean = this.appCtx.getSystemResourceMBean();
                systemResourceMBean = systemResourceMBean instanceof JMSInteropModuleMBean ? JMSBeanHelper.getJMSInteropModule(domainMBean) : domainMBean.lookupJMSSystemResource(systemResourceMBean.getName());
                return systemResourceMBean;
            }
        }
        throw new AssertionError((Object)"Only file-based modules have TargetInfos");
    }

    private DomainMBean getProposedDomain() {
        DomainMBean domainMBean = this.appCtx.getProposedDomain();
        if (domainMBean == null) {
            domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        }
        return domainMBean;
    }

    protected BasicDeploymentMBean getBasicDeployment(DomainMBean domainMBean) {
        switch (this.moduleType) {
            case 0: {
                AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
                AppDeploymentMBean appDeploymentMBean2 = domainMBean.lookupAppDeployment(appDeploymentMBean.getName());
                if (appDeploymentMBean2 == null) {
                    appDeploymentMBean2 = appDeploymentMBean;
                }
                return appDeploymentMBean2;
            }
            case 1: {
                SystemResourceMBean systemResourceMBean = this.appCtx.getSystemResourceMBean();
                SystemResourceMBean systemResourceMBean2 = systemResourceMBean instanceof JMSInteropModuleMBean ? JMSBeanHelper.getJMSInteropModule(domainMBean) : domainMBean.lookupJMSSystemResource(systemResourceMBean.getName());
                if (systemResourceMBean2 == null) {
                    systemResourceMBean2 = systemResourceMBean;
                }
                return systemResourceMBean2;
            }
        }
        return null;
    }

    public void startAddSubDeployments(SubDeploymentMBean subDeploymentMBean) throws BeanUpdateRejectedException {
        this.hasUpdate = true;
    }

    public void finishAddSubDeployments(SubDeploymentMBean subDeploymentMBean, boolean bl) {
        if (!bl || !this.isActive) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: Not listening on sub-deployment " + subDeploymentMBean.getName() + " either because the module is shutdown(" + !this.isActive + ") or this is a rollback which included an addition of a subdeployment(" + !bl + ") in module " + this + " of name " + this.moduleName);
            }
            return;
        }
        if (!this.isActive) {
            return;
        }
        SubDeploymentMBean subDeploymentMBean2 = subDeploymentMBean;
        subDeploymentMBean2.addBeanUpdateListener(this.deploymentListener);
        this.targetingListenees.put(subDeploymentMBean.getName(), subDeploymentMBean);
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: Now listening on subdeployment " + subDeploymentMBean.getName() + " in module " + this.moduleName);
        }
    }

    public void startRemoveSubDeployments(SubDeploymentMBean subDeploymentMBean) throws BeanUpdateRejectedException {
        Object v = this.targetingListenees.get(subDeploymentMBean.getName());
        if (v == null) {
            throw new BeanUpdateRejectedException(JMSExceptionLogger.logUnknownSubDeploymentLoggable((String)this.moduleName.toString(), (String)subDeploymentMBean.getName()).getMessage());
        }
        this.hasUpdate = true;
    }

    public void finishRemoveSubDeployments(SubDeploymentMBean subDeploymentMBean, boolean bl) {
        if (!bl) {
            return;
        }
        SubDeploymentMBean subDeploymentMBean2 = subDeploymentMBean;
        subDeploymentMBean2.removeBeanUpdateListener(this.deploymentListener);
        this.targetingListenees.remove(subDeploymentMBean.getName());
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("INFO: listener on subdeployment " + subDeploymentMBean.getName() + " in module " + this.moduleName + " has been removed");
        }
        this.targeter.subModuleListenerContextMap.remove(subDeploymentMBean.getName());
    }

    public String getName() {
        return this.moduleName.toString();
    }

    public String getType() {
        return WebLogicModuleType.MODULETYPE_JMS;
    }

    public String toString() {
        return "JMSModule(" + System.identityHashCode(this) + ",uri=" + this.uri + ",EARModuleName=" + this.earModuleName + ")" + ", Type(" + this.getType() + ")";
    }

    static {
        deploymentAdditions.put("SubDeployments", SubDeploymentMBean.class);
    }

    public class EARSubDeploymentListener {
        public void startAddSubDeployments(SubDeploymentMBean subDeploymentMBean) throws BeanUpdateRejectedException {
            if (ModuleCoordinator.this.earModuleName == null) {
                return;
            }
            if (ModuleCoordinator.this.earModuleName.equals(subDeploymentMBean.getName())) {
                ModuleCoordinator.this.hasUpdate = true;
            }
        }

        public void finishAddSubDeployments(SubDeploymentMBean subDeploymentMBean, boolean bl) {
            if (!bl || !ModuleCoordinator.this.isActive) {
                if (JMSDebug.JMSModule.isDebugEnabled()) {
                    JMSDebug.JMSModule.debug("INFO: Not listening on sub-deployment " + subDeploymentMBean.getName() + " either because the module is shutdown(" + !ModuleCoordinator.this.isActive + ") or this is a rollback which included an addition of a subdeployment(" + !bl + ") in module " + this + " of name " + ModuleCoordinator.this.moduleName);
                }
                return;
            }
            if (ModuleCoordinator.this.earModuleName == null) {
                return;
            }
            if (!ModuleCoordinator.this.earModuleName.equals(subDeploymentMBean.getName())) {
                return;
            }
            ModuleCoordinator.this.activateSubDeploymentListener(subDeploymentMBean);
            ModuleCoordinator.this.targetingAdditionsListener = new GenericBeanListener(subDeploymentMBean, ModuleCoordinator.this, null, deploymentAdditions, true);
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: EAR sub-deployment " + ModuleCoordinator.this.earModuleName + " in module " + ModuleCoordinator.this.moduleName + " was added");
            }
        }

        public void startRemoveSubDeployments(SubDeploymentMBean subDeploymentMBean) throws BeanUpdateRejectedException {
            if (ModuleCoordinator.this.earModuleName == null) {
                return;
            }
            if (ModuleCoordinator.this.earModuleName.equals(subDeploymentMBean.getName())) {
                ModuleCoordinator.this.hasUpdate = true;
            }
        }

        public void finishRemoveSubDeployments(SubDeploymentMBean subDeploymentMBean, boolean bl) {
            if (!bl) {
                return;
            }
            if (ModuleCoordinator.this.earModuleName == null) {
                return;
            }
            if (!ModuleCoordinator.this.earModuleName.equals(subDeploymentMBean.getName())) {
                return;
            }
            ModuleCoordinator.this.deactivateSubDeploymentListener();
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: EAR sub-deployment " + ModuleCoordinator.this.earModuleName + " in module " + ModuleCoordinator.this.moduleName + " was removed");
            }
        }
    }

    public class ASMDeactivateHandler
    implements Migratable {
        public void migratableInitialize() {
        }

        public void migratableActivate() throws MigrationException {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: Got migratableActivate for " + this);
            }
        }

        public void migratableDeactivate() throws MigrationException {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: Got migratableDeactivate for " + this);
            }
            ModuleCoordinator.this.migratableUpdate();
        }

        public String getName() {
            return "[ASMDeactivateHandler for JMSModule " + ModuleCoordinator.this.moduleName.toString() + "]";
        }

        public String toString() {
            return "[ASMDeactivateHandler for JMSModule " + ModuleCoordinator.this.moduleName.toString() + "]";
        }

        public int getOrder() {
            return -1901;
        }
    }

    public class ASMActivateHandler
    implements Migratable {
        public void migratableInitialize() {
        }

        public void migratableActivate() throws MigrationException {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: Got migratableActivate for " + this);
            }
            ModuleCoordinator.this.migratableUpdate();
        }

        public void migratableDeactivate() throws MigrationException {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: Got migratableDeactivate for " + this);
            }
        }

        public String getName() {
            return "[ASMActivateHandler for JMSModule " + ModuleCoordinator.this.moduleName.toString() + "]";
        }

        public String toString() {
            return "[ASMActivateHandler for JMSModule " + ModuleCoordinator.this.moduleName.toString() + "]";
        }

        public int getOrder() {
            return 0x7FFFFFFE;
        }
    }

    public class JMSTargetsListenerImpl
    implements JMSTargetsListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prepareUpdate(DomainMBean domainMBean, TargetMBean targetMBean, int n, boolean bl) throws BeanUpdateRejectedException {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: jmsListener prepareUpdate called in " + ModuleCoordinator.this.moduleName);
            }
            JMSTargetsListenerImpl jMSTargetsListenerImpl = this;
            synchronized (jMSTargetsListenerImpl) {
                if (!bl) {
                    ModuleCoordinator.this.hasUpdate = true;
                } else {
                    ModuleCoordinator.this.hasMigratableUpdate = true;
                }
                ModuleCoordinator.this.hasMigratableUpdateDomain = domainMBean;
                if (ModuleCoordinator.this.targeter != null) {
                    TargetingHelper targetingHelper = ModuleCoordinator.this.targeter;
                    synchronized (targetingHelper) {
                        ModuleCoordinator.this.targeter.setHasUpdate(true);
                        ModuleCoordinator.this.targeter.setUpdatedTargetMBean(targetMBean);
                        ModuleCoordinator.this.targeter.setUpdateAction(n);
                    }
                }
            }
        }

        public void rollbackUpdate() {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: jmsListener rollbackUpdate called in " + ModuleCoordinator.this.moduleName);
            }
        }

        public void activateUpdate() {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: jmsListener activateUpdate called in " + ModuleCoordinator.this.moduleName);
            }
        }
    }

    private class DeploymentListener
    implements BeanUpdateListener {
        private DeploymentListener() {
        }

        public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: deploymentListener prepareUpdate called in " + ModuleCoordinator.this.moduleName);
            }
            ModuleCoordinator.this.hasUpdate = true;
        }

        public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: deploymentListener activateUpdate called in " + ModuleCoordinator.this.moduleName);
            }
        }

        public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("INFO: deploymentListener rollbackUpdate called in " + ModuleCoordinator.this.moduleName);
            }
        }
    }
}

