/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.util.LinkedList;
import java.util.List;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;

public class TargetListSave {
    private List savedTargets = null;

    public TargetListSave(List list) {
        if (list == null) {
            this.savedTargets = null;
        } else {
            this.savedTargets = new LinkedList();
            for (TargetMBean targetMBean : list) {
                this.savedTargets.add(new TargetSave(targetMBean));
            }
        }
    }

    public List restoreTargets(DomainMBean domainMBean) {
        LinkedList<TargetMBean> linkedList = new LinkedList<TargetMBean>();
        if (this.savedTargets == null) {
            return linkedList;
        }
        for (TargetSave targetSave : this.savedTargets) {
            TargetMBean targetMBean = targetSave.restore(domainMBean);
            if (targetMBean == null) continue;
            linkedList.add(targetMBean);
        }
        return linkedList;
    }

    public int size() {
        return this.savedTargets == null ? 0 : this.savedTargets.size();
    }

    private static class TargetSave {
        private static final int JMS_SERVER = 0;
        private static final int WLS_SERVER = 1;
        private static final int CLUSTER = 2;
        private static final int SAF_AGENT = 3;
        private static final int MIGRATABLE_TARGET = 4;
        private String name;
        private int type;

        public TargetSave(TargetMBean targetMBean) {
            this.name = targetMBean.getName();
            if (targetMBean instanceof JMSServerMBean) {
                this.type = 0;
            } else if (targetMBean instanceof ServerMBean) {
                this.type = 1;
            } else if (targetMBean instanceof ClusterMBean) {
                this.type = 2;
            } else if (targetMBean instanceof SAFAgentMBean) {
                this.type = 3;
            } else if (targetMBean instanceof MigratableTargetMBean) {
                this.type = 4;
            } else {
                throw new AssertionError((Object)("Bad type: " + targetMBean.getClass().getName()));
            }
        }

        public TargetMBean restore(DomainMBean domainMBean) {
            switch (this.type) {
                case 0: {
                    return domainMBean.lookupJMSServer(this.name);
                }
                case 1: {
                    return domainMBean.lookupServer(this.name);
                }
                case 2: {
                    return domainMBean.lookupCluster(this.name);
                }
                case 3: {
                    return domainMBean.lookupSAFAgent(this.name);
                }
                case 4: {
                    return domainMBean.lookupMigratableTarget(this.name);
                }
            }
            throw new AssertionError((Object)"Cannot get here");
        }
    }
}

