/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.DeploymentManager;
import weblogic.application.ModuleException;
import weblogic.application.ModuleListener;
import weblogic.application.ModuleListenerCtx;
import weblogic.application.SubModuleListenerCtx;
import weblogic.application.SubModuleListenerCtxImpl;
import weblogic.cluster.migration.MigrationManager;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.j2ee.descriptor.wl.TargetableBean;
import weblogic.jms.JMSLogger;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.module.JMSModule;
import weblogic.jms.module.UpdateInformation;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class TargetingHelper {
    static final int UNCHANGED = 0;
    static final int ADDED = 1;
    static final int REMOVED = 2;
    static final int CHANGED = 3;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private String serverName;
    private String clusterName;
    private boolean hasUpdate = false;
    private TargetMBean updatedTargetMBean = null;
    private int updateAction = -1;
    private HashMap acceptedLocalGroups;
    private HashMap acceptedGroups;
    String EARModuleName;
    private String appId;
    private String moduleUri;
    private ModuleListener.State state = ModuleListener.STATE_NEW;
    public HashMap subModuleListenerContextMap;
    private final DeploymentManager deploymentManager = DeploymentManager.getDeploymentManager();

    TargetingHelper(JMSModule jMSModule, DomainMBean domainMBean, String string, String string2) {
        this.acceptedLocalGroups = new HashMap();
        this.acceptedGroups = new HashMap();
        this.subModuleListenerContextMap = new HashMap();
        this.moduleUri = jMSModule.getId();
        this.appId = string2;
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        this.serverName = serverMBean.getName();
        ClusterMBean clusterMBean = serverMBean.getCluster();
        if (clusterMBean != null) {
            this.clusterName = clusterMBean.getName();
        }
        this.EARModuleName = string;
        BasicDeploymentMBean basicDeploymentMBean = jMSModule.getBasicDeployment(domainMBean);
        this.analyzeTargets(basicDeploymentMBean, null, jMSModule.getAppCtx());
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setHasUpdate(boolean bl) {
        this.hasUpdate = bl;
    }

    public boolean isHasUpdate() {
        return this.hasUpdate;
    }

    public void setUpdatedTargetMBean(TargetMBean targetMBean) {
        this.updatedTargetMBean = targetMBean;
    }

    public TargetMBean getUpdatedTargetMBean() {
        return this.updatedTargetMBean;
    }

    public void setUpdateAction(int n) {
        this.updateAction = n;
    }

    public int getUpdateAction() {
        return this.updateAction;
    }

    private void fixupList(Map map, DomainMBean domainMBean) {
        for (String string : map.keySet()) {
            List list = (List)map.get(string);
            LinkedList<ClusterMBean> linkedList = new LinkedList<ClusterMBean>();
            SubModuleListenerCtxImpl subModuleListenerCtxImpl = (SubModuleListenerCtxImpl)this.subModuleListenerContextMap.get(string);
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("TargetingHelper:activate(): Got " + subModuleListenerCtxImpl + " for " + string);
                this.dumpSubModuleListenerContext(subModuleListenerCtxImpl);
            }
            this.begin(subModuleListenerCtxImpl, ModuleListener.STATE_ADMIN);
            for (TargetMBean targetMBean : list) {
                String string2 = targetMBean.getName();
                TargetMBean targetMBean2 = null;
                if (targetMBean instanceof ClusterMBean) {
                    targetMBean2 = domainMBean.lookupCluster(string2);
                } else if (targetMBean instanceof ServerMBean) {
                    targetMBean2 = domainMBean.lookupServer(string2);
                } else if (targetMBean instanceof MigratableTargetMBean) {
                    targetMBean2 = domainMBean.lookupMigratableTarget(string2);
                } else if (targetMBean instanceof JMSServerMBean) {
                    targetMBean2 = domainMBean.lookupJMSServer(string2);
                } else if (targetMBean instanceof SAFAgentMBean) {
                    targetMBean2 = domainMBean.lookupSAFAgent(string2);
                }
                if (targetMBean2 == null) {
                    this.failed(subModuleListenerCtxImpl, ModuleListener.STATE_ADMIN);
                    throw new AssertionError((Object)("Could not find a target of name " + string2 + " in module=" + this.appId + " URI=" + this.moduleUri));
                }
                linkedList.add((ClusterMBean)targetMBean2);
            }
            this.end(subModuleListenerCtxImpl, ModuleListener.STATE_ADMIN);
            map.put(string, linkedList);
        }
    }

    void activate() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        for (String string : this.subModuleListenerContextMap.keySet()) {
            SubModuleListenerCtxImpl subModuleListenerCtxImpl = (SubModuleListenerCtxImpl)this.subModuleListenerContextMap.get(string);
            TargetMBean targetMBean = ((ModuleListenerCtx)subModuleListenerCtxImpl).getTarget();
            TargetMBean targetMBean2 = null;
            if (targetMBean == null) continue;
            String string2 = targetMBean.getName();
            if (targetMBean instanceof ClusterMBean) {
                targetMBean2 = domainMBean.lookupCluster(string2);
            } else if (targetMBean instanceof ServerMBean) {
                targetMBean2 = domainMBean.lookupServer(string2);
            } else if (targetMBean instanceof MigratableTargetMBean) {
                targetMBean2 = domainMBean.lookupMigratableTarget(string2);
            } else if (targetMBean instanceof JMSServerMBean) {
                targetMBean2 = domainMBean.lookupJMSServer(string2);
            } else if (targetMBean instanceof SAFAgentMBean) {
                targetMBean2 = domainMBean.lookupSAFAgent(string2);
            }
            SubModuleListenerCtxImpl subModuleListenerCtxImpl2 = new SubModuleListenerCtxImpl(((ModuleListenerCtx)subModuleListenerCtxImpl).getApplicationId(), ((ModuleListenerCtx)subModuleListenerCtxImpl).getModuleUri(), ((ModuleListenerCtx)subModuleListenerCtxImpl).getType(), targetMBean2, subModuleListenerCtxImpl.getSubModuleName(), subModuleListenerCtxImpl.getSubModuleTargets());
            this.subModuleListenerContextMap.put(string, subModuleListenerCtxImpl2);
        }
        this.fixupList(this.acceptedLocalGroups, domainMBean);
        this.fixupList(this.acceptedGroups, domainMBean);
        this.state = ModuleListener.STATE_ADMIN;
    }

    void adminToProduction() {
        if (this.acceptedGroups != null) {
            for (String string : this.acceptedGroups.keySet()) {
                SubModuleListenerCtx subModuleListenerCtx = (SubModuleListenerCtx)this.subModuleListenerContextMap.get(string);
                this.begin(subModuleListenerCtx, ModuleListener.STATE_ACTIVE);
                this.end(subModuleListenerCtx, ModuleListener.STATE_ACTIVE);
            }
        }
        this.state = ModuleListener.STATE_PREPARED;
    }

    void productionToAdmin() {
        if (this.acceptedGroups != null) {
            for (String string : this.acceptedGroups.keySet()) {
                SubModuleListenerCtx subModuleListenerCtx = (SubModuleListenerCtx)this.subModuleListenerContextMap.get(string);
                this.begin(subModuleListenerCtx, ModuleListener.STATE_ADMIN);
                this.end(subModuleListenerCtx, ModuleListener.STATE_ADMIN);
            }
        }
        this.state = ModuleListener.STATE_PREPARED;
    }

    void unprepare() {
        if (this.acceptedGroups != null) {
            for (String string : this.acceptedGroups.keySet()) {
                SubModuleListenerCtx subModuleListenerCtx = (SubModuleListenerCtx)this.subModuleListenerContextMap.get(string);
                this.begin(subModuleListenerCtx, ModuleListener.STATE_NEW);
                this.end(subModuleListenerCtx, ModuleListener.STATE_NEW);
            }
        }
        this.state = ModuleListener.STATE_NEW;
    }

    void deactivate() {
        if (this.acceptedGroups != null) {
            for (String string : this.acceptedGroups.keySet()) {
                SubModuleListenerCtx subModuleListenerCtx = (SubModuleListenerCtx)this.subModuleListenerContextMap.get(string);
                this.begin(subModuleListenerCtx, ModuleListener.STATE_PREPARED);
                this.end(subModuleListenerCtx, ModuleListener.STATE_PREPARED);
            }
        }
        this.state = ModuleListener.STATE_PREPARED;
    }

    void prepareUpdate(BasicDeploymentMBean basicDeploymentMBean, UpdateInformation updateInformation, ApplicationContextInternal applicationContextInternal) throws ModuleException {
        HashMap hashMap = new HashMap();
        updateInformation.setAddedGroups(hashMap);
        HashMap hashMap2 = new HashMap();
        updateInformation.setAddedLocalGroups(hashMap2);
        HashMap hashMap3 = new HashMap();
        updateInformation.setChangedGroups(hashMap3);
        HashMap hashMap4 = new HashMap();
        updateInformation.setChangedLocalGroups(hashMap4);
        if (basicDeploymentMBean == null) {
            updateInformation.setRemovedLocalGroups(new HashMap());
            updateInformation.setRemovedGroups(new HashMap());
            return;
        }
        this.analyzeTargets(basicDeploymentMBean, updateInformation, applicationContextInternal);
        TargetingHelper.removeAll(updateInformation.getChangedGroups(), updateInformation.getRemovedGroups());
        TargetingHelper.removeAll(updateInformation.getChangedLocalGroups(), updateInformation.getRemovedLocalGroups());
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            for (String string : hashMap4.keySet()) {
                JMSDebug.JMSModule.debug("Group " + string + " is changed locally in an update");
            }
            for (String string : hashMap3.keySet()) {
                JMSDebug.JMSModule.debug("Group " + string + " is changed in an update");
            }
        }
    }

    private static void removeAll(HashMap hashMap, HashMap hashMap2) {
        Set set = hashMap2.keySet();
        for (Object k : set) {
            hashMap.remove(k);
        }
    }

    void activateUpdate(UpdateInformation updateInformation) {
        if (updateInformation == null) {
            return;
        }
        this.acceptedLocalGroups.putAll(updateInformation.getAddedLocalGroups());
        this.acceptedGroups.putAll(updateInformation.getAddedGroups());
        this.acceptedLocalGroups.putAll(updateInformation.getChangedLocalGroups());
        this.acceptedGroups.putAll(updateInformation.getChangedGroups());
        TargetingHelper.removeAll(this.acceptedLocalGroups, updateInformation.getRemovedLocalGroups());
        TargetingHelper.removeAll(this.acceptedGroups, updateInformation.getRemovedGroups());
        updateInformation.clearTargetUpdates();
        this.activate();
    }

    void rollbackUpdate(UpdateInformation updateInformation) {
        updateInformation.clearTargetUpdates();
    }

    private boolean isLocallyTargeted(TargetMBean targetMBean) {
        return TargetingHelper.isLocallyTargeted(targetMBean, this.clusterName, this.serverName, this.hasUpdate, this.updatedTargetMBean, this.updateAction);
    }

    public static boolean isLocallyTargeted(TargetMBean targetMBean, String string, String string2) {
        return TargetingHelper.isLocallyTargeted(targetMBean, string, string2, false, null, -1);
    }

    public static boolean isLocallyTargeted(TargetMBean targetMBean, String string, String string2, boolean bl, TargetMBean targetMBean2, int n) {
        Object object;
        Object object2;
        if (targetMBean == null) {
            return false;
        }
        if (targetMBean instanceof SAFAgentMBean) {
            object2 = (SAFAgentMBean)targetMBean;
            object = object2.getTargets();
            if (((TargetMBean[])object).length <= 0) {
                return false;
            }
            if (((TargetMBean[])object).length == 1 && object[0] instanceof MigratableTargetMBean) {
                targetMBean = object[0];
            } else {
                for (int i = 0; i < ((TargetMBean[])object).length; ++i) {
                    String string3;
                    targetMBean = object[i];
                    if (targetMBean == null || !(string3 = targetMBean.getName()).equals(string2) && !string3.equals(string)) continue;
                    return true;
                }
                return false;
            }
        }
        if (targetMBean instanceof JMSServerMBean) {
            object2 = (JMSServerMBean)targetMBean;
            object = object2.getTargets();
            if (((TargetMBean[])object).length <= 0) {
                return false;
            }
            targetMBean = object[0];
            if (targetMBean == null) {
                return false;
            }
        }
        if (targetMBean instanceof MigratableTargetMBean) {
            object2 = (MigratableTargetMBean)targetMBean;
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("TargetingHelper.isLocallyTargeted(): hasUpdate=" + bl + ", lvUpdatedTargetMBean=" + (targetMBean2 != null ? targetMBean2.getName() : "") + ", lvUpdateAction=" + n + ", clusterName=" + string + ", serverName=" + string2 + ", mig(current targetBean)=" + object2.getName() + ", mig.getHostingServer()=" + (object2.getHostingServer() != null ? object2.getHostingServer().getName() : "null") + ", ups=" + (object2.getUserPreferredServer() != null ? object2.getUserPreferredServer().getName() : "null"));
            }
            if (bl && n != -1 && targetMBean2 != null) {
                if (targetMBean2.getType().equals("JMSServer")) {
                    if (((JMSServerMBean)targetMBean2).getTargets().length != 0 && ((JMSServerMBean)targetMBean2).getTargets()[0].equals(object2)) {
                        if (n == 1 || n == 2) {
                            if (JMSDebug.JMSModule.isDebugEnabled()) {
                                JMSDebug.JMSModule.debug("TargetingHelper.isLocallyTargeted(): JMSServer: updatedTargetMBean" + targetMBean2 + " got added to serverName=" + string2);
                            }
                            return true;
                        }
                        if (JMSDebug.JMSModule.isDebugEnabled()) {
                            JMSDebug.JMSModule.debug("TargetingHelper.isLocallyTargeted(): JMSServer: updatedTargetMBean" + targetMBean2 + " got removed from serverName=" + string2);
                        }
                        return false;
                    }
                    if (object2.getMigrationPolicy().equals("manual")) {
                        int n2 = MigrationManager.singleton().getMigratableState(object2.getName());
                        return n2 == 2 || n2 == 1;
                    }
                    object = object2.getHostingServer();
                    return object != null && object.getName().equals(string2);
                }
                if (targetMBean2.getType().equals("SAFAgent")) {
                    object = (SAFAgentMBean)targetMBean2;
                    TargetMBean[] targetMBeanArray = object.getTargets();
                    if (targetMBeanArray.length == 1 && targetMBeanArray[0].equals(object2)) {
                        if (n == 1 || n == 2) {
                            if (JMSDebug.JMSModule.isDebugEnabled()) {
                                JMSDebug.JMSModule.debug("TargetingHelper.isLocallyTargeted(): SAFAgent: updatedTargetMBean" + targetMBean2 + " got added to serverName=" + string2);
                            }
                            return true;
                        }
                        if (JMSDebug.JMSModule.isDebugEnabled()) {
                            JMSDebug.JMSModule.debug("TargetingHelper.isLocallyTargeted(): SAFAgent: updatedTargetMBean" + targetMBean2 + " got remvoed from serverName=" + string2);
                        }
                        return false;
                    }
                    if (object2.getMigrationPolicy().equals("manual")) {
                        int n3 = MigrationManager.singleton().getMigratableState(object2.getName());
                        return n3 == 2 || n3 == 1;
                    }
                    ServerMBean serverMBean = object2.getHostingServer();
                    return serverMBean != null && serverMBean.getName().equals(string2);
                }
            }
            if ((targetMBean = object2.getHostingServer()) == null) {
                return false;
            }
        }
        return ((String)(object2 = targetMBean.getName())).equals(string2) || ((String)object2).equals(string);
    }

    private static void compareToBaseline(String string, UpdateInformation updateInformation, HashMap hashMap, HashMap hashMap2, HashMap hashMap3, HashMap hashMap4, TargetMBean targetMBean, boolean bl) {
        Object object2;
        List list = (List)hashMap.get(string);
        if (list == null) {
            List<TargetMBean> list2;
            if (!bl) {
                return;
            }
            if (hashMap2.containsKey(string)) {
                list2 = (List)hashMap2.get(string);
            } else {
                list2 = new LinkedList();
                hashMap2.put(string, list2);
            }
            list2.add(targetMBean);
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("Group " + string + " added in an update");
            }
            return;
        }
        if (!bl) {
            return;
        }
        hashMap4.remove(string);
        for (Object object2 : list) {
            if (!object2.getClass().equals(targetMBean.getClass()) || !object2.getName().equals(targetMBean.getName())) continue;
            return;
        }
        if (!hashMap3.containsKey(string)) {
            object2 = new LinkedList(list);
            hashMap3.put(string, object2);
        } else {
            object2 = (List)hashMap3.get(string);
        }
        object2.add(targetMBean);
    }

    private static void addToGroupMap(Map map, String string, Object object) {
        List<Object> list;
        if (map.containsKey(string)) {
            list = (List)map.get(string);
        } else {
            list = new LinkedList();
            map.put(string, list);
        }
        list.add(object);
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Group " + string + " added");
        }
    }

    private void updateMaps(String string, TargetMBean targetMBean, UpdateInformation updateInformation, TargetMBean targetMBean2) {
        boolean bl = this.isLocallyTargeted(targetMBean);
        if (updateInformation != null) {
            TargetingHelper.compareToBaseline(string, updateInformation, this.acceptedLocalGroups, updateInformation.getAddedLocalGroups(), updateInformation.getChangedLocalGroups(), updateInformation.getRemovedLocalGroups(), targetMBean2, bl);
            TargetingHelper.compareToBaseline(string, updateInformation, this.acceptedGroups, updateInformation.getAddedGroups(), updateInformation.getChangedGroups(), updateInformation.getRemovedGroups(), targetMBean2, true);
        } else {
            if (bl) {
                TargetingHelper.addToGroupMap(this.acceptedLocalGroups, string, targetMBean2);
            }
            TargetingHelper.addToGroupMap(this.acceptedGroups, string, targetMBean2);
        }
    }

    private SubDeploymentMBean[] getSubModules(BasicDeploymentMBean basicDeploymentMBean, SubDeploymentMBean[] subDeploymentMBeanArray) {
        int n;
        SubDeploymentMBean[] subDeploymentMBeanArray2 = basicDeploymentMBean.getSubDeployments();
        if (subDeploymentMBeanArray2 == null) {
            return null;
        }
        if (this.EARModuleName == null) {
            return subDeploymentMBeanArray2;
        }
        for (n = 0; n < subDeploymentMBeanArray2.length; ++n) {
            SubDeploymentMBean subDeploymentMBean = subDeploymentMBeanArray2[n];
            if (!this.EARModuleName.equals(subDeploymentMBean.getName())) continue;
            return subDeploymentMBean.getSubDeployments();
        }
        if (subDeploymentMBeanArray != null && subDeploymentMBeanArray.length > 0) {
            for (n = 0; n < subDeploymentMBeanArray.length; ++n) {
                if (!this.EARModuleName.equals(subDeploymentMBeanArray[n].getName())) continue;
                return subDeploymentMBeanArray[n].getSubDeployments();
            }
        }
        JMSLogger.logNoEARSubDeployment((String)this.EARModuleName, (String)basicDeploymentMBean.getName());
        return null;
    }

    private void analyzeTargets(BasicDeploymentMBean basicDeploymentMBean, UpdateInformation updateInformation, ApplicationContextInternal applicationContextInternal) {
        SubDeploymentMBean[] subDeploymentMBeanArray;
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Analyzing targets in " + basicDeploymentMBean.getName());
        }
        if (updateInformation != null) {
            subDeploymentMBeanArray = (SubDeploymentMBean[])this.acceptedGroups.clone();
            HashMap hashMap = (HashMap)this.acceptedLocalGroups.clone();
            updateInformation.setRemovedGroups((HashMap)subDeploymentMBeanArray);
            updateInformation.setRemovedLocalGroups(hashMap);
            assert (updateInformation.getChangedGroups().size() == 0);
            assert (updateInformation.getChangedLocalGroups().size() == 0);
        }
        if ((subDeploymentMBeanArray = this.getSubModules(basicDeploymentMBean, applicationContextInternal.getLibrarySubDeployments())) == null) {
            return;
        }
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            TargetMBean targetMBean;
            SubDeploymentMBean subDeploymentMBean = subDeploymentMBeanArray[i];
            String string = subDeploymentMBean.getName();
            TargetMBean[] targetMBeanArray = subDeploymentMBean.getTargets();
            SubModuleListenerCtx subModuleListenerCtx = (SubModuleListenerCtx)this.subModuleListenerContextMap.get(string);
            if (subModuleListenerCtx == null) {
                TargetMBean[] targetMBeanArray2 = basicDeploymentMBean.getTargets();
                targetMBean = targetMBeanArray2.length > 0 ? targetMBeanArray2[0] : null;
                subModuleListenerCtx = new SubModuleListenerCtxImpl(this.appId, this.moduleUri, WebLogicModuleType.MODULETYPE_SUBMODULE, targetMBean, string, targetMBeanArray);
                if (JMSDebug.JMSModule.isDebugEnabled()) {
                    JMSDebug.JMSModule.debug("TargetingHelper:analyzeTargets(): Created a new " + subModuleListenerCtx + " for " + string);
                }
                this.subModuleListenerContextMap.put(string, subModuleListenerCtx);
            }
            if (JMSDebug.JMSModule.isDebugEnabled()) {
                JMSDebug.JMSModule.debug("TargetingHelper:analyzeTargets(): Got " + subModuleListenerCtx + " for " + string);
                this.dumpSubModuleListenerContext((SubModuleListenerCtxImpl)subModuleListenerCtx);
            }
            this.begin(subModuleListenerCtx, ModuleListener.STATE_PREPARED);
            for (int j = 0; j < targetMBeanArray.length; ++j) {
                TargetMBean targetMBean2;
                int n;
                TargetMBean[] targetMBeanArray3;
                TargetMBean targetMBean3;
                targetMBean = targetMBeanArray[j];
                if (targetMBean instanceof JMSServerMBean) {
                    targetMBean3 = (JMSServerMBean)targetMBean;
                    targetMBeanArray3 = targetMBean3.getTargets();
                    for (n = 0; n < targetMBeanArray3.length; ++n) {
                        targetMBean2 = targetMBeanArray3[n];
                        this.updateMaps(string, targetMBean2, updateInformation, targetMBean);
                    }
                } else if (targetMBean instanceof SAFAgentMBean) {
                    targetMBean3 = (SAFAgentMBean)targetMBean;
                    targetMBeanArray3 = targetMBean3.getTargets();
                    for (n = 0; n < targetMBeanArray3.length; ++n) {
                        targetMBean2 = targetMBeanArray3[n];
                        this.updateMaps(string, targetMBean2, updateInformation, targetMBean);
                    }
                } else {
                    this.updateMaps(string, targetMBean, updateInformation, targetMBean);
                }
                this.end(subModuleListenerCtx, ModuleListener.STATE_PREPARED);
            }
        }
        this.state = ModuleListener.STATE_PREPARED;
    }

    private static boolean hasTargetingChanged(Map map, Map map2, Map map3) {
        return map2 != null && map2.size() > 0 || map != null && map.size() > 0 || map3 != null && map3.size() > 0;
    }

    static boolean hasTargetingChanged(UpdateInformation updateInformation) {
        return TargetingHelper.hasTargetingChanged(updateInformation.getAddedGroups(), updateInformation.getRemovedGroups(), updateInformation.getChangedGroups()) || TargetingHelper.hasTargetingChanged(updateInformation.getAddedLocalGroups(), updateInformation.getRemovedLocalGroups(), updateInformation.getChangedLocalGroups());
    }

    int getGroupTargetChangeStatus(TargetableBean targetableBean, String string, UpdateInformation updateInformation, boolean bl) {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3;
        HashMap hashMap4 = bl ? this.acceptedGroups : this.acceptedLocalGroups;
        if (updateInformation == null) {
            if (hashMap4.containsKey(string) || targetableBean.isDefaultTargetingEnabled()) {
                return 1;
            }
            return 0;
        }
        if (targetableBean.isDefaultTargetingEnabled()) {
            if (updateInformation.hasDefaultTargetsChanged()) {
                return 3;
            }
            return 0;
        }
        if (bl) {
            hashMap3 = updateInformation.getAddedGroups();
            hashMap2 = updateInformation.getChangedGroups();
            hashMap = updateInformation.getRemovedGroups();
        } else {
            hashMap3 = updateInformation.getAddedLocalGroups();
            hashMap2 = updateInformation.getChangedLocalGroups();
            hashMap = updateInformation.getRemovedLocalGroups();
        }
        if (hashMap3.containsKey(string)) {
            return 1;
        }
        if (hashMap.containsKey(string)) {
            return 2;
        }
        if (hashMap2.containsKey(string)) {
            return 3;
        }
        return 0;
    }

    List getTarget(TargetInfoMBean targetInfoMBean, TargetableBean targetableBean, String string, UpdateInformation updateInformation, boolean bl) {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3;
        LinkedList<TargetMBean> linkedList = null;
        if (targetableBean != null && targetInfoMBean != null && targetableBean.isDefaultTargetingEnabled()) {
            TargetMBean[] targetMBeanArray = targetInfoMBean.getTargets();
            if (targetMBeanArray != null) {
                linkedList = new LinkedList<TargetMBean>();
                for (int i = 0; i < targetMBeanArray.length; ++i) {
                    if (!bl && !this.isLocallyTargeted(targetMBeanArray[i])) continue;
                    linkedList.add(targetMBeanArray[i]);
                }
            }
            return linkedList;
        }
        if (string == null) {
            return null;
        }
        List list = bl ? (List)this.acceptedGroups.get(string) : (List)this.acceptedLocalGroups.get(string);
        if (updateInformation == null) {
            return list;
        }
        if (bl) {
            hashMap3 = updateInformation.getAddedGroups();
            hashMap2 = updateInformation.getRemovedGroups();
            hashMap = updateInformation.getChangedGroups();
        } else {
            hashMap3 = updateInformation.getAddedLocalGroups();
            hashMap2 = updateInformation.getRemovedLocalGroups();
            hashMap = updateInformation.getChangedLocalGroups();
        }
        if (list != null) {
            if (hashMap2 == null) {
                return list;
            }
            if (hashMap2.containsKey(string)) {
                return null;
            }
            if (hashMap != null && hashMap.containsKey(string)) {
                return (List)hashMap.get(string);
            }
            return list;
        }
        if (hashMap3 == null) {
            return null;
        }
        return (List)hashMap3.get(string);
    }

    private void dumpSubModuleListenerContext(SubModuleListenerCtxImpl subModuleListenerCtxImpl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubModuleListenerContxext " + subModuleListenerCtxImpl);
        stringBuffer.append("\n  Application Id     : " + subModuleListenerCtxImpl.getApplicationId());
        stringBuffer.append("\n  Module URI         : " + subModuleListenerCtxImpl.getModuleUri());
        stringBuffer.append("\n  Module Target      : " + (subModuleListenerCtxImpl.getTarget() != null ? subModuleListenerCtxImpl.getTarget().getName() : ""));
        stringBuffer.append("\n  Sub Module Name    : " + subModuleListenerCtxImpl.getSubModuleName());
        StringBuffer stringBuffer2 = new StringBuffer();
        TargetMBean[] targetMBeanArray = subModuleListenerCtxImpl.getSubModuleTargets();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            stringBuffer2.append(targetMBeanArray[i].getName());
            if (i >= targetMBeanArray.length - 1) continue;
            stringBuffer2.append(",");
        }
        stringBuffer.append("\n  Sub Module Targets : " + stringBuffer2.toString());
        System.out.println(stringBuffer.toString());
    }

    private void begin(SubModuleListenerCtx subModuleListenerCtx, ModuleListener.State state) {
        Iterator iterator = this.deploymentManager.getModuleListeners();
        while (iterator.hasNext()) {
            ((ModuleListener)iterator.next()).beginTransition((ModuleListenerCtx)((Object)subModuleListenerCtx), this.state, state);
        }
    }

    private void end(SubModuleListenerCtx subModuleListenerCtx, ModuleListener.State state) {
        Iterator iterator = this.deploymentManager.getModuleListeners();
        while (iterator.hasNext()) {
            ((ModuleListener)iterator.next()).endTransition((ModuleListenerCtx)((Object)subModuleListenerCtx), this.state, state);
        }
    }

    private void failed(SubModuleListenerCtx subModuleListenerCtx, ModuleListener.State state) {
        Iterator iterator = this.deploymentManager.getModuleListeners();
        while (iterator.hasNext()) {
            ((ModuleListener)iterator.next()).failedTransition((ModuleListenerCtx)((Object)subModuleListenerCtx), this.state, state);
        }
    }
}

