/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module;

import java.util.HashMap;
import java.util.LinkedList;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.TargetMBean;

public class UpdateInformation {
    private int maxType;
    private LinkedList[] addedEntities;
    private HashMap[] addedEntitiesHash;
    private LinkedList[] deletedEntities;
    private HashMap[] deletedEntitiesHash;
    private LinkedList[] changedEntities;
    private TargetMBean[] defaultTargets;
    private boolean defaultTargetsChanged = false;
    private HashMap addedGroups;
    private HashMap removedGroups;
    private HashMap changedGroups;
    private HashMap addedLocalGroups;
    private HashMap removedLocalGroups;
    private HashMap changedLocalGroups;
    private DomainMBean proposedDomain;

    public UpdateInformation(int n) {
        this.maxType = n;
        this.addedEntities = new LinkedList[this.maxType];
        this.addedEntitiesHash = new HashMap[this.maxType];
        this.deletedEntities = new LinkedList[this.maxType];
        this.deletedEntitiesHash = new HashMap[this.maxType];
        this.changedEntities = new LinkedList[this.maxType];
        for (int i = 0; i < this.maxType; ++i) {
            this.addedEntities[i] = new LinkedList();
            this.addedEntitiesHash[i] = new HashMap();
            this.deletedEntities[i] = new LinkedList();
            this.deletedEntitiesHash[i] = new HashMap();
            this.changedEntities[i] = new LinkedList();
        }
    }

    synchronized LinkedList[] getAddedEntities() {
        return this.addedEntities;
    }

    HashMap[] getAddedEntitiesHash() {
        return this.addedEntitiesHash;
    }

    LinkedList[] getDeletedEntities() {
        return this.deletedEntities;
    }

    HashMap[] getDeletedEntitiesHash() {
        return this.deletedEntitiesHash;
    }

    LinkedList[] getChangedEntities() {
        return this.changedEntities;
    }

    void setAddedLocalGroups(HashMap hashMap) {
        this.addedLocalGroups = hashMap;
    }

    HashMap getAddedLocalGroups() {
        return this.addedLocalGroups;
    }

    void setRemovedLocalGroups(HashMap hashMap) {
        this.removedLocalGroups = hashMap;
    }

    HashMap getRemovedLocalGroups() {
        return this.removedLocalGroups;
    }

    void setChangedLocalGroups(HashMap hashMap) {
        this.changedLocalGroups = hashMap;
    }

    HashMap getChangedLocalGroups() {
        return this.changedLocalGroups;
    }

    void setAddedGroups(HashMap hashMap) {
        this.addedGroups = hashMap;
    }

    HashMap getAddedGroups() {
        return this.addedGroups;
    }

    void setRemovedGroups(HashMap hashMap) {
        this.removedGroups = hashMap;
    }

    HashMap getRemovedGroups() {
        return this.removedGroups;
    }

    void setChangedGroups(HashMap hashMap) {
        this.changedGroups = hashMap;
    }

    HashMap getChangedGroups() {
        return this.changedGroups;
    }

    DomainMBean getProposedDomain() {
        return this.proposedDomain;
    }

    void setProposedDomain(DomainMBean domainMBean) {
        this.proposedDomain = domainMBean;
    }

    void setDefaultTargets(TargetMBean[] targetMBeanArray) {
        if (this.defaultTargets != null && targetMBeanArray != null) {
            if (this.defaultTargets.length != targetMBeanArray.length) {
                this.defaultTargetsChanged = true;
            } else {
                int n;
                LinkedList<TargetMBean> linkedList = new LinkedList<TargetMBean>();
                for (n = 0; n < this.defaultTargets.length; ++n) {
                    linkedList.add(this.defaultTargets[n]);
                }
                for (n = 0; n < targetMBeanArray.length; ++n) {
                    if (linkedList.contains(targetMBeanArray[n])) continue;
                    this.defaultTargetsChanged = true;
                }
            }
        }
        if (this.defaultTargets != null && targetMBeanArray == null || this.defaultTargets == null && targetMBeanArray != null) {
            this.defaultTargetsChanged = true;
        }
        if (this.defaultTargetsChanged) {
            this.defaultTargets = targetMBeanArray;
        }
    }

    TargetMBean[] getDefaultTargets() {
        return this.defaultTargets;
    }

    boolean hasDefaultTargetsChanged() {
        return this.defaultTargetsChanged;
    }

    void clearTargetUpdates() {
        this.getAddedGroups().clear();
        this.setAddedGroups(null);
        this.getAddedLocalGroups().clear();
        this.setAddedLocalGroups(null);
        this.getRemovedGroups().clear();
        this.setRemovedGroups(null);
        this.getRemovedLocalGroups().clear();
        this.setRemovedLocalGroups(null);
        this.getChangedGroups().clear();
        this.setChangedGroups(null);
        this.getChangedLocalGroups().clear();
        this.setChangedLocalGroups(null);
    }

    void close() {
        for (int i = 0; i < this.maxType; ++i) {
            this.addedEntities[i].clear();
            this.addedEntities[i] = null;
            this.addedEntitiesHash[i].clear();
            this.addedEntitiesHash[i] = null;
            this.deletedEntities[i].clear();
            this.deletedEntities[i] = null;
            this.deletedEntitiesHash[i].clear();
            this.deletedEntitiesHash[i] = null;
            this.changedEntities[i].clear();
            this.changedEntities[i] = null;
        }
        this.addedEntities = null;
        this.addedEntitiesHash = null;
        this.deletedEntities = null;
        this.deletedEntitiesHash = null;
        this.changedEntities = null;
        this.proposedDomain = null;
        this.defaultTargets = null;
        this.defaultTargetsChanged = false;
    }
}

