/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module.customizers;

import weblogic.j2ee.descriptor.wl.ForeignConnectionFactoryBean;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.internal.encryption.EncryptionServiceException;
import weblogic.utils.NestedRuntimeException;

public class ForeignConnectionFactoryCustomizer {
    private ForeignConnectionFactoryBean customized;

    public ForeignConnectionFactoryCustomizer(ForeignConnectionFactoryBean foreignConnectionFactoryBean) {
        this.customized = foreignConnectionFactoryBean;
    }

    public String getPassword() {
        String string;
        ClearOrEncryptedService clearOrEncryptedService;
        try {
            EncryptionService encryptionService = SerializedSystemIni.getEncryptionService();
            clearOrEncryptedService = new ClearOrEncryptedService(encryptionService);
        }
        catch (NestedRuntimeException nestedRuntimeException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("ERROR: Got an NPE(1).  Please fix CR186445");
            nullPointerException.printStackTrace();
            return null;
        }
        try {
            string = clearOrEncryptedService.decrypt(new String(this.customized.getPasswordEncrypted()));
        }
        catch (EncryptionServiceException encryptionServiceException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("ERROR: Got an NPE(2).  Please fix CR186445");
            nullPointerException.printStackTrace();
            return null;
        }
        return string;
    }

    public void setPassword(String string) throws IllegalArgumentException {
        byte[] byArray;
        ClearOrEncryptedService clearOrEncryptedService;
        if (string == null) {
            return;
        }
        try {
            EncryptionService encryptionService = SerializedSystemIni.getEncryptionService();
            clearOrEncryptedService = new ClearOrEncryptedService(encryptionService);
        }
        catch (NestedRuntimeException nestedRuntimeException) {
            throw new IllegalArgumentException("Could not get encryption service, likely the domain directory could not be found, " + (Object)((Object)nestedRuntimeException));
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("ERROR: Got an NPE(3).  Please fix CR186445");
            nullPointerException.printStackTrace();
            return;
        }
        try {
            byArray = clearOrEncryptedService.encrypt(string).getBytes();
        }
        catch (EncryptionServiceException encryptionServiceException) {
            throw new IllegalArgumentException("Could not encrypt the password, " + (Object)((Object)encryptionServiceException));
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("ERROR: Got an NPE(4).  Please fix CR186445");
            nullPointerException.printStackTrace();
            return;
        }
        this.customized.setPasswordEncrypted(byArray);
    }
}

