/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module.observers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.j2ee.descriptor.wl.DistributedQueueBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.MBeanConverter;
import weblogic.jms.module.observers.JMSObserver;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSDistributedQueueMBean;
import weblogic.management.configuration.JMSDistributedQueueMemberMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.provider.UpdateException;
import weblogic.utils.ArrayUtils;

public class JMSDistributedQueueObserver
implements PropertyChangeListener,
ArrayUtils.DiffHandler {
    private static final String MEMBERS_STRING = "JMSDistributedQueueMembers";
    private static final String[] handledProperties = new String[]{"JMSDistributedQueueMembers"};
    private static final int UNHANDLED = -1;
    private static final int MEMBER = 0;
    private static final int MAX_PROPERTIES = 1;
    private JMSObserver domainObserver;
    private JMSDistributedQueueMBean distributedQueue;
    private int currentType = -1;

    public JMSDistributedQueueObserver(JMSObserver jMSObserver, JMSDistributedQueueMBean jMSDistributedQueueMBean) {
        this.domainObserver = jMSObserver;
        this.distributedQueue = jMSDistributedQueueMBean;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.currentType = this.getType(propertyChangeEvent.getPropertyName());
        if (this.currentType == -1) {
            return;
        }
        Object[] objectArray = (Object[])propertyChangeEvent.getOldValue();
        Object[] objectArray2 = (Object[])propertyChangeEvent.getNewValue();
        ArrayUtils.computeDiff((Object[])objectArray, (Object[])objectArray2, (ArrayUtils.DiffHandler)this, (Comparator)this.domainObserver);
        this.currentType = -1;
    }

    public JMSDistributedQueueMBean getJMSDistributedQueue() {
        return this.distributedQueue;
    }

    private int getType(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < 1; ++i) {
            String string2 = handledProperties[i];
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void addMember(JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(domainMBean);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        DistributedQueueBean distributedQueueBean = jMSBean.lookupDistributedQueue(this.distributedQueue.getName());
        if (distributedQueueBean == null) {
            return;
        }
        DistributedDestinationMemberBean distributedDestinationMemberBean = null;
        try {
            distributedDestinationMemberBean = MBeanConverter.addDistributedQueueMember(jMSBean, distributedQueueBean, jMSDistributedQueueMemberMBean);
        }
        catch (UpdateException updateException) {
            this.domainObserver.logUpdateException(jMSDistributedQueueMemberMBean.getName(), updateException);
            return;
        }
        jMSDistributedQueueMemberMBean.useDelegates(domainMBean, distributedDestinationMemberBean);
    }

    private void removeMember(JMSDistributedQueueMemberMBean jMSDistributedQueueMemberMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(domainMBean);
        if (jMSInteropModuleMBean == null) {
            return;
        }
        JMSBean jMSBean = jMSInteropModuleMBean.getJMSResource();
        DistributedQueueBean distributedQueueBean = jMSBean.lookupDistributedQueue(this.distributedQueue.getName());
        if (distributedQueueBean == null) {
            return;
        }
        DistributedDestinationMemberBean distributedDestinationMemberBean = distributedQueueBean.lookupDistributedQueueMember(jMSDistributedQueueMemberMBean.getName());
        distributedQueueBean.destroyDistributedQueueMember(distributedDestinationMemberBean);
    }

    public void addObject(Object object) {
        switch (this.currentType) {
            case 0: {
                this.addMember((JMSDistributedQueueMemberMBean)object);
                break;
            }
            default: {
                throw new AssertionError((Object)("ERROR: Unknown current type: " + this.currentType));
            }
        }
    }

    public void removeObject(Object object) {
        switch (this.currentType) {
            case 0: {
                this.removeMember((JMSDistributedQueueMemberMBean)object);
                break;
            }
            default: {
                throw new AssertionError((Object)("ERROR: Unknown current type: " + this.currentType));
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof JMSDistributedQueueObserver)) {
            return false;
        }
        JMSDistributedQueueObserver jMSDistributedQueueObserver = (JMSDistributedQueueObserver)object;
        return this.distributedQueue == jMSDistributedQueueObserver.distributedQueue;
    }

    public int hashCode() {
        return this.distributedQueue.hashCode();
    }
}

