/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module.observers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.j2ee.descriptor.wl.DistributedTopicBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.MBeanConverter;
import weblogic.jms.module.observers.JMSObserver;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSDistributedTopicMBean;
import weblogic.management.configuration.JMSDistributedTopicMemberMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.provider.UpdateException;
import weblogic.utils.ArrayUtils;

public class JMSDistributedTopicObserver
implements PropertyChangeListener,
ArrayUtils.DiffHandler {
    private static final String MEMBERS_STRING = "JMSDistributedTopicMembers";
    private static final String[] handledProperties = new String[]{"JMSDistributedTopicMembers"};
    private static final int UNHANDLED = -1;
    private static final int MEMBER = 0;
    private static final int MAX_PROPERTIES = 1;
    private JMSObserver domainObserver;
    private JMSDistributedTopicMBean distributedTopic;
    private int currentType = -1;

    public JMSDistributedTopicObserver(JMSObserver jMSObserver, JMSDistributedTopicMBean jMSDistributedTopicMBean) {
        this.domainObserver = jMSObserver;
        this.distributedTopic = jMSDistributedTopicMBean;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.currentType = this.getType(propertyChangeEvent.getPropertyName());
        if (this.currentType == -1) {
            return;
        }
        Object[] objectArray = (Object[])propertyChangeEvent.getOldValue();
        Object[] objectArray2 = (Object[])propertyChangeEvent.getNewValue();
        ArrayUtils.computeDiff((Object[])objectArray, (Object[])objectArray2, (ArrayUtils.DiffHandler)this, (Comparator)this.domainObserver);
        this.currentType = -1;
    }

    public JMSDistributedTopicMBean getJMSDistributedTopic() {
        return this.distributedTopic;
    }

    private int getType(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < 1; ++i) {
            String string2 = handledProperties[i];
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void addMember(JMSDistributedTopicMemberMBean jMSDistributedTopicMemberMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(domainMBean);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        DistributedTopicBean distributedTopicBean = jMSBean.lookupDistributedTopic(this.distributedTopic.getName());
        if (distributedTopicBean == null) {
            return;
        }
        DistributedDestinationMemberBean distributedDestinationMemberBean = null;
        try {
            distributedDestinationMemberBean = MBeanConverter.addDistributedTopicMember(jMSBean, distributedTopicBean, jMSDistributedTopicMemberMBean);
        }
        catch (UpdateException updateException) {
            this.domainObserver.logUpdateException(jMSDistributedTopicMemberMBean.getName(), updateException);
            return;
        }
        jMSDistributedTopicMemberMBean.useDelegates(domainMBean, distributedDestinationMemberBean);
    }

    private void removeMember(JMSDistributedTopicMemberMBean jMSDistributedTopicMemberMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(domainMBean);
        if (jMSInteropModuleMBean == null) {
            return;
        }
        JMSBean jMSBean = jMSInteropModuleMBean.getJMSResource();
        DistributedTopicBean distributedTopicBean = jMSBean.lookupDistributedTopic(this.distributedTopic.getName());
        if (distributedTopicBean == null) {
            return;
        }
        DistributedDestinationMemberBean distributedDestinationMemberBean = distributedTopicBean.lookupDistributedTopicMember(jMSDistributedTopicMemberMBean.getName());
        distributedTopicBean.destroyDistributedTopicMember(distributedDestinationMemberBean);
    }

    public void addObject(Object object) {
        switch (this.currentType) {
            case 0: {
                this.addMember((JMSDistributedTopicMemberMBean)object);
                break;
            }
            default: {
                throw new AssertionError((Object)("ERROR: Unknown current type: " + this.currentType));
            }
        }
    }

    public void removeObject(Object object) {
        switch (this.currentType) {
            case 0: {
                this.removeMember((JMSDistributedTopicMemberMBean)object);
                break;
            }
            default: {
                throw new AssertionError((Object)("ERROR: Unknown current type: " + this.currentType));
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof JMSDistributedTopicObserver)) {
            return false;
        }
        JMSDistributedTopicObserver jMSDistributedTopicObserver = (JMSDistributedTopicObserver)object;
        return this.distributedTopic == jMSDistributedTopicObserver.distributedTopic;
    }

    public int hashCode() {
        return this.distributedTopic.hashCode();
    }
}

