/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module.observers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import weblogic.j2ee.descriptor.wl.ForeignConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ForeignDestinationBean;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.MBeanConverter;
import weblogic.jms.module.observers.JMSObserver;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ForeignJMSConnectionFactoryMBean;
import weblogic.management.configuration.ForeignJMSDestinationMBean;
import weblogic.management.configuration.ForeignJMSServerMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.utils.ArrayUtils;

public class JMSForeignObserver
implements PropertyChangeListener,
ArrayUtils.DiffHandler {
    private static final String DESTINATION_STRING = "ForeignJMSDestinations";
    private static final String CONNECTION_FACTORY_STRING = "ForeignJMSConnectionFactories";
    private static final String[] handledProperties = new String[]{"ForeignJMSDestinations", "ForeignJMSConnectionFactories"};
    private static final int UNHANDLED = -1;
    private static final int DESTINATION = 0;
    private static final int CONNECTION_FACTORY = 1;
    private static final int MAX_PROPERTIES = 2;
    private JMSObserver domainObserver;
    private ForeignJMSServerMBean foreignJMSServer;
    private int currentType = -1;

    public JMSForeignObserver(JMSObserver jMSObserver, ForeignJMSServerMBean foreignJMSServerMBean) {
        this.domainObserver = jMSObserver;
        this.foreignJMSServer = foreignJMSServerMBean;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.currentType = this.getType(propertyChangeEvent.getPropertyName());
        if (this.currentType == -1) {
            return;
        }
        Object[] objectArray = (Object[])propertyChangeEvent.getOldValue();
        Object[] objectArray2 = (Object[])propertyChangeEvent.getNewValue();
        ArrayUtils.computeDiff((Object[])objectArray, (Object[])objectArray2, (ArrayUtils.DiffHandler)this, (Comparator)this.domainObserver);
        this.currentType = -1;
    }

    public ForeignJMSServerMBean getForeignJMSServer() {
        return this.foreignJMSServer;
    }

    private int getType(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < 2; ++i) {
            String string2 = handledProperties[i];
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void addDestination(ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(domainMBean);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        ForeignServerBean foreignServerBean = jMSBean.lookupForeignServer(this.foreignJMSServer.getName());
        if (foreignServerBean == null) {
            return;
        }
        ForeignDestinationBean foreignDestinationBean = MBeanConverter.addForeignDestination(foreignServerBean, foreignJMSDestinationMBean);
        foreignJMSDestinationMBean.useDelegates(foreignDestinationBean);
    }

    private void removeDestination(ForeignJMSDestinationMBean foreignJMSDestinationMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(domainMBean);
        if (jMSInteropModuleMBean == null) {
            return;
        }
        JMSBean jMSBean = jMSInteropModuleMBean.getJMSResource();
        ForeignServerBean foreignServerBean = jMSBean.lookupForeignServer(this.foreignJMSServer.getName());
        if (foreignServerBean == null) {
            return;
        }
        ForeignDestinationBean foreignDestinationBean = foreignServerBean.lookupForeignDestination(foreignJMSDestinationMBean.getName());
        foreignServerBean.destroyForeignDestination(foreignDestinationBean);
    }

    private void addConnectionFactory(ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(domainMBean);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        ForeignServerBean foreignServerBean = jMSBean.lookupForeignServer(this.foreignJMSServer.getName());
        if (foreignServerBean == null) {
            return;
        }
        ForeignConnectionFactoryBean foreignConnectionFactoryBean = MBeanConverter.addForeignConnectionFactory(foreignServerBean, foreignJMSConnectionFactoryMBean);
        foreignJMSConnectionFactoryMBean.useDelegates(foreignConnectionFactoryBean);
    }

    private void removeConnectionFactory(ForeignJMSConnectionFactoryMBean foreignJMSConnectionFactoryMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(domainMBean);
        if (jMSInteropModuleMBean == null) {
            return;
        }
        JMSBean jMSBean = jMSInteropModuleMBean.getJMSResource();
        ForeignServerBean foreignServerBean = jMSBean.lookupForeignServer(this.foreignJMSServer.getName());
        if (foreignServerBean == null) {
            return;
        }
        ForeignConnectionFactoryBean foreignConnectionFactoryBean = foreignServerBean.lookupForeignConnectionFactory(foreignJMSConnectionFactoryMBean.getName());
        foreignServerBean.destroyForeignConnectionFactory(foreignConnectionFactoryBean);
    }

    public void addObject(Object object) {
        switch (this.currentType) {
            case 0: {
                this.addDestination((ForeignJMSDestinationMBean)object);
                break;
            }
            case 1: {
                this.addConnectionFactory((ForeignJMSConnectionFactoryMBean)object);
                break;
            }
            default: {
                throw new AssertionError((Object)("ERROR: Unknown current type: " + this.currentType));
            }
        }
    }

    public void removeObject(Object object) {
        switch (this.currentType) {
            case 0: {
                this.removeDestination((ForeignJMSDestinationMBean)object);
                break;
            }
            case 1: {
                this.removeConnectionFactory((ForeignJMSConnectionFactoryMBean)object);
                break;
            }
            default: {
                throw new AssertionError((Object)("ERROR: Unknown current type: " + this.currentType));
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof JMSForeignObserver)) {
            return false;
        }
        JMSForeignObserver jMSForeignObserver = (JMSForeignObserver)object;
        return this.foreignJMSServer == jMSForeignObserver.foreignJMSServer;
    }

    public int hashCode() {
        return this.foreignJMSServer.hashCode();
    }
}

