/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module.observers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.j2ee.descriptor.wl.DestinationKeyBean;
import weblogic.j2ee.descriptor.wl.DistributedQueueBean;
import weblogic.j2ee.descriptor.wl.DistributedTopicBean;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.JMSConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.TemplateBean;
import weblogic.jms.JMSLogger;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.JMSCompatibilityProcessor;
import weblogic.jms.module.MBeanConverter;
import weblogic.jms.module.observers.JMSDistributedQueueObserver;
import weblogic.jms.module.observers.JMSDistributedTopicObserver;
import weblogic.jms.module.observers.JMSForeignObserver;
import weblogic.jms.module.observers.JMSServerObserver;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ForeignJMSServerMBean;
import weblogic.management.configuration.JMSConnectionFactoryMBean;
import weblogic.management.configuration.JMSDestinationKeyMBean;
import weblogic.management.configuration.JMSDistributedQueueMBean;
import weblogic.management.configuration.JMSDistributedTopicMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.JMSTemplateMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.AccessCallback;
import weblogic.management.provider.UpdateException;
import weblogic.utils.ArrayUtils;

public class JMSObserver
implements AccessCallback,
PropertyChangeListener,
ArrayUtils.DiffHandler,
Comparator {
    private static final String CONNECTION_FACTORY_STRING = "JMSConnectionFactories";
    private static final String JMS_SERVER_STRING = "JMSServers";
    private static final String TEMPLATE_STRING = "JMSTemplates";
    private static final String FOREIGN_SERVER_STRING = "ForeignJMSServers";
    private static final String DISTRIBUTED_QUEUE_STRING = "JMSDistributedQueues";
    private static final String DISTRIBUTED_TOPIC_STRING = "JMSDistributedTopics";
    private static final String DESTINATION_KEY_STRING = "JMSDestinationKeys";
    private static final String[] handledProperties = new String[]{"JMSConnectionFactories", "JMSServers", "JMSTemplates", "ForeignJMSServers", "JMSDistributedQueues", "JMSDistributedTopics", "JMSDestinationKeys"};
    private static final int UNHANDLED = -1;
    private static final int CONNECTION_FACTORY = 0;
    private static final int JMS_SERVER = 1;
    private static final int TEMPLATE = 2;
    private static final int FOREIGN_SERVER = 3;
    private static final int DISTRIBUTED_QUEUE = 4;
    private static final int DISTRIBUTED_TOPIC = 5;
    private static final int DESTINATION_KEY = 6;
    private static final int MAX_PROPERTIES = 7;
    private DomainMBean root;
    private HashSet jmsServerObservers;
    private HashSet foreignJMSServerObservers;
    private HashSet distributedQueueObservers;
    private HashSet distributedTopicObservers;
    private int currentType = -1;

    public void shutdown() {
        this.root.removePropertyChangeListener(this);
        this.root = null;
    }

    public void accessed(DomainMBean domainMBean) {
        Object object;
        Object object2;
        this.root = domainMBean;
        JMSCompatibilityProcessor.updateConfiguration(domainMBean);
        domainMBean.addPropertyChangeListener(this);
        this.jmsServerObservers = new HashSet();
        this.foreignJMSServerObservers = new HashSet();
        this.distributedQueueObservers = new HashSet();
        this.distributedTopicObservers = new HashSet();
        JMSServerMBean[] jMSServerMBeanArray = this.root.getJMSServers();
        for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
            this.addJMSServer(jMSServerMBeanArray[i]);
        }
        ForeignJMSServerMBean[] foreignJMSServerMBeanArray = this.root.getForeignJMSServers();
        for (int i = 0; i < foreignJMSServerMBeanArray.length; ++i) {
            ForeignJMSServerMBean foreignJMSServerMBean = foreignJMSServerMBeanArray[i];
            object2 = new JMSForeignObserver(this, foreignJMSServerMBean);
            ((AbstractDescriptorBean)foreignJMSServerMBean).addPropertyChangeListener((PropertyChangeListener)object2);
            this.foreignJMSServerObservers.add(object2);
        }
        JMSDistributedQueueMBean[] jMSDistributedQueueMBeanArray = this.root.getJMSDistributedQueues();
        for (int i = 0; i < jMSDistributedQueueMBeanArray.length; ++i) {
            object2 = jMSDistributedQueueMBeanArray[i];
            object = new JMSDistributedQueueObserver(this, (JMSDistributedQueueMBean)object2);
            ((AbstractDescriptorBean)object2).addPropertyChangeListener((PropertyChangeListener)object);
            this.distributedQueueObservers.add(object);
        }
        JMSDistributedTopicMBean[] jMSDistributedTopicMBeanArray = this.root.getJMSDistributedTopics();
        for (int i = 0; i < jMSDistributedTopicMBeanArray.length; ++i) {
            object = jMSDistributedTopicMBeanArray[i];
            JMSDistributedTopicObserver jMSDistributedTopicObserver = new JMSDistributedTopicObserver(this, (JMSDistributedTopicMBean)object);
            ((AbstractDescriptorBean)object).addPropertyChangeListener((PropertyChangeListener)jMSDistributedTopicObserver);
            this.distributedTopicObservers.add(jMSDistributedTopicObserver);
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.currentType = this.getType(propertyChangeEvent.getPropertyName());
        if (this.currentType == -1) {
            return;
        }
        Object[] objectArray = (Object[])propertyChangeEvent.getOldValue();
        Object[] objectArray2 = (Object[])propertyChangeEvent.getNewValue();
        ArrayUtils.computeDiff((Object[])objectArray, (Object[])objectArray2, (ArrayUtils.DiffHandler)this, (Comparator)this);
        this.currentType = -1;
    }

    private int getType(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < 7; ++i) {
            String string2 = handledProperties[i];
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void addConnectionFactory(JMSConnectionFactoryMBean jMSConnectionFactoryMBean) {
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(this.root);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        HashMap hashMap = MBeanConverter.splitDeployment(jMSConnectionFactoryMBean);
        if (hashMap.size() > 1) {
            JMSLogger.logSplitDeployment((String)"JSMConnectionFactory", (String)jMSConnectionFactoryMBean.getName());
            for (String string : hashMap.keySet()) {
                ArrayList arrayList = (ArrayList)hashMap.get(string);
                TargetMBean[] targetMBeanArray = arrayList.toArray(new TargetMBean[0]);
                JMSConnectionFactoryBean jMSConnectionFactoryBean = MBeanConverter.addJMSConnectionFactory(jMSBean, jMSSystemResourceMBean, jMSConnectionFactoryMBean, string, targetMBeanArray);
                jMSConnectionFactoryMBean.useDelegates(jMSConnectionFactoryBean, JMSBeanHelper.findSubDeployment(string, jMSSystemResourceMBean));
            }
        } else {
            JMSConnectionFactoryBean jMSConnectionFactoryBean = MBeanConverter.addJMSConnectionFactory(jMSBean, jMSSystemResourceMBean, jMSConnectionFactoryMBean, jMSConnectionFactoryMBean.getName(), jMSConnectionFactoryMBean.getTargets());
            jMSConnectionFactoryMBean.useDelegates(jMSConnectionFactoryBean, JMSBeanHelper.findSubDeployment(jMSConnectionFactoryMBean.getName(), jMSSystemResourceMBean));
        }
    }

    private void removeConnectionFactory(JMSConnectionFactoryMBean jMSConnectionFactoryMBean) {
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(this.root);
        if (jMSInteropModuleMBean == null) {
            return;
        }
        JMSBean jMSBean = jMSInteropModuleMBean.getJMSResource();
        JMSConnectionFactoryBean jMSConnectionFactoryBean = jMSBean.lookupConnectionFactory(jMSConnectionFactoryMBean.getName());
        jMSBean.destroyConnectionFactory(jMSConnectionFactoryBean);
        SubDeploymentMBean subDeploymentMBean = JMSBeanHelper.findSubDeployment(jMSConnectionFactoryMBean.getName(), jMSInteropModuleMBean);
        jMSInteropModuleMBean.destroySubDeployment(subDeploymentMBean);
    }

    private void addJMSServer(JMSServerMBean jMSServerMBean) {
        JMSServerObserver jMSServerObserver = new JMSServerObserver(this, jMSServerMBean);
        ((AbstractDescriptorBean)jMSServerMBean).addPropertyChangeListener((PropertyChangeListener)jMSServerObserver);
        this.jmsServerObservers.add(jMSServerObserver);
    }

    private void removeJMSServer(JMSServerMBean jMSServerMBean) {
        Iterator iterator = this.jmsServerObservers.iterator();
        while (iterator.hasNext()) {
            JMSServerObserver jMSServerObserver = (JMSServerObserver)iterator.next();
            JMSServerMBean jMSServerMBean2 = jMSServerObserver.getJMSServer();
            if (jMSServerMBean != jMSServerMBean2) continue;
            ((AbstractDescriptorBean)jMSServerMBean).removePropertyChangeListener((PropertyChangeListener)jMSServerObserver);
            iterator.remove();
            return;
        }
    }

    void logUpdateException(String string, UpdateException updateException) {
        JMSLogger.logUnableToAddEntity((String)string, (String)updateException.toString());
    }

    private void addTemplate(JMSTemplateMBean jMSTemplateMBean) {
        TemplateBean templateBean;
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(this.root);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        try {
            templateBean = MBeanConverter.addTemplate(jMSBean, jMSTemplateMBean);
        }
        catch (UpdateException updateException) {
            this.logUpdateException(jMSTemplateMBean.getName(), updateException);
            return;
        }
        jMSTemplateMBean.useDelegates(this.root, jMSBean, templateBean);
    }

    private void removeTemplate(JMSTemplateMBean jMSTemplateMBean) {
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(this.root);
        if (jMSInteropModuleMBean == null) {
            return;
        }
        JMSBean jMSBean = jMSInteropModuleMBean.getJMSResource();
        TemplateBean templateBean = jMSBean.lookupTemplate(jMSTemplateMBean.getName());
        jMSBean.destroyTemplate(templateBean);
    }

    private void addForeignServer(ForeignJMSServerMBean foreignJMSServerMBean) {
        Object object;
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(this.root);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        HashMap hashMap = MBeanConverter.splitDeployment(foreignJMSServerMBean);
        if (hashMap.size() > 1) {
            JMSLogger.logSplitDeployment((String)"ForeignJMSServer", (String)foreignJMSServerMBean.getName());
            for (String string : hashMap.keySet()) {
                ArrayList arrayList = (ArrayList)hashMap.get(string);
                TargetMBean[] targetMBeanArray = arrayList.toArray(new TargetMBean[0]);
                ForeignServerBean foreignServerBean = MBeanConverter.addForeignJMSServer(jMSBean, jMSSystemResourceMBean, foreignJMSServerMBean, string, targetMBeanArray);
                foreignJMSServerMBean.useDelegates(foreignServerBean, JMSBeanHelper.findSubDeployment(string, jMSSystemResourceMBean));
            }
        } else {
            object = MBeanConverter.addForeignJMSServer(jMSBean, jMSSystemResourceMBean, foreignJMSServerMBean, foreignJMSServerMBean.getName(), foreignJMSServerMBean.getTargets());
            foreignJMSServerMBean.useDelegates((ForeignServerBean)object, JMSBeanHelper.findSubDeployment(foreignJMSServerMBean.getName(), jMSSystemResourceMBean));
        }
        object = new JMSForeignObserver(this, foreignJMSServerMBean);
        ((AbstractDescriptorBean)foreignJMSServerMBean).addPropertyChangeListener((PropertyChangeListener)object);
        this.foreignJMSServerObservers.add(object);
    }

    private void removeForeignServer(ForeignJMSServerMBean foreignJMSServerMBean) {
        ForeignJMSServerMBean foreignJMSServerMBean2;
        Object object;
        Iterator iterator = this.foreignJMSServerObservers.iterator();
        while (iterator.hasNext()) {
            object = (JMSForeignObserver)iterator.next();
            foreignJMSServerMBean2 = ((JMSForeignObserver)object).getForeignJMSServer();
            if (foreignJMSServerMBean != foreignJMSServerMBean2) continue;
            ((AbstractDescriptorBean)foreignJMSServerMBean).removePropertyChangeListener((PropertyChangeListener)object);
            iterator.remove();
            break;
        }
        if ((object = JMSBeanHelper.getJMSInteropModule(this.root)) == null) {
            return;
        }
        foreignJMSServerMBean2 = object.getJMSResource();
        ForeignServerBean foreignServerBean = foreignJMSServerMBean2.lookupForeignServer(foreignJMSServerMBean.getName());
        foreignJMSServerMBean2.destroyForeignServer(foreignServerBean);
        SubDeploymentMBean subDeploymentMBean = JMSBeanHelper.findSubDeployment(foreignJMSServerMBean.getName(), (BasicDeploymentMBean)object);
        object.destroySubDeployment(subDeploymentMBean);
    }

    private void addDistributedQueue(JMSDistributedQueueMBean jMSDistributedQueueMBean) {
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(this.root);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        DistributedQueueBean distributedQueueBean = null;
        try {
            distributedQueueBean = MBeanConverter.addDistributedQueue(jMSBean, jMSSystemResourceMBean, jMSDistributedQueueMBean);
        }
        catch (UpdateException updateException) {
            this.logUpdateException(jMSDistributedQueueMBean.getName(), updateException);
            return;
        }
        jMSDistributedQueueMBean.useDelegates(distributedQueueBean, JMSBeanHelper.findSubDeployment(distributedQueueBean.getName(), jMSSystemResourceMBean));
        JMSDistributedQueueObserver jMSDistributedQueueObserver = new JMSDistributedQueueObserver(this, jMSDistributedQueueMBean);
        ((AbstractDescriptorBean)jMSDistributedQueueMBean).addPropertyChangeListener((PropertyChangeListener)jMSDistributedQueueObserver);
        this.distributedQueueObservers.add(jMSDistributedQueueObserver);
    }

    private void removeDistributedQueue(JMSDistributedQueueMBean jMSDistributedQueueMBean) {
        JMSDistributedQueueMBean jMSDistributedQueueMBean2;
        Object object;
        Iterator iterator = this.distributedQueueObservers.iterator();
        while (iterator.hasNext()) {
            object = (JMSDistributedQueueObserver)iterator.next();
            jMSDistributedQueueMBean2 = ((JMSDistributedQueueObserver)object).getJMSDistributedQueue();
            if (jMSDistributedQueueMBean != jMSDistributedQueueMBean2) continue;
            ((AbstractDescriptorBean)jMSDistributedQueueMBean).removePropertyChangeListener((PropertyChangeListener)object);
            iterator.remove();
            break;
        }
        if ((object = JMSBeanHelper.getJMSInteropModule(this.root)) == null) {
            return;
        }
        jMSDistributedQueueMBean2 = object.getJMSResource();
        DistributedQueueBean distributedQueueBean = jMSDistributedQueueMBean2.lookupDistributedQueue(jMSDistributedQueueMBean.getName());
        jMSDistributedQueueMBean2.destroyDistributedQueue(distributedQueueBean);
        SubDeploymentMBean subDeploymentMBean = JMSBeanHelper.findSubDeployment(jMSDistributedQueueMBean.getName(), (BasicDeploymentMBean)object);
        object.destroySubDeployment(subDeploymentMBean);
    }

    private void addDistributedTopic(JMSDistributedTopicMBean jMSDistributedTopicMBean) {
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(this.root);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        DistributedTopicBean distributedTopicBean = null;
        try {
            distributedTopicBean = MBeanConverter.addDistributedTopic(jMSBean, jMSSystemResourceMBean, jMSDistributedTopicMBean);
        }
        catch (UpdateException updateException) {
            this.logUpdateException(jMSDistributedTopicMBean.getName(), updateException);
            return;
        }
        jMSDistributedTopicMBean.useDelegates(distributedTopicBean, JMSBeanHelper.findSubDeployment(distributedTopicBean.getName(), jMSSystemResourceMBean));
        JMSDistributedTopicObserver jMSDistributedTopicObserver = new JMSDistributedTopicObserver(this, jMSDistributedTopicMBean);
        ((AbstractDescriptorBean)jMSDistributedTopicMBean).addPropertyChangeListener((PropertyChangeListener)jMSDistributedTopicObserver);
        this.distributedTopicObservers.add(jMSDistributedTopicObserver);
    }

    private void removeDistributedTopic(JMSDistributedTopicMBean jMSDistributedTopicMBean) {
        JMSDistributedTopicMBean jMSDistributedTopicMBean2;
        Object object;
        Iterator iterator = this.distributedTopicObservers.iterator();
        while (iterator.hasNext()) {
            object = (JMSDistributedTopicObserver)iterator.next();
            jMSDistributedTopicMBean2 = ((JMSDistributedTopicObserver)object).getJMSDistributedTopic();
            if (jMSDistributedTopicMBean != jMSDistributedTopicMBean2) continue;
            ((AbstractDescriptorBean)jMSDistributedTopicMBean).removePropertyChangeListener((PropertyChangeListener)object);
            iterator.remove();
            break;
        }
        if ((object = JMSBeanHelper.getJMSInteropModule(this.root)) == null) {
            return;
        }
        jMSDistributedTopicMBean2 = object.getJMSResource();
        DistributedTopicBean distributedTopicBean = jMSDistributedTopicMBean2.lookupDistributedTopic(jMSDistributedTopicMBean.getName());
        jMSDistributedTopicMBean2.destroyDistributedTopic(distributedTopicBean);
        SubDeploymentMBean subDeploymentMBean = JMSBeanHelper.findSubDeployment(jMSDistributedTopicMBean.getName(), (BasicDeploymentMBean)object);
        object.destroySubDeployment(subDeploymentMBean);
    }

    private void addDestinationKey(JMSDestinationKeyMBean jMSDestinationKeyMBean) {
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(this.root);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        DestinationKeyBean destinationKeyBean = MBeanConverter.addDestinationKey(jMSBean, jMSDestinationKeyMBean);
        jMSDestinationKeyMBean.useDelegates(destinationKeyBean);
    }

    private void removeDestinationKey(JMSDestinationKeyMBean jMSDestinationKeyMBean) {
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(this.root);
        if (jMSInteropModuleMBean == null) {
            return;
        }
        JMSBean jMSBean = jMSInteropModuleMBean.getJMSResource();
        DestinationKeyBean destinationKeyBean = jMSBean.lookupDestinationKey(jMSDestinationKeyMBean.getName());
        jMSBean.destroyDestinationKey(destinationKeyBean);
    }

    public void addObject(Object object) {
        switch (this.currentType) {
            case 0: {
                this.addConnectionFactory((JMSConnectionFactoryMBean)object);
                break;
            }
            case 1: {
                this.addJMSServer((JMSServerMBean)object);
                break;
            }
            case 2: {
                this.addTemplate((JMSTemplateMBean)object);
                break;
            }
            case 3: {
                this.addForeignServer((ForeignJMSServerMBean)object);
                break;
            }
            case 4: {
                this.addDistributedQueue((JMSDistributedQueueMBean)object);
                break;
            }
            case 5: {
                this.addDistributedTopic((JMSDistributedTopicMBean)object);
                break;
            }
            case 6: {
                this.addDestinationKey((JMSDestinationKeyMBean)object);
                break;
            }
            default: {
                throw new AssertionError((Object)("ERROR: Unknown current type: " + this.currentType));
            }
        }
    }

    public void removeObject(Object object) {
        switch (this.currentType) {
            case 0: {
                this.removeConnectionFactory((JMSConnectionFactoryMBean)object);
                break;
            }
            case 1: {
                this.removeJMSServer((JMSServerMBean)object);
                break;
            }
            case 2: {
                this.removeTemplate((JMSTemplateMBean)object);
                break;
            }
            case 3: {
                this.removeForeignServer((ForeignJMSServerMBean)object);
                break;
            }
            case 4: {
                this.removeDistributedQueue((JMSDistributedQueueMBean)object);
                break;
            }
            case 5: {
                this.removeDistributedTopic((JMSDistributedTopicMBean)object);
                break;
            }
            case 6: {
                this.removeDestinationKey((JMSDestinationKeyMBean)object);
                break;
            }
            default: {
                throw new AssertionError((Object)("ERROR: Unknown current type: " + this.currentType));
            }
        }
    }

    DomainMBean getDomain() {
        return this.root;
    }

    private int compareMBean(WebLogicMBean webLogicMBean, WebLogicMBean webLogicMBean2) {
        String string = webLogicMBean.getName();
        String string2 = webLogicMBean2.getName();
        if (string == null) {
            if (string2 == null) {
                return 0;
            }
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    public int compare(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new AssertionError((Object)("ERROR: Comparator should not get nulls: " + object + "/" + object2));
        }
        if (!(object instanceof WebLogicMBean) || !(object2 instanceof WebLogicMBean)) {
            throw new AssertionError((Object)("ERROR: Comparator got beans of unknown type: " + object.getClass().getName() + "/" + object2.getClass().getName()));
        }
        return this.compareMBean((WebLogicMBean)object, (WebLogicMBean)object2);
    }
}

