/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module.observers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.j2ee.descriptor.wl.TargetableBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.MBeanConverter;
import weblogic.jms.module.observers.JMSObserver;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.JMSQueueMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.JMSTopicMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.provider.UpdateException;
import weblogic.utils.ArrayUtils;

public class JMSServerObserver
implements PropertyChangeListener,
ArrayUtils.DiffHandler {
    private static final String QUEUE_STRING = "JMSQueues";
    private static final String TOPIC_STRING = "JMSTopics";
    private static final String[] handledProperties = new String[]{"JMSQueues", "JMSTopics"};
    private static final int UNHANDLED = -1;
    private static final int QUEUE = 0;
    private static final int TOPIC = 1;
    private static final int MAX_PROPERTIES = 2;
    private JMSObserver domainObserver;
    private JMSServerMBean jmsServer;
    private int currentType = -1;

    public JMSServerObserver(JMSObserver jMSObserver, JMSServerMBean jMSServerMBean) {
        this.domainObserver = jMSObserver;
        this.jmsServer = jMSServerMBean;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.currentType = this.getType(propertyChangeEvent.getPropertyName());
        if (this.currentType == -1) {
            return;
        }
        Object[] objectArray = (Object[])propertyChangeEvent.getOldValue();
        Object[] objectArray2 = (Object[])propertyChangeEvent.getNewValue();
        ArrayUtils.computeDiff((Object[])objectArray, (Object[])objectArray2, (ArrayUtils.DiffHandler)this, (Comparator)this.domainObserver);
        this.currentType = -1;
    }

    public JMSServerMBean getJMSServer() {
        return this.jmsServer;
    }

    private int getType(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < 2; ++i) {
            String string2 = handledProperties[i];
            if (!string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void addQuota(JMSBean jMSBean, DestinationBean destinationBean) {
        if (destinationBean.getQuota() != null) {
            return;
        }
        String string = MBeanConverter.constructQuotaNameFromDestinationName(destinationBean.getName());
        QuotaBean quotaBean = jMSBean.lookupQuota(string);
        if (quotaBean != null) {
            return;
        }
        quotaBean = jMSBean.createQuota(string);
        long l = this.jmsServer.getBytesMaximum();
        if (l >= 0L) {
            quotaBean.setBytesMaximum(l);
        }
        if ((l = this.jmsServer.getMessagesMaximum()) >= 0L) {
            quotaBean.setMessagesMaximum(l);
        }
        quotaBean.setShared(false);
        destinationBean.setQuota(quotaBean);
    }

    private void removeQuota(JMSBean jMSBean, DestinationBean destinationBean) {
        String string = MBeanConverter.constructQuotaNameFromDestinationName(destinationBean.getName());
        QuotaBean quotaBean = jMSBean.lookupQuota(string);
        if (quotaBean == null) {
            return;
        }
        jMSBean.destroyQuota(quotaBean);
    }

    private void addQueue(JMSQueueMBean jMSQueueMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(domainMBean);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        QueueBean queueBean = null;
        try {
            queueBean = MBeanConverter.addQueue(jMSBean, jMSSystemResourceMBean, jMSQueueMBean);
        }
        catch (UpdateException updateException) {
            this.domainObserver.logUpdateException(jMSQueueMBean.getName(), updateException);
            return;
        }
        this.addQuota(jMSBean, (DestinationBean)queueBean);
        jMSQueueMBean.useDelegates(domainMBean, jMSBean, queueBean);
    }

    private boolean findTargetableMatch(TargetableBean[] targetableBeanArray, String string) {
        for (int i = 0; i < targetableBeanArray.length; ++i) {
            TargetableBean targetableBean = targetableBeanArray[i];
            if (!string.equals(targetableBean.getSubDeploymentName())) continue;
            return true;
        }
        return false;
    }

    private void removeSubDeployment(TargetableBean targetableBean, JMSSystemResourceMBean jMSSystemResourceMBean) {
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        String string = targetableBean.getSubDeploymentName();
        SubDeploymentMBean subDeploymentMBean = JMSBeanHelper.findSubDeployment(string, jMSSystemResourceMBean);
        if (subDeploymentMBean == null) {
            return;
        }
        QueueBean[] queueBeanArray = jMSBean.getQueues();
        TopicBean[] topicBeanArray = jMSBean.getTopics();
        if (this.findTargetableMatch((TargetableBean[])queueBeanArray, string) || this.findTargetableMatch((TargetableBean[])topicBeanArray, string)) {
            return;
        }
        jMSSystemResourceMBean.destroySubDeployment(subDeploymentMBean);
    }

    private void removeQueue(JMSQueueMBean jMSQueueMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(domainMBean);
        if (jMSInteropModuleMBean == null) {
            return;
        }
        JMSBean jMSBean = jMSInteropModuleMBean.getJMSResource();
        QueueBean queueBean = jMSBean.lookupQueue(jMSQueueMBean.getName());
        if (queueBean != null) {
            jMSBean.destroyQueue(queueBean);
            this.removeQuota(jMSBean, (DestinationBean)queueBean);
        }
        this.removeSubDeployment((TargetableBean)queueBean, jMSInteropModuleMBean);
    }

    private void addTopic(JMSTopicMBean jMSTopicMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSSystemResourceMBean jMSSystemResourceMBean = JMSBeanHelper.addInteropApplication(domainMBean);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        TopicBean topicBean = null;
        try {
            topicBean = MBeanConverter.addTopic(jMSBean, jMSSystemResourceMBean, jMSTopicMBean);
        }
        catch (UpdateException updateException) {
            this.domainObserver.logUpdateException(jMSTopicMBean.getName(), updateException);
            return;
        }
        this.addQuota(jMSBean, (DestinationBean)topicBean);
        jMSTopicMBean.useDelegates(domainMBean, jMSBean, topicBean);
    }

    private void removeTopic(JMSTopicMBean jMSTopicMBean) {
        DomainMBean domainMBean = this.domainObserver.getDomain();
        JMSInteropModuleMBean jMSInteropModuleMBean = JMSBeanHelper.getJMSInteropModule(domainMBean);
        if (jMSInteropModuleMBean == null) {
            return;
        }
        JMSBean jMSBean = jMSInteropModuleMBean.getJMSResource();
        TopicBean topicBean = jMSBean.lookupTopic(jMSTopicMBean.getName());
        if (topicBean != null) {
            jMSBean.destroyTopic(topicBean);
            this.removeQuota(jMSBean, (DestinationBean)topicBean);
        }
        this.removeSubDeployment((TargetableBean)topicBean, jMSInteropModuleMBean);
    }

    public void addObject(Object object) {
        switch (this.currentType) {
            case 0: {
                this.addQueue((JMSQueueMBean)object);
                break;
            }
            case 1: {
                this.addTopic((JMSTopicMBean)object);
                break;
            }
            default: {
                throw new AssertionError((Object)("ERROR: Unknown current type: " + this.currentType));
            }
        }
    }

    public void removeObject(Object object) {
        switch (this.currentType) {
            case 0: {
                this.removeQueue((JMSQueueMBean)object);
                break;
            }
            case 1: {
                this.removeTopic((JMSTopicMBean)object);
                break;
            }
            default: {
                throw new AssertionError((Object)("ERROR: Unknown current type: " + this.currentType));
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof JMSServerObserver)) {
            return false;
        }
        JMSServerObserver jMSServerObserver = (JMSServerObserver)object;
        return this.jmsServer == jMSServerObserver.jmsServer;
    }

    public int hashCode() {
        return this.jmsServer.hashCode();
    }
}

