/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.module.validators;

import java.io.File;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.ClientParamsBean;
import weblogic.j2ee.descriptor.wl.DefaultDeliveryParamsBean;
import weblogic.j2ee.descriptor.wl.DeliveryFailureParamsBean;
import weblogic.j2ee.descriptor.wl.DeliveryParamsOverridesBean;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.DestinationKeyBean;
import weblogic.j2ee.descriptor.wl.DistributedDestinationBean;
import weblogic.j2ee.descriptor.wl.DistributedDestinationMemberBean;
import weblogic.j2ee.descriptor.wl.DistributedQueueBean;
import weblogic.j2ee.descriptor.wl.DistributedTopicBean;
import weblogic.j2ee.descriptor.wl.FlowControlParamsBean;
import weblogic.j2ee.descriptor.wl.ForeignConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ForeignDestinationBean;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.JMSConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.NamedEntityBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.j2ee.descriptor.wl.SAFDestinationBean;
import weblogic.j2ee.descriptor.wl.SAFErrorHandlingBean;
import weblogic.j2ee.descriptor.wl.SAFImportedDestinationsBean;
import weblogic.j2ee.descriptor.wl.SAFQueueBean;
import weblogic.j2ee.descriptor.wl.TargetableBean;
import weblogic.j2ee.descriptor.wl.TemplateBean;
import weblogic.j2ee.descriptor.wl.ThresholdParamsBean;
import weblogic.j2ee.descriptor.wl.TopicBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedDestinationBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedQueueBean;
import weblogic.j2ee.descriptor.wl.UniformDistributedTopicBean;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.deployer.DeployerConstants;
import weblogic.jms.extensions.JMSModuleHelper;
import weblogic.jms.extensions.Schedule;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.validators.JMSTextTextFormatter;
import weblogic.jms.saf.IDBeanHandler;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSInteropModuleMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSSystemResourceMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.PathServiceMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;

public class JMSModuleValidator {
    private static final String PHY_PROP = "PhysicalDestinationName";
    private static final int DQ_TYPE = 0;
    private static final int DT_TYPE = 1;
    private static final int DD_MAX_TYPE = 2;
    private static final int QUEUE_TYPE = 0;
    private static final int TOPIC_TYPE = 1;
    private static final int MAX_TYPE = 2;
    private static final String INTEROP_FILE_NAME = "interop-jms.xml";

    public static void validateJMSModule(JMSBean jMSBean) throws IllegalArgumentException {
        JMSModuleValidator.validateTemplates(jMSBean);
        JMSModuleValidator.validateDestinations(jMSBean);
        JMSModuleValidator.validateConnectionFactories(jMSBean);
        JMSModuleValidator.validateForeignServers(jMSBean);
    }

    public static void validateTemplates(JMSBean jMSBean) throws IllegalArgumentException {
        TemplateBean[] templateBeanArray = jMSBean.getTemplates();
        for (int i = 0; i < templateBeanArray.length; ++i) {
            JMSModuleValidator.validateAMEPolicy(jMSBean, (DescriptorBean)templateBeanArray[i]);
        }
    }

    private static void validateDistributedDestinations(TargetInfoMBean targetInfoMBean, BasicDeploymentMBean basicDeploymentMBean, JMSBean jMSBean) throws IllegalArgumentException {
        JMSModuleValidator.validateDistributedQueues(targetInfoMBean, basicDeploymentMBean, jMSBean);
        JMSModuleValidator.validateDistributedTopics(targetInfoMBean, basicDeploymentMBean, jMSBean);
    }

    private static SubDeploymentMBean mySub(SubDeploymentMBean[] subDeploymentMBeanArray, TargetableBean targetableBean) {
        if (targetableBean.getSubDeploymentName() != null) {
            for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
                if (!subDeploymentMBeanArray[i].getName().equals(targetableBean.getSubDeploymentName())) continue;
                return subDeploymentMBeanArray[i];
            }
        }
        return null;
    }

    private static void sameCluster(DomainMBean domainMBean, String string, Collection collection) {
        TargetMBean targetMBean = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TargetMBean targetMBean2;
            String string2;
            String string3 = string2 = (String)iterator.next();
            TargetMBean[] targetMBeanArray = null;
            if (domainMBean.lookupSAFAgent(string2) != null) {
                targetMBeanArray = domainMBean.lookupSAFAgent(string2).getTargets();
                string3 = string3 + "; 134 domain.lookupSAFAgent " + (targetMBeanArray == null);
            }
            if (targetMBeanArray == null) {
                if (domainMBean.lookupJMSServer(string2) != null) {
                    targetMBeanArray = domainMBean.lookupJMSServer(string2).getTargets();
                    string3 = string3 + "; 140 did domain.lookupJMSServer " + (targetMBeanArray == null);
                }
                if (targetMBeanArray == null) {
                    if (IDBeanHandler.hasSafTarget(string2)) {
                        string2 = IDBeanHandler.extractTargetPart(string2);
                        string3 = string3 + "; 146 replace targetName " + string2;
                    }
                    if ((targetMBean2 = domainMBean.lookupServer(string2)) == null) {
                        targetMBean2 = domainMBean.lookupMigratableTarget(string2);
                    }
                    targetMBeanArray = new TargetMBean[]{targetMBean2};
                    string3 = string3 + "; 151 replace lookupServer " + (targetMBean2 == null);
                }
            }
            targetMBean2 = null;
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                if (targetMBeanArray[i] instanceof ServerMBean) {
                    targetMBean2 = ((ServerMBean)targetMBeanArray[i]).getCluster();
                } else if (targetMBeanArray[i] instanceof MigratableTargetMBean) {
                    targetMBean2 = ((MigratableTargetMBean)targetMBeanArray[i]).getCluster();
                } else if (targetMBeanArray[i] instanceof ClusterMBean) {
                    targetMBean2 = (ClusterMBean)targetMBeanArray[i];
                } else {
                    throw new AssertionError((Object)("Nonsensical target " + targetMBeanArray[i] + " details " + string3 + (targetMBeanArray[i] == null ? "; null " + i : "; [" + i + "] type " + targetMBeanArray[i].getClass().getName())));
                }
                if (targetMBean == null) {
                    targetMBean = targetMBean2;
                    continue;
                }
                if (targetMBean == targetMBean2) continue;
                throw new IllegalArgumentException(string + " may only be targeted to one cluster");
            }
        }
    }

    private static void validateImportedDestinationGroups(SubDeploymentMBean[] subDeploymentMBeanArray, BasicDeploymentMBean basicDeploymentMBean, JMSBean jMSBean) throws IllegalArgumentException {
        SAFImportedDestinationsBean[] sAFImportedDestinationsBeanArray = jMSBean.getSAFImportedDestinations();
        DomainMBean domainMBean = JMSBeanHelper.getDomain(basicDeploymentMBean);
        for (int i = 0; i < sAFImportedDestinationsBeanArray.length; ++i) {
            JMSModuleValidator.validateTargetingOptions((TargetableBean)sAFImportedDestinationsBeanArray[i]);
            SubDeploymentMBean subDeploymentMBean = JMSModuleValidator.mySub(subDeploymentMBeanArray, (TargetableBean)sAFImportedDestinationsBeanArray[i]);
            if (subDeploymentMBean == null) continue;
            TargetMBean[] targetMBeanArray = subDeploymentMBean.getTargets();
            if (targetMBeanArray != null && targetMBeanArray.length != 0) {
                for (int j = 0; j < targetMBeanArray.length; ++j) {
                    if (!(targetMBeanArray[j] instanceof ServerMBean || targetMBeanArray[j] instanceof ClusterMBean || targetMBeanArray[j] instanceof SAFAgentMBean)) {
                        throw new IllegalArgumentException(JMSExceptionLogger.logIllegalTargetTypeLoggable((String)sAFImportedDestinationsBeanArray[j].getName(), (String)targetMBeanArray[j].getName(), (String)subDeploymentMBean.getName()).getMessage());
                    }
                    if (!(targetMBeanArray[j] instanceof SAFAgentMBean) || !"Receiving-only".equals(((SAFAgentMBean)targetMBeanArray[j]).getServiceType())) continue;
                    throw new IllegalArgumentException(JMSExceptionLogger.logIllegalAgentTypeLoggable((String)sAFImportedDestinationsBeanArray[j].getName(), (String)targetMBeanArray[j].getName()).getMessage());
                }
            }
            HashMap hashMap = new HashMap();
            String string = sAFImportedDestinationsBeanArray[i].getName();
            IDBeanHandler.fillWithMyTargets(string, hashMap, domainMBean, subDeploymentMBean.getTargets());
            JMSModuleValidator.sameCluster(domainMBean, string, hashMap.values());
            JMSModuleValidator.validateImportedDestinations(sAFImportedDestinationsBeanArray[i], subDeploymentMBean, jMSBean);
        }
    }

    private static void validateUniformDistributedDestinations(SubDeploymentMBean[] subDeploymentMBeanArray, BasicDeploymentMBean basicDeploymentMBean, JMSBean jMSBean) throws IllegalArgumentException {
        Object object;
        DomainMBean domainMBean = JMSBeanHelper.getDomain(basicDeploymentMBean);
        UniformDistributedQueueBean[] uniformDistributedQueueBeanArray = jMSBean.getUniformDistributedQueues();
        for (int i = 0; i < uniformDistributedQueueBeanArray.length; ++i) {
            JMSModuleValidator.validateTargetingOptions((TargetableBean)uniformDistributedQueueBeanArray[i]);
            SubDeploymentMBean subDeploymentMBean = JMSModuleValidator.mySub(subDeploymentMBeanArray, (TargetableBean)uniformDistributedQueueBeanArray[i]);
            if (subDeploymentMBean == null) continue;
            object = new HashMap();
            JMSModuleHelper.uddFillWithMyTargets(object, domainMBean, subDeploymentMBean);
            JMSModuleValidator.sameCluster(domainMBean, uniformDistributedQueueBeanArray[i].getName(), object.values());
            JMSModuleValidator.validateErrorDestination((DestinationBean)uniformDistributedQueueBeanArray[i], null, true);
        }
        UniformDistributedTopicBean[] uniformDistributedTopicBeanArray = jMSBean.getUniformDistributedTopics();
        for (int i = 0; i < uniformDistributedTopicBeanArray.length; ++i) {
            JMSModuleValidator.validateTargetingOptions((TargetableBean)uniformDistributedTopicBeanArray[i]);
            object = JMSModuleValidator.mySub(subDeploymentMBeanArray, (TargetableBean)uniformDistributedTopicBeanArray[i]);
            if (object == null) continue;
            HashMap hashMap = new HashMap();
            JMSModuleHelper.uddFillWithMyTargets(hashMap, domainMBean, (SubDeploymentMBean)object);
            JMSModuleValidator.sameCluster(domainMBean, uniformDistributedTopicBeanArray[i].getName(), hashMap.values());
            JMSModuleValidator.validateErrorDestination((DestinationBean)uniformDistributedTopicBeanArray[i], null, true);
        }
    }

    private static String getDestinationTargetName(DestinationBean destinationBean, TargetInfoMBean targetInfoMBean) {
        if (targetInfoMBean == null) {
            return null;
        }
        String string = destinationBean.getSubDeploymentName();
        SubDeploymentMBean subDeploymentMBean = null;
        subDeploymentMBean = targetInfoMBean instanceof BasicDeploymentMBean ? ((BasicDeploymentMBean)targetInfoMBean).lookupSubDeployment(string) : ((SubDeploymentMBean)targetInfoMBean).lookupSubDeployment(string);
        if (subDeploymentMBean == null) {
            return null;
        }
        TargetMBean[] targetMBeanArray = subDeploymentMBean.getTargets();
        if (targetMBeanArray.length != 1) {
            return null;
        }
        return targetMBeanArray[0].getName();
    }

    private static void validateDistributedQueues(TargetInfoMBean targetInfoMBean, BasicDeploymentMBean basicDeploymentMBean, JMSBean jMSBean) throws IllegalArgumentException {
        boolean bl = basicDeploymentMBean instanceof JMSInteropModuleMBean;
        boolean bl2 = false;
        String string = null;
        DistributedQueueBean[] distributedQueueBeanArray = jMSBean.getDistributedQueues();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < distributedQueueBeanArray.length; ++i) {
            DistributedQueueBean distributedQueueBean = distributedQueueBeanArray[i];
            DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = distributedQueueBean.getDistributedQueueMembers();
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int j = 0; j < distributedDestinationMemberBeanArray.length; ++j) {
                String string2;
                DistributedDestinationMemberBean distributedDestinationMemberBean = distributedDestinationMemberBeanArray[j];
                if (!bl && distributedDestinationMemberBean.isSet(PHY_PROP)) {
                    throw new IllegalArgumentException(JMSExceptionLogger.logUseOfInteropFieldLoggable((String)basicDeploymentMBean.getName(), (String)distributedQueueBean.getName(), (String)distributedDestinationMemberBean.getName(), (String)distributedDestinationMemberBean.getPhysicalDestinationName()).getMessage());
                }
                String string3 = distributedDestinationMemberBean.getPhysicalDestinationName();
                QueueBean queueBean = jMSBean.lookupQueue(string3);
                if (!bl ? queueBean == null : distributedDestinationMemberBean.isSet(PHY_PROP) && queueBean == null) {
                    throw new IllegalArgumentException(JMSExceptionLogger.logPhysicalDestinationNotPresentLoggable((String)basicDeploymentMBean.getName(), (String)distributedQueueBean.getName(), (String)distributedDestinationMemberBean.getName(), (String)distributedDestinationMemberBean.getPhysicalDestinationName()).getMessage());
                }
                if (queueBean != null) {
                    string2 = queueBean.getUnitOfWorkHandlingPolicy();
                    if (bl2) {
                        if (!string.equals(string2)) {
                            throw new IllegalArgumentException("DQ Member " + distributedDestinationMemberBean.getName() + " has a Unit Of Work Handling Policy which is inconsistent with other members");
                        }
                    } else {
                        string = string2;
                        bl2 = true;
                    }
                }
                if ((string2 = hashMap.put(distributedDestinationMemberBean.getName(), distributedQueueBean.getName())) != null) {
                    throw new IllegalArgumentException("DQ Member " + distributedDestinationMemberBean.getName() + " is part of both " + string2 + " and " + distributedQueueBean.getName());
                }
                String string4 = JMSModuleValidator.getDestinationTargetName((DestinationBean)queueBean, targetInfoMBean);
                if (string4 == null) continue;
                linkedList.add(string4);
            }
            DomainMBean domainMBean = JMSBeanHelper.getDomain(basicDeploymentMBean);
            JMSModuleValidator.sameCluster(domainMBean, distributedQueueBean.getName(), linkedList);
        }
    }

    private static void validateDistributedTopics(TargetInfoMBean targetInfoMBean, BasicDeploymentMBean basicDeploymentMBean, JMSBean jMSBean) throws IllegalArgumentException {
        boolean bl = basicDeploymentMBean instanceof JMSInteropModuleMBean;
        boolean bl2 = false;
        String string = null;
        DistributedTopicBean[] distributedTopicBeanArray = jMSBean.getDistributedTopics();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < distributedTopicBeanArray.length; ++i) {
            DistributedTopicBean distributedTopicBean = distributedTopicBeanArray[i];
            DistributedDestinationMemberBean[] distributedDestinationMemberBeanArray = distributedTopicBean.getDistributedTopicMembers();
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int j = 0; j < distributedDestinationMemberBeanArray.length; ++j) {
                String string2;
                DistributedDestinationMemberBean distributedDestinationMemberBean = distributedDestinationMemberBeanArray[j];
                if (!bl && distributedDestinationMemberBean.isSet(PHY_PROP)) {
                    throw new IllegalArgumentException(JMSExceptionLogger.logUseOfInteropFieldLoggable((String)basicDeploymentMBean.getName(), (String)distributedTopicBean.getName(), (String)distributedDestinationMemberBean.getName(), (String)distributedDestinationMemberBean.getPhysicalDestinationName()).getMessage());
                }
                String string3 = distributedDestinationMemberBean.getPhysicalDestinationName();
                TopicBean topicBean = jMSBean.lookupTopic(string3);
                if (!bl ? topicBean == null : distributedDestinationMemberBean.isSet(PHY_PROP) && topicBean == null) {
                    throw new IllegalArgumentException(JMSExceptionLogger.logPhysicalDestinationNotPresentLoggable((String)basicDeploymentMBean.getName(), (String)distributedTopicBean.getName(), (String)distributedDestinationMemberBean.getName(), (String)distributedDestinationMemberBean.getPhysicalDestinationName()).getMessage());
                }
                if (topicBean != null) {
                    string2 = topicBean.getUnitOfWorkHandlingPolicy();
                    if (bl2) {
                        if (!string.equals(string2)) {
                            throw new IllegalArgumentException("DQ Member " + distributedDestinationMemberBean.getName() + " has a Unit Of Work Handling Policy which is inconsistent with other members");
                        }
                    } else {
                        string = string2;
                        bl2 = true;
                    }
                }
                if ((string2 = hashMap.put(distributedDestinationMemberBean.getName(), distributedTopicBean.getName())) != null) {
                    throw new IllegalArgumentException("DT Member " + distributedDestinationMemberBean.getName() + " is part of both " + string2 + " and " + distributedTopicBean.getName());
                }
                String string4 = JMSModuleValidator.getDestinationTargetName((DestinationBean)topicBean, targetInfoMBean);
                if (string4 == null) continue;
                linkedList.add(string4);
            }
            DomainMBean domainMBean = JMSBeanHelper.getDomain(basicDeploymentMBean);
            JMSModuleValidator.sameCluster(domainMBean, distributedTopicBean.getName(), linkedList);
        }
    }

    private static void validateDestinations(JMSBean jMSBean) throws IllegalArgumentException {
        int n;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (n = 0; n < jMSBean.getQueues().length; ++n) {
            JMSModuleValidator.validateQueue(jMSBean, jMSBean.getQueues()[n], hashMap);
            if (!jMSBean.getQueues()[n].isSet("DefaultTargetingEnabled")) continue;
            throw new IllegalArgumentException(JMSExceptionLogger.logDefaultTargetingNotSupportedLoggable((String)jMSBean.getQueues()[n].getName()).getMessage());
        }
        for (n = 0; n < jMSBean.getTopics().length; ++n) {
            JMSModuleValidator.validateTopic(jMSBean, jMSBean.getTopics()[n], hashMap);
            if (!jMSBean.getTopics()[n].isSet("DefaultTargetingEnabled")) continue;
            throw new IllegalArgumentException(JMSExceptionLogger.logDefaultTargetingNotSupportedLoggable((String)jMSBean.getTopics()[n].getName()).getMessage());
        }
        for (n = 0; n < jMSBean.getUniformDistributedQueues().length; ++n) {
            JMSModuleValidator.validateQueue(jMSBean, (QueueBean)jMSBean.getUniformDistributedQueues()[n], hashMap);
        }
        for (n = 0; n < jMSBean.getUniformDistributedTopics().length; ++n) {
            JMSModuleValidator.validateTopic(jMSBean, (TopicBean)jMSBean.getUniformDistributedTopics()[n], hashMap);
        }
        for (n = 0; n < 2; ++n) {
            String string;
            DistributedQueueBean[] distributedQueueBeanArray;
            switch (n) {
                case 0: {
                    distributedQueueBeanArray = jMSBean.getDistributedQueues();
                    string = "DistributedQueue";
                    break;
                }
                case 1: {
                    distributedQueueBeanArray = jMSBean.getDistributedTopics();
                    string = "DistributedTopic";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + n);
                }
            }
            for (int i = 0; i < distributedQueueBeanArray.length; ++i) {
                DistributedQueueBean distributedQueueBean = distributedQueueBeanArray[i];
                if (hashMap.containsKey(distributedQueueBean.getName())) {
                    String string2 = distributedQueueBean.getName();
                    String string3 = (String)hashMap.get(string2);
                    throw new IllegalArgumentException("The destination " + string2 + " has a duplicate name with an entity of type " + string3);
                }
                hashMap.put(distributedQueueBean.getName(), string);
            }
        }
    }

    private static void validateQueue(JMSBean jMSBean, QueueBean queueBean, HashMap hashMap) throws IllegalArgumentException {
        if (hashMap.containsKey(queueBean.getName())) {
            String string = queueBean.getName();
            String string2 = (String)hashMap.get(string);
            throw new IllegalArgumentException("The destination " + string + " has a duplicate name with an entity of type " + string2);
        }
        hashMap.put(queueBean.getName(), "Queue");
        JMSModuleValidator.validateDestCommon(jMSBean, (DestinationBean)queueBean);
    }

    private static void validateTopic(JMSBean jMSBean, TopicBean topicBean, HashMap hashMap) throws IllegalArgumentException {
        if (hashMap.containsKey(topicBean.getName())) {
            String string = topicBean.getName();
            String string2 = (String)hashMap.get(string);
            throw new IllegalArgumentException("The destination " + string + " has a duplicate name with an entity of type " + string2);
        }
        hashMap.put(topicBean.getName(), "Topic");
        JMSModuleValidator.validateDestCommon(jMSBean, (DestinationBean)topicBean);
        JMSModuleValidator.validateMulticastAddress(topicBean.getMulticast().getMulticastAddress());
    }

    private static void validateDestCommon(JMSBean jMSBean, DestinationBean destinationBean) throws IllegalArgumentException {
        JMSModuleValidator.validateLegalOrderOfDestinationKeys(jMSBean, destinationBean);
        JMSModuleValidator.validateThresholds(destinationBean);
        JMSModuleValidator.validateQuota(destinationBean);
        JMSModuleValidator.validateDeliveryParamsOverrides(destinationBean);
        JMSModuleValidator.validateDeliveryFailureParams(jMSBean, destinationBean);
    }

    private static void validateThresholds(DestinationBean destinationBean) throws IllegalArgumentException {
        JMSModuleValidator.validBytes(destinationBean);
        JMSModuleValidator.validMessages(destinationBean);
    }

    private static void validateQuota(DestinationBean destinationBean) throws IllegalArgumentException {
        JMSModuleValidator.validBytesMaximum(destinationBean);
        JMSModuleValidator.validMessagesMaximum(destinationBean);
    }

    private static void validBytes(DestinationBean destinationBean) throws IllegalArgumentException {
        ThresholdParamsBean thresholdParamsBean = destinationBean.getThresholds();
        long l = thresholdParamsBean.getBytesLow();
        long l2 = thresholdParamsBean.getBytesHigh();
        long l3 = Long.MAX_VALUE;
        QuotaBean quotaBean = destinationBean.getQuota();
        if (quotaBean != null) {
            l3 = quotaBean.getBytesMaximum();
        }
        if (l2 == Long.MAX_VALUE || l < l2 || l3 >= l2) {
            return;
        }
        throw new IllegalArgumentException("Invalid bytes threshold parameter for destination " + destinationBean.getName() + ", bytes low=" + l + ", bytes high=" + l2 + ", bytes maximum=" + l3);
    }

    private static void validMessages(DestinationBean destinationBean) throws IllegalArgumentException {
        ThresholdParamsBean thresholdParamsBean = destinationBean.getThresholds();
        long l = thresholdParamsBean.getMessagesLow();
        long l2 = thresholdParamsBean.getMessagesHigh();
        long l3 = Long.MAX_VALUE;
        QuotaBean quotaBean = destinationBean.getQuota();
        if (quotaBean != null) {
            l3 = quotaBean.getMessagesMaximum();
        }
        if (l2 == Long.MAX_VALUE || l < l2 || l3 >= l2) {
            return;
        }
        throw new IllegalArgumentException("Invalid messages threshold for destination " + destinationBean.getName() + ", messages low=" + l + ", messages high=" + l2 + ", messages maximum=" + l3);
    }

    private static void validBytesMaximum(DestinationBean destinationBean) throws IllegalArgumentException {
        long l = Long.MAX_VALUE;
        QuotaBean quotaBean = destinationBean.getQuota();
        if (quotaBean != null) {
            l = quotaBean.getBytesMaximum();
        }
        if (l == Long.MAX_VALUE || l >= 0L && l <= Long.MAX_VALUE) {
            return;
        }
        throw new IllegalArgumentException("Invalid bytes maximum for destination " + destinationBean.getName() + ", bytes maximum=" + l);
    }

    private static void validMessagesMaximum(DestinationBean destinationBean) throws IllegalArgumentException {
        long l = Long.MAX_VALUE;
        QuotaBean quotaBean = destinationBean.getQuota();
        if (quotaBean != null) {
            l = quotaBean.getMessagesMaximum();
        }
        if (l == Long.MAX_VALUE || l >= 0L && l <= Long.MAX_VALUE) {
            return;
        }
        throw new IllegalArgumentException("Invalid messages maximum for destination " + destinationBean.getName() + ", messages maximum=" + l);
    }

    private static void validateLegalOrderOfDestinationKeys(JMSBean jMSBean, DestinationBean destinationBean) {
        int n;
        String[] stringArray = destinationBean.getDestinationKeys();
        DestinationKeyBean[] destinationKeyBeanArray = new DestinationKeyBean[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            DestinationKeyBean destinationKeyBean = jMSBean.lookupDestinationKey(stringArray[n]);
            if (destinationKeyBean == null) {
                throw new IllegalArgumentException("Destination key " + stringArray[n] + " used by destination " + destinationBean.getName() + " not found");
            }
            destinationKeyBeanArray[n] = destinationKeyBean;
        }
        if (destinationKeyBeanArray.length > 1) {
            for (n = 0; n < destinationKeyBeanArray.length - 1; ++n) {
                if (!destinationKeyBeanArray[n].getProperty().equals("JMSMessageID")) continue;
                throw new IllegalArgumentException("Invalid destination key order for destination " + destinationBean.getName() + ", JMSMessageID must be specified as last key ");
            }
        }
    }

    public static void validateDestinationKeyProperty(DestinationKeyBean destinationKeyBean) throws IllegalArgumentException {
        String string = destinationKeyBean.getProperty();
        if (string == null) {
            throw new IllegalArgumentException("Invalid property value " + string + " found for destination key " + destinationKeyBean.getName());
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid property value \"" + string + "\" found for destination key " + destinationKeyBean.getName());
        }
        if (!(!string.startsWith("JMS") || string.equals("JMSMessageID") || string.equals("JMSTimestamp") || string.equals("JMSCorrelationID") || string.equals("JMSPriority") || string.equals("JMSExpiration") || string.equals("JMSType") || string.equals("JMSRedelivered") || string.equals("JMSDeliveryTime") || string.equals("JMS_BEA_Size") || string.equals("JMS_BEA_UnitOfOrder"))) {
            throw new IllegalArgumentException("Invalid JMS Header property value " + string + " found for destination key " + destinationKeyBean.getName());
        }
    }

    public static void validateDeliveryParamsOverrides(DestinationBean destinationBean) throws IllegalArgumentException {
        JMSModuleValidator.validateTimeToDeliverOverride(destinationBean);
    }

    private static boolean isTimeToDeliverOverrideValid(String string) throws ParseException {
        if (string == null) {
            return true;
        }
        try {
            long l = Long.parseLong(string);
            return l >= -1L;
        }
        catch (NumberFormatException numberFormatException) {
            Schedule.parseSchedule(string);
            return true;
        }
    }

    public static void validateTimeToDeliverOverride(DestinationBean destinationBean) {
        DeliveryParamsOverridesBean deliveryParamsOverridesBean = destinationBean.getDeliveryParamsOverrides();
        String string = deliveryParamsOverridesBean.getTimeToDeliver();
        try {
            if (!JMSModuleValidator.isTimeToDeliverOverrideValid(string)) {
                throw new IllegalArgumentException(JMSTextTextFormatter.getInstance().getIllegalTimeToDeliverOverride());
            }
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(JMSTextTextFormatter.getInstance().getIllegalTimeToDeliverOverrideWithException(parseException.toString()));
        }
    }

    public static void validateTimeToDeliverOverride(String string) {
        try {
            if (!JMSModuleValidator.isTimeToDeliverOverrideValid(string)) {
                throw new IllegalArgumentException(JMSTextTextFormatter.getInstance().getIllegalTimeToDeliverOverride());
            }
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(JMSTextTextFormatter.getInstance().getIllegalTimeToDeliverOverrideWithException(parseException.toString()));
        }
    }

    private static void validateDeliveryFailureParams(JMSBean jMSBean, DestinationBean destinationBean) throws IllegalArgumentException {
        JMSModuleValidator.validateAMEPolicy(jMSBean, (DescriptorBean)destinationBean);
        DeliveryFailureParamsBean deliveryFailureParamsBean = destinationBean.getDeliveryFailureParams();
        if (deliveryFailureParamsBean.getExpirationPolicy().equals("Redirect") && deliveryFailureParamsBean.getErrorDestination() == null) {
            throw new IllegalArgumentException("Can not use \"Redirect\" as message expiration policy if error destination is not defined for destination " + destinationBean.getName());
        }
    }

    private static void validateErrorDestination(DestinationBean destinationBean, TargetInfoMBean targetInfoMBean, boolean bl) throws IllegalArgumentException {
        String string;
        if (targetInfoMBean == null && !bl) {
            return;
        }
        String string2 = destinationBean.getSubDeploymentName();
        String string3 = null;
        DestinationBean destinationBean2 = destinationBean.getDeliveryFailureParams().getErrorDestination();
        if (destinationBean2 == null) {
            return;
        }
        if (destinationBean2 instanceof UniformDistributedDestinationBean) {
            if (!bl) {
                throw new IllegalArgumentException("Invalid Error destination for destination " + destinationBean.getName() + ", a normal destination may not have a uniform distributed destination as an error destination");
            }
        } else if (bl) {
            throw new IllegalArgumentException("Invalid Error destination for destination " + destinationBean.getName() + ", a uniform distributed destination must have a uniform distributed destination as an error destination");
        }
        if ((string = destinationBean2.getName()).equals(destinationBean.getName())) {
            throw new IllegalArgumentException("Invalid Error destination for destination " + destinationBean.getName() + ", a destination cannot set itself as its error destination");
        }
        string3 = destinationBean2.getSubDeploymentName();
        if (string2.equals(string3)) {
            return;
        }
        if (bl) {
            throw new IllegalArgumentException("Invalid Error destination for destination " + destinationBean.getName() + ", a uniform distributed destination must have an error destination which is targeted identically to itself");
        }
        SubDeploymentMBean subDeploymentMBean = null;
        SubDeploymentMBean subDeploymentMBean2 = null;
        if (targetInfoMBean instanceof BasicDeploymentMBean) {
            subDeploymentMBean = ((BasicDeploymentMBean)targetInfoMBean).lookupSubDeployment(string3);
            subDeploymentMBean2 = ((BasicDeploymentMBean)targetInfoMBean).lookupSubDeployment(string2);
        } else {
            subDeploymentMBean = ((SubDeploymentMBean)targetInfoMBean).lookupSubDeployment(string3);
            subDeploymentMBean2 = ((SubDeploymentMBean)targetInfoMBean).lookupSubDeployment(string2);
        }
        if (subDeploymentMBean == null && subDeploymentMBean2 == null) {
            return;
        }
        if (subDeploymentMBean == null && subDeploymentMBean2 != null || subDeploymentMBean != null && subDeploymentMBean2 == null) {
            throw new IllegalArgumentException("Sub Deploymet does not exist for either error destination " + string + " or the destination " + destinationBean.getName());
        }
        TargetMBean[] targetMBeanArray = subDeploymentMBean.getTargets();
        TargetMBean[] targetMBeanArray2 = subDeploymentMBean2.getTargets();
        if (targetMBeanArray.length <= 0 && targetMBeanArray2.length <= 0) {
            return;
        }
        if (targetMBeanArray.length == 1 && targetMBeanArray2.length <= 0 || targetMBeanArray.length <= 0 && targetMBeanArray2.length == 1) {
            throw new IllegalArgumentException("The SubDeployment of either destination " + destinationBean.getName() + " or the error destination " + destinationBean.getName() + " is not currently targeted");
        }
        if (!targetMBeanArray[0].getName().equals(targetMBeanArray2[0].getName())) {
            throw new IllegalArgumentException("Error destination " + string + " must be targeted to the same JMSServer as the destination " + destinationBean.getName());
        }
    }

    private static void validateAMEPolicy(JMSBean jMSBean, DescriptorBean descriptorBean) throws IllegalArgumentException {
        DeliveryFailureParamsBean deliveryFailureParamsBean = null;
        if (descriptorBean instanceof DestinationBean || descriptorBean instanceof TemplateBean) {
            return;
        }
        if (descriptorBean instanceof DestinationBean) {
            deliveryFailureParamsBean = ((DestinationBean)descriptorBean).getDeliveryFailureParams();
        } else if (descriptorBean instanceof TemplateBean) {
            deliveryFailureParamsBean = ((TemplateBean)descriptorBean).getDeliveryFailureParams();
        }
        String string = deliveryFailureParamsBean.getExpirationPolicy();
        if (!(string == null || string.equalsIgnoreCase("Discard") && string.equalsIgnoreCase("Redirect") && string.equalsIgnoreCase("Log"))) {
            throw new IllegalArgumentException("Invalid active message expiration policy for destination " + ((NamedEntityBean)descriptorBean).getName() + ", expiration policy=" + string);
        }
        if (descriptorBean instanceof DestinationBean) {
            DestinationBean destinationBean;
            if (string != null && string.equalsIgnoreCase("Redirect") && (destinationBean = ((DestinationBean)descriptorBean).getDeliveryFailureParams().getErrorDestination()) == null) {
                throw new IllegalArgumentException("Invalid active message expiration policy for destination " + ((NamedEntityBean)descriptorBean).getName() + ", expiration policy=" + string + ", no error destination found");
            }
        } else if (descriptorBean instanceof TemplateBean) {
            DestinationBean[] destinationBeanArray;
            DestinationBean destinationBean;
            TemplateBean templateBean = (TemplateBean)descriptorBean;
            if (string != null && string.equalsIgnoreCase("Redirect") && (destinationBean = templateBean.getDeliveryFailureParams().getErrorDestination()) == null && (destinationBeanArray = JMSBeanHelper.findAllInheritedDestinations(templateBean.getName(), jMSBean)) != null) {
                for (int i = 0; i < destinationBeanArray.length; ++i) {
                    destinationBean = destinationBeanArray[i].getDeliveryFailureParams().getErrorDestination();
                    if (destinationBean != null) continue;
                    throw new IllegalArgumentException("Invalid active message expiration policy for destination " + ((NamedEntityBean)descriptorBean).getName() + ", expiration policy=" + string + ", no error destination found");
                }
            }
        }
    }

    public static void validateMulticastAddress(String string) throws IllegalArgumentException {
        if (string != null && !string.equals("")) {
            for (int i = 0; i < 4; ++i) {
                int n = string.indexOf(".");
                if (n == -1 && i < 3) {
                    throw new IllegalArgumentException(JMSTextTextFormatter.getInstance().InvalidMulticastAddress(string));
                }
                if (i == 3) {
                    n = string.length();
                }
                for (int j = 0; j < n; ++j) {
                    if (Character.isDigit(string.charAt(j))) continue;
                    throw new IllegalArgumentException(JMSTextTextFormatter.getInstance().InvalidMulticastAddress(string));
                }
                if (i >= 3) continue;
                string = string.substring(n + 1);
            }
        }
    }

    public static void validateCFJNDIName(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            return;
        }
        for (int i = 0; i < DeployerConstants.DEFAULT_FACTORY_NAMES.length; ++i) {
            if (!string.equalsIgnoreCase(DeployerConstants.DEFAULT_FACTORY_NAMES[i][1])) continue;
            throw new IllegalArgumentException(JMSTextTextFormatter.getInstance().getJMSCFJNDIConflictWithDefaultsException(string));
        }
    }

    public static void validateCFName(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            return;
        }
        for (int i = 0; i < DeployerConstants.DEFAULT_FACTORY_NAMES.length; ++i) {
            if (!string.equalsIgnoreCase(DeployerConstants.DEFAULT_FACTORY_NAMES[i][0])) continue;
            throw new IllegalArgumentException(JMSTextTextFormatter.getInstance().getJMSCFConflictWithDefaultsException(string));
        }
    }

    private static SubDeploymentMBean[] getSubDeploymentsFromTargetInfo(TargetInfoMBean targetInfoMBean) {
        if (targetInfoMBean == null) {
            return new SubDeploymentMBean[0];
        }
        if (targetInfoMBean instanceof BasicDeploymentMBean) {
            return ((BasicDeploymentMBean)targetInfoMBean).getSubDeployments();
        }
        if (targetInfoMBean instanceof SubDeploymentMBean) {
            return ((SubDeploymentMBean)targetInfoMBean).getSubDeployments();
        }
        return new SubDeploymentMBean[0];
    }

    private static boolean isTargetASubTarget(TargetMBean targetMBean, TargetMBean targetMBean2) {
        boolean bl = targetMBean instanceof ClusterMBean;
        ServerMBean serverMBean = null;
        if (targetMBean2 instanceof SAFAgentMBean) {
            SAFAgentMBean sAFAgentMBean = (SAFAgentMBean)targetMBean2;
            TargetMBean[] targetMBeanArray = sAFAgentMBean.getTargets();
            if (targetMBeanArray.length <= 0) {
                return true;
            }
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                TargetMBean targetMBean3 = targetMBeanArray[i];
                if (targetMBean3 instanceof ServerMBean) {
                    serverMBean = (ServerMBean)targetMBean3;
                    if (JMSModuleValidator.isSingleServerTargetASubTarget(bl, serverMBean, targetMBean, targetMBean2)) continue;
                    return false;
                }
                if (!(targetMBean3 instanceof ClusterMBean)) continue;
                if (!bl) {
                    return false;
                }
                if (JMSModuleValidator.isMatchingCluster(targetMBean, serverMBean)) continue;
                return false;
            }
            return true;
        }
        if (targetMBean2 instanceof JMSServerMBean) {
            JMSServerMBean jMSServerMBean = (JMSServerMBean)targetMBean2;
            TargetMBean[] targetMBeanArray = jMSServerMBean.getTargets();
            if (targetMBeanArray.length <= 0) {
                return true;
            }
            TargetMBean targetMBean4 = targetMBeanArray[0];
            if (targetMBean4 instanceof MigratableTargetMBean) {
                if (!bl) {
                    return false;
                }
                MigratableTargetMBean migratableTargetMBean = (MigratableTargetMBean)targetMBean4;
                if ((targetMBean4 = migratableTargetMBean.getCluster()) == null) {
                    return false;
                }
                return targetMBean.getName().equals(targetMBean4.getName());
            }
            if (!(targetMBean4 instanceof ServerMBean)) {
                return false;
            }
            serverMBean = (ServerMBean)targetMBean4;
        }
        return JMSModuleValidator.isSingleServerTargetASubTarget(bl, serverMBean, targetMBean, targetMBean2);
    }

    private static boolean isSingleServerTargetASubTarget(boolean bl, ServerMBean serverMBean, TargetMBean targetMBean, TargetMBean targetMBean2) {
        if (serverMBean == null && targetMBean2 instanceof ServerMBean) {
            serverMBean = (ServerMBean)targetMBean2;
        }
        if (serverMBean != null) {
            if (bl) {
                return JMSModuleValidator.isMatchingCluster(targetMBean, serverMBean);
            }
            return targetMBean.getName().equals(serverMBean.getName());
        }
        if (!bl) {
            return false;
        }
        return targetMBean.getName().equals(targetMBean2.getName());
    }

    private static boolean isMatchingCluster(TargetMBean targetMBean, ServerMBean serverMBean) {
        ClusterMBean clusterMBean = null;
        if (serverMBean != null) {
            clusterMBean = serverMBean.getCluster();
        }
        if (clusterMBean == null) {
            return false;
        }
        return targetMBean.getName().equals(clusterMBean.getName());
    }

    private static void validateTargetingHierarchy(BasicDeploymentMBean basicDeploymentMBean, TargetInfoMBean targetInfoMBean) throws IllegalArgumentException {
        if (targetInfoMBean == null) {
            return;
        }
        if (basicDeploymentMBean instanceof JMSInteropModuleMBean) {
            return;
        }
        TargetMBean[] targetMBeanArray = basicDeploymentMBean.getTargets();
        if (targetMBeanArray.length <= 0) {
            return;
        }
        SubDeploymentMBean[] subDeploymentMBeanArray = JMSModuleValidator.getSubDeploymentsFromTargetInfo(targetInfoMBean);
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<String> hashSet4 = new HashSet<String>();
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            SubDeploymentMBean subDeploymentMBean = subDeploymentMBeanArray[i];
            TargetMBean[] targetMBeanArray2 = subDeploymentMBean.getTargets();
            for (int j = 0; j < targetMBeanArray2.length; ++j) {
                Object object;
                TargetMBean targetMBean = targetMBeanArray2[j];
                if (targetMBean instanceof JMSServerMBean) {
                    if (hashSet.contains(targetMBean.getName())) continue;
                    hashSet.add(targetMBean.getName());
                } else if (targetMBean instanceof ServerMBean) {
                    if (hashSet2.contains(targetMBean.getName())) continue;
                    hashSet2.add(targetMBean.getName());
                } else if (targetMBean instanceof ClusterMBean) {
                    if (hashSet3.contains(targetMBean.getName())) continue;
                    hashSet3.add(targetMBean.getName());
                } else if (targetMBean instanceof SAFAgentMBean) {
                    if (hashSet4.contains(targetMBean.getName())) continue;
                    hashSet4.add(targetMBean.getName());
                } else {
                    throw new IllegalArgumentException(JMSExceptionLogger.logInvalidSubDeploymentTargetLoggable((String)basicDeploymentMBean.getName(), (String)targetMBean.getName(), (String)targetMBean.getClass().getName(), (String)subDeploymentMBean.getName()).getMessage());
                }
                boolean bl = false;
                TargetMBean targetMBean2 = null;
                for (int k = 0; k < targetMBeanArray.length; ++k) {
                    object = targetMBeanArray[k];
                    if (JMSModuleValidator.isTargetASubTarget((TargetMBean)object, targetMBean)) {
                        bl = true;
                        break;
                    }
                    if (targetMBean2 != null) continue;
                    targetMBean2 = object;
                }
                if (bl) continue;
                String string = targetInfoMBean instanceof SubDeploymentMBean ? JMSBeanHelper.getDecoratedName(basicDeploymentMBean.getName(), targetInfoMBean.getName()) : basicDeploymentMBean.getName();
                object = targetMBean2 == null ? "<no-targets>" : targetMBean2.getName();
                throw new IllegalArgumentException(JMSExceptionLogger.logInvalidSubTargetingLoggable((String)basicDeploymentMBean.getName(), (String)string, (String)subDeploymentMBean.getName(), (String)targetMBean.getName(), (String)object).getMessage());
            }
        }
    }

    private static void validateDeliveryMode(DestinationBean destinationBean, JMSServerMBean jMSServerMBean) {
        if (destinationBean.getDeliveryParamsOverrides().getDeliveryMode().equals("Persistent")) {
            throw new IllegalArgumentException(JMSExceptionLogger.logDeliveryModeMismatch2Loggable((String)destinationBean.getName(), (String)jMSServerMBean.getName()).getMessage());
        }
    }

    public static void validateTargeting(JMSBean jMSBean, BasicDeploymentMBean basicDeploymentMBean, TargetInfoMBean targetInfoMBean) throws IllegalArgumentException {
        int n;
        Object[] objectArray;
        Object object;
        int n2;
        TargetMBean[] targetMBeanArray;
        JMSModuleValidator.validateJMSModuleName(basicDeploymentMBean);
        JMSModuleValidator.validateAppDeploymentFileName(basicDeploymentMBean);
        if (targetInfoMBean != null) {
            JMSModuleValidator.validateTargetingHierarchy(basicDeploymentMBean, targetInfoMBean);
            targetMBeanArray = targetInfoMBean.getTargets();
            for (n2 = 0; n2 < targetMBeanArray.length; ++n2) {
                object = targetMBeanArray[n2];
                if (object instanceof ServerMBean || object instanceof ClusterMBean) continue;
                throw new IllegalArgumentException(JMSExceptionLogger.logInvalidModuleTargetLoggable((String)basicDeploymentMBean.getName(), (String)object.getName(), (String)object.getClass().getName()).getMessage());
            }
        }
        targetMBeanArray = new HashSet();
        for (n2 = 0; n2 < 2; ++n2) {
            switch (n2) {
                case 0: {
                    object = jMSBean.getQueues();
                    break;
                }
                case 1: {
                    object = jMSBean.getTopics();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown JMSServer type: " + n2));
                }
            }
            if (object == null) continue;
            for (int i = 0; i < ((QueueBean[])object).length; ++i) {
                objectArray = object[i];
                String string = objectArray.getSubDeploymentName();
                targetMBeanArray.add(string);
            }
        }
        DomainMBean domainMBean = null;
        object = null;
        DistributedTopicBean[] distributedTopicBeanArray = jMSBean.getDistributedTopics();
        objectArray = jMSBean.getDistributedQueues();
        while (true) {
            for (n = 0; n < objectArray.length; ++n) {
                if (JMSModuleValidator.hashRouting((DistributedDestinationBean)objectArray[n])) continue;
                if (domainMBean == null) {
                    domainMBean = JMSBeanHelper.getDomain(basicDeploymentMBean);
                }
                if (object == null) {
                    object = JMSModuleValidator.validatePathServicesInternal(domainMBean);
                }
                JMSModuleValidator.validatePathServiceDistributedDestination(domainMBean, (Map)object, jMSBean, (DistributedDestinationBean)objectArray[n], basicDeploymentMBean);
            }
            if (objectArray == distributedTopicBeanArray) break;
            objectArray = distributedTopicBeanArray;
        }
        if (targetInfoMBean == null) {
            return;
        }
        objectArray = JMSModuleValidator.getSubDeploymentsFromTargetInfo(targetInfoMBean);
        for (n = 0; n < objectArray.length; ++n) {
            TargetMBean[] targetMBeanArray2;
            DistributedTopicBean distributedTopicBean = objectArray[n];
            String string = distributedTopicBean.getName();
            if (!targetMBeanArray.contains(string) || (targetMBeanArray2 = distributedTopicBean.getTargets()) == null || targetMBeanArray2.length <= 0) continue;
            if (targetMBeanArray2.length > 1) {
                throw new IllegalArgumentException(JMSExceptionLogger.logInvalidDeploymentTargetLoggable((String)string, (String)basicDeploymentMBean.getName()).getMessage());
            }
            TargetMBean targetMBean = targetMBeanArray2[0];
            if (!(targetMBean instanceof JMSServerMBean)) {
                throw new IllegalArgumentException(JMSExceptionLogger.logInvalidDeploymentTargetLoggable((String)string, (String)basicDeploymentMBean.getName()).getMessage());
            }
            JMSServerMBean jMSServerMBean = (JMSServerMBean)targetMBean;
            if (jMSServerMBean.getStoreEnabled()) continue;
            QueueBean[] queueBeanArray = jMSBean.getQueues();
            for (int i = 0; i < queueBeanArray.length; ++i) {
                QueueBean queueBean = queueBeanArray[i];
                if (!queueBean.getSubDeploymentName().equals(string)) continue;
                JMSModuleValidator.validateDeliveryMode((DestinationBean)queueBean, jMSServerMBean);
            }
            TopicBean[] topicBeanArray = jMSBean.getTopics();
            for (int i = 0; i < topicBeanArray.length; ++i) {
                TopicBean topicBean = topicBeanArray[i];
                if (!topicBean.getSubDeploymentName().equals(string)) continue;
                JMSModuleValidator.validateDeliveryMode((DestinationBean)topicBean, jMSServerMBean);
            }
        }
        QueueBean[] queueBeanArray = jMSBean.getQueues();
        if (queueBeanArray != null) {
            for (int i = 0; i < queueBeanArray.length; ++i) {
                JMSModuleValidator.validateErrorDestination((DestinationBean)queueBeanArray[i], targetInfoMBean, false);
            }
        }
        TopicBean[] topicBeanArray = jMSBean.getTopics();
        if (distributedTopicBeanArray != null) {
            for (int i = 0; i < topicBeanArray.length; ++i) {
                JMSModuleValidator.validateErrorDestination((DestinationBean)topicBeanArray[i], targetInfoMBean, false);
            }
        }
        JMSModuleValidator.validateDistributedDestinations(targetInfoMBean, basicDeploymentMBean, jMSBean);
        JMSModuleValidator.validateUniformDistributedDestinations((SubDeploymentMBean[])objectArray, basicDeploymentMBean, jMSBean);
        JMSModuleValidator.validateImportedDestinationGroups((SubDeploymentMBean[])objectArray, basicDeploymentMBean, jMSBean);
    }

    public static void validateJMSSystemResource(JMSSystemResourceMBean jMSSystemResourceMBean) throws IllegalArgumentException {
        if (jMSSystemResourceMBean == null) {
            return;
        }
        JMSModuleValidator.validateJMSModuleName(jMSSystemResourceMBean);
        JMSBean jMSBean = jMSSystemResourceMBean.getJMSResource();
        if (jMSBean == null) {
            return;
        }
        JMSModuleValidator.validateJMSSystemResourceModuleDescriptorFileName(null, jMSSystemResourceMBean);
        JMSModuleValidator.validateTargeting(jMSBean, jMSSystemResourceMBean, jMSSystemResourceMBean);
        if (jMSSystemResourceMBean instanceof JMSInteropModuleMBean) {
            UniformDistributedQueueBean[] uniformDistributedQueueBeanArray = jMSBean.getUniformDistributedQueues();
            if (uniformDistributedQueueBeanArray.length > 0) {
                UniformDistributedQueueBean uniformDistributedQueueBean = uniformDistributedQueueBeanArray[0];
                throw new IllegalArgumentException(JMSExceptionLogger.logInteropUDQLoggable((String)uniformDistributedQueueBean.getName()).getMessage());
            }
            uniformDistributedQueueBeanArray = jMSBean.getUniformDistributedTopics();
            if (uniformDistributedQueueBeanArray.length > 0) {
                UniformDistributedQueueBean uniformDistributedQueueBean = uniformDistributedQueueBeanArray[0];
                throw new IllegalArgumentException(JMSExceptionLogger.logInteropUDTLoggable((String)uniformDistributedQueueBean.getName()).getMessage());
            }
            uniformDistributedQueueBeanArray = jMSBean.getSAFImportedDestinations();
            if (uniformDistributedQueueBeanArray.length > 0) {
                UniformDistributedQueueBean uniformDistributedQueueBean = uniformDistributedQueueBeanArray[0];
                throw new IllegalArgumentException(JMSExceptionLogger.logInteropSIDLoggable((String)uniformDistributedQueueBean.getName()).getMessage());
            }
            uniformDistributedQueueBeanArray = jMSBean.getSAFRemoteContexts();
            if (uniformDistributedQueueBeanArray.length > 0) {
                UniformDistributedQueueBean uniformDistributedQueueBean = uniformDistributedQueueBeanArray[0];
                throw new IllegalArgumentException(JMSExceptionLogger.logInteropSRCLoggable((String)uniformDistributedQueueBean.getName()).getMessage());
            }
            uniformDistributedQueueBeanArray = jMSBean.getSAFErrorHandlings();
            if (uniformDistributedQueueBeanArray.length > 0) {
                UniformDistributedQueueBean uniformDistributedQueueBean = uniformDistributedQueueBeanArray[0];
                throw new IllegalArgumentException(JMSExceptionLogger.logInteropSEHLoggable((String)uniformDistributedQueueBean.getName()).getMessage());
            }
        }
    }

    public static void validateEntityName(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid name: JMS resource name cannot be null or empty");
        }
        if (string.indexOf("!") != -1 || string.indexOf("#") != -1 || string.indexOf("$") != -1 || string.indexOf("%") != -1 || string.indexOf("^") != -1 || string.indexOf("&") != -1 || string.indexOf("*") != -1 || string.indexOf("(") != -1 || string.indexOf(")") != -1 || string.indexOf(",") != -1 || string.indexOf(":") != -1 || string.indexOf("?") != -1 || string.indexOf("+") != -1 || string.indexOf("=") != -1 || string.indexOf("\\") != -1) {
            throw new IllegalArgumentException("Invalid Name " + string + ", any of these characters !#$%^&*(),:?+=\\ are not allowed to be part of the name value");
        }
    }

    private static boolean hashRouting(DistributedDestinationBean distributedDestinationBean) {
        return "Hash".equals(distributedDestinationBean.getUnitOfOrderRouting());
    }

    private static void validateInteropModule(DomainMBean domainMBean) throws IllegalArgumentException {
        JMSInteropModuleMBean[] jMSInteropModuleMBeanArray = domainMBean.getJMSInteropModules();
        if (jMSInteropModuleMBeanArray.length > 1) {
            throw new IllegalArgumentException(JMSExceptionLogger.logMoreThanOneInteropModuleLoggable().getMessage());
        }
        if (jMSInteropModuleMBeanArray.length > 0) {
            if (!jMSInteropModuleMBeanArray[0].getName().equals("interop-jms")) {
                throw new IllegalArgumentException(JMSExceptionLogger.logInvalidInteropModuleLoggable((String)jMSInteropModuleMBeanArray[0].getName()).getMessage());
            }
            String string = jMSInteropModuleMBeanArray[0].getDescriptorFileName().toLowerCase(Locale.ENGLISH);
            String string2 = string.replace(File.separatorChar, '/');
            if (!string2.endsWith("jms/interop-jms.xml")) {
                throw new IllegalArgumentException(JMSExceptionLogger.logInvalidInteropModuleLoggable((String)jMSInteropModuleMBeanArray[0].getName()).getMessage());
            }
        }
    }

    private static void conflictsWithAppDeployment(DomainMBean domainMBean, String string) throws IllegalArgumentException {
        AppDeploymentMBean appDeploymentMBean = domainMBean.lookupAppDeployment(string);
        if (appDeploymentMBean == null) {
            return;
        }
        throw new IllegalArgumentException(JMSExceptionLogger.logDuplicateResourceNameLoggable((String)string).getMessage());
    }

    private static void validateJMSSystemResource(DomainMBean domainMBean) throws IllegalArgumentException {
        JMSSystemResourceMBean[] jMSSystemResourceMBeanArray = domainMBean.getJMSSystemResources();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < jMSSystemResourceMBeanArray.length; ++i) {
            JMSModuleValidator.conflictsWithAppDeployment(domainMBean, jMSSystemResourceMBeanArray[i].getName());
            JMSModuleValidator.validateJMSModuleName(jMSSystemResourceMBeanArray[i]);
            JMSModuleValidator.validateJMSSystemResourceModuleDescriptorFileName(hashMap, jMSSystemResourceMBeanArray[i]);
        }
    }

    private static void validateJMSModuleName(BasicDeploymentMBean basicDeploymentMBean) throws IllegalArgumentException {
        if (!(basicDeploymentMBean instanceof JMSInteropModuleMBean) && basicDeploymentMBean.getName().equals("interop-jms")) {
            throw new IllegalArgumentException(JMSExceptionLogger.logJMSSystemResourceModuleCannotHaveInteropJmsNameLoggable().getMessage());
        }
    }

    private static void validateAppDeploymentFileName(BasicDeploymentMBean basicDeploymentMBean) throws IllegalArgumentException {
        if (basicDeploymentMBean instanceof JMSInteropModuleMBean) {
            return;
        }
        String string = basicDeploymentMBean.getSourcePath();
        File file = new File(string);
        String string2 = file.getName();
        if (INTEROP_FILE_NAME.equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException(JMSExceptionLogger.logJMSDeploymentModuleCannotHaveInteropJmsDescriptorNameLoggable((String)basicDeploymentMBean.getName(), (String)basicDeploymentMBean.getSourcePath()).getMessage());
        }
    }

    private static void validateJMSSystemResourceModuleDescriptorFileName(HashMap hashMap, JMSSystemResourceMBean jMSSystemResourceMBean) throws IllegalArgumentException {
        if (jMSSystemResourceMBean == null) {
            return;
        }
        String string = null;
        String string2 = jMSSystemResourceMBean.getDescriptorFileName();
        File file = new File(string2);
        String string3 = file.getName();
        if (string2 != null) {
            string = string2.replace(File.separatorChar, '/');
            if (!string.toLowerCase(Locale.ENGLISH).endsWith("-jms.xml")) {
                throw new IllegalArgumentException(JMSExceptionLogger.logInvalidJMSSystemResourceModuleDescriptorFileNameLoggable((String)jMSSystemResourceMBean.getName(), (String)string2).getMessage());
            }
            if (!(jMSSystemResourceMBean instanceof JMSInteropModuleMBean) && INTEROP_FILE_NAME.equalsIgnoreCase(string3)) {
                throw new IllegalArgumentException(JMSExceptionLogger.logJMSDeploymentModuleCannotHaveInteropJmsDescriptorNameLoggable((String)jMSSystemResourceMBean.getName(), (String)jMSSystemResourceMBean.getDescriptorFileName()).getMessage());
            }
            if (hashMap != null) {
                if (string.startsWith("./")) {
                    string = string.substring(2, string.length());
                }
                if (hashMap.get(string) != null) {
                    throw new IllegalArgumentException(JMSExceptionLogger.logInvalidJMSSystemResourceModuleDescriptorFileNameLoggable((String)jMSSystemResourceMBean.getName(), (String)string2).getMessage());
                }
                hashMap.put(string, jMSSystemResourceMBean.getName());
            }
        }
    }

    public static void validateJMSDomain(DomainMBean domainMBean) throws IllegalArgumentException {
        JMSModuleValidator.validateInteropModule(domainMBean);
        JMSModuleValidator.validateJMSSystemResource(domainMBean);
        JMSModuleValidator.validatePathServicesInternal(domainMBean);
    }

    private static Map validatePathServicesInternal(DomainMBean domainMBean) throws IllegalArgumentException {
        PathServiceMBean[] pathServiceMBeanArray = domainMBean.getPathServices();
        HashMap<String, PathServiceMBean> hashMap = new HashMap<String, PathServiceMBean>();
        for (int i = 0; i < pathServiceMBeanArray.length; ++i) {
            DeploymentMBean deploymentMBean;
            TargetMBean[] targetMBeanArray = pathServiceMBeanArray[i].getTargets();
            if (targetMBeanArray.length != 1) {
                throw new IllegalArgumentException("PathService " + pathServiceMBeanArray[i].getName() + " is not targetted to a single server");
            }
            ServerMBean serverMBean = null;
            ClusterMBean clusterMBean = null;
            boolean bl = false;
            if (targetMBeanArray[0] instanceof ServerMBean) {
                serverMBean = (ServerMBean)targetMBeanArray[0];
                clusterMBean = serverMBean.getCluster();
            } else if (targetMBeanArray[0] instanceof MigratableTargetMBean) {
                bl = true;
                clusterMBean = ((MigratableTargetMBean)targetMBeanArray[0]).getCluster();
            } else {
                throw new IllegalArgumentException("PathService " + pathServiceMBeanArray[i].getName() + " is not targetted to a server, it is targetted to " + targetMBeanArray[0]);
            }
            if (bl) {
                deploymentMBean = pathServiceMBeanArray[i].getPersistentStore();
                if (deploymentMBean == null) {
                    throw new IllegalArgumentException("PathService " + pathServiceMBeanArray[i].getName() + " is targetted to Migratable Target " + targetMBeanArray[0].getName() + ", it cannot use the default persistent store." + " Please configure a custom persistent store, that is also targeted" + " to the same migratable target as PathService");
                }
                TargetMBean[] targetMBeanArray2 = deploymentMBean.getTargets();
                if (targetMBeanArray2.length != 1 || targetMBeanArray2[0] != targetMBeanArray[0]) {
                    throw new IllegalArgumentException("PathService " + pathServiceMBeanArray[i].getName() + " is targetted to Migratable Target " + targetMBeanArray[0].getName() + ", but persistent store it uses is not targeted to the migratable target as PathService");
                }
            }
            if (clusterMBean == null) {
                if (serverMBean != null) {
                    throw new IllegalArgumentException("PathService " + pathServiceMBeanArray[i].getName() + " is targetted to " + serverMBean.getName() + ", but that sever is not in a cluster");
                }
                throw new IllegalArgumentException("PathService " + pathServiceMBeanArray[i].getName() + " is not targetted to valid targets");
            }
            deploymentMBean = hashMap.put(clusterMBean.getName(), pathServiceMBeanArray[i]);
            if (deploymentMBean == null) continue;
            throw new IllegalArgumentException("Both " + deploymentMBean.getName() + " and " + pathServiceMBeanArray[i].getName() + " are targetted to cluster " + clusterMBean.getName());
        }
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    private static TargetMBean[] getDDTargets(JMSBean jMSBean, DistributedDestinationBean distributedDestinationBean, BasicDeploymentMBean basicDeploymentMBean) {
        QueueBean queueBean;
        String string;
        DistributedDestinationMemberBean distributedDestinationMemberBean;
        Object object;
        Object object2;
        LinkedList<QueueBean> linkedList = new LinkedList<QueueBean>();
        if (distributedDestinationBean instanceof DistributedQueueBean) {
            void destinationBean;
            object2 = (DistributedQueueBean)distributedDestinationBean;
            object = object2.getDistributedQueueMembers();
            boolean n = false;
            while (destinationBean < ((DistributedDestinationMemberBean[])object).length) {
                distributedDestinationMemberBean = object[destinationBean];
                string = distributedDestinationMemberBean.getPhysicalDestinationName();
                queueBean = jMSBean.lookupQueue(string);
                if (queueBean == null) {
                    throw new IllegalArgumentException("Could not find the member bean \"" + string + "\" for distributed queue \"" + distributedDestinationBean.getName() + "\"");
                }
                linkedList.add(queueBean);
                ++destinationBean;
            }
        } else {
            void var6_9;
            object2 = (DistributedTopicBean)distributedDestinationBean;
            object = object2.getDistributedTopicMembers();
            boolean targetMBeanArray = false;
            while (var6_9 < ((DistributedDestinationMemberBean[])object).length) {
                distributedDestinationMemberBean = object[var6_9];
                string = distributedDestinationMemberBean.getPhysicalDestinationName();
                queueBean = jMSBean.lookupTopic(string);
                if (queueBean == null) {
                    throw new IllegalArgumentException("Could not find the member bean \"" + string + "\" for distributed topic \"" + distributedDestinationBean.getName() + "\"");
                }
                linkedList.add(queueBean);
                ++var6_9;
            }
        }
        object2 = new LinkedList();
        for (DestinationBean destinationBean : linkedList) {
            distributedDestinationMemberBean = JMSBeanHelper.getSubDeploymentTargets(destinationBean.getSubDeploymentName(), basicDeploymentMBean);
            for (int i = 0; i < ((TargetMBean[])distributedDestinationMemberBean).length; ++i) {
                ((LinkedList)object2).add(distributedDestinationMemberBean[i]);
            }
        }
        TargetMBean[] targetMBeanArray = ((LinkedList)object2).toArray(new TargetMBean[((LinkedList)object2).size()]);
        return targetMBeanArray;
    }

    private static Map validatePathServiceDistributedDestination(DomainMBean domainMBean, Map map, JMSBean jMSBean, DistributedDestinationBean distributedDestinationBean, BasicDeploymentMBean basicDeploymentMBean) throws IllegalArgumentException {
        if (JMSModuleValidator.hashRouting(distributedDestinationBean)) {
            return map;
        }
        TargetMBean[] targetMBeanArray = JMSModuleValidator.getDDTargets(jMSBean, distributedDestinationBean, basicDeploymentMBean);
        if (targetMBeanArray.length == 0) {
            return map;
        }
        ConfigurationMBean configurationMBean = null;
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            ClusterMBean clusterMBean;
            try {
                clusterMBean = JMSModuleValidator.getClusterFromTarget(targetMBeanArray[i]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Could not extract cluster for JMSDistributedDestination " + distributedDestinationBean.getName() + " target " + targetMBeanArray[i].getName() + ".\n" + illegalArgumentException.toString());
            }
            if (clusterMBean == null) {
                throw new IllegalArgumentException("JMSDistributedDestination " + distributedDestinationBean.getName() + " is targetted to " + targetMBeanArray[i].getName() + ", but is not a cluster member");
            }
            if (configurationMBean == null) {
                configurationMBean = clusterMBean;
                continue;
            }
            if (configurationMBean == clusterMBean) continue;
            throw new IllegalArgumentException("JMSDistributedDestination " + distributedDestinationBean.getName() + " but is targetted to " + targetMBeanArray[i].getName() + ", and that is not in targetted cluster " + configurationMBean.getName());
        }
        if (map == null) {
            map = JMSModuleValidator.validatePathServicesInternal(domainMBean);
        }
        if (map.get(configurationMBean.getName()) == null) {
            throw new IllegalArgumentException("JMSDistributedDestination " + distributedDestinationBean.getName() + " is targetted to cluster " + configurationMBean.getName() + ", but that cluster does not have a PathService");
        }
        return map;
    }

    private static ClusterMBean getClusterFromTarget(TargetMBean targetMBean) throws IllegalArgumentException {
        ServerMBean serverMBean;
        if (targetMBean instanceof ClusterMBean) {
            return (ClusterMBean)targetMBean;
        }
        if (targetMBean instanceof ServerMBean) {
            return ((ServerMBean)targetMBean).getCluster();
        }
        if (targetMBean instanceof MigratableTargetMBean) {
            serverMBean = ((MigratableTargetMBean)targetMBean).getHostingServer();
        } else {
            if (targetMBean instanceof JMSServerMBean) {
                TargetMBean[] targetMBeanArray = ((JMSServerMBean)targetMBean).getTargets();
                if (targetMBeanArray.length == 0) {
                    throw new IllegalArgumentException("no targets for JMSServer " + targetMBean.getName());
                }
                ClusterMBean clusterMBean = JMSModuleValidator.getClusterFromTarget(targetMBeanArray[0]);
                for (int i = 1; i < targetMBeanArray.length; ++i) {
                    ClusterMBean clusterMBean2 = JMSModuleValidator.getClusterFromTarget(targetMBeanArray[i]);
                    if (clusterMBean == clusterMBean2) continue;
                    String string = clusterMBean == null ? null : clusterMBean.getName();
                    String string2 = targetMBeanArray[i] == null ? null : targetMBeanArray[i].getName();
                    String string3 = clusterMBean2 == null ? null : clusterMBean2.getName();
                    throw new IllegalArgumentException("First target for " + targetMBean.getName() + " is in cluster " + string + " but target " + string2 + " is in cluster " + string3);
                }
                return clusterMBean;
            }
            serverMBean = null;
        }
        if (serverMBean == null) {
            throw new IllegalArgumentException("could not find server for " + targetMBean.getName() + " the target class is " + targetMBean.getClass().getName());
        }
        return serverMBean.getCluster();
    }

    private static void validateConnectionFactories(JMSBean jMSBean) {
        JMSConnectionFactoryBean[] jMSConnectionFactoryBeanArray = jMSBean.getConnectionFactories();
        for (int i = 0; i < jMSConnectionFactoryBeanArray.length; ++i) {
            JMSConnectionFactoryBean jMSConnectionFactoryBean = jMSConnectionFactoryBeanArray[i];
            JMSModuleValidator.validateConnectionFactory(jMSConnectionFactoryBean);
        }
    }

    private static void validateConnectionFactory(JMSConnectionFactoryBean jMSConnectionFactoryBean) {
        FlowControlParamsBean flowControlParamsBean = jMSConnectionFactoryBean.getFlowControlParams();
        JMSModuleValidator.validateFlowControl(jMSConnectionFactoryBean.getName(), flowControlParamsBean);
        JMSModuleValidator.validateTargetingOptions((TargetableBean)jMSConnectionFactoryBean);
        ClientParamsBean clientParamsBean = jMSConnectionFactoryBean.getClientParams();
        JMSModuleValidator.validateClient(clientParamsBean);
        DefaultDeliveryParamsBean defaultDeliveryParamsBean = jMSConnectionFactoryBean.getDefaultDeliveryParams();
        JMSModuleValidator.validateDefaultDeliveryParams(jMSConnectionFactoryBean.getName(), defaultDeliveryParamsBean);
    }

    private static void validateDefaultDeliveryParams(String string, DefaultDeliveryParamsBean defaultDeliveryParamsBean) {
        JMSModuleValidator.validateUOOName(string, defaultDeliveryParamsBean.getDefaultUnitOfOrder());
    }

    private static void validateUOOName(String string, String string2) {
        if (string2 == null) {
            return;
        }
        if (string2.startsWith(".")) {
            if (string2.equals(".System")) {
                return;
            }
            if (string2.equals(".Standard")) {
                return;
            }
            throw new IllegalArgumentException("Illegal defaultUnitOfOrderName " + string2 + " starts with \".\" in JMSConnectionFactory " + string);
        }
        JMSModuleValidator.validateCFJNDIName(string2);
    }

    private static void validateFlowControl(String string, FlowControlParamsBean flowControlParamsBean) {
        if (flowControlParamsBean.getFlowSteps() > flowControlParamsBean.getFlowInterval()) {
            throw new IllegalArgumentException(JMSExceptionLogger.logFlowIntervalLoggable((String)string, (int)flowControlParamsBean.getFlowSteps(), (int)flowControlParamsBean.getFlowInterval()).getMessage());
        }
        if (flowControlParamsBean.getFlowMinimum() >= flowControlParamsBean.getFlowMaximum()) {
            throw new IllegalArgumentException(JMSExceptionLogger.logFlowLimitsLoggable((String)string, (int)flowControlParamsBean.getFlowMinimum(), (int)flowControlParamsBean.getFlowMaximum()).getMessage());
        }
    }

    private static void validateClient(ClientParamsBean clientParamsBean) {
        int n = clientParamsBean.getMessagesMaximum();
        if (n < -1 || n == 0) {
            throw new IllegalArgumentException(JMSTextTextFormatter.getInstance().getInvalidJMSMessagesMaximum());
        }
    }

    public static void validateSessionPoolSessionsMaximum(int n) {
        if (n < -1 || n == 0) {
            throw new IllegalArgumentException(JMSExceptionLogger.logBadSessionsMaxLoggable((int)n).getMessage());
        }
    }

    private static void validateSAFErrorDestinationTargeting(String string, SAFErrorHandlingBean sAFErrorHandlingBean, SubDeploymentMBean subDeploymentMBean) {
        if (sAFErrorHandlingBean == null) {
            return;
        }
        SAFDestinationBean sAFDestinationBean = sAFErrorHandlingBean.getSAFErrorDestination();
        if (sAFDestinationBean == null) {
            return;
        }
        SAFImportedDestinationsBean sAFImportedDestinationsBean = (SAFImportedDestinationsBean)((DescriptorBean)sAFDestinationBean).getParentBean();
        if (subDeploymentMBean.getName().equals(sAFImportedDestinationsBean.getSubDeploymentName())) {
            return;
        }
        throw new IllegalArgumentException(JMSExceptionLogger.logBadErrorDestinationLoggable((String)string, (String)sAFErrorHandlingBean.getName(), (String)sAFDestinationBean.getName()).getMessage());
    }

    private static void validateImportedDestinations(SAFImportedDestinationsBean sAFImportedDestinationsBean, SubDeploymentMBean subDeploymentMBean, JMSBean jMSBean) {
        SAFQueueBean sAFQueueBean;
        int n;
        if (sAFImportedDestinationsBean.getSAFErrorHandling() != null) {
            JMSModuleValidator.validateSAFErrorDestinationTargeting(sAFImportedDestinationsBean.getName(), JMSModuleValidator.getErrorHandlingBean(jMSBean, sAFImportedDestinationsBean.getName(), sAFImportedDestinationsBean.getSAFErrorHandling().getName()), subDeploymentMBean);
        }
        SAFQueueBean[] sAFQueueBeanArray = sAFImportedDestinationsBean.getSAFQueues();
        for (n = 0; n < sAFQueueBeanArray.length; ++n) {
            sAFQueueBean = sAFQueueBeanArray[n];
            if (sAFQueueBean.getSAFErrorHandling() == null) continue;
            JMSModuleValidator.validateSAFErrorDestinationTargeting(sAFQueueBean.getName(), JMSModuleValidator.getErrorHandlingBean(jMSBean, sAFQueueBean.getName(), sAFQueueBean.getSAFErrorHandling().getName()), subDeploymentMBean);
        }
        sAFQueueBeanArray = sAFImportedDestinationsBean.getSAFTopics();
        for (n = 0; n < sAFQueueBeanArray.length; ++n) {
            sAFQueueBean = sAFQueueBeanArray[n];
            if (sAFQueueBean.getSAFErrorHandling() == null) continue;
            JMSModuleValidator.validateSAFErrorDestinationTargeting(sAFQueueBean.getName(), JMSModuleValidator.getErrorHandlingBean(jMSBean, sAFQueueBean.getName(), sAFQueueBean.getSAFErrorHandling().getName()), subDeploymentMBean);
        }
    }

    private static SAFErrorHandlingBean getErrorHandlingBean(JMSBean jMSBean, String string, String string2) {
        if (string2 == null) {
            return null;
        }
        SAFErrorHandlingBean sAFErrorHandlingBean = jMSBean.lookupSAFErrorHandling(string2);
        if (sAFErrorHandlingBean == null) {
            throw new IllegalArgumentException(JMSExceptionLogger.logErrorHandlingNotFoundLoggable((String)string, (String)string2).getMessage());
        }
        return sAFErrorHandlingBean;
    }

    private static void validateForeignServers(JMSBean jMSBean) {
        ForeignServerBean[] foreignServerBeanArray = jMSBean.getForeignServers();
        for (int i = 0; i < foreignServerBeanArray.length; ++i) {
            ForeignServerBean foreignServerBean = foreignServerBeanArray[i];
            JMSModuleValidator.validateForeignServer(foreignServerBean);
        }
    }

    private static void validateForeignServer(ForeignServerBean foreignServerBean) {
        boolean bl = false;
        JMSModuleValidator.validateTargetingOptions((TargetableBean)foreignServerBean);
        String string = foreignServerBean.getConnectionURL();
        if (string != null && !string.trim().equals("")) {
            bl = true;
        }
        ForeignDestinationBean[] foreignDestinationBeanArray = foreignServerBean.getForeignDestinations();
        for (int i = 0; i < foreignDestinationBeanArray.length; ++i) {
            if (bl || foreignDestinationBeanArray[i].getLocalJNDIName() == null || foreignDestinationBeanArray[i].getRemoteJNDIName() == null || !foreignDestinationBeanArray[i].getLocalJNDIName().equals(foreignDestinationBeanArray[i].getRemoteJNDIName())) continue;
            throw new IllegalArgumentException(JMSExceptionLogger.logInvalidForeignServerLoggable((String)foreignServerBean.getName(), (String)foreignDestinationBeanArray[i].getName(), (String)"Foreign Destination", (String)foreignDestinationBeanArray[i].getLocalJNDIName()).getMessage());
        }
        ForeignConnectionFactoryBean[] foreignConnectionFactoryBeanArray = foreignServerBean.getForeignConnectionFactories();
        for (int i = 0; i < foreignConnectionFactoryBeanArray.length; ++i) {
            if (bl || foreignConnectionFactoryBeanArray[i].getLocalJNDIName() == null || foreignConnectionFactoryBeanArray[i].getRemoteJNDIName() == null || !foreignConnectionFactoryBeanArray[i].getLocalJNDIName().equals(foreignConnectionFactoryBeanArray[i].getRemoteJNDIName())) continue;
            throw new IllegalArgumentException(JMSExceptionLogger.logInvalidForeignServerLoggable((String)foreignServerBean.getName(), (String)foreignConnectionFactoryBeanArray[i].getName(), (String)"Foreign Connection Factory", (String)foreignConnectionFactoryBeanArray[i].getLocalJNDIName()).getMessage());
        }
    }

    private static void validateTargetingOptions(TargetableBean targetableBean) throws IllegalArgumentException {
        if (targetableBean.isDefaultTargetingEnabled() && targetableBean.isSet("SubDeploymentName")) {
            throw new IllegalArgumentException(JMSExceptionLogger.logConflictingTargetingInformationLoggable((String)targetableBean.getName()).getMessage());
        }
    }
}

