/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.multicast;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.jms.Destination;
import weblogic.jms.client.JMSSession;
import weblogic.jms.common.BufferDataInputStream;
import weblogic.jms.extensions.SequenceGapException;
import weblogic.utils.io.Chunk;

public final class JMSFragmentStash {
    private static final int INVALID_FRAGMENT_NUMBER = -1;
    private final JMSSession session;
    private long currentSeqNo;
    private int lastFragNum;
    private HashMap<Integer, Chunk> chunkMap = null;
    private int numFragmentsReceived;
    private final Destination destination;

    JMSFragmentStash(JMSSession jMSSession, long l, Destination destination) {
        this.session = jMSSession;
        this.currentSeqNo = l - 1L;
        this.destination = destination;
    }

    Chunk processFragment(long l, int n, int n2, int n3, BufferDataInputStream bufferDataInputStream, int n4) throws SequenceGapException, IOException {
        Chunk chunk;
        if (l < this.currentSeqNo) {
            return null;
        }
        if (l > this.currentSeqNo) {
            int n5 = (int)(l - this.currentSeqNo);
            if (n5 > 1) {
                this.session.onException(new SequenceGapException("Missing message(s)", this.destination, n5 - 1));
            }
            this.currentSeqNo = l;
            this.lastFragNum = -1;
            this.chunkMap = null;
            this.numFragmentsReceived = 0;
        }
        if (this.chunkMap == null || !this.chunkMap.containsKey(n3)) {
            Chunk chunk2 = Chunk.createOneSharedChunk((InputStream)bufferDataInputStream, (int)n4);
            if (n3 + n4 >= n) {
                this.lastFragNum = n2;
                if (this.lastFragNum == 0) {
                    return chunk2;
                }
            }
            if (this.chunkMap == null) {
                this.chunkMap = new HashMap();
            }
            this.chunkMap.put(n3, chunk2);
            ++this.numFragmentsReceived;
        }
        if (this.numFragmentsReceived != this.lastFragNum + 1) {
            return null;
        }
        Chunk chunk3 = chunk = this.chunkMap.remove(0);
        int n6 = chunk3.buf.length;
        while (this.numFragmentsReceived > 1) {
            chunk = chunk.next = this.chunkMap.remove(n6);
            --this.numFragmentsReceived;
        }
        return chunk3;
    }
}

