/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;
import weblogic.application.ModuleException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.SAFDestinationBean;
import weblogic.j2ee.descriptor.wl.SAFErrorHandlingBean;
import weblogic.j2ee.descriptor.wl.SAFImportedDestinationsBean;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSMessageExpirationHelper;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.JMSModuleManagedEntity;
import weblogic.jms.saf.JMSSAFManager;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.utils.BeanListenerCustomizer;
import weblogic.management.utils.GenericBeanListener;
import weblogic.messaging.Message;
import weblogic.messaging.kernel.Destination;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.RedirectionListener;
import weblogic.messaging.kernel.SendOptions;

public class ErrorHandler
implements JMSModuleManagedEntity,
BeanListenerCustomizer {
    public static final int DISCARD = 1;
    public static final int DISCARD_AND_LOG = 2;
    public static final int REDIRECT = 3;
    public static final int ALWAYS_FORWARD = 4;
    private SAFErrorHandlingBean ehBean;
    private SAFDestinationBean safErrorDestinationBean;
    private short type;
    private String name;
    private String policy;
    private String logFormat;
    private int policyAsInt = -1;
    private String fullyQualifiedName;
    private static final HashMap safErrorHandlingBeanSignatures = new HashMap();
    private GenericBeanListener safErrorHandlingBeanListener;
    private HashMap importedDestinations;
    private String safErrorDestinationNamePrefix;

    public ErrorHandler() {
    }

    public ErrorHandler(SAFErrorHandlingBean sAFErrorHandlingBean, String string, List list, String string2) throws ModuleException {
        this.ehBean = sAFErrorHandlingBean;
        this.name = sAFErrorHandlingBean.getName();
        this.fullyQualifiedName = string;
        this.type = (short)2;
        this.initialize(string2);
    }

    private void initialize(String string) throws ModuleException {
        this.policy = this.ehBean.getPolicy();
        this.policyAsInt = this.getSafErrorHandlingPolicyAsInt();
        this.logFormat = this.ehBean.getLogFormat();
        this.safErrorDestinationBean = this.ehBean.getSAFErrorDestination();
        if (this.safErrorDestinationBean != null) {
            String string2 = ((SAFImportedDestinationsBean)((DescriptorBean)this.safErrorDestinationBean).getParentBean()).getName();
            this.safErrorDestinationNamePrefix = JMSBeanHelper.getDecoratedName(string, string2);
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("ErrorHandling " + this.fullyQualifiedName + ": Policy = " + this.policy);
        }
        this.safErrorHandlingBeanListener = JMSSAFManager.initializeGenericBeanListener((DescriptorBean)this.ehBean, this, this, safErrorHandlingBeanSignatures, null);
        JMSSAFManager.manager.addErrorHandler(this.fullyQualifiedName, this);
        this.importedDestinations = new HashMap();
    }

    public short getType() {
        return this.type;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public boolean isAlwaysForward() {
        return this.policyAsInt == 4;
    }

    synchronized void removeImportedDestination(String string) {
        this.importedDestinations.remove(string);
    }

    public void prepare() {
    }

    public void activate(JMSBean jMSBean) throws ModuleException {
        this.ehBean = jMSBean.lookupSAFErrorHandling(this.getEntityName());
        this.safErrorHandlingBeanListener = JMSSAFManager.initializeGenericBeanListener((DescriptorBean)this.ehBean, this, this, safErrorHandlingBeanSignatures, null);
        if (this.safErrorHandlingBeanListener != null) {
            this.safErrorHandlingBeanListener.open();
        }
    }

    public void deactivate() {
        if (this.safErrorHandlingBeanListener != null) {
            this.safErrorHandlingBeanListener.close();
        }
    }

    public void unprepare() {
    }

    public void destroy() {
        JMSSAFManager.manager.removeErrorHandler(this.fullyQualifiedName);
    }

    public void remove() {
    }

    public String getEntityName() {
        return this.ehBean.getName();
    }

    public void setTargets(List list, DomainMBean domainMBean) {
    }

    public void prepareChangeOfTargets(List list, DomainMBean domainMBean) {
    }

    public void activateChangeOfTargets() {
    }

    public void rollbackChangeOfTargets() {
    }

    public void activateFinished() {
    }

    public String toString() {
        String string = "Policy=" + this.getPolicy();
        if (this.getType() == 3) {
            string = string + ", ErrorDestination" + this.safErrorDestinationBean.getName();
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    private int getSafErrorHandlingPolicyAsInt() {
        int n = 1;
        if (this.policy != null) {
            if ("Discard".equals(this.policy)) {
                n = 1;
            } else if ("Log".equals(this.policy)) {
                n = 2;
            } else if ("Redirect".equals(this.policy)) {
                n = 3;
            } else if ("Always-Forward".equals(this.policy)) {
                n = 4;
            }
        }
        return n;
    }

    public String getPolicy() {
        return this.policy;
    }

    public int getPolicyAsInt() {
        return this.policyAsInt;
    }

    public synchronized void setPolicy(String string) {
        this.policy = string;
        this.policyAsInt = this.getSafErrorHandlingPolicyAsInt();
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public void setLogFormat(String string) {
        this.logFormat = string;
    }

    public SAFDestinationBean getSAFErrorDestination() {
        return this.safErrorDestinationBean;
    }

    public void setSAFErrorDestination(SAFDestinationBean sAFDestinationBean) {
        this.safErrorDestinationBean = sAFDestinationBean;
    }

    void handleFailure(RedirectionListener.Info info, String string, MessageImpl messageImpl) throws KernelException, JMSException {
        switch (this.getPolicyAsInt()) {
            case 1: {
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug("Handle failure: policy = " + this.getPolicyAsInt());
                }
                return;
            }
            case 2: {
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug("Handle failure: policy = " + this.getPolicy() + " log policy = " + this.getLogFormat());
                }
                StringBuffer stringBuffer = new StringBuffer(256);
                List list = JMSMessageExpirationHelper.extractJMSHeaderAndProperty(this.getLogFormat(), stringBuffer);
                List list2 = JMSMessageExpirationHelper.convertStringToLinkedList(stringBuffer.toString());
                JMSMessageExpirationHelper.logExpiredSAFMessage(messageImpl, list, list2);
                return;
            }
            case 3: {
                if (JMSDebug.JMSSAF.isDebugEnabled()) {
                    JMSDebug.JMSSAF.debug("Handle failure: policy = " + this.getPolicy() + " Error destination = " + this.safErrorDestinationBean.getName());
                }
                BEDestinationImpl bEDestinationImpl = this.findDestination(string, this.safErrorDestinationBean.getName());
                Destination destination = bEDestinationImpl.getKernelDestination();
                if (info != null) {
                    info.setRedirectDestination(destination);
                    info.setSendOptions(this.createSendOptions(messageImpl, bEDestinationImpl));
                } else {
                    this.redirect(bEDestinationImpl, messageImpl);
                }
                return;
            }
        }
    }

    private SendOptions createSendOptions(MessageImpl messageImpl, BEDestinationImpl bEDestinationImpl) throws JMSException {
        this.overrideMessageProperties(messageImpl);
        return bEDestinationImpl.createSendOptions(0L, bEDestinationImpl.findOrCreateKernelSequence(messageImpl), messageImpl);
    }

    private BEDestinationImpl findDestination(String string, String string2) {
        String string3 = JMSBeanHelper.getDecoratedName(this.safErrorDestinationNamePrefix, string2);
        BackEnd backEnd = JMSService.getJMSService().getBEDeployer().findBackEnd(string);
        string3 = backEnd.getFullSAFDestinationName(string3);
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Finding kernel destination " + string2 + " in " + string + " fully qualified error destination name = " + string3);
        }
        BEDestinationImpl bEDestinationImpl = backEnd.findDestination(string3);
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Found kernel destination " + string2 + " in " + string + " backend = " + backEnd + " dest = " + bEDestinationImpl);
        }
        return bEDestinationImpl;
    }

    private void overrideMessageProperties(MessageImpl messageImpl) {
        messageImpl.setDeliveryTime(0L);
        messageImpl._setJMSRedeliveryLimit(-1);
        messageImpl._setJMSExpiration(0L);
        messageImpl.setSAFSequenceName(null);
        messageImpl.setSAFSeqNumber(0L);
    }

    private void redirect(BEDestinationImpl bEDestinationImpl, MessageImpl messageImpl) throws KernelException, JMSException {
        Destination destination;
        KernelRequest kernelRequest;
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Redirecting message: " + messageImpl.getJMSMessageID() + " to " + bEDestinationImpl.getName());
        }
        if ((kernelRequest = (destination = bEDestinationImpl.getKernelDestination()).send((Message)messageImpl, this.createSendOptions(messageImpl, bEDestinationImpl))) != null) {
            kernelRequest.getResult();
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Successfully redirected " + messageImpl.getJMSMessageID() + " to destination " + destination.getName());
        }
    }

    static {
        safErrorHandlingBeanSignatures.put("Policy", String.class);
        safErrorHandlingBeanSignatures.put("LogFormat", String.class);
        safErrorHandlingBeanSignatures.put("SAFErrorDestination", SAFDestinationBean.class);
    }
}

