/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ModuleException;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.MessageLoggingParamsBean;
import weblogic.j2ee.descriptor.wl.NamedEntityBean;
import weblogic.j2ee.descriptor.wl.SAFDestinationBean;
import weblogic.j2ee.descriptor.wl.SAFErrorHandlingBean;
import weblogic.j2ee.descriptor.wl.SAFImportedDestinationsBean;
import weblogic.j2ee.descriptor.wl.SAFQueueBean;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.common.EntityName;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.dd.DDConfig;
import weblogic.jms.dd.DDConstants;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDManager;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.TargetListSave;
import weblogic.jms.saf.ImportedDestination;
import weblogic.jms.saf.ImportedDestinationGroup;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.GenericBeanListener;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class IDBeanHandler
implements DDConfig,
DDConstants {
    private final String name;
    private SAFImportedDestinationsBean idGroupBean;
    private ImportedDestinationGroup idGroup;
    private SAFDestinationBean destBean;
    private ApplicationContextInternal appCtx;
    private String earModuleName;
    private DDHandler ddHandler;
    private static final HashMap targetSignatures;
    private List lotsOfListeners = new LinkedList();
    private HashMap destinations = new HashMap();
    private HashMap activeTargetedServers = new HashMap();
    private HashMap preparedTargetedServers = new HashMap();
    private LinkedList addedLocalDestinations = null;
    private LinkedList preparedForRemovalTargetedServers = new LinkedList();
    private static HashMap idBeanSignatures;
    private static HashMap messageLoggingSignatures;
    private static HashMap domainBeanSignatures;
    private String moduleName;
    private EntityName entityName;
    private String messageLoggingFormat;
    private boolean messageLoggingEnabled = false;
    private static final AuthenticatedSubject kernelId;
    private boolean reconciled = false;
    private TargetListSave savedTargets = null;
    private static final String AT_SIGN = "@";
    private static final String PERSISTENT_QOS = "weblogic.jms.saf.persistent.qos";
    static boolean TODOREMOVEDEBUG;

    IDBeanHandler(ImportedDestinationGroup importedDestinationGroup, ApplicationContext applicationContext, EntityName entityName, SAFDestinationBean sAFDestinationBean, List list, DomainMBean domainMBean) throws ModuleException {
        this.idGroup = importedDestinationGroup;
        this.idGroupBean = importedDestinationGroup.getBean();
        this.entityName = entityName;
        this.name = JMSBeanHelper.getDecoratedName(entityName.getFullyQualifiedModuleName(), JMSBeanHelper.getDecoratedName(this.idGroupBean.getName(), sAFDestinationBean.getName()));
        this.destBean = sAFDestinationBean;
        this.appCtx = (ApplicationContextInternal)applicationContext;
        this.moduleName = entityName.getFullyQualifiedModuleName();
        this.earModuleName = entityName.getEARModuleName();
        if (TODOREMOVEDEBUG || JMSDebug.JMSSAF.isDebugEnabled()) {
            IDBeanHandler.TODOREMOVEdebug("Constructing IDBeanHandler: " + this.name + ": moduleName=" + this.moduleName + " earModuleName = " + this.earModuleName + " applicationid = " + (applicationContext != null ? applicationContext.getApplicationId() : null));
        }
        this.savedTargets = new TargetListSave(list);
        if (list != null) {
            this.makeDD(domainMBean, list);
        } else {
            this.makeDD(domainMBean, null);
        }
    }

    private BasicDeploymentMBean getBasicDeployment(DomainMBean domainMBean) {
        BasicDeploymentMBean basicDeploymentMBean = null;
        basicDeploymentMBean = this.appCtx.getAppDeploymentMBean();
        if (basicDeploymentMBean != null) {
            String string = basicDeploymentMBean.getName();
            if ((basicDeploymentMBean = domainMBean.lookupAppDeployment(string)) == null) {
                throw new AssertionError((Object)"Cannot find my deployment");
            }
            return basicDeploymentMBean;
        }
        basicDeploymentMBean = this.appCtx.getSystemResourceMBean();
        if (basicDeploymentMBean == null) {
            throw new AssertionError((Object)"Cannot find my resource");
        }
        String string = basicDeploymentMBean.getName();
        return domainMBean.lookupJMSSystemResource(string);
    }

    private static void fillWithSAFAgents(String string, HashMap hashMap, DomainMBean domainMBean, ServerMBean[] serverMBeanArray) {
        if (serverMBeanArray == null) {
            return;
        }
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            IDBeanHandler.fillWithSAFAgents(string, hashMap, domainMBean, serverMBeanArray[i]);
        }
    }

    private static void checkAndAdd(String string, HashMap hashMap, String string2) {
        if (hashMap.put(string2, string2) != null) {
            throw new IllegalArgumentException("Targets of imported destination " + string + " overlap");
        }
    }

    private static boolean fillFromSAFAgentMBean(String string, HashMap hashMap, SAFAgentMBean sAFAgentMBean) {
        if (sAFAgentMBean.getServiceType().equals("Receiving-only")) {
            return false;
        }
        TargetMBean[] targetMBeanArray = sAFAgentMBean.getTargets();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (targetMBean instanceof ServerMBean || targetMBean instanceof MigratableTargetMBean) {
                IDBeanHandler.checkAndAdd(string, hashMap, IDBeanHandler.getAgentAtServerName(sAFAgentMBean.getName(), targetMBean.getName()));
                continue;
            }
            assert (targetMBean instanceof ClusterMBean);
            ServerMBean[] serverMBeanArray = ((ClusterMBean)targetMBean).getServers();
            for (int j = 0; j < serverMBeanArray.length; ++j) {
                IDBeanHandler.checkAndAdd(string, hashMap, IDBeanHandler.getAgentAtServerName(sAFAgentMBean.getName(), serverMBeanArray[j].getName()));
            }
        }
        return true;
    }

    public static String getAgentAtServerName(String string, String string2) {
        String string3 = string + AT_SIGN + string2;
        if (TODOREMOVEDEBUG) {
            IDBeanHandler.debugServerPart(string2, string3);
            IDBeanHandler.debugAgentPart(string, string3);
        }
        return string3;
    }

    private static void debugServerPart(String string, String string2) {
        if (string.contains("SendingAgent")) {
            String string3 = "PROBLEM sending agent sever wrong order, server=" + string + ", for " + string2;
            IDBeanHandler.TODOREMOVEdebugException(string3);
        } else if (string.contains(AT_SIGN)) {
            String string4 = "PROBLEM @ is unexpectedly in sever=" + string + ", for " + string2;
            IDBeanHandler.TODOREMOVEdebugException(string4);
        } else {
            IDBeanHandler.TODOREMOVEdebug("target portion of " + string2 + " is " + string);
        }
    }

    private static void TODOREMOVEdebug(String string) {
        if (TODOREMOVEDEBUG) {
            System.err.println(string);
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(string);
        }
    }

    private static void TODOREMOVEdebugException(String string) {
        if (TODOREMOVEDEBUG) {
            new Exception(string).printStackTrace();
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug(string, (Throwable)new Exception(string));
        }
    }

    private static void debugAgentPart(String string, String string2) {
        if (string.contains("D1C")) {
            String string3 = "PROBLEM sending agentPart sever wrong order, agentPart=" + string + ", for " + string2;
            IDBeanHandler.TODOREMOVEdebugException(string3);
        } else if (string.contains(AT_SIGN)) {
            String string4 = "PROBLEM @ is unexpectedly in agentPart=" + string + ", for " + string2;
            IDBeanHandler.TODOREMOVEdebugException(string4);
        } else {
            IDBeanHandler.TODOREMOVEdebug("agent bean name  portion of " + string2 + " is " + string);
        }
    }

    public static boolean hasSafTarget(String string) {
        return string.lastIndexOf(AT_SIGN) >= 0;
    }

    public static String extractTargetPart(String string) {
        String string2 = string.substring(string.lastIndexOf(AT_SIGN) + 1);
        if (TODOREMOVEDEBUG) {
            IDBeanHandler.debugServerPart(string2, string);
        }
        return string2;
    }

    private String extractAgent(String string) {
        int n = string.lastIndexOf(AT_SIGN);
        if (n < 0) {
            AssertionError assertionError = new AssertionError((Object)("SAF expected @ in " + string));
            if (TODOREMOVEDEBUG || JMSDebug.JMSSAF.isDebugEnabled()) {
                IDBeanHandler.TODOREMOVEdebugException(((Throwable)((Object)assertionError)).getMessage());
            }
            throw assertionError;
        }
        String string2 = string.substring(0, n);
        int n2 = string2.lastIndexOf(64);
        if (n2 > -1) {
            String string3 = string2.substring(n2);
            if (TODOREMOVEDEBUG || JMSDebug.JMSSAF.isDebugEnabled()) {
                String string4 = "debug changing agent=" + string2 + ", to " + string3;
                if (TODOREMOVEDEBUG) {
                    IDBeanHandler.TODOREMOVEdebugException(string4);
                } else {
                    IDBeanHandler.TODOREMOVEdebug(string4);
                }
            }
            string2 = string3;
        }
        if (TODOREMOVEDEBUG) {
            IDBeanHandler.debugAgentPart(string2, string);
        }
        return string2;
    }

    private static boolean isServerLocal(String string) {
        return ManagementService.getRuntimeAccess(kernelId) == null || ManagementService.getRuntimeAccess(kernelId).getServerName().equals(string);
    }

    private static void fillWithSAFAgents(String string, HashMap hashMap, DomainMBean domainMBean, ServerMBean serverMBean) {
        if (serverMBean == null) {
            return;
        }
        SAFAgentMBean[] sAFAgentMBeanArray = domainMBean.getSAFAgents();
        for (int i = 0; i < sAFAgentMBeanArray.length; ++i) {
            TargetMBean[] targetMBeanArray;
            if (sAFAgentMBeanArray[i].getServiceType().equals("Receiving-only") || (targetMBeanArray = sAFAgentMBeanArray[i].getTargets()) == null) continue;
            for (int j = 0; j < targetMBeanArray.length; ++j) {
                TargetMBean targetMBean = targetMBeanArray[j];
                if (targetMBean instanceof ServerMBean) {
                    if (!targetMBean.getName().equals(serverMBean.getName())) continue;
                    IDBeanHandler.checkAndAdd(string, hashMap, IDBeanHandler.getAgentAtServerName(sAFAgentMBeanArray[i].getName(), serverMBean.getName()));
                    continue;
                }
                ClusterMBean clusterMBean = serverMBean.getCluster();
                if (clusterMBean == null) continue;
                if (clusterMBean.getName().equals(targetMBean.getName()) && IDBeanHandler.isServerLocal(serverMBean.getName())) {
                    IDBeanHandler.checkAndAdd(string, hashMap, IDBeanHandler.getAgentAtServerName(sAFAgentMBeanArray[i].getName(), serverMBean.getName()));
                }
                if (!(targetMBean instanceof MigratableTargetMBean)) continue;
                ClusterMBean clusterMBean2 = ((MigratableTargetMBean)targetMBean).getCluster();
                if (!clusterMBean.getName().equals(clusterMBean2.getName()) || hashMap.get(IDBeanHandler.getAgentAtServerName(sAFAgentMBeanArray[i].getName(), targetMBean.getName())) != null) continue;
                IDBeanHandler.fillFromSAFAgentMBean(string, hashMap, sAFAgentMBeanArray[i]);
            }
        }
    }

    public static void fillWithMyTargets(String string, HashMap hashMap, DomainMBean domainMBean, TargetMBean[] targetMBeanArray) {
        if (targetMBeanArray == null) {
            return;
        }
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (targetMBean instanceof ClusterMBean) {
                ServerMBean[] serverMBeanArray = ((ClusterMBean)targetMBean).getServers();
                IDBeanHandler.fillWithSAFAgents(string, hashMap, domainMBean, serverMBeanArray);
                continue;
            }
            if (targetMBean instanceof ServerMBean) {
                IDBeanHandler.fillWithSAFAgents(string, hashMap, domainMBean, (ServerMBean)targetMBean);
                continue;
            }
            if (targetMBean instanceof SAFAgentMBean) {
                if (IDBeanHandler.fillFromSAFAgentMBean(string, hashMap, (SAFAgentMBean)targetMBean)) continue;
                throw new IllegalArgumentException("The imported destination " + string + " has been targeted to a SAF Agent that only supports receiving: " + targetMBean.getName());
            }
            throw new IllegalArgumentException("The imported destination " + string + " has been targeted to an invalid target: " + targetMBean.getName());
        }
    }

    private void fillWithMyTargets(HashMap hashMap, DomainMBean domainMBean, List list) {
        if (list != null) {
            IDBeanHandler.fillWithMyTargets(this.name, hashMap, domainMBean, list.toArray(new TargetMBean[0]));
        }
    }

    private void makeDestination(String string) throws BeanUpdateRejectedException {
        String string2 = this.extractAgent(string);
        try {
            ImportedDestination importedDestination = new ImportedDestination(this, this.idGroup, this.appCtx != null ? this.appCtx.getApplicationId() : null, new EntityName(this.entityName.getApplicationName(), this.entityName.getEARModuleName(), this.destBean.getName()), this.name, string2, this.getTimeToLiveDefault(), this.isUseSAFTimeToLiveDefault(), this.destBean instanceof SAFQueueBean ? "queue" : "topic", this.getNonPersistentQos(), this.destBean.getMessageLoggingParams().getMessageLoggingFormat(), this.destBean.getMessageLoggingParams().isMessageLoggingEnabled(), this.getPersistentQos());
            importedDestination.setRemoteJNDIName(this.destBean.getRemoteJNDIName());
            if (TODOREMOVEDEBUG || JMSDebug.JMSSAF.isDebugEnabled()) {
                IDBeanHandler.TODOREMOVEdebug("Putting " + string + " in destinations");
            }
            this.destinations.put(string, importedDestination);
        }
        catch (ModuleException moduleException) {
            throw new BeanUpdateRejectedException("Failed to create Destination", (Throwable)((Object)moduleException));
        }
    }

    public String getEntityName() {
        return this.name;
    }

    private void addMember(String string, DomainMBean domainMBean) throws BeanUpdateRejectedException {
        if (this.isTargetLocal(string)) {
            this.makeDestination(string);
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug("IDBeanHandler added Member for " + string);
            }
        }
    }

    private void removeMember(String string) {
        this.destinations.remove(string);
    }

    private void makeDD(DomainMBean domainMBean, List list) throws ModuleException {
        if (domainMBean == null) {
            domainMBean = list != null ? JMSBeanHelper.getDomain((TargetMBean)list.get(0)) : ManagementService.getRuntimeAccess(kernelId).getDomain();
        }
        this.fillWithMyTargets(this.preparedTargetedServers, domainMBean, list);
        for (String string : this.preparedTargetedServers.values()) {
            try {
                this.addMember(string, domainMBean);
            }
            catch (BeanUpdateRejectedException beanUpdateRejectedException) {
                throw new ModuleException("Could not create Uniform Distributed Destination", beanUpdateRejectedException);
            }
        }
        this.ddHandler = new DDHandler(this, false);
    }

    private boolean isTargetLocal(String string) {
        return this.isSAFAgentLocal(this.extractAgent(string));
    }

    private Iterator makeDestinationsIterator(HashMap hashMap) {
        LinkedList<ImportedDestination> linkedList = new LinkedList<ImportedDestination>();
        if (hashMap != null) {
            for (String string : hashMap.values()) {
                ImportedDestination importedDestination;
                if (TODOREMOVEDEBUG || JMSDebug.JMSSAF.isDebugEnabled()) {
                    IDBeanHandler.TODOREMOVEdebug("Trying to find " + string + " destinations");
                }
                if ((importedDestination = (ImportedDestination)this.destinations.get(string)) != null) {
                    linkedList.add(importedDestination);
                    continue;
                }
                if (!TODOREMOVEDEBUG && !JMSDebug.JMSSAF.isDebugEnabled()) continue;
                IDBeanHandler.TODOREMOVEdebug("did not find " + string + " in destinations, keys " + this.destinations.keySet());
            }
        }
        return linkedList.listIterator();
    }

    private Iterator preparedDestinationsIterator() {
        return this.makeDestinationsIterator(this.preparedTargetedServers);
    }

    private Iterator activeDestinationsIterator() {
        return this.makeDestinationsIterator(this.activeTargetedServers);
    }

    private ImportedDestination findDestination(String string) {
        return (ImportedDestination)this.destinations.get(string);
    }

    private void reregisterBeanUpdateListeners() {
        this.unregisterBeanUpdateListeners();
        this.registerBeanUpdateListeners();
    }

    public void activate(NamedEntityBean namedEntityBean) throws ModuleException {
        Object object;
        this.destBean = (SAFDestinationBean)namedEntityBean;
        Object object2 = this.preparedDestinationsIterator();
        while (object2.hasNext()) {
            object = (ImportedDestination)object2.next();
            ((ImportedDestination)object).activate();
        }
        this.reregisterBeanUpdateListeners();
        if (this.ddHandler != null) {
            this.ddHandler = DDManager.activateOrUpdate(this.ddHandler);
        }
        object2 = ManagementService.getRuntimeAccess(kernelId).getServer().getName();
        object = ManagementService.getRuntimeAccess(kernelId).getServer().getCluster();
        Iterator iterator = this.preparedTargetedServers.values().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<BEDestinationImpl> arrayList2 = new ArrayList<BEDestinationImpl>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.substring(string.lastIndexOf(AT_SIGN) + 1);
            ImportedDestination importedDestination = this.findDestination(string);
            if (object == null) {
                if (!((String)object2).equalsIgnoreCase(string2)) continue;
                arrayList.add(IDBeanHandler.getAgentAtServerName(this.name, string));
                arrayList2.add(importedDestination == null ? null : importedDestination.getManagedDestination());
                continue;
            }
            arrayList.add(IDBeanHandler.getAgentAtServerName(this.name, string));
            arrayList2.add(importedDestination == null ? null : importedDestination.getManagedDestination());
        }
        this.ddHandler.addMembers(arrayList.toArray(new String[0]), arrayList2.toArray(new BEDestinationImpl[0]));
        this.activeTargetedServers = this.preparedTargetedServers;
        this.preparedTargetedServers = new HashMap();
    }

    private void registerBeanUpdateListeners() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)this.destBean, (Object)this, (Map)idBeanSignatures, null));
        this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)this.destBean.getMessageLoggingParams(), (Object)this, (Map)messageLoggingSignatures, null));
        this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)domainMBean, (Object)this, null, domainBeanSignatures));
        SAFAgentMBean[] sAFAgentMBeanArray = domainMBean.getSAFAgents();
        for (int i = 0; i < sAFAgentMBeanArray.length; ++i) {
            this.lotsOfListeners.add(new GenericBeanListener((DescriptorBean)sAFAgentMBeanArray[i], (Object)this, null, targetSignatures));
        }
    }

    private void unregisterBeanUpdateListeners() {
        ListIterator listIterator = this.lotsOfListeners.listIterator();
        while (listIterator.hasNext()) {
            ((GenericBeanListener)listIterator.next()).close();
        }
        this.lotsOfListeners.clear();
    }

    public void deactivate() throws ModuleException {
        this.unregisterBeanUpdateListeners();
        Iterator iterator = this.activeDestinationsIterator();
        while (iterator.hasNext()) {
            ImportedDestination importedDestination = (ImportedDestination)iterator.next();
            importedDestination.deactivate();
        }
        if (this.ddHandler != null) {
            this.ddHandler.deactivate();
        }
    }

    public void destroy() throws ModuleException {
        Iterator iterator = this.activeDestinationsIterator();
        while (iterator.hasNext()) {
            ImportedDestination importedDestination = (ImportedDestination)iterator.next();
            importedDestination.destroy();
        }
    }

    private boolean isSAFAgentLocal(String string) {
        return ImportedDestinationGroup.getLocalSAFAgents().get(string) != null;
    }

    private boolean onlyRemoteNewSAFAgents(DomainMBean domainMBean) {
        HashMap hashMap = new HashMap();
        this.fillWithMyTargets(hashMap, domainMBean, this.savedTargets.restoreTargets(domainMBean));
        boolean bl = false;
        for (String string : hashMap.values()) {
            if (this.activeTargetedServers.containsKey(string)) continue;
            bl = true;
            if (!this.isSAFAgentLocal(string)) continue;
            return false;
        }
        for (String string : this.activeTargetedServers.values()) {
            if (hashMap.containsKey(string)) continue;
            bl = true;
        }
        return bl;
    }

    public void prepareUpdate(DomainMBean domainMBean, int n) throws BeanUpdateRejectedException {
        if (!this.onlyRemoteNewSAFAgents(domainMBean)) {
            return;
        }
        this.reconcileTargets(domainMBean);
    }

    public void rollbackUpdate() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        if (!this.onlyRemoteNewSAFAgents(domainMBean)) {
            return;
        }
        try {
            this.activateTargetUpdates(false);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new AssertionError((Object)"activateTargetUpdates failed");
        }
    }

    public void activateUpdate() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        if (!this.onlyRemoteNewSAFAgents(domainMBean)) {
            return;
        }
        try {
            this.activateTargetUpdates(true);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new AssertionError((Object)"activateTargetUpdates failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareChangeOfTargets(List list, DomainMBean domainMBean) throws ModuleException {
        TargetListSave targetListSave = this.savedTargets;
        this.savedTargets = new TargetListSave(list);
        if (targetListSave == null && this.savedTargets != null || targetListSave != null && this.savedTargets == null || targetListSave.size() != this.savedTargets.size()) {
            IDBeanHandler iDBeanHandler = this;
            synchronized (iDBeanHandler) {
                this.reconciled = false;
            }
        }
        if (domainMBean == null) {
            throw new AssertionError((Object)"Cannot find domain!");
        }
        try {
            this.reconcileTargets(domainMBean);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new ModuleException("Rejected targeting change", beanUpdateRejectedException);
        }
    }

    public void activateChangeOfTargets() throws ModuleException {
        try {
            this.activateTargetUpdates(true);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new ModuleException("Rejected targeting change", beanUpdateRejectedException);
        }
    }

    public void rollbackChangeOfTargets() {
        try {
            this.activateTargetUpdates(false);
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new AssertionError((Object)("Rejected targeting change" + (Object)((Object)beanUpdateRejectedException)));
        }
    }

    public void prepare() throws ModuleException {
        Iterator iterator = this.preparedDestinationsIterator();
        while (iterator.hasNext()) {
            ImportedDestination importedDestination = (ImportedDestination)iterator.next();
            importedDestination.prepare();
        }
    }

    public void remove() throws ModuleException {
        Iterator iterator = this.activeDestinationsIterator();
        while (iterator.hasNext()) {
            ImportedDestination importedDestination = (ImportedDestination)iterator.next();
            importedDestination.remove();
        }
    }

    public void unprepare() throws ModuleException {
        ImportedDestination importedDestination;
        Iterator iterator = this.preparedDestinationsIterator();
        while (iterator.hasNext()) {
            importedDestination = (ImportedDestination)iterator.next();
            importedDestination.unprepare();
        }
        iterator = this.activeDestinationsIterator();
        while (iterator.hasNext()) {
            importedDestination = (ImportedDestination)iterator.next();
            importedDestination.unprepare();
        }
    }

    public void setLocalJNDIName(String string) {
        this.ddHandler.setJNDIName(this.getJNDIName());
    }

    private void reconcileAddedLocalDestinations(HashMap hashMap, DomainMBean domainMBean) throws BeanUpdateRejectedException {
        this.addedLocalDestinations = new LinkedList();
        for (String string : hashMap.values()) {
            if (this.destinations.containsKey(string) || !this.isTargetLocal(string)) continue;
            this.addedLocalDestinations.add(string);
            this.makeDestination(string);
            ImportedDestination importedDestination = this.findDestination(string);
            try {
                importedDestination.prepare();
            }
            catch (ModuleException moduleException) {
                throw new BeanUpdateRejectedException("Cannot prepare destination; ", (Throwable)((Object)moduleException));
            }
        }
    }

    private void reconcileAddedMembers(HashMap hashMap, DomainMBean domainMBean) throws BeanUpdateRejectedException {
        this.preparedTargetedServers = new HashMap();
        for (String string : hashMap.values()) {
            if (this.activeTargetedServers.containsKey(string)) continue;
            this.addMember(string, domainMBean);
            ImportedDestination importedDestination = this.findDestination(string);
            if (importedDestination != null) {
                try {
                    importedDestination.prepare();
                }
                catch (ModuleException moduleException) {
                    throw new BeanUpdateRejectedException("Cannot prepare destination; ", (Throwable)((Object)moduleException));
                }
            }
            this.preparedTargetedServers.put(string, string);
        }
    }

    private void reconcileSubtractedMembers(HashMap hashMap) {
        this.preparedForRemovalTargetedServers = new LinkedList();
        for (String string : this.activeTargetedServers.values()) {
            if (hashMap.containsKey(string)) continue;
            this.preparedForRemovalTargetedServers.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileTargets(DomainMBean domainMBean) throws BeanUpdateRejectedException {
        HashMap hashMap = new HashMap();
        IDBeanHandler iDBeanHandler = this;
        synchronized (iDBeanHandler) {
            if (this.reconciled) {
                return;
            }
            this.reconciled = true;
        }
        this.fillWithMyTargets(hashMap, domainMBean, this.savedTargets.restoreTargets(domainMBean));
        this.reconcileAddedMembers(hashMap, domainMBean);
        this.reconcileAddedLocalDestinations(hashMap, domainMBean);
        this.reconcileSubtractedMembers(hashMap);
    }

    private void activateAddedLocalDestinations(boolean bl) throws BeanUpdateRejectedException {
        if (this.addedLocalDestinations == null) {
            return;
        }
        ListIterator listIterator = this.addedLocalDestinations.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (!bl) {
                this.destinations.remove(string);
                continue;
            }
            ImportedDestination importedDestination = this.findDestination(string);
            try {
                importedDestination.activate();
            }
            catch (ModuleException moduleException) {
                throw new BeanUpdateRejectedException("activate failed", (Throwable)((Object)moduleException));
            }
        }
        this.addedLocalDestinations = null;
    }

    private void activateAddedMembers(boolean bl) throws BeanUpdateRejectedException {
        if (this.preparedTargetedServers == null) {
            return;
        }
        for (String string : this.preparedTargetedServers.values()) {
            ImportedDestination importedDestination = this.findDestination(string);
            if (!bl) {
                this.removeMember(string);
                if (importedDestination != null) {
                    try {
                        importedDestination.unprepare();
                    }
                    catch (ModuleException moduleException) {
                        throw new AssertionError((Object)"Unprepare failed");
                    }
                }
            } else {
                if (importedDestination != null) {
                    try {
                        importedDestination.activate();
                    }
                    catch (ModuleException moduleException) {
                        throw new BeanUpdateRejectedException("activate failed", (Throwable)((Object)moduleException));
                    }
                }
                this.activeTargetedServers.put(string, string);
            }
            this.ddHandler.addMember(IDBeanHandler.getAgentAtServerName(this.name, string), importedDestination == null ? null : importedDestination.getManagedDestination());
        }
        this.preparedTargetedServers = null;
    }

    private void activateSubtractedMembers(boolean bl) throws BeanUpdateRejectedException {
        if (this.preparedForRemovalTargetedServers == null) {
            return;
        }
        ListIterator listIterator = this.preparedForRemovalTargetedServers.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (bl) {
                ImportedDestination importedDestination = this.findDestination(string);
                this.removeMember(string);
                if (importedDestination != null) {
                    try {
                        importedDestination.deactivate();
                        importedDestination.destroy();
                        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
                        if (domainMBean.lookupSAFAgent(this.extractAgent(string)) == null || domainMBean.lookupTarget(IDBeanHandler.extractTargetPart(string)) == null) {
                            importedDestination.remove();
                        } else {
                            importedDestination.unprepare();
                        }
                    }
                    catch (ModuleException moduleException) {
                        throw new BeanUpdateRejectedException("Cannot bring down member for " + string, (Throwable)((Object)moduleException));
                    }
                }
                this.activeTargetedServers.remove(string);
            }
            this.ddHandler.removeMember(IDBeanHandler.getAgentAtServerName(this.name, string));
        }
        this.preparedForRemovalTargetedServers = null;
    }

    private void activateSubtractedLocalDestinations() throws BeanUpdateRejectedException {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        Iterator iterator = this.destinations.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ImportedDestination importedDestination = this.findDestination(string);
            if (this.isTargetLocal(string)) continue;
            try {
                importedDestination.deactivate();
                importedDestination.destroy();
                if (domainMBean.lookupSAFAgent(this.extractAgent(string)) == null || domainMBean.lookupTarget(IDBeanHandler.extractTargetPart(string)) == null) {
                    importedDestination.remove();
                } else {
                    importedDestination.unprepare();
                }
            }
            catch (ModuleException moduleException) {
                throw new BeanUpdateRejectedException("destroy failed", (Throwable)((Object)moduleException));
            }
            iterator.remove();
        }
    }

    public synchronized void activateTargetUpdates(boolean bl) throws BeanUpdateRejectedException {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDBeanHandler.activatetargetUpdates: isActive?" + bl + " conciled = " + this.reconciled);
        }
        if (!this.reconciled) {
            return;
        }
        this.reconciled = false;
        this.activateAddedLocalDestinations(bl);
        this.activateAddedMembers(bl);
        this.activateSubtractedMembers(bl);
        this.activateSubtractedLocalDestinations();
    }

    public void startAny() throws BeanUpdateRejectedException {
        ListIterator listIterator = this.lotsOfListeners.listIterator();
        DomainMBean domainMBean = null;
        while (listIterator.hasNext()) {
            GenericBeanListener genericBeanListener = (GenericBeanListener)listIterator.next();
            if (genericBeanListener.getCurrentEvent() == null) continue;
            domainMBean = JMSBeanHelper.getDomain((WebLogicMBean)genericBeanListener.getCurrentEvent().getProposedBean());
        }
        assert (domainMBean != null);
        this.reconcileTargets(domainMBean);
    }

    public void finishAny(boolean bl) throws BeanUpdateRejectedException {
        this.activateTargetUpdates(bl);
        if (bl) {
            this.reregisterBeanUpdateListeners();
        }
    }

    public void startAddTargets(TargetMBean targetMBean) throws BeanUpdateRejectedException {
        this.startAny();
    }

    public void finishAddTargets(TargetMBean targetMBean, boolean bl) throws BeanUpdateRejectedException {
        this.finishAny(bl);
    }

    public void startRemoveTargets(TargetMBean targetMBean) throws BeanUpdateRejectedException {
        this.startAny();
    }

    public void finishRemoveTargets(TargetMBean targetMBean, boolean bl) throws BeanUpdateRejectedException {
        this.finishAny(bl);
    }

    public void startAddSAFAgents(SAFAgentMBean sAFAgentMBean) throws BeanUpdateRejectedException {
        this.startAny();
    }

    public void finishAddSAFAgents(SAFAgentMBean sAFAgentMBean, boolean bl) throws BeanUpdateRejectedException {
        this.finishAny(bl);
    }

    public void startRemoveSAFAgents(SAFAgentMBean sAFAgentMBean) throws BeanUpdateRejectedException {
        this.startAny();
    }

    public void finishRemoveSAFAgents(SAFAgentMBean sAFAgentMBean, boolean bl) throws BeanUpdateRejectedException {
        this.finishAny(bl);
    }

    public void startAddServers(ServerMBean serverMBean) throws BeanUpdateRejectedException {
        this.startAny();
    }

    public void finishAddServers(ServerMBean serverMBean, boolean bl) throws BeanUpdateRejectedException {
        this.finishAny(bl);
    }

    public void startRemoveServers(ServerMBean serverMBean) throws BeanUpdateRejectedException {
        this.startAny();
    }

    public void finishRemoveServers(ServerMBean serverMBean, boolean bl) throws BeanUpdateRejectedException {
        this.finishAny(bl);
    }

    public String getApplicationName() {
        if (this.appCtx != null) {
            return this.appCtx.getApplicationId();
        }
        return null;
    }

    public String getEARModuleName() {
        return this.earModuleName;
    }

    public String getReferenceName() {
        String string = null;
        string = this.destBean.getRemoteJNDIName();
        if (string != null) {
            string = string.replace('/', '.');
        }
        return this.idGroup.getRemoteSAFContextFullyQualifiedName() + "@@" + string;
    }

    public int getForwardDelay() {
        return 0;
    }

    public boolean getResetDeliveryCountOnForward() {
        return true;
    }

    public String getJNDIName() {
        String string = this.idGroupBean.getJNDIPrefix();
        if (string == null) {
            string = "";
        }
        String string2 = this.destBean.getLocalJNDIName() != null ? this.destBean.getLocalJNDIName() : this.destBean.getRemoteJNDIName();
        return string + string2;
    }

    public int getLoadBalancingPolicyAsInt() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    public String getSAFExportPolicy() {
        return null;
    }

    public int getType() {
        return this.destBean instanceof SAFQueueBean ? 0 : 1;
    }

    public String getUnitOfOrderRouting() {
        return this.destBean.getUnitOfOrderRouting();
    }

    public boolean isDefaultUnitOfOrder() {
        return false;
    }

    public void setRemoteJNDIName(String string) {
        for (ImportedDestination importedDestination : this.destinations.values()) {
            importedDestination.setRemoteJNDIName(string);
        }
    }

    public void setMessageLoggingEnabled(boolean bl) {
        for (ImportedDestination importedDestination : this.destinations.values()) {
            importedDestination.getManagedDestination().setMessageLoggingEnabled(bl);
        }
        this.messageLoggingEnabled = bl;
    }

    public boolean isMessageLoggingEnabled() {
        return this.messageLoggingEnabled;
    }

    public void setMessageLoggingFormat(String string) {
        for (ImportedDestination importedDestination : this.destinations.values()) {
            importedDestination.getManagedDestination().setMessageLoggingFormat(string);
        }
        this.messageLoggingFormat = string;
    }

    public String getMessageLoggingFormat() {
        return this.messageLoggingFormat;
    }

    public void setNonPersistentQos(String string) {
        for (ImportedDestination importedDestination : this.destinations.values()) {
            importedDestination.setNonPersistentQos(string);
        }
    }

    public String getNonPersistentQos() {
        return this.destBean.getNonPersistentQos();
    }

    public String getPersistentQos() {
        String string = "Exactly-Once";
        String string2 = System.getProperty(PERSISTENT_QOS);
        if (string2 != null) {
            if (string2.toUpperCase().equals("At-Least-Once".toUpperCase())) {
                string = "At-Least-Once";
            } else if (string2.toUpperCase().equals("At-Most-Once".toUpperCase())) {
                string = "At-Most-Once";
            }
        } else {
            string = this.destBean.getPersistentQos();
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDBeanHandler.getPersistentQos()  " + string);
        }
        return string;
    }

    public void setSAFErrorHandling(SAFErrorHandlingBean sAFErrorHandlingBean) {
        for (ImportedDestination importedDestination : this.destinations.values()) {
            if (sAFErrorHandlingBean == null) {
                importedDestination.setSAFErrorHandling(this.idGroupBean.getSAFErrorHandling());
                continue;
            }
            importedDestination.setSAFErrorHandling(sAFErrorHandlingBean);
        }
    }

    public void setTimeToLiveDefault(long l) {
        for (ImportedDestination importedDestination : this.destinations.values()) {
            importedDestination.setTimeToLiveDefault(l);
        }
    }

    public long getTimeToLiveDefault() {
        return this.destBean.getTimeToLiveDefault();
    }

    public boolean isUseSAFTimeToLiveDefault() {
        return this.destBean.isUseSAFTimeToLiveDefault();
    }

    public void setUseSAFTimeToLiveDefault(boolean bl) {
        for (ImportedDestination importedDestination : this.destinations.values()) {
            importedDestination.setUseSAFTimeToLiveDefault(bl);
        }
    }

    public void setJNDIPrefix(String string) {
        this.setLocalJNDIName(this.destBean.getLocalJNDIName());
    }

    public void remoteContextChanged() {
        for (ImportedDestination importedDestination : this.destinations.values()) {
            importedDestination.remoteContextChanged();
        }
    }

    SAFErrorHandlingBean getSafErrorHandling() {
        return this.destBean.getSAFErrorHandling();
    }

    MessageLoggingParamsBean getMessageLoggingParamsBean() {
        return this.destBean.getMessageLoggingParams();
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        idBeanSignatures = new HashMap();
        idBeanSignatures.put("RemoteJNDIName", String.class);
        idBeanSignatures.put("LocalJNDIName", String.class);
        idBeanSignatures.put("NonPersistentQos", String.class);
        idBeanSignatures.put("SAFErrorHandling", SAFErrorHandlingBean.class);
        idBeanSignatures.put("TimeToLiveDefault", Long.TYPE);
        idBeanSignatures.put("UseSAFTimeToLiveDefault", Boolean.TYPE);
        messageLoggingSignatures = new HashMap();
        messageLoggingSignatures.put("MessageLoggingFormat", String.class);
        messageLoggingSignatures.put("MessageLoggingEnabled", Boolean.TYPE);
        domainBeanSignatures = new HashMap();
        domainBeanSignatures.put("SAFAgents", SAFAgentMBean.class);
        domainBeanSignatures.put("Servers", ServerMBean.class);
        targetSignatures = new HashMap();
        targetSignatures.put("Targets", TargetMBean.class);
        TODOREMOVEDEBUG = false;
    }
}

