/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.security.AccessController;
import javax.jms.JMSException;
import weblogic.application.ModuleException;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.j2ee.descriptor.wl.SAFErrorHandlingBean;
import weblogic.j2ee.descriptor.wl.SAFImportedDestinationsBean;
import weblogic.j2ee.descriptor.wl.SAFRemoteContextBean;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.EntityName;
import weblogic.jms.forwarder.RuntimeHandler;
import weblogic.jms.saf.IDBeanHandler;
import weblogic.jms.saf.ImportedDestinationGroup;
import weblogic.jms.saf.RemoteContextAgent;
import weblogic.jms.saf.SAFAgentAdmin;
import weblogic.jms.saf.SAFQueueImpl;
import weblogic.jms.saf.SAFRemoteEndpointCustomizer;
import weblogic.jms.saf.SAFRemoteEndpointRuntimeMBeanImpl;
import weblogic.jms.saf.SAFService;
import weblogic.management.ManagementException;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.kernel.Queue;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

class ImportedDestination {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final String name;
    private final ImportedDestinationGroup idGroup;
    private final IDBeanHandler idBeanHandler;
    private SAFQueueImpl managedDestination;
    private String remoteJNDIName;
    private int nonPersistentQos = 1;
    private int persistentQos = 2;
    private SAFRemoteEndpointCustomizer runtimeMBean;
    private final SAFAgentAdmin safAgent;
    private String agentName;
    private String applicationId;
    private String earModuleName;
    private RemoteContextAgent remoteContext;
    private long timeToLiveDefault;
    private boolean useSafTimeToLiveDefault;
    private long agentTimeToLiveOverride;
    private EntityName entityName;
    private String destinationType;
    private String messageLoggingFormat;
    private boolean messageLoggingEnabled = false;

    ImportedDestination(IDBeanHandler iDBeanHandler, ImportedDestinationGroup importedDestinationGroup, String string, EntityName entityName, String string2, String string3, long l, boolean bl, String string4, String string5, String string6, boolean bl2, String string7) throws ModuleException {
        this.idGroup = importedDestinationGroup;
        this.applicationId = string;
        this.entityName = entityName;
        this.earModuleName = entityName.getEARModuleName();
        this.name = string2;
        this.agentName = string3;
        this.timeToLiveDefault = l;
        this.useSafTimeToLiveDefault = bl;
        this.safAgent = SAFService.getSAFService().getDeployer().getAgent(string3);
        this.idBeanHandler = iDBeanHandler;
        this.destinationType = string4;
        this.setNonPersistentQos(string5);
        this.setPersistentQos(string7);
        this.messageLoggingFormat = string6;
        this.messageLoggingEnabled = bl2;
    }

    public void prepare() throws ModuleException {
        this.safAgent.addImportedDestination(this);
        BackEnd backEnd = this.safAgent.getBackEnd();
        try {
            this.managedDestination = new SAFQueueImpl(this.safAgent, backEnd.getFullSAFDestinationName(this.name), false, this.entityName, this.destinationType);
        }
        catch (JMSException jMSException) {
            throw new ModuleException(jMSException);
        }
        this.agentTimeToLiveOverride = this.safAgent.getDefaultTimeToLive();
        this.applyTimeToLive();
        this.managedDestination.setPriority(-1);
        this.managedDestination.setTimeToLive(-1L);
        this.managedDestination.setRedeliveryLimit(Integer.MAX_VALUE);
        this.managedDestination.setNonPersistentQos(this.nonPersistentQos);
        this.managedDestination.setPersistentQos(this.persistentQos);
        this.managedDestination.setLocalJNDIName(this.name + "@" + this.agentName + "@SAF");
        if (this.idBeanHandler.getSafErrorHandling() == null) {
            this.managedDestination.initializeErrorHandling(null);
        } else {
            this.managedDestination.initializeErrorHandling(this.idBeanHandler.getSafErrorHandling().getName());
        }
        DestinationImpl destinationImpl = new DestinationImpl(this.managedDestination.getDestinationTypeIndicator(), backEnd.getName(), backEnd.getPersistentStore() != null ? backEnd.getPersistentStore().getName() : null, this.managedDestination.getName(), this.applicationId, this.earModuleName, backEnd.getJMSServerId(), this.managedDestination.getJMSID(), this.managedDestination.getCreationTime(), this.managedDestination.getSAFExportPolicy());
        this.managedDestination.setDestinationImpl(destinationImpl);
        try {
            this.managedDestination.setQuota(backEnd.getQuota());
        }
        catch (BeanUpdateFailedException beanUpdateFailedException) {
            throw new ModuleException(beanUpdateFailedException.getMessage(), beanUpdateFailedException);
        }
        try {
            backEnd.addDestination(this.managedDestination);
        }
        catch (JMSException jMSException) {
            throw new ModuleException("ERROR: Unable to add destination " + this.managedDestination.getName() + " to the back end " + backEnd.getName(), jMSException);
        }
        SAFImportedDestinationsBean sAFImportedDestinationsBean = this.idGroup.getBean();
        SAFRemoteContextBean sAFRemoteContextBean = sAFImportedDestinationsBean.getSAFRemoteContext();
        String string = sAFRemoteContextBean != null ? sAFRemoteContextBean.getSAFLoginContext().getLoginURL() : null;
        try {
            SAFRemoteEndpointRuntimeMBeanImpl sAFRemoteEndpointRuntimeMBeanImpl = new SAFRemoteEndpointRuntimeMBeanImpl(backEnd.getFullSAFDestinationName(this.name), string + "/" + this.remoteJNDIName, this.managedDestination, SAFService.getSAFService().getRuntimeMBean().getAgent(this.agentName).getJMSSAFAgentRuntime(), this.managedDestination.getErrorHandler());
            this.runtimeMBean = new SAFRemoteEndpointCustomizer(sAFRemoteEndpointRuntimeMBeanImpl.getName(), null, sAFRemoteEndpointRuntimeMBeanImpl);
            this.managedDestination.setSAFRuntimeMBean(sAFRemoteEndpointRuntimeMBeanImpl);
            this.safAgent.addRemoteEndpointRuntimeMBean(this.runtimeMBean);
        }
        catch (ManagementException managementException) {
            throw new ModuleException(managementException);
        }
        try {
            this.managedDestination.open();
        }
        catch (JMSException jMSException) {
            throw new ModuleException(jMSException);
        }
    }

    public void activate() throws ModuleException {
        try {
            this.managedDestination.setMessageLoggingEnabled(this.messageLoggingEnabled);
            this.managedDestination.setMessageLoggingFormat(this.messageLoggingFormat);
            this.managedDestination.start();
        }
        catch (JMSException jMSException) {
            throw new ModuleException("ERROR: Could not activate " + this.managedDestination.getName(), jMSException);
        }
        this.initializeRemoteContext();
    }

    private void initializeRemoteContext() {
        this.remoteContext = this.safAgent.findOrCreateRemoteContext(this.idGroup.getRemoteSAFContextFullyQualifiedName(), this.idGroup.getRemoteContextBean());
        this.remoteContext.addForwarder(this.managedDestination.getBackEnd().getPersistentStore(), this.managedDestination.getBackEnd().getAsyncPushWorkManager(), (RuntimeHandler)((Object)this.runtimeMBean.getDelegate()), (Queue)this.managedDestination.getKernelDestination(), this.remoteJNDIName, this.nonPersistentQos, this.persistentQos);
    }

    private void deinitializeRemoteContext() {
        if (this.remoteContext != null) {
            this.remoteContext.removeForwarder((Queue)this.managedDestination.getKernelDestination(), this.remoteJNDIName);
        }
    }

    public void deactivate() throws ModuleException {
        this.deinitializeRemoteContext();
    }

    public void unprepare() throws ModuleException {
        this.safAgent.removeImportedDestination(this);
        BackEnd backEnd = this.safAgent.getBackEnd();
        backEnd.removeDestination(this.managedDestination);
        try {
            PrivilegedActionUtilities.unregister(this.runtimeMBean, kernelId);
        }
        catch (ManagementException managementException) {
            throw new ModuleException(managementException);
        }
        this.safAgent.removeRemoteEndpointRuntimeMBean(this.runtimeMBean);
        this.runtimeMBean = null;
    }

    public void destroy() throws ModuleException {
    }

    public void remove() throws ModuleException {
        this.managedDestination.adminDeletion();
    }

    public BEDestinationImpl getManagedDestination() {
        return this.managedDestination;
    }

    public void setRemoteJNDIName(String string) {
        this.remoteJNDIName = string;
        this.remoteContextChanged();
    }

    public void setNonPersistentQos(String string) {
        if ("At-Most-Once".equals(string)) {
            this.nonPersistentQos = 1;
        } else if ("Exactly-Once".equals(string)) {
            this.nonPersistentQos = 2;
        } else if ("At-Least-Once".equals(string)) {
            this.nonPersistentQos = 3;
        } else {
            throw new IllegalArgumentException(string);
        }
        if (this.managedDestination != null) {
            this.managedDestination.setNonPersistentQos(this.nonPersistentQos);
        }
        this.remoteContextChanged();
    }

    public void setPersistentQos(String string) {
        if ("At-Most-Once".equals(string)) {
            this.persistentQos = 1;
        } else if ("Exactly-Once".equals(string)) {
            this.persistentQos = 2;
        } else if ("At-Least-Once".equals(string)) {
            this.persistentQos = 3;
        } else {
            throw new IllegalArgumentException(string);
        }
        if (this.managedDestination != null) {
            this.managedDestination.setPersistentQos(this.persistentQos);
        }
        this.remoteContextChanged();
    }

    public synchronized void setSAFErrorHandling(SAFErrorHandlingBean sAFErrorHandlingBean) {
        if (sAFErrorHandlingBean == null) {
            this.managedDestination.setSAFErrorHandlingName(null);
        } else {
            this.managedDestination.setSAFErrorHandlingName(sAFErrorHandlingBean.getName());
        }
    }

    public void setTimeToLiveDefault(long l) {
        this.timeToLiveDefault = l;
        this.applyTimeToLive();
    }

    public void setUseSAFTimeToLiveDefault(boolean bl) {
        this.useSafTimeToLiveDefault = bl;
        this.applyTimeToLive();
    }

    void setAgentTimeToLiveOverride(long l) {
        this.agentTimeToLiveOverride = l;
        this.applyTimeToLive();
    }

    private void applyTimeToLive() {
        if (this.useSafTimeToLiveDefault) {
            if (this.timeToLiveDefault == -1L) {
                this.managedDestination.setTimeToLiveDefault(this.agentTimeToLiveOverride);
            } else {
                this.managedDestination.setTimeToLiveDefault(this.timeToLiveDefault);
            }
        } else {
            this.managedDestination.setTimeToLiveDefault(-1L);
        }
    }

    public void remoteContextChanged() {
        if (this.remoteContext != null) {
            this.deinitializeRemoteContext();
            this.initializeRemoteContext();
        }
    }
}

