/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import weblogic.application.ApplicationContext;
import weblogic.application.ModuleException;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.NamedEntityBean;
import weblogic.j2ee.descriptor.wl.SAFDestinationBean;
import weblogic.j2ee.descriptor.wl.SAFImportedDestinationsBean;
import weblogic.j2ee.descriptor.wl.SAFQueueBean;
import weblogic.j2ee.descriptor.wl.SAFRemoteContextBean;
import weblogic.j2ee.descriptor.wl.SAFTopicBean;
import weblogic.jms.common.EntityName;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSTargetsListener;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.JMSModuleManagedEntity;
import weblogic.jms.saf.IDBeanHandler;
import weblogic.jms.saf.SAFService;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.utils.GenericBeanListener;

public class ImportedDestinationGroup
implements JMSModuleManagedEntity,
JMSTargetsListener {
    private final String name;
    private SAFImportedDestinationsBean idGroupBean;
    private GenericBeanListener groupBeanListener;
    private static HashMap groupBeanAddRemoveSignatures;
    private static HashMap groupBeanSignatures;
    private final Map importedDestinations = new HashMap();
    private final ApplicationContext appCtx;
    private List localTargets;
    private List preparedTargets;
    private EntityName entityName;
    private boolean defaultTargetingEnabled;
    private static Map localSAFAgents;
    private static LinkedList instances;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImportedDestinationGroup(String string, ApplicationContext applicationContext, EntityName entityName, SAFImportedDestinationsBean sAFImportedDestinationsBean, List list, DomainMBean domainMBean) throws ModuleException {
        this.name = string;
        this.idGroupBean = sAFImportedDestinationsBean;
        this.entityName = entityName;
        this.appCtx = applicationContext;
        this.localTargets = list;
        this.defaultTargetingEnabled = sAFImportedDestinationsBean.isDefaultTargetingEnabled();
        SAFQueueBean[] sAFQueueBeanArray = sAFImportedDestinationsBean.getSAFQueues();
        for (int i = 0; i < sAFQueueBeanArray.length; ++i) {
            this.importedDestinations.put(sAFQueueBeanArray[i].getName(), new IDBeanHandler(this, applicationContext, entityName, (SAFDestinationBean)sAFQueueBeanArray[i], list, domainMBean));
            LinkedList linkedList = instances;
            synchronized (linkedList) {
                instances.add(this.importedDestinations.get(sAFQueueBeanArray[i].getName()));
                continue;
            }
        }
        SAFTopicBean[] sAFTopicBeanArray = sAFImportedDestinationsBean.getSAFTopics();
        for (int i = 0; i < sAFTopicBeanArray.length; ++i) {
            this.importedDestinations.put(sAFTopicBeanArray[i].getName(), new IDBeanHandler(this, applicationContext, entityName, (SAFDestinationBean)sAFTopicBeanArray[i], list, domainMBean));
            LinkedList linkedList = instances;
            synchronized (linkedList) {
                instances.add(this.importedDestinations.get(sAFTopicBeanArray[i].getName()));
                continue;
            }
        }
    }

    String getName() {
        return this.name;
    }

    public void prepare() throws ModuleException {
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.prepare();
        }
    }

    SAFRemoteContextBean getRemoteContextBean() {
        return this.idGroupBean.getSAFRemoteContext();
    }

    String getRemoteSAFContextFullyQualifiedName() {
        SAFRemoteContextBean sAFRemoteContextBean = this.getRemoteContextBean();
        if (sAFRemoteContextBean != null) {
            return JMSBeanHelper.getDecoratedName(this.entityName.getFullyQualifiedModuleName(), sAFRemoteContextBean.getName());
        }
        return JMSBeanHelper.getDecoratedName(this.entityName.getFullyQualifiedModuleName(), "#LOCAL SERVER CONTEXT#");
    }

    SAFImportedDestinationsBean getBean() {
        return this.idGroupBean;
    }

    public void activate(JMSBean jMSBean) throws ModuleException {
        this.idGroupBean = jMSBean.lookupSAFImportedDestinations(this.getEntityName());
        this.unregisterBeanUpdateListeners();
        this.registerBeanUpdateListeners();
        SAFQueueBean[] sAFQueueBeanArray = this.idGroupBean.getSAFQueues();
        for (int i = 0; i < sAFQueueBeanArray.length; ++i) {
            IDBeanHandler iDBeanHandler = (IDBeanHandler)this.importedDestinations.get(sAFQueueBeanArray[i].getName());
            iDBeanHandler.activate((NamedEntityBean)sAFQueueBeanArray[i]);
        }
        SAFTopicBean[] sAFTopicBeanArray = this.idGroupBean.getSAFTopics();
        for (int i = 0; i < sAFTopicBeanArray.length; ++i) {
            IDBeanHandler iDBeanHandler = (IDBeanHandler)this.importedDestinations.get(sAFTopicBeanArray[i].getName());
            iDBeanHandler.activate((NamedEntityBean)sAFTopicBeanArray[i]);
        }
    }

    public void deactivate() throws ModuleException {
        this.unregisterBeanUpdateListeners();
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unprepare() throws ModuleException {
        Object object2;
        for (Object object2 : this.importedDestinations.values()) {
            ((IDBeanHandler)object2).unprepare();
        }
        this.importedDestinations.clear();
        object2 = instances;
        synchronized (object2) {
            Iterator iterator = instances.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    public void destroy() throws ModuleException {
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.destroy();
        }
    }

    public void remove() throws ModuleException {
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.remove();
        }
    }

    public String getEntityName() {
        return this.idGroupBean.getName();
    }

    public void prepareChangeOfTargets(List list, DomainMBean domainMBean) throws ModuleException {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDG.prepareChangeOfTargets: targets=" + list);
        }
        this.preparedTargets = list;
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.prepareChangeOfTargets(list, domainMBean);
        }
    }

    public void activateChangeOfTargets() throws ModuleException {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDG.activateChangeOfTargets ");
        }
        this.localTargets = this.preparedTargets;
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.activateChangeOfTargets();
        }
    }

    public void rollbackChangeOfTargets() {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDG.rollbackChangeOfTargets ");
        }
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.rollbackChangeOfTargets();
        }
    }

    public void prepareUpdate(DomainMBean domainMBean, TargetMBean targetMBean, int n, boolean bl) throws BeanUpdateRejectedException {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDG.prepareUpdate: target = " + targetMBean + " action = " + n);
        }
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.prepareUpdate(domainMBean, n);
        }
    }

    public void rollbackUpdate() {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDG.rollbackUpdate ");
        }
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.rollbackUpdate();
        }
    }

    public void activateUpdate() {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDG.activateUpdate ");
        }
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.activateUpdate();
        }
    }

    public static void prepareLocalSAFAgent(SAFAgentMBean sAFAgentMBean) throws DeploymentException {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDG.prepareLocalSAFAgent: " + sAFAgentMBean.getName());
        }
        localSAFAgents.put(sAFAgentMBean.getName(), sAFAgentMBean.getName());
        ImportedDestinationGroup.broadcastChangeToAllIDs(JMSBeanHelper.getDomain(sAFAgentMBean), true);
    }

    public static void activateLocalSAFAgent(SAFAgentMBean sAFAgentMBean) throws DeploymentException {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDG.activateLocalSAFAgent: " + sAFAgentMBean.getName());
        }
        localSAFAgents.put(sAFAgentMBean.getName(), sAFAgentMBean.getName());
        ImportedDestinationGroup.broadcastChangeToAllIDs(JMSBeanHelper.getDomain(sAFAgentMBean), true);
        ImportedDestinationGroup.broadcastChangeToAllIDs(JMSBeanHelper.getDomain(sAFAgentMBean), false);
    }

    public static void deactivateLocalSAFAgent(SAFAgentMBean sAFAgentMBean) throws UndeploymentException {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDG.deactivateLocalSAFAgent: " + sAFAgentMBean.getName());
        }
        localSAFAgents.remove(sAFAgentMBean.getName());
        try {
            ImportedDestinationGroup.broadcastChangeToAllIDs(JMSBeanHelper.getDomain(sAFAgentMBean), true);
            ImportedDestinationGroup.broadcastChangeToAllIDs(JMSBeanHelper.getDomain(sAFAgentMBean), false);
        }
        catch (DeploymentException deploymentException) {
            throw new UndeploymentException((Throwable)((Object)deploymentException));
        }
    }

    public static void unprepareLocalSAFAgent(SAFAgentMBean sAFAgentMBean) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("IDG.unprepareLocalSAFAgent: " + sAFAgentMBean.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void broadcastChangeToAllIDs(DomainMBean domainMBean, boolean bl) throws DeploymentException {
        boolean bl2 = false;
        IDBeanHandler iDBeanHandler = null;
        LinkedList linkedList = instances;
        synchronized (linkedList) {
            try {
                Iterator iterator = instances.iterator();
                while (iterator.hasNext()) {
                    iDBeanHandler = (IDBeanHandler)iterator.next();
                    try {
                        if (bl) {
                            iDBeanHandler.reconcileTargets(domainMBean);
                            continue;
                        }
                        iDBeanHandler.activateTargetUpdates(true);
                    }
                    catch (BeanUpdateRejectedException beanUpdateRejectedException) {
                        throw new DeploymentException("Rejected bean update", beanUpdateRejectedException);
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (bl2) throw throwable;
                if (!bl) throw throwable;
                ListIterator listIterator = instances.listIterator();
                while (listIterator.hasNext()) {
                    IDBeanHandler iDBeanHandler2 = (IDBeanHandler)listIterator.next();
                    if (iDBeanHandler2 == iDBeanHandler) throw throwable;
                    try {
                        iDBeanHandler2.activateTargetUpdates(false);
                    }
                    catch (BeanUpdateRejectedException beanUpdateRejectedException) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAddDest(SAFDestinationBean sAFDestinationBean) throws BeanUpdateRejectedException {
        if (sAFDestinationBean == null) {
            return;
        }
        try {
            IDBeanHandler iDBeanHandler = new IDBeanHandler(this, this.appCtx, this.entityName, sAFDestinationBean, this.localTargets, null);
            iDBeanHandler.prepare();
            this.importedDestinations.put(sAFDestinationBean.getName(), iDBeanHandler);
            LinkedList linkedList = instances;
            synchronized (linkedList) {
                instances.add(iDBeanHandler);
            }
        }
        catch (ModuleException moduleException) {
            throw new BeanUpdateRejectedException("Adding destination", (Throwable)((Object)moduleException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishAddDest(SAFDestinationBean sAFDestinationBean, boolean bl) throws BeanUpdateRejectedException {
        if (!bl) {
            IDBeanHandler iDBeanHandler = (IDBeanHandler)this.importedDestinations.remove(sAFDestinationBean.getName());
            LinkedList linkedList = instances;
            synchronized (linkedList) {
                instances.remove(iDBeanHandler);
            }
        }
        IDBeanHandler iDBeanHandler = (IDBeanHandler)this.importedDestinations.get(sAFDestinationBean.getName());
        try {
            iDBeanHandler.activate((NamedEntityBean)sAFDestinationBean);
        }
        catch (ModuleException moduleException) {
            throw new BeanUpdateRejectedException("Adding destination", (Throwable)((Object)moduleException));
        }
    }

    public void startAddSAFQueues(SAFQueueBean sAFQueueBean) throws BeanUpdateRejectedException {
        this.startAddDest((SAFDestinationBean)sAFQueueBean);
    }

    public void finishAddSAFQueues(SAFQueueBean sAFQueueBean, boolean bl) throws BeanUpdateRejectedException {
        this.finishAddDest((SAFDestinationBean)sAFQueueBean, bl);
    }

    public void startAddSAFTopics(SAFTopicBean sAFTopicBean) throws BeanUpdateRejectedException {
        this.startAddDest((SAFDestinationBean)sAFTopicBean);
    }

    public void finishAddSAFTopics(SAFTopicBean sAFTopicBean, boolean bl) throws BeanUpdateRejectedException {
        this.finishAddDest((SAFDestinationBean)sAFTopicBean, bl);
    }

    public void startRemoveDest(SAFDestinationBean sAFDestinationBean) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRemoveDest(SAFDestinationBean sAFDestinationBean, boolean bl) {
        if (!bl) {
            return;
        }
        IDBeanHandler iDBeanHandler = (IDBeanHandler)this.importedDestinations.remove(sAFDestinationBean.getName());
        LinkedList linkedList = instances;
        synchronized (linkedList) {
            instances.remove(iDBeanHandler);
        }
        try {
            iDBeanHandler.deactivate();
            iDBeanHandler.unprepare();
        }
        catch (ModuleException moduleException) {
            // empty catch block
        }
    }

    public void startRemoveSAFQueues(SAFQueueBean sAFQueueBean) {
        this.startRemoveDest((SAFDestinationBean)sAFQueueBean);
    }

    public void finishRemoveSAFQueues(SAFQueueBean sAFQueueBean, boolean bl) {
        this.finishRemoveDest((SAFDestinationBean)sAFQueueBean, bl);
    }

    public void startRemoveSAFTopics(SAFTopicBean sAFTopicBean) {
        this.startRemoveDest((SAFDestinationBean)sAFTopicBean);
    }

    public void finishRemoveSAFTopics(SAFTopicBean sAFTopicBean, boolean bl) {
        this.finishRemoveDest((SAFDestinationBean)sAFTopicBean, bl);
    }

    private void registerBeanUpdateListeners() {
        SAFService.getSAFService().getDeployer().addSAFAgentListener(this);
        this.groupBeanListener = new GenericBeanListener((DescriptorBean)this.idGroupBean, (Object)this, (Map)groupBeanSignatures, groupBeanAddRemoveSignatures);
    }

    private void unregisterBeanUpdateListeners() {
        SAFService.getSAFService().getDeployer().removeSAFAgentListener(this);
        if (this.groupBeanListener != null) {
            this.groupBeanListener.close();
            this.groupBeanListener = null;
        }
    }

    public void setJNDIPrefix(String string) {
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.setJNDIPrefix(string);
        }
    }

    public void setSAFRemoteContext(SAFRemoteContextBean sAFRemoteContextBean) {
        for (IDBeanHandler iDBeanHandler : this.importedDestinations.values()) {
            iDBeanHandler.remoteContextChanged();
        }
    }

    public void setDefaultTargetingEnabled(boolean bl) {
        this.defaultTargetingEnabled = bl;
    }

    public boolean isDefaultTargetingEnabled() {
        return this.defaultTargetingEnabled;
    }

    public static Map getLocalSAFAgents() {
        return localSAFAgents;
    }

    public Map getImportedDestinations() {
        return this.importedDestinations;
    }

    static {
        localSAFAgents = Collections.synchronizedMap(new HashMap());
        instances = new LinkedList();
        groupBeanAddRemoveSignatures = new HashMap();
        groupBeanSignatures = new HashMap();
        groupBeanAddRemoveSignatures.put("SAFQueues", SAFQueueBean.class);
        groupBeanAddRemoveSignatures.put("SAFTopics", SAFTopicBean.class);
        groupBeanSignatures.put("JNDIPrefix", String.class);
        groupBeanSignatures.put("SAFRemoteContext", SAFRemoteContextBean.class);
        groupBeanSignatures.put("DefaultTargetingEnabled", Boolean.TYPE);
    }
}

