/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import weblogic.application.ModuleException;
import weblogic.descriptor.DescriptorBean;
import weblogic.jms.saf.ErrorHandler;
import weblogic.jms.saf.RemoteContext;
import weblogic.management.ManagementException;
import weblogic.management.utils.BeanListenerCustomizer;
import weblogic.management.utils.GenericBeanListener;
import weblogic.messaging.saf.utils.Util;
import weblogic.work.WorkManager;

public final class JMSSAFManager {
    static final String JMSSAF_WM_NAME = "weblogic.jms.saf.General";
    public static JMSSAFManager manager = new JMSSAFManager();
    private Map remoteSAFContexts = Collections.synchronizedMap(new HashMap());
    private Map errorHandlers = Collections.synchronizedMap(new HashMap());
    private WorkManager workManager;

    private void initializeWorkManagers() {
        this.workManager = Util.findOrCreateWorkManager(JMSSAF_WM_NAME, -1, 0, -1);
    }

    public void addErrorHandler(String string, ErrorHandler errorHandler) {
        this.errorHandlers.put(string, errorHandler);
    }

    public ErrorHandler getErrorHandler(String string) {
        return (ErrorHandler)this.errorHandlers.get(string);
    }

    public void removeErrorHandler(String string) {
        this.errorHandlers.remove(string);
    }

    public void addRemoteSAFContext(String string, RemoteContext remoteContext) {
        this.remoteSAFContexts.put(string, remoteContext);
    }

    public RemoteContext getRemoteSAFContext(String string) {
        return (RemoteContext)this.remoteSAFContexts.get(string);
    }

    public void removeRemoteSAFContext(String string) {
        this.remoteSAFContexts.remove(string);
    }

    WorkManager getWorkManager() {
        return this.workManager;
    }

    public static GenericBeanListener initializeGenericBeanListener(DescriptorBean descriptorBean, Object object, BeanListenerCustomizer beanListenerCustomizer, HashMap hashMap, HashMap hashMap2) throws ModuleException {
        GenericBeanListener genericBeanListener = null;
        genericBeanListener = hashMap2 == null ? new GenericBeanListener(descriptorBean, object, hashMap) : new GenericBeanListener(descriptorBean, object, (Map)hashMap, hashMap2);
        if (beanListenerCustomizer != null) {
            genericBeanListener.setCustomizer(beanListenerCustomizer);
        }
        try {
            genericBeanListener.initialize();
        }
        catch (ManagementException managementException) {
            throw new ModuleException(managementException.getMessage(), managementException);
        }
        return genericBeanListener;
    }

    static {
        manager.initializeWorkManagers();
    }
}

