/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.SAFLoginContextBean;
import weblogic.j2ee.descriptor.wl.SAFRemoteContextBean;
import weblogic.jms.forwarder.Forwarder;
import weblogic.jms.forwarder.ReplyHandler;
import weblogic.jms.forwarder.RuntimeHandler;
import weblogic.jndi.ClientEnvironmentFactory;
import weblogic.management.EncryptionHelper;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.utils.GenericBeanListener;
import weblogic.messaging.kernel.Queue;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.t3.srvr.T3Srvr;
import weblogic.work.WorkManager;

public class RemoteContextAgent {
    private static final AbstractSubject kernelID = RemoteContextAgent.getKernelIdentity();
    private final String rcBeanFullyQualifiedName;
    private final SAFRemoteContextBean rcBean;
    private static final HashMap RC_ATTRIBUTES = new HashMap();
    private static final HashMap LC_ATTRIBUTES = new HashMap();
    private GenericBeanListener rcChangeListener;
    private GenericBeanListener lcChangeListener;
    Forwarder forwarder;
    ReplyHandler replyHandler;
    private boolean isInitialized;
    private static AuthenticatedSubject KERNEL_ID;
    private static RuntimeAccess runtimeAccess;
    private ServerStateChangeListener stateChangeListener;

    private static final AbstractSubject getKernelIdentity() {
        try {
            return (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    public RemoteContextAgent(String string, SAFRemoteContextBean sAFRemoteContextBean, ReplyHandler replyHandler, ClientEnvironmentFactory clientEnvironmentFactory) {
        this.rcBeanFullyQualifiedName = string;
        this.rcBean = sAFRemoteContextBean;
        this.replyHandler = replyHandler;
        this.forwarder = new Forwarder(sAFRemoteContextBean == null, this.replyHandler, clientEnvironmentFactory);
        this.initializeListeners();
        if (T3Srvr.getT3Srvr().getRunState() == 2) {
            this.forwarder.start();
        } else {
            this.stateChangeListener = new ServerStateChangeListener();
            runtimeAccess.getServerRuntime().addPropertyChangeListener(this.stateChangeListener);
        }
    }

    private void initializeListeners() {
        if (this.rcBean == null) {
            this.isInitialized = true;
            return;
        }
        this.rcChangeListener = new GenericBeanListener((DescriptorBean)this.rcBean, (Object)this, (Map)RC_ATTRIBUTES, null);
        SAFLoginContextBean sAFLoginContextBean = this.rcBean.getSAFLoginContext();
        this.lcChangeListener = new GenericBeanListener((DescriptorBean)sAFLoginContextBean, (Object)this, (Map)LC_ATTRIBUTES, null);
        try {
            this.rcChangeListener.initialize();
            this.lcChangeListener.initialize();
            this.isInitialized = true;
        }
        catch (ManagementException managementException) {
            throw new AssertionError((Object)managementException);
        }
    }

    public String toString() {
        return this.rcBeanFullyQualifiedName;
    }

    public String getRcBeanFullyQualifiedName() {
        return this.rcBeanFullyQualifiedName;
    }

    public SAFRemoteContextBean getRcBean() {
        return this.rcBean;
    }

    public boolean isLocalServerContext() {
        return this.rcBean == null;
    }

    public void addForwarder(PersistentStoreXA persistentStoreXA, WorkManager workManager, RuntimeHandler runtimeHandler, Queue queue, String string, int n) {
        this.forwarder.addSubforwarder(persistentStoreXA, workManager, runtimeHandler, queue, string, n);
    }

    public void addForwarder(PersistentStoreXA persistentStoreXA, WorkManager workManager, RuntimeHandler runtimeHandler, Queue queue, String string, int n, int n2) {
        this.forwarder.addSubforwarder(persistentStoreXA, workManager, runtimeHandler, queue, string, n, n2);
    }

    public void removeForwarder(Queue queue, String string) {
        this.forwarder.removeSubforwarder(queue);
    }

    public void setCompressionThreshold(int n) {
        this.forwarder.setCompressionThreshold(n);
    }

    public void setReplyToSAFRemoteContextName(String string) {
        this.replyHandler.setReplyToSAFRemoteContextName(string);
    }

    public void setLoginURL(String string) {
        if (this.isInitialized) {
            this.forwarder.stop();
        }
        this.forwarder.setLoginURL(string);
        if (this.isInitialized) {
            this.forwarder.start();
        }
    }

    public void setUsername(String string) {
        if (this.isInitialized) {
            this.forwarder.stop();
        }
        this.forwarder.setUsername(string);
        if (this.isInitialized) {
            this.forwarder.start();
        }
    }

    public void setPassword(String string) {
        if (this.isInitialized) {
            this.forwarder.stop();
        }
        this.forwarder.setPassword(string);
        if (this.isInitialized) {
            this.forwarder.start();
        }
    }

    public void setPasswordEncrypted(byte[] byArray) {
        if (this.isInitialized) {
            this.forwarder.stop();
        }
        this.forwarder.setPassword(EncryptionHelper.decryptString(byArray, (AuthenticatedSubject)kernelID));
        if (this.isInitialized) {
            this.forwarder.start();
        }
    }

    public void setRetryDelayBase(long l) {
        this.forwarder.setRetryDelayBase(l);
    }

    public void setRetryDelayMaximum(long l) {
        this.forwarder.setRetryDelayMaximum(l);
    }

    public void setRetryDelayMultiplier(double d) {
        this.forwarder.setRetryDelayMultiplier(d);
    }

    public void setWindowSize(int n) {
        this.forwarder.setWindowSize(n);
    }

    public void setWindowInterval(long l) {
        this.forwarder.setWindowInterval(l);
    }

    static {
        RC_ATTRIBUTES.put("CompressionThreshold", Integer.TYPE);
        RC_ATTRIBUTES.put("ReplyToSAFRemoteContextName", String.class);
        LC_ATTRIBUTES.put("LoginURL", String.class);
        LC_ATTRIBUTES.put("Username", String.class);
        LC_ATTRIBUTES.put("Password", String.class);
        LC_ATTRIBUTES.put("PasswordEncrypted", byte[].class);
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
    }

    class ServerStateChangeListener
    implements PropertyChangeListener {
        ServerStateChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("State".equals(propertyChangeEvent.getPropertyName()) && "RUNNING".equals((String)propertyChangeEvent.getNewValue())) {
                RemoteContextAgent.this.forwarder.start();
            }
        }
    }
}

