/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.io.IOException;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import weblogic.application.ModuleException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.SAFRemoteContextBean;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.saf.ImportedDestination;
import weblogic.jms.saf.RemoteContextAgent;
import weblogic.jms.saf.SAFAgentRuntimeMBeanAggregator;
import weblogic.jms.saf.SAFAgentRuntimeMBeanImpl;
import weblogic.jms.saf.SAFOutgoingReplyHandler;
import weblogic.jms.saf.SAFService;
import weblogic.jndi.internal.ClientEnvironmentFactoryImpl;
import weblogic.logging.jms.JMSMessageLoggerFactory;
import weblogic.logging.jms.JMSSAFMessageLogger;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.JMSSAFMessageLogFileMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.SAFRemoteEndpointRuntimeMBean;
import weblogic.management.utils.GenericBeanListener;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.saf.internal.SAFThresholdHandler;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.PersistentStoreManager;
import weblogic.store.admin.FileAdminHandler;
import weblogic.store.xa.PersistentStoreXA;

public class SAFAgentAdmin {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final HashMap BACKEND_ATTRIBUTES = new HashMap();
    private static final HashMap SAF_AGENT_ATTRIBUTES = new HashMap();
    private BackEnd backEnd;
    private GenericBeanListener backendChangeListener;
    private GenericBeanListener safChangeListener;
    private HashSet endpointRuntimes = new HashSet();
    private Set importedDestinations = Collections.synchronizedSet(new HashSet());
    private final boolean receivingOnly;
    private long defaultRetryDelayBase;
    private long defaultRetryDelayMaximum;
    private double defaultRetryDelayMultiplier;
    private int windowSize;
    private long defaultTimeToLive;
    private long windowInterval;
    private final HashMap remoteContexts = new HashMap();
    private boolean loggingEnabled;
    private long remoteEndpointsTotalCount;
    private long remoteEndpointsHighCount;
    private SAFAgentRuntimeMBeanAggregator runtimeMBean;

    SAFAgentAdmin(boolean bl) {
        this.receivingOnly = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepare(SAFAgentMBean sAFAgentMBean) throws DeploymentException {
        this.loggingEnabled = sAFAgentMBean.isLoggingEnabled();
        if (!this.receivingOnly) {
            SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID);
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
            try {
                try {
                    TargetMBean[] targetMBeanArray = sAFAgentMBean.getTargets();
                    this.backEnd = targetMBeanArray[0] instanceof MigratableTargetMBean ? new BackEnd(sAFAgentMBean.getName() + "@" + targetMBeanArray[0].getName(), "SAFAgent") : new BackEnd(sAFAgentMBean.getName() + "@" + runtimeAccess.getServerName(), "SAFAgent");
                    this.backEnd.setJMSMessageLogger(SAFAgentAdmin.findJMSSAFMessageLogger(sAFAgentMBean));
                }
                catch (ManagementException managementException) {
                    throw new DeploymentException(managementException);
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
                throw throwable;
            }
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            this.backEnd.setThresholdHandler(new SAFThresholdHandler(this.backEnd.getKernel(), this.backEnd.getName()));
            this.initializeChangeListeners(sAFAgentMBean);
            try {
                JMSService.getJMSService().getBEDeployer().addBackEnd(this.backEnd);
            }
            catch (JMSException jMSException) {
                throw new AssertionError((Object)jMSException);
            }
        }
        try {
            this.runtimeMBean = new SAFAgentRuntimeMBeanAggregator(sAFAgentMBean.getName(), this.backEnd, new SAFAgentRuntimeMBeanImpl(sAFAgentMBean.getName(), this, SAFService.getSAFService().getRuntimeMBean()));
        }
        catch (ManagementException managementException) {
            throw new DeploymentException(managementException);
        }
        SAFService.getSAFService().getRuntimeMBean().addAgent(this.runtimeMBean);
    }

    void activate(SAFAgentMBean sAFAgentMBean) throws DeploymentException {
        if (this.receivingOnly) {
            return;
        }
        this.closeChangeListeners();
        this.initializeChangeListeners(sAFAgentMBean);
        this.backEnd.setPersistentStore(SAFAgentAdmin.findPersistentStore(sAFAgentMBean));
        this.backEnd.setPagingDirectory(SAFAgentAdmin.findPagingDirectory(sAFAgentMBean));
        try {
            this.backEnd.open();
        }
        catch (JMSException jMSException) {
            throw new DeploymentException(jMSException);
        }
    }

    void deactivate() throws UndeploymentException {
        if (this.receivingOnly) {
            return;
        }
        this.backEnd.close();
    }

    public void unprepare() throws UndeploymentException {
        if (this.receivingOnly) {
            return;
        }
        this.backEnd.destroy();
        try {
            PrivilegedActionUtilities.unregister(this.runtimeMBean, KERNEL_ID);
        }
        catch (ManagementException managementException) {
            throw new UndeploymentException(managementException);
        }
        SAFService.getSAFService().getRuntimeMBean().removeAgent(this.runtimeMBean);
        this.closeChangeListeners();
        JMSService.getJMSService().getBEDeployer().removeBackEnd(this.backEnd);
    }

    private void initializeChangeListeners(SAFAgentMBean sAFAgentMBean) throws DeploymentException {
        this.backendChangeListener = new GenericBeanListener((DescriptorBean)sAFAgentMBean, (Object)this.backEnd, (Map)BACKEND_ATTRIBUTES, null);
        this.backendChangeListener.setCustomizer(this.backEnd);
        this.safChangeListener = new GenericBeanListener((DescriptorBean)sAFAgentMBean, (Object)this, (Map)SAF_AGENT_ATTRIBUTES, null);
        try {
            this.backendChangeListener.initialize();
            this.safChangeListener.initialize();
        }
        catch (ManagementException managementException) {
            throw new DeploymentException(managementException);
        }
    }

    private void closeChangeListeners() {
        this.backendChangeListener.close();
        this.safChangeListener.close();
    }

    SAFAgentRuntimeMBeanAggregator getRuntimeMBean() {
        return this.runtimeMBean;
    }

    private static PersistentStoreXA findPersistentStore(SAFAgentMBean sAFAgentMBean) throws DeploymentException {
        PersistentStoreXA persistentStoreXA;
        if (sAFAgentMBean.getStore() != null) {
            String string = sAFAgentMBean.getStore().getName();
            persistentStoreXA = (PersistentStoreXA)PersistentStoreManager.getManager().getStore(string);
            if (persistentStoreXA == null) {
                throw new DeploymentException("The persistent store \"" + string + "\" does not exist");
            }
        } else {
            persistentStoreXA = (PersistentStoreXA)PersistentStoreManager.getManager().getDefaultStore();
            if (persistentStoreXA == null) {
                throw new DeploymentException("The default persistent store does not exist");
            }
        }
        return persistentStoreXA;
    }

    void addImportedDestination(ImportedDestination importedDestination) {
        this.importedDestinations.add(importedDestination);
    }

    void removeImportedDestination(ImportedDestination importedDestination) {
        this.importedDestinations.remove(importedDestination);
    }

    private static String findPagingDirectory(SAFAgentMBean sAFAgentMBean) {
        String string;
        if (sAFAgentMBean.getPagingDirectory() != null) {
            string = sAFAgentMBean.getPagingDirectory();
            string = FileAdminHandler.canonicalizeDirectoryName(string);
        } else {
            String string2 = ManagementService.getRuntimeAccess(KERNEL_ID).getServer().getName();
            string = DomainDir.getTempDirForServer((String)string2);
        }
        return string;
    }

    synchronized void addRemoteEndpointRuntimeMBean(SAFRemoteEndpointRuntimeMBean sAFRemoteEndpointRuntimeMBean) throws ModuleException {
        ++this.remoteEndpointsTotalCount;
        if (this.remoteEndpointsTotalCount > this.remoteEndpointsHighCount) {
            this.remoteEndpointsHighCount = this.remoteEndpointsTotalCount;
        }
        this.endpointRuntimes.add(sAFRemoteEndpointRuntimeMBean);
    }

    synchronized void removeRemoteEndpointRuntimeMBean(SAFRemoteEndpointRuntimeMBean sAFRemoteEndpointRuntimeMBean) throws ModuleException {
        --this.remoteEndpointsTotalCount;
        this.endpointRuntimes.remove(sAFRemoteEndpointRuntimeMBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteContextAgent findOrCreateRemoteContext(String string, SAFRemoteContextBean sAFRemoteContextBean) {
        HashMap hashMap = this.remoteContexts;
        synchronized (hashMap) {
            RemoteContextAgent remoteContextAgent = (RemoteContextAgent)this.remoteContexts.get(string);
            if (remoteContextAgent == null) {
                SAFOutgoingReplyHandler sAFOutgoingReplyHandler = sAFRemoteContextBean != null ? new SAFOutgoingReplyHandler(sAFRemoteContextBean.getReplyToSAFRemoteContextName()) : new SAFOutgoingReplyHandler(null);
                remoteContextAgent = new RemoteContextAgent(string, sAFRemoteContextBean, sAFOutgoingReplyHandler, new ClientEnvironmentFactoryImpl());
                remoteContextAgent.setRetryDelayBase(this.defaultRetryDelayBase);
                remoteContextAgent.setRetryDelayMaximum(this.defaultRetryDelayMaximum);
                remoteContextAgent.setRetryDelayMultiplier(this.defaultRetryDelayMultiplier);
                remoteContextAgent.setWindowSize(this.windowSize);
                remoteContextAgent.setWindowInterval(this.windowInterval);
                this.remoteContexts.put(string, remoteContextAgent);
            }
            return remoteContextAgent;
        }
    }

    SAFRemoteEndpointRuntimeMBean[] getRemoteEndpoints() {
        SAFRemoteEndpointRuntimeMBean[] sAFRemoteEndpointRuntimeMBeanArray = new SAFRemoteEndpointRuntimeMBean[this.endpointRuntimes.size()];
        return this.endpointRuntimes.toArray(sAFRemoteEndpointRuntimeMBeanArray);
    }

    public long getRemoteEndpointsCurrentCount() {
        return this.endpointRuntimes.size();
    }

    public long getRemoteEndpointsHighCount() {
        return this.remoteEndpointsHighCount;
    }

    public long getRemoteEndpointsTotalCount() {
        return this.remoteEndpointsTotalCount;
    }

    public BackEnd getBackEnd() {
        return this.backEnd;
    }

    boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultRetryDelayBase(long l) {
        this.defaultRetryDelayBase = l;
        HashMap hashMap = this.remoteContexts;
        synchronized (hashMap) {
            for (RemoteContextAgent remoteContextAgent : this.remoteContexts.values()) {
                remoteContextAgent.setRetryDelayBase(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultRetryDelayMaximum(long l) {
        this.defaultRetryDelayMaximum = l;
        HashMap hashMap = this.remoteContexts;
        synchronized (hashMap) {
            for (RemoteContextAgent remoteContextAgent : this.remoteContexts.values()) {
                remoteContextAgent.setRetryDelayMaximum(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultRetryDelayMultiplier(double d) {
        this.defaultRetryDelayMultiplier = d;
        HashMap hashMap = this.remoteContexts;
        synchronized (hashMap) {
            for (RemoteContextAgent remoteContextAgent : this.remoteContexts.values()) {
                remoteContextAgent.setRetryDelayMultiplier(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowSize(int n) {
        this.windowSize = n;
        HashMap hashMap = this.remoteContexts;
        synchronized (hashMap) {
            for (RemoteContextAgent remoteContextAgent : this.remoteContexts.values()) {
                remoteContextAgent.setWindowSize(n);
            }
        }
    }

    public void setLoggingEnabled(boolean bl) {
        this.loggingEnabled = bl;
    }

    public void setConversationIdleTimeMaximum(long l) {
    }

    public void setAcknowledgeInterval(long l) {
    }

    public void setDefaultTimeToLive(long l) {
        this.defaultTimeToLive = l;
        for (ImportedDestination importedDestination : this.importedDestinations) {
            importedDestination.setAgentTimeToLiveOverride(l);
        }
    }

    long getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowInterval(long l) {
        this.windowInterval = l;
        HashMap hashMap = this.remoteContexts;
        synchronized (hashMap) {
            for (RemoteContextAgent remoteContextAgent : this.remoteContexts.values()) {
                remoteContextAgent.setWindowInterval(l);
            }
        }
    }

    long getWindowInterval() {
        return this.windowInterval;
    }

    public void setIncomingPausedAtStartup(boolean bl) {
        this.backEnd.setProductionPausedAtStartup("" + bl);
    }

    public void setForwardingPausedAtStartup(boolean bl) {
        this.backEnd.setConsumptionPausedAtStartup("" + bl);
    }

    public void setReceivingPausedAtStartup(boolean bl) {
    }

    private static JMSSAFMessageLogger findJMSSAFMessageLogger(SAFAgentMBean sAFAgentMBean) throws DeploymentException {
        try {
            JMSSAFMessageLogFileMBean jMSSAFMessageLogFileMBean = sAFAgentMBean.getJMSSAFMessageLogFile();
            return JMSMessageLoggerFactory.findOrCreateJMSSAFMessageLogger(jMSSAFMessageLogFileMBean);
        }
        catch (IOException iOException) {
            throw new DeploymentException("Cannot find or create JMS message log file for saf agent " + sAFAgentMBean.getName(), iOException);
        }
    }

    static {
        BACKEND_ATTRIBUTES.put("BytesMaximum", Long.TYPE);
        BACKEND_ATTRIBUTES.put("BytesThresholdHigh", Long.TYPE);
        BACKEND_ATTRIBUTES.put("BytesThresholdLow", Long.TYPE);
        BACKEND_ATTRIBUTES.put("MessagesMaximum", Long.TYPE);
        BACKEND_ATTRIBUTES.put("MessagesThresholdHigh", Long.TYPE);
        BACKEND_ATTRIBUTES.put("MessagesThresholdLow", Long.TYPE);
        BACKEND_ATTRIBUTES.put("MaximumMessageSize", Integer.TYPE);
        BACKEND_ATTRIBUTES.put("MessageBufferSize", Long.TYPE);
        SAF_AGENT_ATTRIBUTES.put("DefaultRetryDelayBase", Long.TYPE);
        SAF_AGENT_ATTRIBUTES.put("DefaultRetryDelayMaximum", Long.TYPE);
        SAF_AGENT_ATTRIBUTES.put("DefaultRetryDelayMultiplier", Double.TYPE);
        SAF_AGENT_ATTRIBUTES.put("WindowSize", Integer.TYPE);
        SAF_AGENT_ATTRIBUTES.put("LoggingEnabled", Boolean.TYPE);
        SAF_AGENT_ATTRIBUTES.put("ConversationIdleTimeMaximum", Long.TYPE);
        SAF_AGENT_ATTRIBUTES.put("AcknowledgeInterval", Long.TYPE);
        SAF_AGENT_ATTRIBUTES.put("DefaultTimeToLive", Long.TYPE);
        SAF_AGENT_ATTRIBUTES.put("WindowInterval", Long.TYPE);
        SAF_AGENT_ATTRIBUTES.put("IncomingPausedAtStartup", Boolean.TYPE);
        SAF_AGENT_ATTRIBUTES.put("ForwardingPausedAtStartup", Boolean.TYPE);
        SAF_AGENT_ATTRIBUTES.put("ReceivingPausedAtStartup", Boolean.TYPE);
    }
}

