/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSTargetsListener;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.ModuleCoordinator;
import weblogic.jms.module.TargetingHelper;
import weblogic.jms.saf.ImportedDestinationGroup;
import weblogic.jms.saf.SAFAgentAdmin;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.GenericAdminHandler;
import weblogic.messaging.saf.internal.SAFServerService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class SAFAgentDeployer
implements GenericAdminHandler {
    private final HashMap agents = new HashMap();
    private HashSet safAgentListeners = new HashSet();
    private HashMap safAgentBeanListeners = new HashMap();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private boolean migrationInProgress = false;

    public boolean isMigrationInProgress() {
        return this.migrationInProgress;
    }

    public void setMigrationInProgress(boolean bl) {
        this.migrationInProgress = bl;
    }

    void start() {
        this.initializeSAFAgentListeners();
    }

    void stop() {
        this.removeSAFAgentListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(DeploymentMBean deploymentMBean) throws DeploymentException {
        if (!(deploymentMBean instanceof SAFAgentMBean)) {
            return;
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Preparing saf agent " + deploymentMBean.getName());
        }
        SAFAgentMBean sAFAgentMBean = (SAFAgentMBean)deploymentMBean;
        boolean bl = "Receiving-only".equals(sAFAgentMBean.getServiceType());
        SAFAgentAdmin sAFAgentAdmin = new SAFAgentAdmin(bl);
        sAFAgentAdmin.prepare(sAFAgentMBean);
        this.agents.put(sAFAgentMBean.getName(), sAFAgentAdmin);
        SAFAgentDeployer sAFAgentDeployer = this;
        synchronized (sAFAgentDeployer) {
            ImportedDestinationGroup.prepareLocalSAFAgent(sAFAgentMBean);
            try {
                this.startAddSAFAgents(sAFAgentMBean);
            }
            catch (BeanUpdateRejectedException beanUpdateRejectedException) {
                throw new DeploymentException(beanUpdateRejectedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(DeploymentMBean deploymentMBean) throws DeploymentException {
        if (!(deploymentMBean instanceof SAFAgentMBean)) {
            return;
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Activating saf agent " + deploymentMBean.getName());
        }
        SAFAgentMBean sAFAgentMBean = (SAFAgentMBean)deploymentMBean;
        SAFAgentAdmin sAFAgentAdmin = (SAFAgentAdmin)this.agents.get(sAFAgentMBean.getName());
        sAFAgentAdmin.activate(sAFAgentMBean);
        SAFAgentDeployer sAFAgentDeployer = this;
        synchronized (sAFAgentDeployer) {
            ImportedDestinationGroup.activateLocalSAFAgent(sAFAgentMBean);
            this.finishAddSAFAgents(sAFAgentMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(DeploymentMBean deploymentMBean) throws UndeploymentException {
        if (!(deploymentMBean instanceof SAFAgentMBean)) {
            return;
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Deactivating saf agent " + deploymentMBean.getName());
        }
        SAFAgentMBean sAFAgentMBean = (SAFAgentMBean)deploymentMBean;
        Object object = this;
        synchronized (object) {
            ImportedDestinationGroup.deactivateLocalSAFAgent(sAFAgentMBean);
            try {
                this.startRemoveSAFAgents(sAFAgentMBean);
            }
            catch (BeanUpdateRejectedException beanUpdateRejectedException) {
                throw new UndeploymentException(beanUpdateRejectedException);
            }
        }
        object = (SAFAgentAdmin)this.agents.get(sAFAgentMBean.getName());
        if (object != null) {
            ((SAFAgentAdmin)object).deactivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unprepare(DeploymentMBean deploymentMBean) throws UndeploymentException {
        if (!(deploymentMBean instanceof SAFAgentMBean)) {
            return;
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Unpreparing saf agent " + deploymentMBean.getName());
        }
        SAFAgentMBean sAFAgentMBean = (SAFAgentMBean)deploymentMBean;
        Object object = this;
        synchronized (object) {
            ImportedDestinationGroup.unprepareLocalSAFAgent(sAFAgentMBean);
            this.finishRemoveSAFAgents(sAFAgentMBean);
        }
        object = (SAFAgentAdmin)this.agents.remove(sAFAgentMBean.getName());
        if (object != null) {
            ((SAFAgentAdmin)object).unprepare();
        }
    }

    public SAFAgentAdmin getAgent(String string) {
        return (SAFAgentAdmin)this.agents.get(string);
    }

    SAFAgentAdmin[] getSAFAgents() {
        SAFAgentAdmin[] sAFAgentAdminArray = new SAFAgentAdmin[this.agents.size()];
        return this.agents.values().toArray(sAFAgentAdminArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSAFAgentListeners() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        SAFAgentMBean[] sAFAgentMBeanArray = domainMBean.getSAFAgents();
        for (int i = 0; i < sAFAgentMBeanArray.length; ++i) {
            SAFAgentMBean sAFAgentMBean = sAFAgentMBeanArray[i];
            SAFAgentBeanListener sAFAgentBeanListener = new SAFAgentBeanListener(sAFAgentMBeanArray[i]);
            sAFAgentMBean.addBeanUpdateListener(sAFAgentBeanListener);
            HashMap hashMap = this.safAgentBeanListeners;
            synchronized (hashMap) {
                this.safAgentBeanListeners.put(sAFAgentMBeanArray[i].getName(), new DescriptorAndListener(sAFAgentMBean, sAFAgentBeanListener));
            }
            if (!JMSDebug.JMSSAF.isDebugEnabled()) continue;
            JMSDebug.JMSSAF.debug("Listening for changes to SAFAgent " + sAFAgentMBeanArray[i].getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSAFAgentListeners() {
        HashMap hashMap = this.safAgentBeanListeners;
        synchronized (hashMap) {
            for (String string : this.safAgentBeanListeners.keySet()) {
                DescriptorAndListener descriptorAndListener = (DescriptorAndListener)this.safAgentBeanListeners.get(string);
                DescriptorBean descriptorBean = descriptorAndListener.getDescriptorBean();
                SAFAgentBeanListener sAFAgentBeanListener = descriptorAndListener.getListener();
                descriptorBean.removeBeanUpdateListener((BeanUpdateListener)sAFAgentBeanListener);
                sAFAgentBeanListener.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSAFAgentListener(JMSTargetsListener jMSTargetsListener) {
        HashSet hashSet = this.safAgentListeners;
        synchronized (hashSet) {
            this.safAgentListeners.add(jMSTargetsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSAFAgentListener(JMSTargetsListener jMSTargetsListener) {
        HashSet hashSet = this.safAgentListeners;
        synchronized (hashSet) {
            this.safAgentListeners.remove(jMSTargetsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fireListenersPrepare(DomainMBean domainMBean, SAFAgentMBean sAFAgentMBean, int n) throws BeanUpdateRejectedException {
        boolean bl = false;
        LinkedList<JMSTargetsListener> linkedList = new LinkedList<JMSTargetsListener>();
        LinkedList<JMSTargetsListener> linkedList2 = new LinkedList<JMSTargetsListener>();
        LinkedList<JMSTargetsListener> linkedList3 = new LinkedList<JMSTargetsListener>();
        HashSet hashSet = this.safAgentListeners;
        synchronized (hashSet) {
            Iterator iterator;
            for (JMSTargetsListener jMSTargetsListener : this.safAgentListeners) {
                if (jMSTargetsListener instanceof ModuleCoordinator.JMSTargetsListenerImpl) {
                    linkedList2.add(jMSTargetsListener);
                    continue;
                }
                if (!(jMSTargetsListener instanceof ImportedDestinationGroup)) continue;
                linkedList3.add(jMSTargetsListener);
            }
            try {
                for (JMSTargetsListener jMSTargetsListener : linkedList2) {
                    jMSTargetsListener.prepareUpdate(domainMBean, sAFAgentMBean, n, this.migrationInProgress);
                    linkedList.addLast(jMSTargetsListener);
                }
                iterator = linkedList3.iterator();
                while (iterator.hasNext()) {
                    JMSTargetsListener jMSTargetsListener;
                    jMSTargetsListener = (JMSTargetsListener)iterator.next();
                    jMSTargetsListener.prepareUpdate(domainMBean, sAFAgentMBean, n, this.migrationInProgress);
                    linkedList.addLast(jMSTargetsListener);
                }
                return;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                if (bl) throw throwable;
                iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    JMSTargetsListener jMSTargetsListener = (JMSTargetsListener)iterator.next();
                    jMSTargetsListener.rollbackUpdate();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListenersActivateOrRollback(boolean bl) {
        LinkedList<JMSTargetsListener> linkedList = new LinkedList<JMSTargetsListener>();
        LinkedList<JMSTargetsListener> linkedList2 = new LinkedList<JMSTargetsListener>();
        HashSet hashSet = this.safAgentListeners;
        synchronized (hashSet) {
            for (JMSTargetsListener jMSTargetsListener : this.safAgentListeners) {
                if (jMSTargetsListener instanceof ModuleCoordinator.JMSTargetsListenerImpl) {
                    linkedList.add(jMSTargetsListener);
                    continue;
                }
                if (!(jMSTargetsListener instanceof ImportedDestinationGroup)) continue;
                linkedList2.add(jMSTargetsListener);
            }
            for (JMSTargetsListener jMSTargetsListener : linkedList) {
                if (bl) {
                    jMSTargetsListener.activateUpdate();
                    continue;
                }
                jMSTargetsListener.rollbackUpdate();
            }
            for (JMSTargetsListener jMSTargetsListener : linkedList2) {
                if (bl) {
                    jMSTargetsListener.activateUpdate();
                    continue;
                }
                jMSTargetsListener.rollbackUpdate();
            }
        }
    }

    public void startAddSAFAgents(SAFAgentMBean sAFAgentMBean) throws BeanUpdateRejectedException {
        DomainMBean domainMBean;
        try {
            domainMBean = JMSBeanHelper.getDomain(sAFAgentMBean);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BeanUpdateRejectedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
        this.fireListenersPrepare(domainMBean, sAFAgentMBean, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishAddSAFAgents(SAFAgentMBean sAFAgentMBean) {
        this.fireListenersActivateOrRollback(true);
        SAFAgentBeanListener sAFAgentBeanListener = new SAFAgentBeanListener(sAFAgentMBean);
        sAFAgentMBean.addBeanUpdateListener(sAFAgentBeanListener);
        HashMap hashMap = this.safAgentBeanListeners;
        synchronized (hashMap) {
            this.safAgentBeanListeners.put(sAFAgentMBean.getName(), new DescriptorAndListener(sAFAgentMBean, sAFAgentBeanListener));
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Listening for changes to SAFAgent " + sAFAgentMBean.getName());
        }
    }

    public void startRemoveSAFAgents(SAFAgentMBean sAFAgentMBean) throws BeanUpdateRejectedException {
        DomainMBean domainMBean = null;
        try {
            domainMBean = JMSBeanHelper.getDomain(sAFAgentMBean);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BeanUpdateRejectedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
        this.fireListenersPrepare(domainMBean, sAFAgentMBean, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRemoveSAFAgents(SAFAgentMBean sAFAgentMBean) {
        this.fireListenersActivateOrRollback(true);
        HashMap hashMap = this.safAgentBeanListeners;
        synchronized (hashMap) {
            DescriptorAndListener descriptorAndListener = (DescriptorAndListener)this.safAgentBeanListeners.remove(sAFAgentMBean.getName());
            if (descriptorAndListener == null) {
                return;
            }
            DescriptorBean descriptorBean = descriptorAndListener.getDescriptorBean();
            SAFAgentBeanListener sAFAgentBeanListener = descriptorAndListener.getListener();
            descriptorBean.removeBeanUpdateListener((BeanUpdateListener)sAFAgentBeanListener);
            sAFAgentBeanListener.close();
        }
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Not listening for changes to removed SAFAgent " + sAFAgentMBean.getName());
        }
    }

    private static class DescriptorAndListener {
        private DescriptorBean db;
        private SAFAgentBeanListener listener;

        private DescriptorAndListener(DescriptorBean descriptorBean, SAFAgentBeanListener sAFAgentBeanListener) {
            this.db = descriptorBean;
            this.listener = sAFAgentBeanListener;
        }

        private DescriptorBean getDescriptorBean() {
            return this.db;
        }

        private SAFAgentBeanListener getListener() {
            return this.listener;
        }
    }

    private class SAFAgentBeanListener
    implements BeanUpdateListener {
        private SAFAgentMBean safAgent;
        private SAFAgentMBean proposedSAFAgent;
        private MigratableTargetMBean migratableTarget;
        int numFound;
        boolean safAgentChanged;

        private SAFAgentBeanListener(SAFAgentMBean sAFAgentMBean) {
            this.safAgent = sAFAgentMBean;
            TargetMBean[] targetMBeanArray = this.safAgent.getTargets();
            if (targetMBeanArray.length != 1) {
                return;
            }
            TargetMBean targetMBean = targetMBeanArray[0];
            if (targetMBean instanceof MigratableTargetMBean) {
                this.migratableTarget = (MigratableTargetMBean)targetMBean;
                this.migratableTarget.addBeanUpdateListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
            DomainMBean domainMBean;
            Object object;
            DescriptorBean descriptorBean;
            this.safAgentChanged = this.migratableTarget == null ? true : (descriptorBean = beanUpdateEvent.getProposedBean()) instanceof SAFAgentMBean;
            boolean bl = false;
            boolean bl2 = false;
            BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
            for (int i = 0; i < propertyUpdateArray.length; ++i) {
                object = propertyUpdateArray[i];
                if (this.safAgentChanged && object.getPropertyName().equals("Targets")) {
                    bl2 = true;
                    bl = true;
                    break;
                }
                if (this.safAgentChanged || !object.getPropertyName().equals("UserPreferredServer")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
            ++this.numFound;
            SAFAgentMBean sAFAgentMBean = this.proposedSAFAgent = this.safAgentChanged ? (SAFAgentMBean)beanUpdateEvent.getProposedBean() : this.safAgent;
            if (bl2 && !SAFServerService.getService().isTargetsChangeAllowed(this.proposedSAFAgent)) {
                throw new BeanUpdateRejectedException("Cannot retarget SAF agent " + this.safAgent.getName() + " to a MigrableTarget while it is currently targeted to a Server/Cluster or handling WSRM messages");
            }
            try {
                domainMBean = this.safAgentChanged ? JMSBeanHelper.getDomain(this.proposedSAFAgent) : JMSBeanHelper.getDomain((WebLogicMBean)beanUpdateEvent.getProposedBean());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new BeanUpdateRejectedException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
            }
            object = SAFAgentDeployer.this;
            synchronized (object) {
                if (ImportedDestinationGroup.getLocalSAFAgents().get(this.proposedSAFAgent.getName()) == null && !this.isLocallyTargeted(this.proposedSAFAgent)) {
                    SAFAgentDeployer.this.fireListenersPrepare(domainMBean, this.proposedSAFAgent, 2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
            if (this.numFound <= 0) {
                return;
            }
            --this.numFound;
            Object object = SAFAgentDeployer.this;
            synchronized (object) {
                if (ImportedDestinationGroup.getLocalSAFAgents().get(this.proposedSAFAgent.getName()) == null && !this.isLocallyTargeted(this.proposedSAFAgent)) {
                    SAFAgentDeployer.this.fireListenersActivateOrRollback(true);
                }
            }
            if (!this.safAgentChanged) {
                return;
            }
            object = this.migratableTarget;
            if (object != null) {
                object.removeBeanUpdateListener((BeanUpdateListener)this);
            }
            this.migratableTarget = null;
            TargetMBean[] targetMBeanArray = this.safAgent.getTargets();
            if (targetMBeanArray.length != 1) {
                return;
            }
            TargetMBean targetMBean = targetMBeanArray[0];
            if (targetMBean instanceof MigratableTargetMBean) {
                this.migratableTarget = (MigratableTargetMBean)targetMBean;
                this.migratableTarget.addBeanUpdateListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
            if (this.numFound <= 0) {
                return;
            }
            --this.numFound;
            SAFAgentDeployer sAFAgentDeployer = SAFAgentDeployer.this;
            synchronized (sAFAgentDeployer) {
                if (ImportedDestinationGroup.getLocalSAFAgents().get(this.proposedSAFAgent.getName()) == null && !this.isLocallyTargeted(this.proposedSAFAgent)) {
                    SAFAgentDeployer.this.fireListenersActivateOrRollback(false);
                }
            }
        }

        private void close() {
            if (this.migratableTarget == null) {
                return;
            }
            this.migratableTarget.removeBeanUpdateListener(this);
        }

        private boolean isLocallyTargeted(SAFAgentMBean sAFAgentMBean) {
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
            if (serverMBean == null) {
                return false;
            }
            return TargetingHelper.isLocallyTargeted(sAFAgentMBean, serverMBean.getCluster() == null ? null : serverMBean.getCluster().getName(), serverMBean.getName());
        }
    }
}

