/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.util.Arrays;
import java.util.HashSet;
import weblogic.health.HealthState;
import weblogic.jms.saf.SAFAgentRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.SAFAgentRuntimeMBean;
import weblogic.management.runtime.SAFConversationRuntimeMBean;
import weblogic.management.runtime.SAFRemoteEndpointRuntimeMBean;
import weblogic.messaging.saf.SAFException;

public class SAFAgentRuntimeMBeanAggregator
extends RuntimeMBeanDelegate
implements SAFAgentRuntimeMBean {
    private final SAFAgentRuntimeMBean delegate1;
    private SAFAgentRuntimeMBean delegate2;

    public SAFAgentRuntimeMBeanAggregator(String string, RuntimeMBean runtimeMBean, SAFAgentRuntimeMBean sAFAgentRuntimeMBean) throws ManagementException {
        super(string, runtimeMBean, true);
        this.delegate1 = sAFAgentRuntimeMBean;
    }

    SAFAgentRuntimeMBeanImpl getJMSSAFAgentRuntime() {
        return (SAFAgentRuntimeMBeanImpl)this.delegate1;
    }

    public void setDelegate2(SAFAgentRuntimeMBean sAFAgentRuntimeMBean) {
        this.delegate2 = sAFAgentRuntimeMBean;
    }

    public HealthState getHealthState() {
        return this.delegate1.getHealthState();
    }

    public SAFRemoteEndpointRuntimeMBean[] getRemoteEndpoints() {
        HashSet<SAFRemoteEndpointRuntimeMBean> hashSet = new HashSet<SAFRemoteEndpointRuntimeMBean>();
        hashSet.addAll(Arrays.asList(this.delegate1.getRemoteEndpoints()));
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        if (sAFAgentRuntimeMBean != null) {
            hashSet.addAll(Arrays.asList(sAFAgentRuntimeMBean.getRemoteEndpoints()));
        }
        return hashSet.toArray(new SAFRemoteEndpointRuntimeMBean[hashSet.size()]);
    }

    public long getRemoteEndpointsCurrentCount() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        return this.delegate1.getRemoteEndpointsCurrentCount() + (sAFAgentRuntimeMBean == null ? 0L : sAFAgentRuntimeMBean.getRemoteEndpointsCurrentCount());
    }

    public long getRemoteEndpointsHighCount() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        return this.delegate1.getRemoteEndpointsHighCount() + (sAFAgentRuntimeMBean == null ? 0L : sAFAgentRuntimeMBean.getRemoteEndpointsHighCount());
    }

    public long getRemoteEndpointsTotalCount() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        return this.delegate1.getRemoteEndpointsTotalCount() + (sAFAgentRuntimeMBean == null ? 0L : sAFAgentRuntimeMBean.getRemoteEndpointsTotalCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseIncoming() throws SAFException {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean;
        try {
            this.delegate1.pauseIncoming();
            Object var2_1 = null;
            sAFAgentRuntimeMBean = this.delegate2;
            if (sAFAgentRuntimeMBean == null) {
                return;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            SAFAgentRuntimeMBean sAFAgentRuntimeMBean2 = this.delegate2;
            if (sAFAgentRuntimeMBean2 == null) {
                return;
            }
            sAFAgentRuntimeMBean2.pauseIncoming();
            throw throwable;
        }
        sAFAgentRuntimeMBean.pauseIncoming();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeIncoming() throws SAFException {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean;
        try {
            this.delegate1.resumeIncoming();
            Object var2_1 = null;
            sAFAgentRuntimeMBean = this.delegate2;
            if (sAFAgentRuntimeMBean == null) {
                return;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            SAFAgentRuntimeMBean sAFAgentRuntimeMBean2 = this.delegate2;
            if (sAFAgentRuntimeMBean2 == null) {
                return;
            }
            sAFAgentRuntimeMBean2.resumeIncoming();
            throw throwable;
        }
        sAFAgentRuntimeMBean.resumeIncoming();
    }

    public boolean isPausedForIncoming() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        if (sAFAgentRuntimeMBean != null) {
            return sAFAgentRuntimeMBean.isPausedForIncoming();
        }
        return this.delegate1.isPausedForIncoming();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseForwarding() throws SAFException {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean;
        try {
            this.delegate1.pauseForwarding();
            Object var2_1 = null;
            sAFAgentRuntimeMBean = this.delegate2;
            if (sAFAgentRuntimeMBean == null) {
                return;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            SAFAgentRuntimeMBean sAFAgentRuntimeMBean2 = this.delegate2;
            if (sAFAgentRuntimeMBean2 == null) {
                return;
            }
            sAFAgentRuntimeMBean2.pauseForwarding();
            throw throwable;
        }
        sAFAgentRuntimeMBean.pauseForwarding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeForwarding() throws SAFException {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean;
        try {
            this.delegate1.resumeForwarding();
            Object var2_1 = null;
            sAFAgentRuntimeMBean = this.delegate2;
            if (sAFAgentRuntimeMBean == null) {
                return;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            SAFAgentRuntimeMBean sAFAgentRuntimeMBean2 = this.delegate2;
            if (sAFAgentRuntimeMBean2 == null) {
                return;
            }
            sAFAgentRuntimeMBean2.resumeForwarding();
            throw throwable;
        }
        sAFAgentRuntimeMBean.resumeForwarding();
    }

    public boolean isPausedForForwarding() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        if (sAFAgentRuntimeMBean != null) {
            return sAFAgentRuntimeMBean.isPausedForForwarding();
        }
        return this.delegate1.isPausedForForwarding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseReceiving() throws SAFException {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean;
        try {
            this.delegate1.pauseReceiving();
            Object var2_1 = null;
            sAFAgentRuntimeMBean = this.delegate2;
            if (sAFAgentRuntimeMBean == null) {
                return;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            SAFAgentRuntimeMBean sAFAgentRuntimeMBean2 = this.delegate2;
            if (sAFAgentRuntimeMBean2 == null) {
                return;
            }
            sAFAgentRuntimeMBean2.pauseReceiving();
            throw throwable;
        }
        sAFAgentRuntimeMBean.pauseReceiving();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeReceiving() throws SAFException {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean;
        try {
            this.delegate1.resumeReceiving();
            Object var2_1 = null;
            sAFAgentRuntimeMBean = this.delegate2;
            if (sAFAgentRuntimeMBean == null) {
                return;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            SAFAgentRuntimeMBean sAFAgentRuntimeMBean2 = this.delegate2;
            if (sAFAgentRuntimeMBean2 == null) {
                return;
            }
            sAFAgentRuntimeMBean2.resumeReceiving();
            throw throwable;
        }
        sAFAgentRuntimeMBean.resumeReceiving();
    }

    public boolean isPausedForReceiving() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        if (sAFAgentRuntimeMBean != null) {
            return sAFAgentRuntimeMBean.isPausedForReceiving();
        }
        return this.delegate1.isPausedForReceiving();
    }

    public SAFConversationRuntimeMBean[] getConversations() {
        HashSet<SAFConversationRuntimeMBean> hashSet = new HashSet<SAFConversationRuntimeMBean>();
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        if (sAFAgentRuntimeMBean != null) {
            hashSet.addAll(Arrays.asList(sAFAgentRuntimeMBean.getConversations()));
        }
        return hashSet.toArray(new SAFConversationRuntimeMBean[hashSet.size()]);
    }

    public long getConversationsCurrentCount() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        return this.delegate1.getConversationsCurrentCount() + (sAFAgentRuntimeMBean == null ? 0L : sAFAgentRuntimeMBean.getConversationsCurrentCount());
    }

    public long getConversationsHighCount() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        return this.delegate1.getConversationsHighCount() + (sAFAgentRuntimeMBean == null ? 0L : sAFAgentRuntimeMBean.getConversationsHighCount());
    }

    public long getConversationsTotalCount() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        return this.delegate1.getConversationsTotalCount() + (sAFAgentRuntimeMBean == null ? 0L : sAFAgentRuntimeMBean.getConversationsTotalCount());
    }

    public long getMessagesCurrentCount() {
        return this.delegate1.getMessagesCurrentCount();
    }

    public long getMessagesPendingCount() {
        return this.delegate1.getMessagesPendingCount();
    }

    public long getMessagesHighCount() {
        return this.delegate1.getMessagesHighCount();
    }

    public long getMessagesReceivedCount() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        return this.delegate1.getMessagesReceivedCount() + (sAFAgentRuntimeMBean == null ? 0L : sAFAgentRuntimeMBean.getMessagesReceivedCount());
    }

    public long getMessagesThresholdTime() {
        return this.delegate1.getMessagesThresholdTime();
    }

    public long getBytesPendingCount() {
        return this.delegate1.getBytesPendingCount();
    }

    public long getBytesCurrentCount() {
        return this.delegate1.getBytesCurrentCount();
    }

    public long getBytesHighCount() {
        return this.delegate1.getBytesHighCount();
    }

    public long getBytesReceivedCount() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        return this.delegate1.getBytesReceivedCount() + (sAFAgentRuntimeMBean == null ? 0L : sAFAgentRuntimeMBean.getBytesReceivedCount());
    }

    public long getBytesThresholdTime() {
        return this.delegate1.getBytesThresholdTime();
    }

    public long getFailedMessagesTotal() {
        SAFAgentRuntimeMBean sAFAgentRuntimeMBean = this.delegate2;
        return this.delegate1.getFailedMessagesTotal() + (sAFAgentRuntimeMBean == null ? 0L : sAFAgentRuntimeMBean.getFailedMessagesTotal());
    }
}

