/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import javax.jms.JMSException;
import weblogic.health.HealthState;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.saf.SAFAgentAdmin;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.SAFAgentRuntimeMBean;
import weblogic.management.runtime.SAFConversationRuntimeMBean;
import weblogic.management.runtime.SAFRemoteEndpointRuntimeMBean;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFLogger;

class SAFAgentRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements SAFAgentRuntimeMBean {
    private final SAFAgentAdmin safAgent;
    private final BackEnd backEnd;
    private long failedMessagesCount;

    SAFAgentRuntimeMBeanImpl(String string, SAFAgentAdmin sAFAgentAdmin, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string, null, false);
        this.safAgent = sAFAgentAdmin;
        this.backEnd = sAFAgentAdmin.getBackEnd();
    }

    public HealthState getHealthState() {
        if (this.backEnd != null) {
            return this.backEnd.getHealthState();
        }
        return new HealthState(0);
    }

    public SAFRemoteEndpointRuntimeMBean[] getRemoteEndpoints() {
        return this.safAgent.getRemoteEndpoints();
    }

    public long getRemoteEndpointsCurrentCount() {
        return this.safAgent.getRemoteEndpointsCurrentCount();
    }

    public long getRemoteEndpointsHighCount() {
        return this.safAgent.getRemoteEndpointsHighCount();
    }

    public long getRemoteEndpointsTotalCount() {
        return this.safAgent.getRemoteEndpointsTotalCount();
    }

    public void pauseIncoming() throws SAFException {
        if (this.backEnd == null) {
            return;
        }
        try {
            this.backEnd.pauseProduction(false);
        }
        catch (JMSException jMSException) {
            throw new SAFException(jMSException.getMessage());
        }
        SAFLogger.logIncomingPauseOfSAFAgent((String)this.getName());
    }

    public void resumeIncoming() throws SAFException {
        if (this.backEnd == null) {
            return;
        }
        try {
            this.backEnd.resumeProduction(false);
        }
        catch (JMSException jMSException) {
            throw new SAFException(jMSException.getMessage());
        }
        SAFLogger.logIncomingResumeOfSAFAgent((String)this.getName());
    }

    public boolean isPausedForIncoming() {
        if (this.backEnd == null) {
            return false;
        }
        return this.backEnd.isProductionPaused();
    }

    public void pauseForwarding() throws SAFException {
        if (this.backEnd == null) {
            return;
        }
        try {
            this.backEnd.pauseConsumption(false);
        }
        catch (JMSException jMSException) {
            throw new SAFException(jMSException.getMessage());
        }
        SAFLogger.logForwardingPauseOfSAFAgent((String)this.getName());
    }

    public void resumeForwarding() throws SAFException {
        if (this.backEnd == null) {
            return;
        }
        try {
            this.backEnd.resumeConsumption(false);
        }
        catch (JMSException jMSException) {
            throw new SAFException(jMSException.getMessage());
        }
        SAFLogger.logForwardingResumeOfSAFAgent((String)this.getName());
    }

    public boolean isPausedForForwarding() {
        if (this.backEnd == null) {
            return false;
        }
        return this.backEnd.isConsumptionPaused();
    }

    public void pauseReceiving() throws SAFException {
    }

    public void resumeReceiving() throws SAFException {
    }

    public boolean isPausedForReceiving() {
        return false;
    }

    public SAFConversationRuntimeMBean[] getConversations() {
        return new SAFConversationRuntimeMBean[0];
    }

    public long getConversationsCurrentCount() {
        return 0L;
    }

    public long getConversationsHighCount() {
        return 0L;
    }

    public long getConversationsTotalCount() {
        return 0L;
    }

    public long getMessagesCurrentCount() {
        return this.backEnd.getMessagesCurrentCount() + this.backEnd.getMessagesPendingCount();
    }

    public long getMessagesPendingCount() {
        return this.backEnd.getMessagesPendingCount();
    }

    public long getMessagesHighCount() {
        return this.backEnd.getMessagesHighCount();
    }

    public long getMessagesReceivedCount() {
        return this.backEnd.getMessagesReceivedCount();
    }

    public long getMessagesThresholdTime() {
        return this.backEnd.getMessagesThresholdTime();
    }

    public long getBytesPendingCount() {
        return this.backEnd.getBytesPendingCount();
    }

    public long getBytesCurrentCount() {
        return this.backEnd.getBytesCurrentCount();
    }

    public long getBytesHighCount() {
        return this.backEnd.getBytesHighCount();
    }

    public long getBytesReceivedCount() {
        return this.backEnd.getBytesReceivedCount();
    }

    public long getBytesThresholdTime() {
        return this.backEnd.getBytesThresholdTime();
    }

    public long getFailedMessagesTotal() {
        return this.failedMessagesCount;
    }

    synchronized void updateFailedMessagesCount(long l) {
        this.failedMessagesCount += l;
    }
}

