/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.util.HashMap;
import java.util.Map;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.DestinationImplObserver;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.WrappedDestinationImpl;
import weblogic.jms.dd.DDHandler;
import weblogic.jms.dd.DDManager;
import weblogic.jms.forwarder.ReplyHandler;

public class SAFOutgoingReplyHandler
implements ReplyHandler,
DestinationImplObserver {
    private String replyToSAFContextName;
    private static Map destinationTable = new HashMap();

    public static void init() {
        WrappedDestinationImpl.setObserver(new SAFOutgoingReplyHandler(null));
    }

    public SAFOutgoingReplyHandler(String string) {
        this.replyToSAFContextName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageImpl messageImpl) {
        DestinationImpl destinationImpl = (DestinationImpl)messageImpl.getJMSReplyTo();
        if (destinationImpl == null) {
            return;
        }
        String string = null;
        if (destinationImpl instanceof DistributedDestinationImpl) {
            DDHandler dDHandler = DDManager.findDDHandlerByDDName(destinationImpl.getName());
            if (dDHandler != null) {
                string = dDHandler.getJNDIName();
            }
        } else {
            Map map = destinationTable;
            synchronized (map) {
                string = (String)destinationTable.get(SAFOutgoingReplyHandler.makeName(destinationImpl));
            }
        }
        if (this.replyToSAFContextName == null) {
            return;
        }
        if (string != null) {
            destinationImpl.setReferenceName(this.replyToSAFContextName + "@@" + string);
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Setting reference name to " + destinationImpl.getReferenceName());
            }
        } else if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Cannot find reference name for " + destinationImpl.getName());
        }
    }

    private static String makeName(DestinationImpl destinationImpl) {
        return destinationImpl.getApplicationName() + "!" + destinationImpl.getModuleName() + "!" + destinationImpl.getName();
    }

    public void setReplyToSAFRemoteContextName(String string) {
        this.replyToSAFContextName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newDestination(String string, DestinationImpl destinationImpl) {
        Map map = destinationTable;
        synchronized (map) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Adding " + string + " mapping to " + SAFOutgoingReplyHandler.makeName(destinationImpl) + " to table");
            }
            destinationTable.put(SAFOutgoingReplyHandler.makeName(destinationImpl), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(String string, DestinationImpl destinationImpl) {
        Map map = destinationTable;
        synchronized (map) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Removing " + SAFOutgoingReplyHandler.makeName(destinationImpl) + " from table");
            }
            destinationTable.remove(SAFOutgoingReplyHandler.makeName(destinationImpl));
        }
    }
}

