/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import weblogic.jms.JMSLogger;
import weblogic.jms.backend.BEBrowser;
import weblogic.jms.backend.BEConnectionConsumerImpl;
import weblogic.jms.backend.BEConsumerCreateRequest;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BEDestinationSecurityImpl;
import weblogic.jms.backend.BEQueueImpl;
import weblogic.jms.backend.BESession;
import weblogic.jms.backend.BESessionImpl;
import weblogic.jms.common.EntityName;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.WLMessage;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.saf.ErrorHandler;
import weblogic.jms.saf.JMSSAFManager;
import weblogic.jms.saf.SAFAgentAdmin;
import weblogic.jms.saf.SAFRemoteEndpointRuntimeMBeanImpl;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.management.runtime.SAFRemoteEndpointRuntimeMBean;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.RedirectionListener;
import weblogic.messaging.kernel.SendOptions;
import weblogic.messaging.kernel.Sequence;

public final class SAFQueueImpl
extends BEQueueImpl {
    private String errorHandlingName;
    private ErrorHandler errorHandler;
    private boolean updatedErrorHandler;
    private SAFAgentAdmin safAgent;
    private SAFRemoteEndpointRuntimeMBean safRuntimeMBean;
    private long timeToLiveDefault = -1L;
    private int nonPersistentQos = 1;
    private int persistentQos = 2;
    private static transient AuditableThreadLocal consumersAllowedThreadLocal = AuditableThreadLocalFactory.createThreadLocal();
    private String refreshedSequenceName;

    public SAFQueueImpl(SAFAgentAdmin sAFAgentAdmin, String string, boolean bl, EntityName entityName, String string2) throws JMSException {
        super(sAFAgentAdmin.getBackEnd(), string, bl, new BEDestinationSecurityImpl(entityName, string2));
        this.safAgent = sAFAgentAdmin;
        this.moduleName = entityName.getFullyQualifiedModuleName();
        this.refreshedSequenceName = this.refreshSequenceName(this.fullyQualifiedDestinationName);
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("Refreshed SAF sequence name is " + this.refreshedSequenceName);
        }
    }

    static void allowCreateConsumer() {
        consumersAllowedThreadLocal.set((Object)Boolean.TRUE);
    }

    static void disallowCreateConsumer() {
        consumersAllowedThreadLocal.set((Object)Boolean.FALSE);
    }

    protected BEConsumerImpl createConsumer(BESessionImpl bESessionImpl, boolean bl, BEConsumerCreateRequest bEConsumerCreateRequest) throws JMSException {
        this.checkConsumption("consumer");
        return super.createConsumer(bESessionImpl, bl, bEConsumerCreateRequest);
    }

    protected BEConnectionConsumerImpl createConnectionConsumer(JMSID jMSID, ServerSessionPool serverSessionPool, String string, String string2, String string3, boolean bl, int n, long l, boolean bl2, boolean bl3) throws JMSException {
        this.checkConsumption("connection consumer");
        return super.createConnectionConsumer(jMSID, serverSessionPool, string, string2, string3, bl, n, l, bl2, bl3);
    }

    public BEBrowser createBrowser(BESession bESession, String string) throws JMSException {
        this.checkConsumption("browser");
        return super.createBrowser(bESession, string);
    }

    private void checkConsumption(String string) throws JMSException {
        if (consumersAllowedThreadLocal.get() != Boolean.TRUE) {
            throw new JMSException("Cannot create " + string + " on imported " + "(store-and-forward) destination because it is not allowed to " + "receive messages from an imported destination");
        }
    }

    public void setTimeToLiveDefault(long l) {
        this.timeToLiveDefault = l;
    }

    protected int getSequenceMode(WLMessage wLMessage) {
        boolean bl;
        int n = ((MessageImpl)wLMessage).getJMSDeliveryMode();
        if (n == 1 && this.nonPersistentQos != 2) {
            return 0;
        }
        if (n == 2 && this.persistentQos != 2) {
            return 0;
        }
        boolean bl2 = this.checkForwarded(wLMessage);
        boolean bl3 = bl = wLMessage.getSAFSeqNumber() != 0L;
        if (!bl || !bl2) {
            return 1;
        }
        return super.getSequenceMode(bl, bl2);
    }

    protected String getSequenceName(WLMessage wLMessage) {
        String string = wLMessage.getSAFSequenceName();
        if (string != null) {
            return string;
        }
        return this.refreshedSequenceName;
    }

    private String versionedName(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSSS");
        return string + simpleDateFormat.format(new Date(this.getCreationTime()));
    }

    public SendOptions createSendOptions(long l, Sequence sequence, MessageImpl messageImpl) {
        SendOptions sendOptions = this.createSendOptionsInternal(l, sequence, messageImpl);
        if (this.timeToLiveDefault != -1L) {
            if (this.timeToLiveDefault == 0L) {
                sendOptions.setExpirationTime(0L);
            } else {
                long l2 = System.currentTimeMillis() + this.timeToLiveDefault;
                sendOptions.setExpirationTime(l2);
            }
        }
        return sendOptions;
    }

    public void expirationTimeReached(RedirectionListener.Info info, boolean bl) {
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("SAFQueueImpl's expirationTimeReached() is called");
        }
        this.errorHandler = this.getErrorHandler();
        if (this.errorHandler == null) {
            if (JMSDebug.JMSSAF.isDebugEnabled()) {
                JMSDebug.JMSSAF.debug("Error Handler == null, alreadyReported " + bl + " loggingEnabled " + this.safAgent.isLoggingEnabled());
            }
            if (!bl && this.safAgent.isLoggingEnabled()) {
                JMSLogger.logExpiredSAFMessageNoHeaderProperty((String)("'" + info.getMessage().getMessageID() + "'"));
            }
            ((SAFRemoteEndpointRuntimeMBeanImpl)this.safRuntimeMBean).updateFailedMessagesCount(1L);
            return;
        }
        int n = this.errorHandler.getPolicyAsInt();
        if (n != 4) {
            ((SAFRemoteEndpointRuntimeMBeanImpl)this.safRuntimeMBean).updateFailedMessagesCount(1L);
            try {
                this.errorHandler.handleFailure(info, this.getBackEnd().getName(), (MessageImpl)info.getMessage());
            }
            catch (KernelException kernelException) {
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    void initializeErrorHandling(String string) {
        this.errorHandlingName = string;
        this.errorHandler = this.getErrorHandler();
        if (this.errorHandler == null) {
            return;
        }
        Queue queue = this.getKernelQueue();
        try {
            if (this.errorHandler.getPolicyAsInt() == 4) {
                queue.setProperty("IgnoreExpiration", (Object)new Boolean(true));
            }
        }
        catch (KernelException kernelException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ErrorHandler getErrorHandler() {
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("Name = " + this.name + " ModuleName = " + this.moduleName + " ErrorHandlingName " + this.errorHandlingName);
        }
        if (this.errorHandlingName == null) {
            return null;
        }
        SAFQueueImpl sAFQueueImpl = this;
        synchronized (sAFQueueImpl) {
            if (!this.updatedErrorHandler) {
                this.errorHandler = JMSSAFManager.manager.getErrorHandler(JMSBeanHelper.getDecoratedName(this.moduleName, this.errorHandlingName));
                this.updatedErrorHandler = true;
            }
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("ErrorHandler= " + (this.errorHandler == null ? "null" : this.errorHandler.toString()));
        }
        return this.errorHandler;
    }

    synchronized void setSAFErrorHandlingName(String string) {
        this.errorHandlingName = string;
        this.updatedErrorHandler = false;
    }

    synchronized void setSAFRuntimeMBean(SAFRemoteEndpointRuntimeMBean sAFRemoteEndpointRuntimeMBean) {
        this.safRuntimeMBean = sAFRemoteEndpointRuntimeMBean;
    }

    void setNonPersistentQos(int n) {
        this.nonPersistentQos = n;
    }

    void setPersistentQos(int n) {
        this.persistentQos = n;
    }

    protected boolean clientSendResumeNeedsNewThread() {
        return true;
    }

    private String refreshSequenceName(String string) {
        String string2 = null;
        Queue queue = this.getKernelQueue();
        Collection collection = queue.getSequences();
        Iterator iterator = collection.iterator();
        String string3 = string;
        while (iterator.hasNext()) {
            Sequence sequence = (Sequence)iterator.next();
            if (!sequence.getName().contains(string) || sequence.getName().compareTo(string3) < 0) continue;
            string2 = string3 = sequence.getName();
        }
        if (string2 == null || this.isNewlyCreated()) {
            string2 = this.versionedName(string);
        }
        return string2;
    }
}

