/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.util.Date;
import javax.jms.JMSException;
import weblogic.jms.JMSLogger;
import weblogic.jms.backend.BEMessageManagementRuntimeDelegate;
import weblogic.jms.backend.BEQueueImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.forwarder.RuntimeHandler;
import weblogic.jms.saf.ErrorHandler;
import weblogic.jms.saf.JMSSAFManager;
import weblogic.jms.saf.SAFAgentRuntimeMBeanImpl;
import weblogic.jms.saf.SAFQueueImpl;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JMSRemoteEndpointRuntimeMBean;
import weblogic.messaging.kernel.Cursor;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.saf.OperationState;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFLogger;
import weblogic.messaging.saf.internal.RemoteEndpointRuntimeCommonAddition;
import weblogic.utils.StackTraceUtils;
import weblogic.work.WorkManager;

public class SAFRemoteEndpointRuntimeMBeanImpl
extends BEMessageManagementRuntimeDelegate
implements JMSRemoteEndpointRuntimeMBean,
RuntimeHandler,
Runnable {
    private final String url;
    private final BEQueueImpl delegate;
    private Queue kernelQueue;
    private ErrorHandler errorHandler;
    private long failedMessagesCount;
    private SAFAgentRuntimeMBeanImpl agentRuntime;
    private RemoteEndpointRuntimeCommonAddition addition;
    private long expireAllStartedTime;
    private WorkManager workManager;

    SAFRemoteEndpointRuntimeMBeanImpl(String string, String string2, SAFQueueImpl sAFQueueImpl, SAFAgentRuntimeMBeanImpl sAFAgentRuntimeMBeanImpl, ErrorHandler errorHandler) throws ManagementException {
        super(string, null, false, sAFQueueImpl);
        this.url = string2;
        this.kernelQueue = sAFQueueImpl.getKernelQueue();
        this.errorHandler = errorHandler;
        this.agentRuntime = sAFAgentRuntimeMBeanImpl;
        this.delegate = sAFQueueImpl;
        this.addition = new RemoteEndpointRuntimeCommonAddition();
        this.workManager = JMSSAFManager.manager.getWorkManager();
    }

    public String getURL() {
        return this.url;
    }

    public String getEndpointType() {
        return "JMS";
    }

    public synchronized void pauseIncoming() throws SAFException {
        try {
            this.delegate.pauseProduction(false);
        }
        catch (JMSException jMSException) {
            throw new SAFException(jMSException);
        }
        SAFLogger.logIncomingPauseOfRemoteEndpoint((String)this.name);
    }

    public synchronized void resumeIncoming() throws SAFException {
        try {
            this.delegate.resumeProduction(false);
        }
        catch (JMSException jMSException) {
            throw new SAFException(jMSException);
        }
        SAFLogger.logIncomingResumeOfRemoteEndpoint((String)this.name);
    }

    public synchronized boolean isPausedForIncoming() {
        return this.delegate.isProductionPaused();
    }

    public synchronized void pauseForwarding() throws SAFException {
        try {
            this.delegate.pauseConsumption(false);
        }
        catch (JMSException jMSException) {
            throw new SAFException(jMSException);
        }
        SAFLogger.logForwardingPauseOfRemoteEndpoint((String)this.name);
    }

    public synchronized void resumeForwarding() throws SAFException {
        try {
            this.delegate.resumeConsumption(false);
        }
        catch (JMSException jMSException) {
            throw new SAFException(jMSException);
        }
        SAFLogger.logForwardingResumeOfRemoteEndpoint((String)this.name);
    }

    public synchronized boolean isPausedForForwarding() {
        return this.delegate.isConsumptionPaused();
    }

    public void purge() throws SAFException {
        try {
            this.deleteMessages("");
        }
        catch (ManagementException managementException) {
            throw new SAFException(managementException.getMessage(), managementException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireAll() {
        SAFRemoteEndpointRuntimeMBeanImpl sAFRemoteEndpointRuntimeMBeanImpl = this;
        synchronized (sAFRemoteEndpointRuntimeMBeanImpl) {
            if (this.addition.getOperationState() == OperationState.RUNNING) {
                return;
            }
            this.addition.setOperationState(OperationState.RUNNING);
        }
        this.expireAllStartedTime = System.currentTimeMillis();
        this.workManager.schedule((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        Cursor cursor = null;
        if (JMSDebug.JMSSAF.isDebugEnabled()) {
            JMSDebug.JMSSAF.debug("ExpireAll(): kernelQueue=" + this.kernelQueue.getName() + " messagesCurrentCount = " + this.kernelQueue.getStatistics().getMessagesCurrent());
        }
        try {
            cursor = this.kernelQueue.createCursor(true, null, -1);
        }
        catch (KernelException kernelException) {
            kernelException.printStackTrace();
        }
        if (JMSDebug.JMSModule.isDebugEnabled()) {
            JMSDebug.JMSModule.debug("expireAll(): cursor.size() = " + (cursor == null ? 0 : cursor.size()));
        }
        int n = 0;
        Throwable throwable = null;
        if (cursor != null) {
            try {
                while ((object = cursor.next()) != null && ((MessageImpl)object.getMessage()).getJMSTimestamp() <= this.expireAllStartedTime) {
                    if (this.errorHandler != null) {
                        this.errorHandler.handleFailure(null, this.delegate.getBackEnd().getName(), (MessageImpl)object.getMessage());
                    }
                    ++n;
                    KernelRequest kernelRequest = this.kernelQueue.delete(object);
                    if (kernelRequest == null) continue;
                    kernelRequest.getResult();
                }
            }
            catch (KernelException kernelException) {
                throwable = kernelException;
            }
            catch (JMSException jMSException) {
                throwable = jMSException;
            }
        }
        this.updateFailedMessagesCount(n);
        object = this;
        synchronized (object) {
            if (throwable != null) {
                this.addition.setOperationState(OperationState.STOPPED);
            } else {
                this.addition.setOperationState(OperationState.COMPLETED);
            }
        }
    }

    public synchronized long getMessagesCurrentCount() {
        return this.delegate.getMessagesCurrentCount() + this.delegate.getMessagesPendingCount();
    }

    public synchronized long getMessagesPendingCount() {
        return this.delegate.getMessagesPendingCount();
    }

    public synchronized long getMessagesHighCount() {
        return this.delegate.getMessagesHighCount();
    }

    public synchronized long getMessagesReceivedCount() {
        return this.delegate.getMessagesReceivedCount();
    }

    public synchronized long getMessagesThresholdTime() {
        return this.delegate.getMessagesThresholdTime();
    }

    public synchronized long getBytesPendingCount() {
        return this.delegate.getBytesPendingCount();
    }

    public synchronized long getBytesCurrentCount() {
        return this.delegate.getBytesCurrentCount();
    }

    public synchronized long getBytesHighCount() {
        return this.delegate.getBytesHighCount();
    }

    public synchronized long getBytesReceivedCount() {
        return this.delegate.getBytesReceivedCount();
    }

    public synchronized long getBytesThresholdTime() {
        return this.delegate.getBytesThresholdTime();
    }

    public long getFailedMessagesTotal() {
        return this.failedMessagesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFailedMessagesCount(long l) {
        SAFRemoteEndpointRuntimeMBeanImpl sAFRemoteEndpointRuntimeMBeanImpl = this;
        synchronized (sAFRemoteEndpointRuntimeMBeanImpl) {
            this.failedMessagesCount += l;
        }
        this.agentRuntime.updateFailedMessagesCount(l);
    }

    public boolean isConnected() {
        return this.addition.isConnected();
    }

    private void updateLastTimeConnected(long l) {
        this.addition.updateLastTimeConnected(l);
    }

    private void updateLastTimeDisconnected(long l, Exception exception) {
        this.addition.updateLastTimeDisconnected(l, exception);
    }

    public void connected() {
        if (!this.isConnected()) {
            JMSLogger.logSAFForwarderConnected((String)this.url);
        }
        this.addition.connected();
    }

    public void disconnected(Exception exception) {
        if (this.isConnected()) {
            JMSLogger.logSAFForwarderDisconnected((String)this.url, (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
        }
        this.addition.disconnected(exception);
    }

    public long getDowntimeHigh() {
        return this.addition.getDowntimeHigh();
    }

    public long getDowntimeTotal() {
        return this.addition.getDowntimeTotal();
    }

    public long getUptimeHigh() {
        return this.addition.getUptimeHigh();
    }

    public long getUptimeTotal() {
        return this.addition.getUptimeTotal();
    }

    public synchronized Date getLastTimeConnected() {
        return this.addition.getLastTimeConnected();
    }

    public synchronized Date getLastTimeFailedToConnect() {
        return this.addition.getLastTimeFailedToConnect();
    }

    public Exception getLastException() {
        return this.addition.getLastException();
    }

    public String getOperationState() {
        return this.addition.getOperationState().toString();
    }

    public void setOperationState(OperationState operationState) {
        this.addition.setOperationState(operationState);
    }
}

