/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.util.HashMap;
import java.util.HashSet;
import weblogic.health.HealthState;
import weblogic.jms.saf.SAFAgentRuntimeMBeanAggregator;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.SAFAgentRuntimeMBean;
import weblogic.management.runtime.SAFRuntimeMBean;

public class SAFRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements SAFRuntimeMBean {
    private static final HashMap agents = new HashMap();

    SAFRuntimeMBeanImpl(String string) throws ManagementException {
        super(string, true);
    }

    public synchronized void addAgent(SAFAgentRuntimeMBeanAggregator sAFAgentRuntimeMBeanAggregator) {
        agents.put(sAFAgentRuntimeMBeanAggregator.getName(), sAFAgentRuntimeMBeanAggregator);
    }

    public synchronized void removeAgent(SAFAgentRuntimeMBeanAggregator sAFAgentRuntimeMBeanAggregator) {
        agents.remove(sAFAgentRuntimeMBeanAggregator.getName());
    }

    public synchronized SAFAgentRuntimeMBeanAggregator getAgent(String string) {
        return (SAFAgentRuntimeMBeanAggregator)agents.get(string);
    }

    public synchronized HealthState getHealthState() {
        int n = 0;
        HashSet<String> hashSet = new HashSet<String>();
        SAFAgentRuntimeMBean[] sAFAgentRuntimeMBeanArray = this.getAgents();
        for (int i = 0; i < sAFAgentRuntimeMBeanArray.length; ++i) {
            HealthState healthState = sAFAgentRuntimeMBeanArray[i].getHealthState();
            n = Math.max(healthState.getState(), n);
            String[] stringArray = healthState.getReasonCode();
            for (int j = 0; j < stringArray.length; ++j) {
                hashSet.add(stringArray[j]);
            }
        }
        String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        return new HealthState(n, stringArray);
    }

    public synchronized SAFAgentRuntimeMBean[] getAgents() {
        SAFAgentRuntimeMBean[] sAFAgentRuntimeMBeanArray = new SAFAgentRuntimeMBean[agents.size()];
        return agents.values().toArray(sAFAgentRuntimeMBeanArray);
    }
}

