/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf;

import java.security.AccessController;
import weblogic.health.HealthMonitorService;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.saf.SAFAgentDeployer;
import weblogic.jms.saf.SAFOutgoingReplyHandler;
import weblogic.jms.saf.SAFRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public class SAFService
extends AbstractServerService {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final SAFAgentDeployer safDeployer = new SAFAgentDeployer();
    private static SAFService singleton;
    private SAFRuntimeMBeanImpl runtimeMBean;

    public SAFService() throws ManagementException {
        singleton = this;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
        String string = runtimeAccess.getServerName() + ".saf";
        this.runtimeMBean = new SAFRuntimeMBeanImpl(string);
        runtimeAccess.getServerRuntime().setSAFRuntime(this.runtimeMBean);
        SAFOutgoingReplyHandler.init();
    }

    public static SAFService getSAFService() {
        return singleton;
    }

    public SAFRuntimeMBeanImpl getRuntimeMBean() {
        return this.runtimeMBean;
    }

    public SAFAgentDeployer getDeployer() {
        return this.safDeployer;
    }

    public void start() throws ServiceFailureException {
        HealthMonitorService.register(this.runtimeMBean.getName(), this.runtimeMBean, false);
        this.safDeployer.start();
    }

    public void stop() throws ServiceFailureException {
        this.safDeployer.stop();
        try {
            PrivilegedActionUtilities.unregister(this.runtimeMBean, KERNEL_ID);
        }
        catch (ManagementException managementException) {
            throw new ServiceFailureException((Throwable)managementException);
        }
    }

    public void halt() throws ServiceFailureException {
        this.stop();
    }

    static BackEnd getBackEnd(String string) {
        return JMSService.getJMSService().getBEDeployer().findBackEnd(string);
    }
}

