/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.saf.forwarder.internal;

import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import weblogic.jms.cache.CacheContextInfo;
import weblogic.jms.client.JMSProducer;
import weblogic.jms.common.DistributedDestinationImpl;
import weblogic.jms.deployer.DeployerConstants;
import weblogic.jms.forwarder.DestinationName;
import weblogic.jms.forwarder.SessionRuntimeContext;
import weblogic.jms.forwarder.dd.DDLoadBalancerDelegate;
import weblogic.jms.forwarder.dd.internal.DDInfoImpl;
import weblogic.jms.forwarder.dd.internal.DDLoadBalancerDelegateImpl;
import weblogic.jms.forwarder.internal.DestinationNameImpl;
import weblogic.jms.forwarder.internal.SessionRuntimeContextImpl;
import weblogic.jms.saf.forwarder.DestinationForwarder;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.work.WorkManager;

public class DestinationForwarderImpl
implements DestinationForwarder,
NakedTimerListener {
    private DestinationName destinationName;
    private CacheContextInfo remoteContextInfo;
    private String jmsConnectionFactoryName;
    private SessionRuntimeContext jmsSessionRuntimeContext;
    private JMSProducer messageProducer;
    private long forarderCreateTimerInterval = 10000L;
    private long forwarderCreateInitialDelay = 100000L;
    private TimerManager timerManager = TimerManagerFactory.getTimerManagerFactory().getTimerManager("weblogic.jms.JMSProducerTimer", (WorkManager)null);
    private Timer producerCreatePoller;
    private int destinationType;
    private Destination destination;
    private boolean isDistributedDestination;
    private HashMap nullDDForwarderMap = new HashMap();
    private DDExactlyOnceForwarder ddExactlyOnceForwarder;
    private boolean isInLocalCluster;

    public DestinationForwarderImpl(CacheContextInfo cacheContextInfo, String string, String string2, String string3, int n, String string4, String string5) {
        this(cacheContextInfo, string, string2, string3, n, 10000L, 100000L, string4, string5);
    }

    public DestinationForwarderImpl(CacheContextInfo cacheContextInfo, String string, String string2, String string3, int n, long l, long l2, String string4, String string5) {
        this.remoteContextInfo = cacheContextInfo;
        this.destinationName = new DestinationNameImpl(string3, string2);
        this.destinationType = n;
        if (string == null) {
            this.jmsConnectionFactoryName = DeployerConstants.DEFAULT_FACTORY_NAMES[0][0];
        }
        this.jmsConnectionFactoryName = string;
        this.forwarderCreateInitialDelay = l;
        this.forarderCreateTimerInterval = l2;
        this.createJMSProducer();
    }

    public DestinationForwarderImpl(CacheContextInfo cacheContextInfo, String string) {
        this(cacheContextInfo, string, 10000L, 100000L);
    }

    public DestinationForwarderImpl(CacheContextInfo cacheContextInfo, String string, long l, long l2) {
        this.remoteContextInfo = cacheContextInfo;
        this.jmsConnectionFactoryName = string;
        this.forwarderCreateInitialDelay = l;
        this.forarderCreateTimerInterval = l2;
    }

    public int getDestinationType() {
        return this.destinationType;
    }

    public long getForwarderCreateTimerInterval() {
        return this.forarderCreateTimerInterval;
    }

    public void setForwarderCreateTimerInterval(long l) {
        this.forarderCreateTimerInterval = l;
        if (this.producerCreatePoller != null) {
            this.timerManager.stop();
            this.startProducerCreatePoller();
        }
    }

    public long getForwarderCreateInitialDelay() {
        return this.forwarderCreateInitialDelay;
    }

    public void setForwarderCreateInitialDelay(long l) {
        this.forwarderCreateInitialDelay = l;
        if (this.producerCreatePoller != null) {
            this.timerManager.stop();
            this.startProducerCreatePoller();
        }
    }

    private void createJMSProducer() {
        try {
            this.jmsSessionRuntimeContext = new SessionRuntimeContextImpl(this.remoteContextInfo.getProviderUrl(), this.remoteContextInfo.getUserName(), this.remoteContextInfo.getPassword(), this.jmsConnectionFactoryName);
            Session session = this.jmsSessionRuntimeContext.getJMSSession();
            if (this.destinationName != null) {
                this.initDestination(this.jmsSessionRuntimeContext);
            }
            Destination destination = null;
            if (this.destination != null && !(this.destination instanceof DistributedDestinationImpl)) {
                destination = this.destination;
            }
            if (this.producerCreatePoller != null) {
                this.producerCreatePoller.cancel();
            }
            this.messageProducer = (JMSProducer)session.createProducer(destination);
        }
        catch (NamingException namingException) {
            this.startProducerCreatePoller();
        }
        catch (JMSException jMSException) {
            this.startProducerCreatePoller();
        }
    }

    private void startProducerCreatePoller() {
        this.producerCreatePoller = this.timerManager.schedule((TimerListener)this, this.forwarderCreateInitialDelay, this.forarderCreateTimerInterval);
    }

    private void initDestination(SessionRuntimeContext sessionRuntimeContext) throws NamingException, JMSException {
        Object object;
        String string = this.destinationName.getJNDIName();
        if (string != null) {
            Context context = sessionRuntimeContext.getProviderContext();
            object = (Destination)context.lookup(string);
        } else {
            String string2 = this.destinationName.getConfigName();
            Session session = sessionRuntimeContext.getJMSSession();
            object = this.destinationType == 1 ? session.createQueue(string2) : session.createTopic(string2);
        }
        this.destination = object;
        this.isDistributedDestination = object instanceof DistributedDestinationImpl;
        if (this.isDistributedDestination) {
            this.findOrCreateDDExactlyOnceForwardHandler((Destination)object);
        }
    }

    private DDExactlyOnceForwarder findOrCreateDDExactlyOnceForwardHandler(Destination destination) throws JMSException {
        DDExactlyOnceForwarder dDExactlyOnceForwarder = (DDExactlyOnceForwarder)this.nullDDForwarderMap.get(destination);
        if (dDExactlyOnceForwarder == null) {
            dDExactlyOnceForwarder = new DDExactlyOnceForwarder((DistributedDestinationImpl)destination);
            this.nullDDForwarderMap.put(destination, dDExactlyOnceForwarder);
        }
        return dDExactlyOnceForwarder;
    }

    public void timerExpired(Timer timer) {
        this.producerCreatePoller.cancel();
        this.createJMSProducer();
    }

    public long getTimeToDeliver() throws JMSException {
        return this.messageProducer.getTimeToDeliver();
    }

    public void setTimeToDeliver(long l) throws JMSException {
        this.messageProducer.setTimeToDeliver(l);
    }

    public int getRedeliveryLimit() throws JMSException {
        return this.messageProducer.getRedeliveryLimit();
    }

    public void setRedeliveryLimit(int n) throws JMSException {
        this.messageProducer.setRedeliveryLimit(n);
    }

    public long getSendTimeout() throws JMSException {
        return this.messageProducer.getSendTimeout();
    }

    public void setSendTimeout(long l) throws JMSException {
        this.messageProducer.setSendTimeout(l);
    }

    public String getUnitOfOrder() throws JMSException {
        return this.messageProducer.getUnitOfOrder();
    }

    public void setUnitOfOrder(String string) throws JMSException {
        this.messageProducer.setUnitOfOrder(string);
    }

    public void setUnitOfOrder() throws JMSException {
        this.messageProducer.setUnitOfOrder();
    }

    public void forward(Message message, int n, int n2, long l) throws JMSException {
        if (this.isDistributedDestination) {
            this.ddExactlyOnceForwarder.forward(message, n, n2, l);
        } else {
            this.messageProducer.forward(message, n, n2, l);
        }
    }

    public void forward(Message message) throws JMSException {
        if (this.isDistributedDestination) {
            this.ddExactlyOnceForwarder.forward(message);
        } else {
            this.messageProducer.forward(message);
        }
    }

    public void forward(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        if (this.isDistributedDestination) {
            throw new JMSException(" Cannot switch destinations for non null WLForwarder");
        }
        if (destination instanceof DistributedDestinationImpl) {
            DDExactlyOnceForwarder dDExactlyOnceForwarder = this.findOrCreateDDExactlyOnceForwardHandler(destination);
            dDExactlyOnceForwarder.forward(message, n, n2, l);
        } else {
            this.messageProducer.forward(destination, message, n, n2, l);
        }
    }

    public void forward(Destination destination, Message message) throws JMSException {
        if (this.isDistributedDestination) {
            throw new JMSException(" Cannot switch destinations for non null WLMessageProducer");
        }
        if (destination instanceof DistributedDestinationImpl) {
            DDExactlyOnceForwarder dDExactlyOnceForwarder = this.findOrCreateDDExactlyOnceForwardHandler(destination);
            dDExactlyOnceForwarder.forward(message);
        } else {
            this.messageProducer.forward(destination, message);
        }
    }

    public void setCompressionThreshold(int n) throws JMSException {
        this.messageProducer.setCompressionThreshold(n);
    }

    public int getCompressionThreshold() throws JMSException {
        return this.messageProducer.getCompressionThreshold();
    }

    public void setDeliveryMode(int n) throws JMSException {
        this.messageProducer.setDeliveryMode(n);
    }

    public int getDeliveryMode() throws JMSException {
        return this.messageProducer.getDeliveryMode();
    }

    public void setPriority(int n) throws JMSException {
        this.messageProducer.setPriority(n);
    }

    public int getPriority() throws JMSException {
        return this.messageProducer.getPriority();
    }

    public void setTimeToLive(long l) throws JMSException {
        this.messageProducer.setTimeToLive(l);
    }

    public long getTimeToLive() throws JMSException {
        return this.messageProducer.getTimeToLive();
    }

    public Destination getDestination() throws JMSException {
        return this.messageProducer.getDestination();
    }

    public void close() throws JMSException {
        this.messageProducer.close();
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        this.messageProducer.setDisableMessageID(bl);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.messageProducer.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        this.messageProducer.setDisableMessageTimestamp(bl);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.messageProducer.getDisableMessageTimestamp();
    }

    public void send(Message message) throws JMSException {
        if (this.isDistributedDestination) {
            this.ddExactlyOnceForwarder.forward(message);
        } else {
            this.messageProducer.send(message);
        }
    }

    public void send(Message message, int n, int n2, long l) throws JMSException {
        if (this.isDistributedDestination) {
            this.ddExactlyOnceForwarder.send(message, n, n2, l);
        } else {
            this.messageProducer.send(message, n, n2, l);
        }
    }

    public void send(Destination destination, Message message, int n, int n2, long l) throws JMSException {
        if (this.isDistributedDestination) {
            throw new JMSException(" Cannot switch destinations for non null WLForwarder");
        }
        if (destination instanceof DistributedDestinationImpl) {
            DDExactlyOnceForwarder dDExactlyOnceForwarder = this.findOrCreateDDExactlyOnceForwardHandler(destination);
            dDExactlyOnceForwarder.send(message, n, n2, l);
        } else {
            this.messageProducer.send(destination, message, n, n2, l);
        }
    }

    public void send(Destination destination, Message message) throws JMSException {
        if (this.isDistributedDestination) {
            throw new JMSException(" Cannot switch destinations for non null WLMessageProducer");
        }
        if (destination instanceof DistributedDestinationImpl) {
            DDExactlyOnceForwarder dDExactlyOnceForwarder = this.findOrCreateDDExactlyOnceForwardHandler(destination);
            dDExactlyOnceForwarder.send(message);
        } else {
            this.messageProducer.send(destination, message);
        }
    }

    private class DDExactlyOnceForwarder {
        private DistributedDestinationImpl destination;
        private DDLoadBalancerDelegate ddLoadBalancerDelegate;

        DDExactlyOnceForwarder(DistributedDestinationImpl distributedDestinationImpl) throws JMSException {
            this.destination = distributedDestinationImpl;
            DDInfoImpl dDInfoImpl = new DDInfoImpl(distributedDestinationImpl.getDDJNDIName(), distributedDestinationImpl.getName(), distributedDestinationImpl.getDestinationInstanceType(), distributedDestinationImpl.getApplicationName(), distributedDestinationImpl.getModuleName(), distributedDestinationImpl.getLoadBalancingPolicy(), distributedDestinationImpl.getMessageForwardingPolicy());
            this.ddLoadBalancerDelegate = new DDLoadBalancerDelegateImpl(DestinationForwarderImpl.this.jmsSessionRuntimeContext, dDInfoImpl, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void forward(Message message, int n, int n2, long l) throws JMSException {
            DDLoadBalancerDelegate dDLoadBalancerDelegate = this.ddLoadBalancerDelegate;
            synchronized (dDLoadBalancerDelegate) {
                try {
                    Destination destination = this.ddLoadBalancerDelegate.loadBalance();
                    DestinationForwarderImpl.this.messageProducer.forward(destination, message, n, n2, l);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void forward(Message message) throws JMSException {
            DDLoadBalancerDelegate dDLoadBalancerDelegate = this.ddLoadBalancerDelegate;
            synchronized (dDLoadBalancerDelegate) {
                try {
                    Destination destination = this.ddLoadBalancerDelegate.loadBalance();
                    DestinationForwarderImpl.this.messageProducer.forward(destination, message);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(Message message, int n, int n2, long l) throws JMSException {
            DDLoadBalancerDelegate dDLoadBalancerDelegate = this.ddLoadBalancerDelegate;
            synchronized (dDLoadBalancerDelegate) {
                try {
                    Destination destination = this.ddLoadBalancerDelegate.loadBalance();
                    DestinationForwarderImpl.this.messageProducer.send(destination, message, n, n2, l);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(Message message) throws JMSException {
            DDLoadBalancerDelegate dDLoadBalancerDelegate = this.ddLoadBalancerDelegate;
            synchronized (dDLoadBalancerDelegate) {
                try {
                    Destination destination = this.ddLoadBalancerDelegate.loadBalance();
                    DestinationForwarderImpl.this.messageProducer.send(destination, message);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

