/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient;

import java.io.File;
import javax.jms.JMSException;
import javax.naming.Context;
import org.w3c.dom.Document;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.extensions.ClientSAF;
import weblogic.jms.safclient.ClientSAFManager;
import weblogic.jms.safclient.MessageMigrator;
import weblogic.jms.safclient.admin.ConfigurationUtils;
import weblogic.jms.safclient.admin.PersistentStoreBean;
import weblogic.jms.safclient.agent.AgentManager;
import weblogic.jms.safclient.jndi.ContextImpl;
import weblogic.jms.safclient.store.StoreUtils;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.transaction.TransactionHelper;

public final class ClientSAFDelegate {
    private Object lock = new Object();
    private boolean closed = true;
    private AgentManager agentManager;
    private ClientSAF userObj;
    private ContextImpl context;
    private File rootDirectory;

    ClientSAFDelegate(ClientSAF clientSAF) {
        this.userObj = clientSAF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discover(Document document, File file, String string, long l) throws JMSException {
        TransactionHelper.pushTransactionHelper((TransactionHelper)ClientSAFManager.getTxHelper());
        try {
            this.initStore(document, file);
            this.context = new ContextImpl(this.userObj, document, this);
            MessageMigrator.discover(file, StoreUtils.getStore(file), this.context, string, l);
        }
        finally {
            TransactionHelper.popTransactionHelper();
            PersistentStoreXA persistentStoreXA = StoreUtils.getStore(file);
            if (persistentStoreXA != null) {
                block9: {
                    try {
                        persistentStoreXA.close();
                    }
                    catch (Throwable throwable) {
                        if (!JMSDebug.JMSCommon.isDebugEnabled()) break block9;
                        JMSDebug.JMSCommon.debug("Failed to close the store:" + throwable.getMessage());
                    }
                }
                StoreUtils.removeStore(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(Document document, File file, char[] cArray) throws JMSException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                return;
            }
            this.closed = false;
        }
        this.rootDirectory = file;
        TransactionHelper.pushTransactionHelper((TransactionHelper)ClientSAFManager.getTxHelper());
        boolean bl = false;
        try {
            this.initStore(document, file);
            this.context = new ContextImpl(this.userObj, document, this);
            MessageMigrator.migrateMessagesIfNecessary(file, StoreUtils.getStore(file), this.context);
            this.agentManager = new AgentManager(document, this.context, cArray, file);
            bl = true;
        }
        finally {
            TransactionHelper.popTransactionHelper();
            if (!bl) {
                this.close();
            }
        }
    }

    private void initStore(Document document, File file) throws JMSException {
        PersistentStoreBean persistentStoreBean = ConfigurationUtils.getPersistentStore(document);
        File file2 = new File(persistentStoreBean.getStoreDirectory());
        if (!file2.isAbsolute()) {
            file2 = new File(file, persistentStoreBean.getStoreDirectory());
        }
        if (file2.exists() && !file2.isDirectory()) {
            throw new JMSException("Store directory " + file2.getAbsolutePath() + " must be a directory");
        }
        StoreUtils.initStores(file, file2, persistentStoreBean.getSynchronousWritePolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean close() {
        Object object = this.lock;
        synchronized (object) {
            PersistentStoreXA persistentStoreXA;
            if (this.closed) {
                return false;
            }
            this.closed = true;
            if (this.context != null) {
                try {
                    this.context.shutdown(new JMSException("The client SAF system is being closed normally"));
                }
                catch (Throwable throwable) {
                    System.out.println(throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
            if (this.agentManager != null) {
                try {
                    this.agentManager.shutdown();
                }
                catch (Throwable throwable) {
                    System.out.println(throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
            if ((persistentStoreXA = StoreUtils.getStore(this.rootDirectory)) != null) {
                block13: {
                    try {
                        persistentStoreXA.close();
                    }
                    catch (Throwable throwable) {
                        if (!JMSDebug.JMSCommon.isDebugEnabled()) break block13;
                        JMSDebug.JMSCommon.debug("Failed to close the store:" + throwable.getMessage());
                    }
                }
                StoreUtils.removeStore(this.rootDirectory);
            }
            return true;
        }
    }

    ClientSAF getUserObj() {
        return this.userObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpened() {
        Object object = this.lock;
        synchronized (object) {
            return !this.closed;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public AgentManager getAgentManager() {
        return this.agentManager;
    }

    public TransactionHelper getTransactionHelper() {
        return ClientSAFManager.getTxHelper();
    }
}

