/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import weblogic.jms.extensions.ClientSAF;
import weblogic.jms.extensions.ClientSAFDuplicateException;
import weblogic.jms.safclient.ClientSAFDelegate;
import weblogic.jms.safclient.ClientSAFManager;

public final class ClientSAFImpl
implements ClientSAF {
    private File rootDirectory;
    private Document document;
    private ClientSAFDelegate delegate;

    public ClientSAFImpl(File file, InputStream inputStream) throws ClientSAFDuplicateException, JMSException {
        DocumentBuilder documentBuilder;
        this.rootDirectory = file;
        this.delegate = ClientSAFManager.getManager().getDelegate(this.rootDirectory);
        if (this.delegate != null) {
            throw new ClientSAFDuplicateException(this.delegate.getUserObj());
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new weblogic.jms.common.JMSException(parserConfigurationException);
        }
        try {
            this.document = documentBuilder.parse(inputStream);
        }
        catch (SAXException sAXException) {
            throw new weblogic.jms.common.JMSException(sAXException);
        }
        catch (IOException iOException) {
            throw new weblogic.jms.common.JMSException(iOException);
        }
        this.delegate = ClientSAFManager.getManager().createDelegate(this.rootDirectory, this);
    }

    public void open(char[] cArray) throws JMSException {
        this.delegate.open(this.document, this.rootDirectory, cArray);
    }

    public void discover(String string, long l) throws JMSException {
        this.delegate.discover(this.document, this.rootDirectory, string, l);
    }

    public void close() {
        if (this.delegate.close()) {
            ClientSAFManager.getManager().removeDelegate(this.rootDirectory);
        }
    }

    public boolean isOpen() {
        return this.delegate.isOpened();
    }

    public Context getContext() {
        return this.delegate.getContext();
    }
}

