/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient;

import java.io.File;
import java.util.HashMap;
import weblogic.jms.common.CrossDomainSecurityManager;
import weblogic.jms.extensions.ClientSAF;
import weblogic.jms.safclient.ClientSAFDelegate;
import weblogic.jms.safclient.transaction.jta.SimpleTransactionHelper;
import weblogic.jms.safclient.transaction.jta.SimpleTransactionManager;
import weblogic.kernel.KernelInitializer;

public final class ClientSAFManager {
    private static ClientSAFManager singleton;
    private static boolean properlyInitialized;
    private static AssertionError initializationError;
    private static SimpleTransactionHelper clientSAFTxHelper;
    private HashMap delegates = new HashMap();

    private static void initialize() throws AssertionError {
        CrossDomainSecurityManager.ensureSubjectManagerInitialized();
        KernelInitializer.initializeWebLogicKernel();
        clientSAFTxHelper = new SimpleTransactionHelper(new SimpleTransactionManager());
    }

    static ClientSAFManager getManager() {
        if (!properlyInitialized) {
            throw initializationError;
        }
        if (singleton != null) {
            return singleton;
        }
        singleton = new ClientSAFManager();
        return singleton;
    }

    private ClientSAFManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientSAFDelegate createDelegate(File file, ClientSAF clientSAF) {
        HashMap hashMap = this.delegates;
        synchronized (hashMap) {
            ClientSAFDelegate clientSAFDelegate = (ClientSAFDelegate)this.delegates.get(file);
            if (clientSAFDelegate != null) {
                return clientSAFDelegate;
            }
            clientSAFDelegate = new ClientSAFDelegate(clientSAF);
            this.delegates.put(file, clientSAFDelegate);
            return clientSAFDelegate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientSAFDelegate getDelegate(File file) {
        HashMap hashMap = this.delegates;
        synchronized (hashMap) {
            return (ClientSAFDelegate)this.delegates.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDelegate(File file) {
        HashMap hashMap = this.delegates;
        synchronized (hashMap) {
            this.delegates.remove(file);
        }
    }

    public static SimpleTransactionHelper getTxHelper() {
        return clientSAFTxHelper;
    }

    static {
        properlyInitialized = false;
        try {
            ClientSAFManager.initialize();
            properlyInitialized = true;
        }
        catch (AssertionError assertionError) {
            initializationError = assertionError;
        }
    }
}

