/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jms.JMSException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.WLMessage;
import weblogic.jms.safclient.admin.ConfigurationUtils;
import weblogic.jms.safclient.agent.AgentManager;
import weblogic.jms.safclient.jndi.ContextImpl;
import weblogic.messaging.Message;
import weblogic.messaging.kernel.Cursor;
import weblogic.messaging.kernel.Kernel;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.SendOptions;
import weblogic.messaging.kernel.Sequence;
import weblogic.messaging.kernel.internal.KernelImpl;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class MessageMigrator {
    private static String SAFCLIENT_KERNEL_PREFIX = "weblogic.messaging.ClientSAFAgent";
    private static String SAFCLIENT_KERNEL_NAME_PREFIX = "ClientSAFAgent";
    private static String DEFAULT_CUTOFF_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static SimpleDateFormat CUTOFF_TIME_FORMAT = null;
    public static final boolean revertBugFix;
    private static Map<File, Boolean> migrationDone;
    private PersistentStoreXA pStore;
    private ContextImpl context;
    private File pagingDirectory;
    private List<Kernel> oldKernels = new ArrayList<Kernel>();
    private Kernel kernel0;
    private Queue queue0;
    private Sequence sequence0;
    private int migrateTotal = 0;

    MessageMigrator(File file, PersistentStoreXA persistentStoreXA, ContextImpl contextImpl) {
        this.pStore = persistentStoreXA;
        this.context = contextImpl;
        this.pagingDirectory = new File(file, "paging");
    }

    static void migrateMessagesIfNecessary(File file, PersistentStoreXA persistentStoreXA, ContextImpl contextImpl) throws JMSException {
        if (revertBugFix) {
            return;
        }
        boolean bl = Boolean.valueOf(System.getProperty("weblogic.jms.safclient.MigrateExistingMessages", "true"));
        if (!bl) {
            return;
        }
        Boolean bl2 = migrationDone.get(file);
        if (bl2 != null && bl2.booleanValue()) {
            return;
        }
        String string = System.getProperty("weblogic.jms.safclient.MigrationCutoffTime");
        long l = -1L;
        if (string != null) {
            try {
                l = CUTOFF_TIME_FORMAT.parse(string).getTime();
            }
            catch (ParseException parseException) {
                MessageMigrator.throwJMSException(parseException, "The cutoff time property " + string + " is not of " + CUTOFF_TIME_FORMAT + " format");
            }
        }
        MessageMigrator messageMigrator = new MessageMigrator(file, persistentStoreXA, contextImpl);
        messageMigrator.migrateMessages(l);
        migrationDone.put(file, new Boolean(true));
    }

    static void discover(File file, PersistentStoreXA persistentStoreXA, ContextImpl contextImpl, String string, long l) throws JMSException {
        File file2 = string == null || string.equals("") ? new File(file, "SAF_DISCOVERY") : new File(string);
        MessageMigrator messageMigrator = new MessageMigrator(file, persistentStoreXA, contextImpl);
        messageMigrator.discoverLocalSAF(file2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverLocalSAF(File file, long l) throws JMSException {
        PrintStream printStream = null;
        try {
            if (file == null) {
                printStream = System.out;
            } else {
                if (!file.exists()) {
                    file.createNewFile();
                }
                printStream = new PrintStream(file);
            }
        }
        catch (IOException iOException) {
            MessageMigrator.throwJMSException(iOException, "Error in open discovery file " + file);
        }
        try {
            this.printDiscovery(printStream, 0, "Client SAF discovery:");
            this.settlePagingDirectory();
            this.openKernels();
            Map map = this.context.getDestinationMap();
            for (Object k : map.keySet()) {
                String string = (String)k;
                for (Object k2 : ((Map)map.get(string)).keySet()) {
                    this.discoverDestination(string, (String)k2, l, printStream, 1);
                }
            }
        }
        catch (JMSException jMSException) {
            this.printDiscovery(printStream, 0, "\nEncouter error during discovery:" + jMSException.getMessage());
        }
        finally {
            this.closeKernels();
            if (!printStream.equals(System.out)) {
                printStream.close();
            }
        }
        System.out.println("Client SAF discovery has been written to file " + file);
    }

    private void discoverDestination(String string, String string2, long l, PrintStream printStream, int n) {
        this.printDiscovery(printStream, n, "Group:" + string + ", destination:" + string2);
        if (this.kernel0 != null) {
            this.discoverKernelQueue(this.kernel0, string, string2, l, printStream, n + 1);
        }
        for (Kernel kernel : this.oldKernels) {
            this.discoverKernelQueue(kernel, string, string2, l, printStream, n + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverKernelQueue(Kernel kernel, String string, String string2, long l, PrintStream printStream, int n) {
        String string3 = "(group:" + string + ", destination:" + string2 + ")";
        Cursor cursor = null;
        try {
            Queue queue = this.openKernelQueue(kernel, string, string2);
            if (queue == null) {
                this.printDiscovery(printStream, n, "Kernel " + kernel.getName() + ": No kernel queue was created for " + string3);
                return;
            }
            this.printDiscovery(printStream, n, "Kernel " + kernel.getName() + ": queue " + queue.getName() + " was created for " + string3);
            cursor = queue.createCursor(true, null, 1073);
            this.printDiscovery(printStream, n + 1, "Total message in kernel queue " + cursor.size());
            MessageElement messageElement = null;
            MessageElement messageElement2 = null;
            MessageElement messageElement3 = null;
            int n2 = 0;
            int n3 = 0;
            while ((messageElement = cursor.next()) != null) {
                if (n2 == 0) {
                    messageElement2 = messageElement;
                } else {
                    messageElement3 = messageElement;
                }
                ++n2;
                if (((javax.jms.Message)messageElement.getMessage()).getJMSTimestamp() >= l) continue;
                ++n3;
            }
            String string4 = "No cutoff time is specified";
            if (l > 0L) {
                string4 = "The number of messages before cutoff time is " + n3;
            }
            this.printDiscovery(printStream, n + 1, string4);
            if (messageElement2 != null) {
                this.printDiscovery(printStream, n + 1, "The first message in this kernel queue:");
                this.discoverMessage(messageElement2, printStream, n + 1);
            }
            if (messageElement3 != null) {
                this.printDiscovery(printStream, n + 1, "The last message in this kernel queue:");
                this.discoverMessage(messageElement3, printStream, n + 1);
            }
        }
        catch (Throwable throwable) {
            this.printDiscovery(printStream, n, "Encounter error when discovery " + string3 + " in kernel " + kernel.getName());
            this.printDiscovery(printStream, n, "Error: " + throwable.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private void discoverMessage(MessageElement messageElement, PrintStream printStream, int n) {
        if (messageElement == null) {
            return;
        }
        WLMessage wLMessage = (WLMessage)messageElement.getMessage();
        try {
            this.printDiscovery(printStream, n + 1, "JMSMessageID=" + wLMessage.getJMSMessageID());
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            this.printDiscovery(printStream, n + 1, "JMSCorrelationID=" + wLMessage.getJMSCorrelationID());
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            this.printDiscovery(printStream, n + 1, "JMSTimestamp=" + CUTOFF_TIME_FORMAT.format(new Date(wLMessage.getJMSTimestamp())));
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.printDiscovery(printStream, n + 1, "SAFSequenceName=" + messageElement.getSequence().getName());
        this.printDiscovery(printStream, n + 1, "SAFSeqNumber=" + messageElement.getSequenceNum());
        this.printDiscovery(printStream, n + 1, "UnitOfOrder=" + wLMessage.getUnitOfOrder());
    }

    private void printDiscovery(PrintStream printStream, int n, String string) {
        for (int i = 0; i < n; ++i) {
            printStream.print("    ");
        }
        printStream.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateMessages(long l) throws JMSException {
        String string = "NONE";
        try {
            this.settlePagingDirectory();
            this.openKernels();
            if (this.oldKernels.size() == 0) {
                return;
            }
            if (this.kernel0 == null) {
                this.kernel0 = this.openKernel(SAFCLIENT_KERNEL_NAME_PREFIX + "0");
            }
            string = "PARTIAL";
            Map map = this.context.getDestinationMap();
            for (Object k : map.keySet()) {
                String string2 = (String)k;
                for (Object k2 : ((Map)map.get(string2)).keySet()) {
                    this.migrateDestination(string2, (String)k2, l);
                }
            }
            string = "COMPLETE";
        }
        finally {
            this.closeKernels();
            if (string.equals("COMPLETE")) {
                System.out.println("The message migration was successfully done. The total messages migrated was " + this.migrateTotal);
            } else if (string.equals("PARTIAL")) {
                System.out.println("The message migration was partially done. The total messages migrated was " + this.migrateTotal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateDestination(String string, String string2, long l) throws JMSException {
        this.setupKernelQueue0(string, string2, l);
        for (Kernel kernel : this.oldKernels) {
            Queue queue = this.openKernelQueue(kernel, string, string2);
            if (queue == null) continue;
            Cursor cursor = null;
            try {
                cursor = queue.createCursor(true, null, 1073);
                MessageElement messageElement = null;
                while ((messageElement = cursor.next()) != null) {
                    if (l > 0L && ((javax.jms.Message)messageElement.getMessage()).getJMSTimestamp() < l) {
                        queue.delete(messageElement);
                        continue;
                    }
                    this.moveOneMessageToQueue0(messageElement, queue);
                }
            }
            catch (KernelException kernelException) {
                MessageMigrator.throwJMSException(kernelException, "Failed to migrate message for group:" + string + ", destination:" + string2);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.deleteKernelQueue(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveOneMessageToQueue0(MessageElement messageElement, Queue queue) throws JMSException {
        MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
        SendOptions sendOptions = new SendOptions();
        sendOptions.setPersistent(messageImpl.getJMSDeliveryMode() == 2);
        int n = messageImpl.getJMSRedeliveryLimit();
        if (n >= 0) {
            sendOptions.setRedeliveryLimit(n);
        }
        sendOptions.setExpirationTime(messageImpl.getJMSExpiration());
        sendOptions.setDeliveryTime(messageImpl.getJMSDeliveryTime());
        sendOptions.setSequence(this.sequence0);
        ClientTransactionManager clientTransactionManager = TransactionHelper.getTransactionHelper().getTransactionManager();
        boolean bl = false;
        try {
            clientTransactionManager.begin();
            bl = true;
            KernelRequest kernelRequest = this.queue0.send((Message)messageImpl, sendOptions);
            if (kernelRequest != null) {
                kernelRequest.getResult();
            }
            if ((kernelRequest = queue.delete(messageElement)) != null) {
                kernelRequest.getResult();
            }
            clientTransactionManager.commit();
            bl = false;
            ++this.migrateTotal;
        }
        catch (Throwable throwable) {
            MessageMigrator.throwJMSException(throwable, "Failed to move one message to from other kernel queue to kernel0 queue");
        }
        finally {
            block16: {
                if (bl) {
                    try {
                        clientTransactionManager.rollback();
                    }
                    catch (Throwable throwable) {
                        if (!JMSDebug.JMSCommon.isDebugEnabled()) break block16;
                        JMSDebug.JMSCommon.debug("Failed to rollback the migration transaction:" + throwable.getMessage());
                    }
                }
            }
        }
    }

    private void settlePagingDirectory() throws JMSException {
        if (!this.pagingDirectory.exists()) {
            if (!this.pagingDirectory.mkdirs()) {
                throw new JMSException("Failed to create paging directory " + this.pagingDirectory.getAbsolutePath());
            }
        } else if (!this.pagingDirectory.isDirectory()) {
            throw new JMSException("The file " + this.pagingDirectory.getAbsolutePath() + " must be a directory, it will be used for the paging store");
        }
    }

    private Queue openKernelQueue(Kernel kernel, String string, String string2) throws JMSException {
        String string3 = AgentManager.constructDestinationName(string, string2);
        Queue queue = kernel.findQueue(string3);
        if (queue != null) {
            try {
                queue.resume(16384);
            }
            catch (KernelException kernelException) {
                MessageMigrator.throwJMSException(kernelException, "Failed to resume the kernel queue " + string3 + " of kernel " + kernel.getName());
            }
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupKernelQueue0(String string, String string2, long l) throws JMSException {
        Cursor cursor;
        String string3;
        this.queue0 = this.openKernelQueue(this.kernel0, string, string2);
        if (this.queue0 == null) {
            string3 = AgentManager.constructDestinationName(string, string2);
            cursor = new HashMap();
            cursor.put("Durable", new Boolean(true));
            cursor.put("MaximumMessageSize", new Integer(Integer.MAX_VALUE));
            try {
                this.queue0 = this.kernel0.createQueue(string3, (Map)cursor);
            }
            catch (KernelException kernelException) {
                MessageMigrator.throwJMSException(kernelException, "Failed to create the kernel queue " + string3 + " of kernel0");
            }
            try {
                this.queue0.resume(16384);
            }
            catch (KernelException kernelException) {
                MessageMigrator.throwJMSException(kernelException, "Failed to resume the kernel queue " + string3 + " of kernel0");
            }
        }
        string3 = ConfigurationUtils.getSequenceNameFromQueue(this.queue0);
        try {
            this.sequence0 = this.queue0.findOrCreateSequence(string3, 1);
        }
        catch (KernelException kernelException) {
            MessageMigrator.throwJMSException(kernelException, "Failed to create sequence " + string3 + " for queue " + this.queue0.getName());
        }
        if (l > 0L) {
            cursor = null;
            try {
                cursor = this.queue0.createCursor(true, null, 1073);
                MessageElement messageElement = null;
                while ((messageElement = cursor.next()) != null) {
                    if (((javax.jms.Message)messageElement.getMessage()).getJMSTimestamp() >= l) continue;
                    this.queue0.delete(messageElement);
                }
            }
            catch (KernelException kernelException) {
                MessageMigrator.throwJMSException(kernelException, "Failed to cleanup queue0 based on the cutoff time");
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    private void deleteKernelQueue(Queue queue) {
        block2: {
            try {
                KernelRequest kernelRequest = new KernelRequest();
                queue.delete(kernelRequest);
                kernelRequest.getResult();
            }
            catch (KernelException kernelException) {
                if (!JMSDebug.JMSCommon.isDebugEnabled()) break block2;
                JMSDebug.JMSCommon.debug("Failed to delete kernel queue " + queue.getName() + " with error:" + kernelException.getMessage());
            }
        }
    }

    private Kernel openKernel(String string) throws JMSException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PagingDirectory", this.pagingDirectory.getAbsolutePath());
        hashMap.put("Store", (String)this.pStore);
        WorkManager workManager = WorkManagerFactory.getInstance().getSystem();
        WorkManager workManager2 = WorkManagerFactory.getInstance().getSystem();
        String string2 = AgentManager.getManagerSequence();
        String string3 = "client.SAF." + string + string2;
        String string4 = "client.SAF." + string + string2 + ".direct";
        hashMap.put("WorkManager", (String)workManager);
        hashMap.put("LimitedWorkManager", (String)workManager2);
        hashMap.put("LimitedTimerManagerName", string3);
        hashMap.put("DirectTimerManagerName", string4);
        KernelImpl kernelImpl = null;
        try {
            kernelImpl = new KernelImpl(string, hashMap);
            kernelImpl.open();
            kernelImpl.setProperty("MessageBufferSize", (Object)new Long(Long.MAX_VALUE));
            kernelImpl.setProperty("MaximumMessageSize", (Object)new Integer(Integer.MAX_VALUE));
        }
        catch (KernelException kernelException) {
            MessageMigrator.throwJMSException(kernelException, "Failed to open the Kernel " + string);
        }
        return kernelImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openKernels() throws JMSException {
        TreeMap<Integer, Kernel> treeMap = new TreeMap<Integer, Kernel>();
        Iterator iterator = this.pStore.getConnectionNames();
        try {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.startsWith(SAFCLIENT_KERNEL_PREFIX) || !string.endsWith(".header")) continue;
                int n = 0;
                try {
                    n = Integer.parseInt(string.substring(SAFCLIENT_KERNEL_PREFIX.length(), string.indexOf(".header")));
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                String string2 = SAFCLIENT_KERNEL_NAME_PREFIX + n;
                Kernel kernel = this.openKernel(string2);
                if (n == 0) {
                    this.kernel0 = kernel;
                    continue;
                }
                treeMap.put(new Integer(n), kernel);
            }
        }
        finally {
            for (Kernel kernel : treeMap.values()) {
                this.oldKernels.add(kernel);
            }
        }
    }

    private void closeKernels() {
        if (this.oldKernels != null) {
            for (Kernel kernel : this.oldKernels) {
                try {
                    kernel.close();
                }
                catch (KernelException kernelException) {
                    if (!JMSDebug.JMSCommon.isDebugEnabled()) continue;
                    JMSDebug.JMSCommon.debug("Failed to close the kernel " + kernel.getName() + " with error:" + kernelException.getMessage());
                }
            }
            this.oldKernels = null;
        }
        if (this.kernel0 != null) {
            block7: {
                try {
                    this.kernel0.close();
                }
                catch (KernelException kernelException) {
                    if (!JMSDebug.JMSCommon.isDebugEnabled()) break block7;
                    JMSDebug.JMSCommon.debug("Failed to close the kernel0 with error:" + kernelException.getMessage());
                }
            }
            this.kernel0 = null;
        }
    }

    private static void throwJMSException(Throwable throwable, String string) throws JMSException {
        JMSException jMSException = new JMSException(string);
        jMSException.initCause(throwable);
        throw jMSException;
    }

    static {
        String string = null;
        string = System.getProperty("weblogic.jms.safclient.MigrationCutoffTimeFormat");
        if (string == null) {
            string = DEFAULT_CUTOFF_TIME_FORMAT;
        }
        CUTOFF_TIME_FORMAT = new SimpleDateFormat(string);
        revertBugFix = Boolean.valueOf(System.getProperty("weblogic.jms.safclient.revertBug8174629Fix", "true"));
        migrationDone = new HashMap<File, Boolean>();
    }
}

