/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.admin;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.jms.JMSException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import weblogic.jms.common.SecHelper;
import weblogic.jms.safclient.ClientSAFDelegate;
import weblogic.jms.safclient.admin.PersistentStoreBean;
import weblogic.jms.safclient.agent.AgentManager;
import weblogic.jms.safclient.agent.DestinationImpl;
import weblogic.jms.safclient.agent.internal.Agent;
import weblogic.jms.safclient.agent.internal.ErrorHandler;
import weblogic.jms.safclient.agent.internal.RemoteContext;
import weblogic.jms.safclient.agent.internal.RuntimeHandlerImpl;
import weblogic.jms.safclient.jms.ConnectionFactoryImpl;
import weblogic.jms.safclient.jndi.ContextImpl;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.Sequence;

public final class ConfigurationUtils {
    private static final String ROOT_TAG = "weblogic-client-jms";
    private static final String STORE_TAG = "persistent-store";
    private static final String DIRPATH_TAG = "directory-path";
    private static final String SWPOLICY_TAG = "synchronous-write-policy";
    private static final String CF_TAG = "connection-factory";
    private static final String JNDI_TAG = "jndi-name";
    private static final String LOCAL_JNDI_TAG = "local-jndi-name";
    private static final String REMOTE_JNDI_TAG = "remote-jndi-name";
    private static final String NAME_ATT = "name";
    private static final String DDP_TAG = "default-delivery-params";
    private static final String DFDM_TAG = "default-delivery-mode";
    private static final String DFTD_TAG = "default-time-to-deliver";
    private static final String DFTTL_TAG = "default-time-to-live";
    private static final String DFPRI_TAG = "default-priority";
    private static final String DFRED_TAG = "default-redelivery-delay";
    private static final String DFSND_TAG = "send-timeout";
    private static final String DFCMP_TAG = "default-compression-threshold";
    private static final String DFUOO_TAG = "default-unit-of-order";
    private static final String CLIENT_TAG = "client-params";
    private static final String CID_TAG = "client-id";
    private static final String MM_TAG = "messages-maximum";
    private static final String MOR_TAG = "multicast-overrun-policy";
    private static final String SEC_TAG = "security-params";
    private static final String ATT_TAG = "attach-jmsx-user-id";
    private static final String SAFGROUP_TAG = "saf-imported-destinations";
    private static final String QUEUE_TAG = "saf-queue";
    private static final String TOPIC_TAG = "saf-topic";
    private static final String AGENT_TAG = "saf-agent";
    private static final String BYMAX_TAG = "bytes-maximum";
    private static final String MMS_TAG = "maximum-message-size";
    private static final String MBS_TAG = "message-buffer-size";
    private static final String SRC_TAG = "saf-remote-context";
    private static final String CMP_TAG = "compression-threshold";
    private static final String LOG_TAG = "saf-login-context";
    private static final String URL_TAG = "loginURL";
    private static final String UNAME_TAG = "username";
    private static final String PW_TAG = "password-encrypted";
    private static final String RDB_TAG = "default-retry-delay-base";
    private static final String RDM_TAG = "default-retry-delay-maximum";
    private static final String RDX_TAG = "default-retry-delay-multiplier";
    private static final String WIN_TAG = "window-size";
    private static final String LOE_TAG = "logging-enabled";
    private static final String WINI_TAG = "window-interval";
    private static final String SAFG_TAG = "saf-imported-destinations";
    private static final String NONQ_TAG = "non-persistent-qos";
    private static final String ERH_TAG = "saf-error-handling";
    private static final String POL_TAG = "policy";
    private static final String LOGF_TAG = "log-format";
    private static final String SED_TAG = "saf-error-destination";
    private static final String SEHG_TAG = "saf-error-handling";
    private static final String DEFAULT_CF_NAME = "weblogic.jms.safclient.ConnectionFactory";
    private static final String PREFIX_NAME = "ClientSAF_";
    public static final String EXACTLY_ONCE = "Exactly-Once";
    private static final String AT_LEAST_ONCE = "At-Least-Once";
    private static final String AT_MOST_ONCE = "At-Most-Once";

    private static final String getNestedSingleField(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() <= 0) {
            return null;
        }
        Node node = nodeList.item(0);
        return ConfigurationUtils.getTextContent_14(node);
    }

    public static String getTextContent_14(Node node, boolean bl) {
        if (node.hasChildNodes()) {
            Pattern pattern = Pattern.compile("[^ \t\r\n]");
            StringBuffer stringBuffer = new StringBuffer();
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2 instanceof Text || node2 instanceof CDATASection) {
                    String string = node2.getNodeValue();
                    if (!pattern.matcher(string).find()) continue;
                    stringBuffer.append(string);
                    continue;
                }
                stringBuffer.append(ConfigurationUtils.getTextContent_14(node2, bl));
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static String getTextContent_14(Node node) {
        if (node instanceof Document || node instanceof DocumentType || node instanceof Notation) {
            return null;
        }
        if (node instanceof Text || node instanceof CDATASection || node instanceof Comment || node instanceof ProcessingInstruction) {
            String string;
            Pattern pattern = Pattern.compile("[^ \t\r\n]");
            if (pattern.matcher(string = node.getNodeValue()).find()) {
                return string;
            }
            return "";
        }
        return ConfigurationUtils.getTextContent_14(node, true);
    }

    public static PersistentStoreBean getPersistentStore(Document document) throws JMSException {
        PersistentStoreBeanImpl persistentStoreBeanImpl = new PersistentStoreBeanImpl();
        NodeList nodeList = document.getElementsByTagName(ROOT_TAG);
        if (nodeList.getLength() != 1) {
            throw new JMSException("This document must contain a root node of weblogic-client-jms");
        }
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName(STORE_TAG);
        if (nodeList2 != null && nodeList2.getLength() > 0) {
            Element element2 = (Element)nodeList2.item(0);
            String string = ConfigurationUtils.getNestedSingleField(element2, DIRPATH_TAG);
            if (string != null) {
                persistentStoreBeanImpl.setStoreDirectory(string);
            }
            if ((string = ConfigurationUtils.getNestedSingleField(element2, SWPOLICY_TAG)) != null) {
                persistentStoreBeanImpl.setPolicy(string);
            }
        }
        return persistentStoreBeanImpl;
    }

    private static void addToJNDIMap(HashMap hashMap, String string, Object object) throws JMSException {
        if (string == null) {
            return;
        }
        if (hashMap.containsKey(string)) {
            throw new JMSException(string + " is already bound into JNDI");
        }
        hashMap.put(string, object);
    }

    public static void doJNDIConnectionFactories(Document document, ClientSAFDelegate clientSAFDelegate, HashMap hashMap) throws JMSException {
        ConnectionFactoryImpl connectionFactoryImpl = new ConnectionFactoryImpl(DEFAULT_CF_NAME, clientSAFDelegate);
        ConfigurationUtils.addToJNDIMap(hashMap, DEFAULT_CF_NAME, connectionFactoryImpl);
        NodeList nodeList = document.getElementsByTagName(ROOT_TAG);
        if (nodeList.getLength() != 1) {
            throw new JMSException("This document must contain a root node of weblogic-client-jms");
        }
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName(CF_TAG);
        if (nodeList2 == null || nodeList2.getLength() <= 0) {
            return;
        }
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            String string;
            Object object;
            Object object2;
            Object object3;
            Element element2 = (Element)nodeList2.item(i);
            String string2 = element2.getAttribute(NAME_ATT);
            if (string2 == null) {
                throw new JMSException("A connection factory does not have a name attribute");
            }
            String string3 = ConfigurationUtils.getNestedSingleField(element2, JNDI_TAG);
            String string4 = ConfigurationUtils.getNestedSingleField(element2, LOCAL_JNDI_TAG);
            if (string3 == null && string4 == null) continue;
            connectionFactoryImpl = new ConnectionFactoryImpl(string2, clientSAFDelegate);
            NodeList nodeList3 = element2.getElementsByTagName(DDP_TAG);
            if (nodeList3 != null && nodeList3.getLength() > 0) {
                object3 = (Element)nodeList3.item(0);
                object2 = ConfigurationUtils.getNestedSingleField((Element)object3, DFDM_TAG);
                if (object2 != null) {
                    connectionFactoryImpl.setDefaultDeliveryMode((String)object2);
                }
                if ((object2 = ConfigurationUtils.getNestedSingleField((Element)object3, DFTD_TAG)) != null) {
                    connectionFactoryImpl.setDefaultTimeToDeliver((String)object2);
                }
                if ((object2 = ConfigurationUtils.getNestedSingleField((Element)object3, DFTTL_TAG)) != null) {
                    connectionFactoryImpl.setDefaultTimeToLive(Long.parseLong((String)object2));
                }
                if ((object2 = ConfigurationUtils.getNestedSingleField((Element)object3, DFPRI_TAG)) != null) {
                    connectionFactoryImpl.setDefaultPriority(Integer.parseInt((String)object2));
                }
                if ((object2 = ConfigurationUtils.getNestedSingleField((Element)object3, DFRED_TAG)) != null) {
                    connectionFactoryImpl.setDefaultRedeliveryDelay(Long.parseLong((String)object2));
                }
                if ((object2 = ConfigurationUtils.getNestedSingleField((Element)object3, DFSND_TAG)) != null) {
                    connectionFactoryImpl.setSendTimeout(Long.parseLong((String)object2));
                }
                if ((object2 = ConfigurationUtils.getNestedSingleField((Element)object3, DFCMP_TAG)) != null) {
                    connectionFactoryImpl.setDefaultCompressionThreshold(Integer.parseInt((String)object2));
                }
                if ((object2 = ConfigurationUtils.getNestedSingleField((Element)object3, DFUOO_TAG)) != null) {
                    connectionFactoryImpl.setDefaultUnitOfOrder((String)object2);
                }
            }
            if ((object3 = element2.getElementsByTagName(CLIENT_TAG)) != null && object3.getLength() > 0) {
                object2 = (Element)object3.item(0);
                object = ConfigurationUtils.getNestedSingleField((Element)object2, CID_TAG);
                if (object != null) {
                    connectionFactoryImpl.setClientId((String)object);
                }
                if ((object = ConfigurationUtils.getNestedSingleField((Element)object2, MM_TAG)) != null) {
                    connectionFactoryImpl.setMessagesMaximum(Integer.parseInt((String)object));
                }
                if ((object = ConfigurationUtils.getNestedSingleField((Element)object2, MOR_TAG)) != null) {
                    connectionFactoryImpl.setMulticastOverrunPolicy((String)object);
                }
            }
            if ((object2 = element2.getElementsByTagName(SEC_TAG)) != null && object2.getLength() > 0 && (string = ConfigurationUtils.getNestedSingleField((Element)(object = (Element)object2.item(0)), ATT_TAG)) != null) {
                boolean bl = string.equalsIgnoreCase("true");
                connectionFactoryImpl.setAttachJMSXUserId(bl);
            }
            ConfigurationUtils.addToJNDIMap(hashMap, string3, connectionFactoryImpl);
            ConfigurationUtils.addToJNDIMap(hashMap, string4, connectionFactoryImpl);
        }
    }

    private static void doDestinations(String string, NodeList nodeList, boolean bl, HashMap hashMap, HashMap hashMap2) throws JMSException {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string2 = element.getAttribute(NAME_ATT);
            if (string2 == null) {
                throw new JMSException("A saf destination does not have a name attribute");
            }
            DestinationImpl destinationImpl = new DestinationImpl(string, string2, bl);
            hashMap.put(string2, destinationImpl);
            String string3 = ConfigurationUtils.getNestedSingleField(element, LOCAL_JNDI_TAG);
            if (string3 == null) {
                string3 = ConfigurationUtils.getNestedSingleField(element, REMOTE_JNDI_TAG);
            }
            if (string3 == null) {
                throw new JMSException("The saf destination " + string2 + " in saf group " + string + " does not have a JNDI name");
            }
            ConfigurationUtils.addToJNDIMap(hashMap2, string3, destinationImpl);
        }
    }

    public static void doJNDIDestinations(Document document, HashMap hashMap, HashMap hashMap2) throws JMSException {
        NodeList nodeList = document.getElementsByTagName(ROOT_TAG);
        if (nodeList.getLength() != 1) {
            throw new JMSException("This document must contain a root node of weblogic-client-jms");
        }
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName("saf-imported-destinations");
        if (nodeList2 == null || nodeList2.getLength() <= 0) {
            return;
        }
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            NodeList nodeList3;
            Element element2 = (Element)nodeList2.item(i);
            String string = element2.getAttribute(NAME_ATT);
            if (string == null) {
                throw new JMSException("A saf imported destination group does not have a name attribute");
            }
            HashMap hashMap3 = new HashMap();
            hashMap.put(string, hashMap3);
            NodeList nodeList4 = element2.getElementsByTagName(QUEUE_TAG);
            if (nodeList4 != null || nodeList4.getLength() > 0) {
                ConfigurationUtils.doDestinations(string, nodeList4, true, hashMap3, hashMap2);
            }
            if ((nodeList3 = element2.getElementsByTagName(TOPIC_TAG)) == null && nodeList3.getLength() <= 0) continue;
            ConfigurationUtils.doDestinations(string, nodeList3, false, hashMap3, hashMap2);
        }
    }

    public static void doAgent(Document document, Agent agent) throws JMSException {
        NodeList nodeList = document.getElementsByTagName(ROOT_TAG);
        if (nodeList.getLength() != 1) {
            throw new JMSException("This document must contain a root node of weblogic-client-jms");
        }
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName(AGENT_TAG);
        if (nodeList2 == null || nodeList2.getLength() <= 0) {
            return;
        }
        Element element2 = (Element)nodeList2.item(0);
        String string = ConfigurationUtils.getNestedSingleField(element2, BYMAX_TAG);
        if (string != null) {
            agent.setBytesMaximum(Long.parseLong(string));
        }
        if ((string = ConfigurationUtils.getNestedSingleField(element2, MM_TAG)) != null) {
            agent.setMessagesMaximum(Long.parseLong(string));
        }
        if ((string = ConfigurationUtils.getNestedSingleField(element2, MMS_TAG)) != null) {
            agent.setMaximumMessageSize(Integer.parseInt(string));
        }
        if ((string = ConfigurationUtils.getNestedSingleField(element2, MBS_TAG)) != null) {
            agent.setMessageBufferSize(Integer.parseInt(string));
        }
        if ((string = ConfigurationUtils.getNestedSingleField(element2, RDB_TAG)) != null) {
            agent.setDefaultRetryDelayBase(Long.parseLong(string));
        }
        if ((string = ConfigurationUtils.getNestedSingleField(element2, RDM_TAG)) != null) {
            agent.setDefaultRetryDelayMaximum(Long.parseLong(string));
        }
        if ((string = ConfigurationUtils.getNestedSingleField(element2, RDX_TAG)) != null) {
            agent.setDefaultRetryDelayMultiplier(Double.parseDouble(string));
        }
        if ((string = ConfigurationUtils.getNestedSingleField(element2, WIN_TAG)) != null) {
            agent.setWindowSize(Integer.parseInt(string));
        }
        if ((string = ConfigurationUtils.getNestedSingleField(element2, LOE_TAG)) != null) {
            boolean bl = string.equalsIgnoreCase("true");
            agent.setLoggingEnabled(bl);
        }
        if ((string = ConfigurationUtils.getNestedSingleField(element2, WINI_TAG)) != null) {
            agent.setWindowInterval(Integer.parseInt(string));
        }
    }

    public static void doRemoteContexts(Document document, Agent agent, HashMap hashMap, char[] cArray) throws JMSException {
        NodeList nodeList = document.getElementsByTagName(ROOT_TAG);
        if (nodeList.getLength() != 1) {
            throw new JMSException("This document must contain a root node of weblogic-client-jms");
        }
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName(SRC_TAG);
        if (nodeList2 == null || nodeList2.getLength() <= 0) {
            return;
        }
        int n = nodeList2.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList3;
            Element element2 = (Element)nodeList2.item(i);
            String string = element2.getAttribute(NAME_ATT);
            if (string == null) {
                throw new JMSException("A saf remote context does not have a name attribute");
            }
            RemoteContext remoteContext = new RemoteContext(string);
            String string2 = ConfigurationUtils.getNestedSingleField(element2, CMP_TAG);
            if (string2 != null) {
                remoteContext.setCompressionThreshold(Integer.parseInt(string2));
            }
            if ((nodeList3 = element2.getElementsByTagName(LOG_TAG)) != null && nodeList3.getLength() > 0) {
                Element element3 = (Element)nodeList3.item(0);
                string2 = ConfigurationUtils.getNestedSingleField(element3, URL_TAG);
                if (string2 != null) {
                    remoteContext.setLoginURL(string2);
                }
                if ((string2 = ConfigurationUtils.getNestedSingleField(element3, UNAME_TAG)) != null) {
                    remoteContext.setUsername(string2);
                }
                if ((string2 = ConfigurationUtils.getNestedSingleField(element3, PW_TAG)) != null) {
                    char[] cArray2;
                    try {
                        cArray2 = SecHelper.decryptString(cArray, string2);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        throw new weblogic.jms.common.JMSException("Invalid password key to unlock the passwords in the configuration file", (Throwable)generalSecurityException);
                    }
                    catch (IOException iOException) {
                        throw new weblogic.jms.common.JMSException(iOException);
                    }
                    remoteContext.setPassword(new String(cArray2));
                    for (int j = 0; j < cArray2.length; ++j) {
                        cArray2[j] = 120;
                    }
                }
            }
            remoteContext.setRetryDelayBase(agent.getDefaultRetryDelayBase());
            remoteContext.setRetryDelayMaximum(agent.getDefaultRetryDelayMaximum());
            remoteContext.setRetryDelayMultiplier(agent.getDefaultRetryDelayMultiplier());
            remoteContext.setWindowSize(agent.getWindowSize());
            remoteContext.setWindowInterval(agent.getWindowInterval());
            hashMap.put(string, remoteContext);
        }
    }

    public static void doErrorHandlers(Document document, HashMap hashMap) throws JMSException {
        NodeList nodeList = document.getElementsByTagName(ROOT_TAG);
        if (nodeList.getLength() != 1) {
            throw new JMSException("This document must contain a root node of weblogic-client-jms");
        }
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName("saf-error-handling");
        if (nodeList2 == null || nodeList2.getLength() <= 0) {
            return;
        }
        int n = nodeList2.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList2.item(i);
            String string = element2.getAttribute(NAME_ATT);
            if (string == null) {
                throw new JMSException("A saf remote context does not have a name attribute");
            }
            ErrorHandler errorHandler = new ErrorHandler(string);
            String string2 = ConfigurationUtils.getNestedSingleField(element2, POL_TAG);
            if (string2 != null) {
                errorHandler.setPolicy(string2);
            }
            if ((string2 = ConfigurationUtils.getNestedSingleField(element2, LOGF_TAG)) != null) {
                errorHandler.setLogFormat(string2);
            }
            if ((string2 = ConfigurationUtils.getNestedSingleField(element2, LOGF_TAG)) != null) {
                errorHandler.setLogFormat(string2);
            }
            if ((string2 = ConfigurationUtils.getNestedSingleField(element2, SED_TAG)) != null) {
                errorHandler.setErrorDestinationName(string2);
            }
            hashMap.put(string, errorHandler);
        }
    }

    private static int qosStringToInt(String string) {
        if (EXACTLY_ONCE.equals(string)) {
            return 2;
        }
        if (AT_LEAST_ONCE.equals(string)) {
            return 3;
        }
        return 1;
    }

    private static void doImportedDestination(NodeList nodeList, String string, Agent agent, ContextImpl contextImpl, RemoteContext remoteContext, ErrorHandler errorHandler, HashMap hashMap) throws JMSException {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            String string2 = element.getAttribute(NAME_ATT);
            if (string2 == null) {
                throw new JMSException("A saf imported destination does not have a name attribute");
            }
            String string3 = ConfigurationUtils.getNestedSingleField(element, REMOTE_JNDI_TAG);
            if (string3 == null) {
                throw new JMSException("The remote JNDI name field is not set for destination " + string2 + " in saf group " + string);
            }
            String string4 = ConfigurationUtils.getNestedSingleField(element, NONQ_TAG);
            if (string4 == null) {
                string4 = AT_MOST_ONCE;
            }
            String string5 = AgentManager.constructDestinationName(string, string2);
            String string6 = ConfigurationUtils.getNestedSingleField(element, "saf-error-handling");
            ErrorHandler errorHandler2 = errorHandler;
            if (string6 != null && (errorHandler2 = (ErrorHandler)hashMap.get(string6)) == null) {
                throw new JMSException("There is no error handler named " + string6 + " in SAF destination " + string5);
            }
            Queue queue = agent.addConfiguredDestination(string5);
            DestinationImpl destinationImpl = contextImpl.getDestination(string, string2);
            if (destinationImpl == null) {
                throw new JMSException("Could not find the configuration destination " + string5);
            }
            destinationImpl.setKernelQueue(queue);
            destinationImpl.setSequenceName(ConfigurationUtils.getLatestSequenceName(ConfigurationUtils.getBaseSequenceName(string5), queue));
            destinationImpl.setNonPersistentQOS(string4);
            destinationImpl.setLoggingEnabled(agent.isLoggingEnabled());
            destinationImpl.setErrorHandler(errorHandler2);
            remoteContext.addForwarder(agent.getPersistentStore(), agent.getAsyncPushWorkManager(), new RuntimeHandlerImpl(agent.getName(), string2, remoteContext.getName()), queue, string3, ConfigurationUtils.qosStringToInt(string4));
        }
    }

    public static void doImportedDestinationGroup(Document document, HashMap hashMap, HashMap hashMap2, Agent agent, ContextImpl contextImpl) throws JMSException {
        NodeList nodeList = document.getElementsByTagName(ROOT_TAG);
        if (nodeList.getLength() != 1) {
            throw new JMSException("This document must contain a root node of weblogic-client-jms");
        }
        Element element = (Element)nodeList.item(0);
        NodeList nodeList2 = element.getElementsByTagName("saf-imported-destinations");
        if (nodeList2 == null || nodeList2.getLength() <= 0) {
            return;
        }
        int n = nodeList2.getLength();
        for (int i = 0; i < n; ++i) {
            NodeList nodeList3;
            Element element2 = (Element)nodeList2.item(i);
            String string = element2.getAttribute(NAME_ATT);
            if (string == null) {
                throw new JMSException("A saf imported destination group does not have a name attribute");
            }
            String string2 = ConfigurationUtils.getNestedSingleField(element2, SRC_TAG);
            if (string2 == null) continue;
            RemoteContext remoteContext = (RemoteContext)hashMap.get(string2);
            if (remoteContext == null) {
                throw new JMSException("There is no remote context of name " + string2 + " in saf destination group " + string);
            }
            String string3 = ConfigurationUtils.getNestedSingleField(element2, "saf-error-handling");
            ErrorHandler errorHandler = null;
            if (string3 != null && (errorHandler = (ErrorHandler)hashMap2.get(string3)) == null) {
                throw new JMSException("There is no error handler of name " + string3 + " in saf destination group " + string);
            }
            NodeList nodeList4 = element2.getElementsByTagName(QUEUE_TAG);
            if (nodeList4 != null && nodeList4.getLength() > 0) {
                ConfigurationUtils.doImportedDestination(nodeList4, string, agent, contextImpl, remoteContext, errorHandler, hashMap2);
            }
            if ((nodeList3 = element2.getElementsByTagName(TOPIC_TAG)) == null || nodeList3.getLength() <= 0) continue;
            ConfigurationUtils.doImportedDestination(nodeList3, string, agent, contextImpl, remoteContext, errorHandler, hashMap2);
        }
    }

    public static void resolveErrorDestinations(HashMap hashMap, ContextImpl contextImpl) throws JMSException {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            ErrorHandler errorHandler = (ErrorHandler)hashMap.get(iterator.next());
            String string = errorHandler.getErrorDestinationName();
            if (string == null) continue;
            int n = contextImpl.howManyDestinationsWithThisName(string);
            if (n > 1) {
                throw new JMSException("There are " + n + " SAF destinations with the name " + string + ".  Hence a destination with that name cannot be used as an error destination");
            }
            if (n < 1) {
                throw new JMSException("No error destination of name " + string + " was found");
            }
            DestinationImpl destinationImpl = contextImpl.getDestination(string);
            errorHandler.setErrorDestination(destinationImpl);
        }
    }

    private static String versionedName(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSSS");
        return string + simpleDateFormat.format(new Date(System.currentTimeMillis()));
    }

    private static String getBaseSequenceName(String string) {
        return PREFIX_NAME + string + "@";
    }

    private static String getLatestSequenceName(String string, Queue queue) {
        Collection collection = queue.getSequences();
        if (collection == null || collection.size() == 0) {
            return ConfigurationUtils.versionedName(string);
        }
        Iterator iterator = collection.iterator();
        String string2 = string;
        while (iterator.hasNext()) {
            Sequence sequence = (Sequence)iterator.next();
            if (!sequence.getName().contains(string) || sequence.getName().compareTo(string2) <= 0) continue;
            string2 = sequence.getName();
        }
        return string2;
    }

    public static String getSequenceNameFromQueue(Queue queue) {
        return ConfigurationUtils.getLatestSequenceName(ConfigurationUtils.getBaseSequenceName(queue.getName()), queue);
    }

    private static class PersistentStoreBeanImpl
    implements PersistentStoreBean {
        private static final String DEFAULT_DIRECTORY = "stores/default";
        private static final String DEFAULT_POLICY = "Direct-Write";
        private String storeDirectory = "stores/default";
        private String policy = "Direct-Write";

        private PersistentStoreBeanImpl() {
        }

        private void setStoreDirectory(String string) {
            this.storeDirectory = string;
        }

        public String getStoreDirectory() {
            return this.storeDirectory;
        }

        private void setPolicy(String string) {
            this.policy = string;
        }

        public String getSynchronousWritePolicy() {
            return this.policy;
        }
    }
}

