/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.agent;

import java.io.File;
import java.util.HashMap;
import javax.jms.JMSException;
import org.w3c.dom.Document;
import weblogic.jms.safclient.MessageMigrator;
import weblogic.jms.safclient.admin.ConfigurationUtils;
import weblogic.jms.safclient.agent.DestinationImpl;
import weblogic.jms.safclient.agent.internal.Agent;
import weblogic.jms.safclient.agent.internal.RemoteContext;
import weblogic.jms.safclient.jndi.ContextImpl;

public final class AgentManager {
    private static final String SEPARATOR = "!";
    private Agent agent;
    private HashMap remoteContextMap = new HashMap();
    private HashMap errorHandlerMap = new HashMap();
    private ContextImpl context;
    private static int managerSequenceNumber;
    private static Object managerSequenceNumberLock;
    private static int agentNumber;
    private static Object numberLock;
    private static final String AGENT_COMPONENT = "ClientSAFAgent";

    public static String constructDestinationName(String string, String string2) {
        return string + SEPARATOR + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAgentName() {
        if (MessageMigrator.revertBugFix) {
            int n;
            Object object = numberLock;
            synchronized (object) {
                n = agentNumber++;
            }
            return AGENT_COMPONENT + n;
        }
        return "ClientSAFAgent0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentManager(Document document, ContextImpl contextImpl, char[] cArray, File file) throws JMSException {
        boolean bl = true;
        try {
            this.context = contextImpl;
            String string = AgentManager.getAgentName();
            this.agent = new Agent(string, file);
            ConfigurationUtils.doAgent(document, this.agent);
            ConfigurationUtils.doRemoteContexts(document, this.agent, this.remoteContextMap, cArray);
            ConfigurationUtils.doErrorHandlers(document, this.errorHandlerMap);
            this.agent.initialize();
            ConfigurationUtils.doImportedDestinationGroup(document, this.remoteContextMap, this.errorHandlerMap, this.agent, this.context);
            ConfigurationUtils.resolveErrorDestinations(this.errorHandlerMap, this.context);
            bl = false;
        }
        finally {
            if (bl) {
                try {
                    this.shutdown();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws JMSException {
        HashMap hashMap = this.remoteContextMap;
        synchronized (hashMap) {
            for (RemoteContext remoteContext : this.remoteContextMap.values()) {
                remoteContext.shutdown();
            }
            this.remoteContextMap.clear();
        }
        hashMap = this.errorHandlerMap;
        synchronized (hashMap) {
            this.errorHandlerMap.clear();
        }
        if (this.agent != null) {
            this.agent.shutdown();
            this.agent = null;
        }
    }

    public DestinationImpl getDestination(String string, String string2) {
        return this.context.getDestination(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getManagerSequence() {
        int n;
        Object object = managerSequenceNumberLock;
        synchronized (object) {
            n = managerSequenceNumber++;
        }
        return "." + n;
    }

    static {
        managerSequenceNumberLock = new Object();
        numberLock = new Object();
    }
}

