/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.agent;

import java.util.List;
import javax.jms.JMSException;
import weblogic.jms.JMSLogger;
import weblogic.jms.common.JMSMessageExpirationHelper;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.safclient.agent.AgentManager;
import weblogic.jms.safclient.agent.internal.ErrorHandler;
import weblogic.messaging.kernel.Destination;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.RedirectionListener;
import weblogic.messaging.kernel.SendOptions;

public final class DestinationImpl
extends weblogic.jms.common.DestinationImpl
implements RedirectionListener {
    private static final String SERVER_PFX = "client.saf.server.";
    private static final String MODULE_PFX = "client.saf.module.";
    private static final long serialVersionUID = 6099783323740404732L;
    private transient Queue kernelQueue;
    private transient boolean loggingEnabled = true;
    private transient ErrorHandler errorHandler;
    private transient String sequenceName;
    private transient String nonPersistentQOS;

    public DestinationImpl(String string, String string2, boolean bl) {
        super(bl ? (byte)1 : 2);
        String string3 = JMSDispatcherManager.generateDispatcherName();
        String string4 = SERVER_PFX + string3;
        String string5 = MODULE_PFX + string3;
        this.setName(string2);
        this.setApplicationName(string);
        this.setServerName(string4);
        this.setModuleName(string5);
    }

    public String getCreateDestinationArgument() {
        return AgentManager.constructDestinationName(this.getApplicationName(), this.getName());
    }

    public String toString() {
        return AgentManager.constructDestinationName(this.getApplicationName(), this.getName());
    }

    public void setKernelQueue(Queue queue) {
        this.kernelQueue = queue;
    }

    public void setLoggingEnabled(boolean bl) {
        this.loggingEnabled = bl;
    }

    public Queue getKernelQueue() {
        return this.kernelQueue;
    }

    public void setErrorHandler(ErrorHandler errorHandler) throws JMSException {
        this.errorHandler = errorHandler;
        if (this.errorHandler != null && this.kernelQueue != null) {
            try {
                this.kernelQueue.setProperty("RedirectionListener", (Object)this);
                if (this.errorHandler.getPolicy() == 3) {
                    this.kernelQueue.setProperty("IgnoreExpiration", (Object)new Boolean(true));
                }
            }
            catch (KernelException kernelException) {
                throw new weblogic.jms.common.JMSException(kernelException);
            }
        }
    }

    private static SendOptions createSendOptions(MessageImpl messageImpl) {
        SendOptions sendOptions = new SendOptions();
        sendOptions.setPersistent(messageImpl.getAdjustedDeliveryMode() == 2);
        sendOptions.setExpirationTime(messageImpl.getExpirationTime());
        sendOptions.setRedeliveryLimit(messageImpl.getRedeliveryLimit());
        return sendOptions;
    }

    private static void overrideMessageProperties(MessageImpl messageImpl, boolean bl) {
        messageImpl.setDeliveryTime(0L);
        messageImpl._setJMSRedeliveryLimit(-1);
        if (bl) {
            messageImpl._setJMSExpiration(0L);
        }
        messageImpl.setSAFSequenceName(null);
        messageImpl.setSAFSeqNumber(0L);
    }

    public void expirationTimeReached(RedirectionListener.Info info, boolean bl) {
        if (this.errorHandler == null) {
            if (!bl && this.loggingEnabled) {
                JMSLogger.logExpiredSAFMessageNoHeaderProperty((String)("'" + info.getMessage().getMessageID() + "'"));
            }
            return;
        }
        MessageImpl messageImpl = (MessageImpl)info.getMessage();
        int n = this.errorHandler.getPolicy();
        switch (n) {
            case 0: 
            case 3: {
                return;
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer(256);
                List list = JMSMessageExpirationHelper.extractJMSHeaderAndProperty(this.errorHandler.getLogFormat(), stringBuffer);
                List list2 = JMSMessageExpirationHelper.convertStringToLinkedList(stringBuffer.toString());
                JMSMessageExpirationHelper.logExpiredSAFMessage(messageImpl, list, list2);
                return;
            }
            case 2: {
                DestinationImpl destinationImpl = this.errorHandler.getErrorDestination();
                Queue queue = destinationImpl.getKernelQueue();
                DestinationImpl.overrideMessageProperties(messageImpl, true);
                info.setSendOptions(DestinationImpl.createSendOptions(messageImpl));
                info.setRedirectDestination((Destination)queue);
                return;
            }
        }
        throw new AssertionError((Object)("Unknown policy: " + n));
    }

    public void deliveryLimitReached(RedirectionListener.Info info) {
        DestinationImpl destinationImpl = this.errorHandler.getErrorDestination();
        if (destinationImpl == null) {
            return;
        }
        Queue queue = destinationImpl.getKernelQueue();
        MessageImpl messageImpl = (MessageImpl)info.getMessage();
        DestinationImpl.overrideMessageProperties(messageImpl, false);
        info.setSendOptions(DestinationImpl.createSendOptions(messageImpl));
        info.setRedirectDestination((Destination)queue);
    }

    public void setSequenceName(String string) {
        this.sequenceName = string;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setNonPersistentQOS(String string) {
        this.nonPersistentQOS = string;
    }

    public String getNonPersistentQOS() {
        return this.nonPersistentQOS;
    }
}

