/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.agent.internal;

import java.io.File;
import java.util.HashMap;
import javax.jms.JMSException;
import weblogic.jms.safclient.MessageMigrator;
import weblogic.jms.safclient.agent.AgentManager;
import weblogic.jms.safclient.store.StoreUtils;
import weblogic.messaging.kernel.Kernel;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.Quota;
import weblogic.messaging.kernel.QuotaPolicy;
import weblogic.messaging.kernel.internal.KernelImpl;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public final class Agent {
    public static final String AGENT_WM_PREFIX = "client.SAF.";
    public static final String NORMAL_WM_NAME = ".System";
    public static final String LIMITED_WM_NAME = ".Limited";
    private static final String ASYNC_WM_NAME = ".AsyncPush";
    public static final int LIMITED_WM_NUM_THREADS = 8;
    private static final String QUOTA_NAME = "client.SAF.Quota";
    public static final String AGENT_TM_PREFIX = "client.SAF.";
    public static final String DIRECT_TIMER_EXT = ".direct";
    private String name;
    private File rootDirectory;
    private WorkManager workManager;
    private WorkManager limitedWorkManager;
    private WorkManager asyncPushWorkManager;
    private String limitedTimerManagerName;
    private String directTimerManagerName;
    private long bytesMaximum = -1L;
    private int messagesMaximum = -1;
    private long messageBufferSize = -1L;
    private int maximumMessageSize = Integer.MAX_VALUE;
    private long defaultRetryDelayBase = 20000L;
    private long defaultRetryDelayMaximum = 180000L;
    private double defaultRetryDelayMultiplier = 1.0;
    private int windowSize = 10;
    private boolean loggingEnabled = true;
    private int windowInterval = 0;
    private HashMap destinations = new HashMap();
    private Kernel kernel;
    private Quota quota;

    public Agent(String string, File file) {
        this.name = string;
        this.rootDirectory = file;
    }

    public String getName() {
        return this.name;
    }

    public void setBytesMaximum(long l) {
        this.bytesMaximum = l;
    }

    public void setMessagesMaximum(long l) {
        this.messagesMaximum = (int)l;
    }

    public void setMessageBufferSize(long l) {
        this.messageBufferSize = l;
    }

    public void setMaximumMessageSize(int n) {
        this.maximumMessageSize = n;
    }

    public WorkManager getAsyncPushWorkManager() {
        return this.asyncPushWorkManager;
    }

    public long getDefaultRetryDelayBase() {
        return this.defaultRetryDelayBase;
    }

    public void setDefaultRetryDelayBase(long l) {
        this.defaultRetryDelayBase = l;
    }

    public long getDefaultRetryDelayMaximum() {
        return this.defaultRetryDelayMaximum;
    }

    public void setDefaultRetryDelayMaximum(long l) {
        this.defaultRetryDelayMaximum = l;
    }

    public double getDefaultRetryDelayMultiplier() {
        return this.defaultRetryDelayMultiplier;
    }

    public void setDefaultRetryDelayMultiplier(double d) {
        this.defaultRetryDelayMultiplier = d;
    }

    public void setLoggingEnabled(boolean bl) {
        this.loggingEnabled = bl;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int n) {
        this.windowSize = n;
    }

    public int getWindowInterval() {
        return this.windowInterval;
    }

    public void setWindowInterval(int n) {
        this.windowInterval = n;
    }

    public void initialize() throws JMSException {
        File file = new File(this.rootDirectory, "paging");
        if (!file.exists() && !file.mkdirs()) {
            throw new JMSException("Unable to create paging directory " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new JMSException("The file " + file.getAbsolutePath() + " must be a directory, it will be used for the paging store");
        }
        PersistentStoreXA persistentStoreXA = StoreUtils.getStore(this.rootDirectory);
        if (persistentStoreXA == null) {
            throw new JMSException("Could not find default store");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        WorkManagerFactory workManagerFactory = WorkManagerFactory.getInstance();
        if (MessageMigrator.revertBugFix) {
            this.workManager = workManagerFactory.findOrCreate("client.SAF." + this.name + NORMAL_WM_NAME, 100, 1, -1);
            this.limitedWorkManager = workManagerFactory.findOrCreate("client.SAF." + this.name + LIMITED_WM_NAME, 1, 8);
            this.asyncPushWorkManager = WorkManagerFactory.getInstance().findOrCreate("client.SAF." + this.name + ASYNC_WM_NAME, 100, 1, -1);
        } else {
            String string = AgentManager.getManagerSequence();
            this.workManager = workManagerFactory.findOrCreate("client.SAF." + this.name + string + NORMAL_WM_NAME, 100, 1, -1);
            this.limitedWorkManager = workManagerFactory.findOrCreate("client.SAF." + this.name + string + LIMITED_WM_NAME, 1, 8);
            this.asyncPushWorkManager = WorkManagerFactory.getInstance().findOrCreate("client.SAF." + this.name + string + ASYNC_WM_NAME, 100, 1, -1);
            this.limitedTimerManagerName = "client.SAF." + this.name + string;
            this.directTimerManagerName = "client.SAF." + this.name + string + DIRECT_TIMER_EXT;
            hashMap.put("LimitedTimerManagerName", this.limitedTimerManagerName);
            hashMap.put("DirectTimerManagerName", this.directTimerManagerName);
        }
        hashMap.put("WorkManager", (String)this.workManager);
        hashMap.put("LimitedWorkManager", (String)this.limitedWorkManager);
        hashMap.put("PagingDirectory", file.getAbsolutePath());
        try {
            this.kernel = new KernelImpl(this.name, hashMap);
            this.kernel.setProperty("Store", (Object)persistentStoreXA);
            this.kernel.open();
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        try {
            this.kernel.setProperty("MessageBufferSize", (Object)new Long(this.messageBufferSize < 0L ? Long.MAX_VALUE : this.messageBufferSize));
            this.kernel.setProperty("MaximumMessageSize", (Object)new Integer(this.maximumMessageSize < 0 ? Integer.MAX_VALUE : this.maximumMessageSize));
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        try {
            this.quota = this.kernel.createQuota(QUOTA_NAME);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        this.quota.setPolicy(QuotaPolicy.FIFO);
        this.quota.setBytesMaximum(this.bytesMaximum < 0L ? Long.MAX_VALUE : this.bytesMaximum);
        this.quota.setMessagesMaximum(this.messagesMaximum < 0 ? Integer.MAX_VALUE : this.messagesMaximum);
    }

    public PersistentStoreXA getPersistentStore() {
        return (PersistentStoreXA)this.kernel.getProperty("Store");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue addConfiguredDestination(String string) throws weblogic.jms.common.JMSException {
        Queue queue = null;
        HashMap<String, Comparable<Boolean>> hashMap = new HashMap<String, Comparable<Boolean>>();
        hashMap.put("Durable", new Boolean(true));
        hashMap.put("Quota", (Comparable<Boolean>)this.quota);
        hashMap.put("MaximumMessageSize", new Integer(this.maximumMessageSize < 0 ? Integer.MAX_VALUE : this.maximumMessageSize));
        try {
            queue = this.kernel.findQueue(string);
            if (queue == null) {
                try {
                    queue = this.kernel.createQueue(string, hashMap);
                }
                catch (KernelException kernelException) {
                    throw new weblogic.jms.common.JMSException(kernelException);
                }
            }
            try {
                queue.setProperties(hashMap);
            }
            catch (KernelException kernelException) {
                throw new weblogic.jms.common.JMSException(kernelException);
            }
            try {
                queue.resume(16384);
            }
            catch (KernelException kernelException) {
                queue = null;
                throw new weblogic.jms.common.JMSException(kernelException);
            }
        }
        finally {
            if (queue != null) {
                HashMap hashMap2 = this.destinations;
                synchronized (hashMap2) {
                    this.destinations.put(string, queue);
                }
            }
        }
        return queue;
    }

    public synchronized void shutdown() throws JMSException {
        try {
            if (this.kernel != null) {
                this.kernel.close();
            }
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }
}

