/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.agent.internal;

import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.omg.CORBA.COMM_FAILURE;
import weblogic.jndi.ClientEnvironment;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public final class ClientEnvironmentImpl
implements ClientEnvironment {
    private static final String ICF = "weblogic.jndi.WLInitialContextFactory";
    private static final AbstractSubject kernelID = ClientEnvironmentImpl.getKernelIdentity();
    private Hashtable properties = new Hashtable();
    private AbstractSubject subject;
    private Context context;

    private static final AbstractSubject getKernelIdentity() {
        try {
            return (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    public ClientEnvironmentImpl() {
        this.properties.put("java.naming.factory.initial", ICF);
    }

    public void setProviderURL(String string) {
        if (string == null) {
            this.properties.remove("java.naming.provider.url");
            return;
        }
        this.properties.put("java.naming.provider.url", string);
    }

    public void setSecurityPrincipal(String string) {
        if (string == null) {
            this.properties.remove("java.naming.security.principal");
            return;
        }
        this.properties.put("java.naming.security.principal", string);
    }

    public void setSecurityCredentials(Object object) {
        if (object == null) {
            this.properties.remove("java.naming.security.credentials");
            return;
        }
        this.properties.put("java.naming.security.credentials", object);
    }

    public void setEnableServerAffinity(boolean bl) {
        this.properties.put("weblogic.jndi.enableServerAffinity", bl ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
    }

    public Context getContext() throws NamingException {
        if (this.context != null) {
            return this.context;
        }
        try {
            this.context = new InitialContext(this.properties);
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            throw new NamingException(cOMM_FAILURE.getMessage());
        }
        this.subject = SubjectManager.getSubjectManager().getCurrentSubject(kernelID);
        return this.context;
    }

    public AbstractSubject getSubject() {
        return this.subject;
    }

    public Hashtable getProperties() {
        return (Hashtable)this.properties.clone();
    }
}

