/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.jms;

import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.safclient.ClientSAFDelegate;
import weblogic.jms.safclient.jms.ConnectionImpl;
import weblogic.jms.safclient.jndi.Shutdownable;

public final class ConnectionFactoryImpl
implements QueueConnectionFactory,
TopicConnectionFactory,
Shutdownable {
    private String name;
    private String defaultDeliveryMode = "Persistent";
    private String defaultTimeToDeliver = "0";
    private long defaultTimeToLive = 0L;
    private int defaultPriority = 4;
    private long sendTimeout = 10L;
    private int defaultCompressionThreshold = Integer.MAX_VALUE;
    private String defaultUnitOfOrder = null;
    private String clientID = null;
    private boolean attach = false;
    private ClientSAFDelegate root;
    private HashMap connections = new HashMap();
    private int currentConnectionId;

    public ConnectionFactoryImpl(String string, ClientSAFDelegate clientSAFDelegate) {
        this.name = string;
        this.root = clientSAFDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection createConnection() throws JMSException {
        this.checkClosed();
        Integer n = new Integer(this.currentConnectionId++);
        ConnectionImpl connectionImpl = new ConnectionImpl(this, n);
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            this.connections.put(n, connectionImpl);
        }
        if (this.clientID != null) {
            connectionImpl.setClientID(this.clientID);
        }
        return connectionImpl;
    }

    public Connection createConnection(String string, String string2) throws JMSException {
        return this.createConnection();
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String string, String string2) throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosed(int n) {
        HashMap hashMap = this.connections;
        synchronized (hashMap) {
            this.connections.remove(new Integer(n));
        }
    }

    private void checkClosed() throws JMSException {
        if (!this.root.isOpened()) {
            throw new IllegalStateException("The client SAF system is closed");
        }
    }

    public void setJNDIName(String string) {
    }

    public void setLocalJNDIName(String string) {
    }

    public void setDefaultDeliveryMode(String string) {
        this.defaultDeliveryMode = string;
    }

    String getDefaultDeliveryMode() {
        return this.defaultDeliveryMode;
    }

    public void setDefaultTimeToDeliver(String string) {
        this.defaultTimeToDeliver = string;
    }

    String getDefaultTimeToDeliver() {
        return this.defaultTimeToDeliver;
    }

    public void setDefaultTimeToLive(long l) {
        this.defaultTimeToLive = l;
    }

    long getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    public void setDefaultPriority(int n) {
        this.defaultPriority = n;
    }

    int getDefaultPriority() {
        return this.defaultPriority;
    }

    public void setDefaultRedeliveryDelay(long l) {
    }

    public void setSendTimeout(long l) {
        this.sendTimeout = l;
    }

    long getSendTimeout() {
        return this.sendTimeout;
    }

    public void setDefaultCompressionThreshold(int n) {
        this.defaultCompressionThreshold = n;
    }

    int getDefaultCompressionThreshold() {
        return this.defaultCompressionThreshold;
    }

    public void setDefaultUnitOfOrder(String string) {
        this.defaultUnitOfOrder = string;
    }

    String getDefaultUnitOfOrder() {
        return this.defaultUnitOfOrder;
    }

    public void setClientId(String string) {
        this.clientID = string;
    }

    public void setAcknowledgePolicy(String string) {
    }

    public void setAllowCloseInOnMessage(boolean bl) {
    }

    public void setMessagesMaximum(int n) {
    }

    public void setMulticastOverrunPolicy(String string) {
    }

    public void setSynchronousPrefetchMode(String string) {
    }

    public void setXAConnectionFactoryEnabled(boolean bl) {
    }

    public void setAttachJMSXUserId(boolean bl) {
        this.attach = bl;
    }

    boolean getAttachJMSXUserId() {
        return this.attach;
    }

    ClientSAFDelegate getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(JMSException jMSException) {
        HashMap hashMap;
        Object object = this.connections;
        synchronized (object) {
            hashMap = (HashMap)this.connections.clone();
        }
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            ConnectionImpl connectionImpl = (ConnectionImpl)hashMap.get(object.next());
            connectionImpl.preClose(jMSException);
            try {
                connectionImpl.close();
            }
            catch (JMSException jMSException2) {}
        }
    }

    public String toString() {
        return "ConnectionFactory(" + this.name + "," + System.identityHashCode(this) + ")";
    }
}

