/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.jms;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.safclient.ClientSAFDelegate;
import weblogic.jms.safclient.jms.ConnectionFactoryImpl;
import weblogic.jms.safclient.jms.SessionImpl;

public final class ConnectionImpl
implements QueueConnection,
TopicConnection {
    private ConnectionFactoryImpl connectionFactory;
    private HashMap sessions = new HashMap();
    private int currentSessionId;
    private int id;
    private boolean closed = false;
    private boolean started = false;
    private ExceptionListener listener;
    private String clientID;

    ConnectionImpl(ConnectionFactoryImpl connectionFactoryImpl, int n) {
        this.connectionFactory = connectionFactoryImpl;
        this.id = n;
    }

    public synchronized QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        return (QueueSession)this.createSession(bl, n);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        throw new JMSException("No consumer allowed in client SAF implementation");
    }

    public TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        return (TopicSession)this.createSession(bl, n);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        throw new JMSException("No consumer allowed in client SAF implementation");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        throw new JMSException("No consumer allowed in client SAF implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(boolean bl, int n) throws JMSException {
        this.checkClosed();
        SessionImpl sessionImpl = new SessionImpl(this, this.currentSessionId, bl, n);
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.put(new Integer(this.currentSessionId), sessionImpl);
        }
        ++this.currentSessionId;
        return sessionImpl;
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.clientID;
    }

    public void setClientID(String string) throws JMSException {
        this.checkClosed();
        if (this.started) {
            throw new JMSException("ClientID cannot be set once the connection is started");
        }
        this.clientID = string;
    }

    public ConnectionMetaData getMetaData() {
        return new MetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.listener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.checkClosed();
        this.listener = exceptionListener;
    }

    public void start() throws JMSException {
        this.checkClosed();
        this.started = true;
    }

    public void stop() throws JMSException {
        this.checkClosed();
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Collection collection = this.sessions.values();
            for (Session session : collection) {
                session.close();
            }
            this.sessions.clear();
        }
        this.connectionFactory.connectionClosed(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preClose(JMSException jMSException) {
        HashMap hashMap;
        HashMap hashMap2 = this.sessions;
        synchronized (hashMap2) {
            hashMap = (HashMap)this.sessions.clone();
        }
        for (SessionImpl sessionImpl : hashMap.values()) {
            sessionImpl.preClose(jMSException);
        }
        if (this.listener != null) {
            try {
                this.listener.onException(jMSException);
            }
            catch (Throwable throwable) {
                int n = 0;
                for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
                    System.out.println("User onException listener threw an exception.  Level " + n++);
                    throwable2.printStackTrace();
                }
            }
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        throw new JMSException("No consumer allowed in client SAF implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionClosed(int n) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(new Integer(n));
        }
    }

    private void checkClosed() throws JMSException {
        if (!this.closed) {
            return;
        }
        throw new IllegalStateException("The connection has been closed");
    }

    String getDefaultTimeToDeliver() {
        return this.connectionFactory.getDefaultTimeToDeliver();
    }

    long getSendTimeout() {
        return this.connectionFactory.getSendTimeout();
    }

    String getDefaultUnitOfOrder() {
        return this.connectionFactory.getDefaultUnitOfOrder();
    }

    int getDefaultCompressionThreshold() {
        return this.connectionFactory.getDefaultCompressionThreshold();
    }

    String getDefaultDeliveryMode() {
        return this.connectionFactory.getDefaultDeliveryMode();
    }

    int getDefaultPriority() {
        return this.connectionFactory.getDefaultPriority();
    }

    long getDefaultTimeToLive() {
        return this.connectionFactory.getDefaultTimeToLive();
    }

    boolean getAttachJMSXUserId() {
        return this.connectionFactory.getAttachJMSXUserId();
    }

    ClientSAFDelegate getRoot() {
        return this.connectionFactory.getRoot();
    }

    public String toString() {
        return "ConnectionImpl(" + this.id + ")";
    }

    private static class MetaData
    implements ConnectionMetaData {
        private static final String JMS_PROVIDER_NAME = "BEA Systems, Inc.";
        private static final String PROVIDER_VERSION = "9.0.2";

        private MetaData() {
        }

        public String getJMSVersion() throws JMSException {
            return "1.0.2b";
        }

        public int getJMSMajorVersion() throws JMSException {
            return 1;
        }

        public int getJMSMinorVersion() throws JMSException {
            return 1;
        }

        public String getJMSProviderName() throws JMSException {
            return JMS_PROVIDER_NAME;
        }

        public String getProviderVersion() throws JMSException {
            return PROVIDER_VERSION;
        }

        public int getProviderMajorVersion() throws JMSException {
            return 9;
        }

        public int getProviderMinorVersion() throws JMSException {
            return 2;
        }

        public Enumeration getJMSXPropertyNames() throws JMSException {
            Vector<String> vector = new Vector<String>();
            vector.add("JMSXDeliveryCount");
            vector.add("JMSXGroupID");
            vector.add("JMSXGroupSeq");
            vector.add("JMSXUserID");
            return vector.elements();
        }
    }
}

