/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.jms;

import java.util.Random;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import weblogic.jms.client.JMSProducer;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.ProducerSendResponse;
import weblogic.jms.common.ResourceAllocationException;
import weblogic.jms.extensions.WLMessage;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.jms.safclient.ClientSAFDelegate;
import weblogic.jms.safclient.agent.DestinationImpl;
import weblogic.jms.safclient.jms.SessionImpl;
import weblogic.messaging.Message;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.QuotaException;
import weblogic.messaging.kernel.SendOptions;
import weblogic.transaction.TransactionHelper;

public final class MessageProducerImpl
implements TopicPublisher,
QueueSender,
WLMessageProducer {
    private static final String NON_PERSISTENT = "Non-Persistent";
    private SessionImpl session;
    private int id;
    private DestinationImpl destination;
    private long timeToDeliver;
    private int redeliveryLimit = -1;
    private long sendTimeout;
    private String unitOfOrder;
    private int compressionThreshold;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int deliveryMode;
    private int priority;
    private long timeToLive;
    private boolean closed = false;

    MessageProducerImpl(SessionImpl sessionImpl, int n, DestinationImpl destinationImpl) {
        this.session = sessionImpl;
        this.id = n;
        this.destination = destinationImpl;
        this.timeToDeliver = Long.parseLong(this.session.getDefaultTimeToDeliver());
        this.sendTimeout = this.session.getSendTimeout();
        this.unitOfOrder = this.session.getDefaultUnitOfOrder();
        this.compressionThreshold = this.session.getDefaultCompressionThreshold();
        this.deliveryMode = MessageProducerImpl.deliveryModeToInt(this.session.getDefaultDeliveryMode());
        this.priority = this.session.getDefaultPriority();
        this.timeToLive = this.session.getDefaultTimeToLive();
    }

    private static int deliveryModeToInt(String string) {
        if (NON_PERSISTENT.equals(string)) {
            return 1;
        }
        return 2;
    }

    public Topic getTopic() throws JMSException {
        this.checkClosed();
        if (this.destination == null) {
            return null;
        }
        if (!this.destination.isTopic()) {
            throw new weblogic.jms.common.JMSException("The destination for this message producer is not a topic");
        }
        return this.destination;
    }

    public void publish(javax.jms.Message message) throws JMSException {
        this.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void publish(javax.jms.Message message, int n, int n2, long l) throws JMSException {
        if (this.destination == null) {
            throw new weblogic.jms.common.JMSException("This is not a pinned message producer, cannot use this API");
        }
        this.send(this.destination, message, n, n2, l);
    }

    public void publish(Topic topic, javax.jms.Message message) throws JMSException {
        this.publish(topic, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void publish(Topic topic, javax.jms.Message message, int n, int n2, long l) throws JMSException {
        if (this.destination != null) {
            throw new weblogic.jms.common.JMSException("This is a pinned message producer, cannot use this API");
        }
        this.send((Destination)topic, message, n, n2, l);
    }

    public Queue getQueue() throws JMSException {
        this.checkClosed();
        if (this.destination == null) {
            return null;
        }
        if (!this.destination.isQueue()) {
            throw new weblogic.jms.common.JMSException("The destination for this message producer is not a queue");
        }
        return this.destination;
    }

    public void send(javax.jms.Message message) throws JMSException {
        this.send(message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(javax.jms.Message message, int n, int n2, long l) throws JMSException {
        if (this.destination == null) {
            throw new weblogic.jms.common.JMSException("This is not a pinned message producer, cannot use this API");
        }
        this.send(this.destination, message, n, n2, l);
    }

    public void send(Queue queue, javax.jms.Message message) throws JMSException {
        this.send(queue, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Queue queue, javax.jms.Message message, int n, int n2, long l) throws JMSException {
        this.send((Destination)queue, message, n, n2, l);
    }

    public long getTimeToDeliver() throws JMSException {
        this.checkClosed();
        return this.timeToDeliver;
    }

    public void setTimeToDeliver(long l) throws JMSException {
        this.checkClosed();
        this.timeToDeliver = l;
    }

    public int getRedeliveryLimit() throws JMSException {
        this.checkClosed();
        return this.redeliveryLimit;
    }

    public void setRedeliveryLimit(int n) throws JMSException {
        this.checkClosed();
        this.redeliveryLimit = n;
    }

    public long getSendTimeout() throws JMSException {
        this.checkClosed();
        return this.sendTimeout;
    }

    public void setSendTimeout(long l) throws JMSException {
        this.checkClosed();
        this.sendTimeout = l;
    }

    public String getUnitOfOrder() throws JMSException {
        this.checkClosed();
        return this.unitOfOrder;
    }

    public void setUnitOfOrder(String string) throws JMSException {
        this.checkClosed();
        this.unitOfOrder = string;
    }

    private static char intToHexChar(int n) {
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(97 + (n - 10));
    }

    private static String bitsToString(byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            return new String();
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n = by & 0xF;
            stringBuffer.append(MessageProducerImpl.intToHexChar(n));
            int n2 = by >> 4 & 0xF;
            stringBuffer.append(MessageProducerImpl.intToHexChar(n2));
        }
        return stringBuffer.toString();
    }

    public void setUnitOfOrder() throws JMSException {
        this.checkClosed();
        Random random = new Random();
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        this.setUnitOfOrder(MessageProducerImpl.bitsToString(byArray));
    }

    public void forward(javax.jms.Message message, int n, int n2, long l) throws JMSException {
        throw new weblogic.jms.common.JMSException("Not yet implemented");
    }

    public void forward(javax.jms.Message message) throws JMSException {
        throw new weblogic.jms.common.JMSException("Not yet implemented");
    }

    public void forward(Destination destination, javax.jms.Message message, int n, int n2, long l) throws JMSException {
        throw new weblogic.jms.common.JMSException("Not yet implemented");
    }

    public void forward(Destination destination, javax.jms.Message message) throws JMSException {
        throw new weblogic.jms.common.JMSException("Not yet implemented");
    }

    public void setCompressionThreshold(int n) throws JMSException {
        this.checkClosed();
        this.compressionThreshold = n;
    }

    public int getCompressionThreshold() throws JMSException {
        this.checkClosed();
        return this.compressionThreshold;
    }

    public void setDisableMessageID(boolean bl) throws JMSException {
        this.checkClosed();
        this.disableMessageID = bl;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = bl;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int n) throws JMSException {
        this.checkClosed();
        if (n != 2 && n != 1) {
            throw new weblogic.jms.common.JMSException("Invalid delivery mode: " + n);
        }
        this.deliveryMode = n;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.deliveryMode;
    }

    public void setPriority(int n) throws JMSException {
        this.checkClosed();
        this.priority = n;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.priority;
    }

    public void setTimeToLive(long l) throws JMSException {
        this.checkClosed();
        this.timeToLive = l;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.timeToLive;
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.destination;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.session.closeProducer(this.id);
    }

    public void send(Destination destination, javax.jms.Message message) throws JMSException {
        this.send(destination, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    private static long safeLongAdd(long l, long l2) {
        if (l > 0L && l2 > 0L) {
            long l3 = l + l2;
            if (l3 < 0L) {
                return Long.MAX_VALUE;
            }
            return l3;
        }
        if (l < 0L && l2 < 0L) {
            long l4 = l + l2;
            if (l4 >= 0L) {
                return Long.MIN_VALUE;
            }
            return l4;
        }
        return l + l2;
    }

    private void handleJMSMessagePreSend(MessageImpl messageImpl, boolean bl, long l, long l2, int n, boolean bl2, int n2, boolean bl3, String string) throws JMSException {
        messageImpl.resetUserPropertySize();
        if (!bl) {
            messageImpl.setForward(false);
            messageImpl.resetForwardsCount();
            messageImpl.setOldMessage(false);
            messageImpl.setJMSXUserID(null);
            messageImpl.setId(JMSMessageId.create());
        }
        messageImpl.setJMSExpiration(l);
        messageImpl.setDeliveryTime(l2);
        messageImpl.setJMSRedeliveryLimit(n);
        messageImpl.setJMSDestinationImpl(null);
        messageImpl.setJMSDeliveryMode(bl2 ? 2 : 1);
        messageImpl.setJMSPriority(n2);
        messageImpl.setDDForwarded(false);
        messageImpl.setDeliveryCount(0);
        messageImpl.requestJMSXUserID(bl3);
        messageImpl.setUnitOfOrderName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSend(ClientSAFDelegate clientSAFDelegate, SessionImpl sessionImpl, DestinationImpl destinationImpl, MessageImpl messageImpl, boolean bl, boolean bl2, int n, int n2, long l, long l2, long l3, boolean bl3, String string) throws JMSException {
        weblogic.messaging.kernel.Queue queue;
        SendOptions sendOptions = new SendOptions();
        sendOptions.setPersistent(bl2);
        if (n >= 0) {
            sendOptions.setRedeliveryLimit(n);
        }
        long l4 = -1L;
        long l5 = 0L;
        if (l > 0L) {
            l4 = System.currentTimeMillis();
            l5 = MessageProducerImpl.safeLongAdd(l4, l);
            sendOptions.setExpirationTime(l5);
        }
        long l6 = 0L;
        if (l2 > 0L) {
            if (l4 == -1L) {
                l4 = System.currentTimeMillis();
            }
            l6 = MessageProducerImpl.safeLongAdd(l4, l2);
            sendOptions.setDeliveryTime(l6);
        }
        if (l3 > 0L) {
            sendOptions.setTimeout(l3);
        }
        if ((queue = destinationImpl.getKernelQueue()) == null) {
            throw new weblogic.jms.common.JMSException("Failed to send messages -- client SAF is not properly started. Check client SAF configuration.");
        }
        MessageImpl messageImpl2 = null;
        if (messageImpl != null) {
            messageImpl2 = messageImpl.copy();
            this.handleJMSMessagePreSend(messageImpl2, bl, l5, l6, n, bl2, n2, bl3, string);
        }
        TransactionHelper transactionHelper = clientSAFDelegate.getTransactionHelper();
        TransactionHelper.pushTransactionHelper((TransactionHelper)transactionHelper);
        if (sessionImpl.getTransacted()) {
            sessionImpl.beginOrResume(transactionHelper);
        }
        try {
            KernelRequest kernelRequest;
            try {
                sendOptions.setSequence(queue.findOrCreateSequence(this.getSequenceName(messageImpl2, destinationImpl), this.getSequenceMode(messageImpl2, destinationImpl)));
                kernelRequest = queue.send((Message)messageImpl2, sendOptions);
            }
            catch (QuotaException quotaException) {
                throw new ResourceAllocationException(quotaException.toString(), quotaException);
            }
            catch (KernelException kernelException) {
                throw new weblogic.jms.common.JMSException(kernelException);
            }
            if (kernelRequest == null) {
                if (messageImpl2 != null) {
                    ProducerSendResponseImpl producerSendResponseImpl = new ProducerSendResponseImpl(messageImpl2.getId(), bl2, n2, l, l2, n);
                    JMSProducer.sendReturn(producerSendResponseImpl, messageImpl, messageImpl2, bl, l2, l, bl2 ? 2 : 1, n2, destinationImpl);
                }
                return;
            }
            try {
                kernelRequest.getResult();
            }
            catch (QuotaException quotaException) {
                throw new ResourceAllocationException(quotaException.toString(), quotaException);
            }
            catch (KernelException kernelException) {
                throw new weblogic.jms.common.JMSException(kernelException);
            }
            if (messageImpl2 != null) {
                ProducerSendResponseImpl producerSendResponseImpl = new ProducerSendResponseImpl(messageImpl2.getId(), bl2, n2, l, l2, n);
                JMSProducer.sendReturn(producerSendResponseImpl, messageImpl, messageImpl2, bl, l2, l, bl2 ? 2 : 1, n2, destinationImpl);
            }
        }
        finally {
            if (sessionImpl.getTransacted()) {
                sessionImpl.suspend(transactionHelper);
            }
            TransactionHelper.popTransactionHelper();
        }
    }

    public void send(Destination destination, javax.jms.Message message, int n, int n2, long l) throws JMSException {
        this.checkClosed();
        if (destination == null) {
            throw new weblogic.jms.common.JMSException("The destination is null");
        }
        if (!(destination instanceof DestinationImpl)) {
            throw new weblogic.jms.common.JMSException("The destination passed to the client SAF implementation must befrom the proper initial context.  However, this destination is of type: " + destination.getClass().getName());
        }
        MessageImpl messageImpl = null;
        if (message != null) {
            if (!(message instanceof MessageImpl)) {
                throw new weblogic.jms.common.JMSException("A message of an unknown type was found.  It is of type " + message.getClass().getName());
            }
            messageImpl = (MessageImpl)message;
        }
        this.internalSend(this.session.getRoot(), this.session, (DestinationImpl)destination, messageImpl, false, n == 2, this.redeliveryLimit, n2, l, this.timeToDeliver, this.sendTimeout, this.session.getAttachJMSXUserId(), this.unitOfOrder);
    }

    private synchronized void checkClosed() throws JMSException {
        if (!this.closed) {
            return;
        }
        throw new IllegalStateException("The message producer has been closed");
    }

    private String getSequenceName(WLMessage wLMessage, DestinationImpl destinationImpl) {
        String string = wLMessage.getSAFSequenceName();
        if (string != null) {
            return string;
        }
        return destinationImpl.getSequenceName();
    }

    protected int getSequenceMode(WLMessage wLMessage, DestinationImpl destinationImpl) {
        boolean bl;
        int n = ((MessageImpl)wLMessage).getJMSDeliveryMode();
        if (n == 1 && destinationImpl.getNonPersistentQOS() != "Exactly-Once") {
            return 0;
        }
        boolean bl2 = ((MessageImpl)wLMessage).isForwarded();
        boolean bl3 = bl = wLMessage.getSAFSeqNumber() != 0L;
        if (!bl || !bl2) {
            return 1;
        }
        return 2;
    }

    private static class ProducerSendResponseImpl
    implements ProducerSendResponse {
        private JMSMessageId messageID;
        private boolean persistent;
        private int priority;
        private long timeToLive;
        private long timeToDeliver;
        private int redeliveryLimit;

        private ProducerSendResponseImpl(JMSMessageId jMSMessageId, boolean bl, int n, long l, long l2, int n2) {
            this.messageID = jMSMessageId;
            this.persistent = bl;
            this.priority = n;
            this.timeToLive = l;
            this.timeToDeliver = l2;
            this.redeliveryLimit = n2;
        }

        public JMSMessageId getMessageId() {
            return this.messageID;
        }

        public boolean get90StyleMessageId() {
            return true;
        }

        public int getDeliveryMode() {
            return this.persistent ? 2 : 1;
        }

        public int getPriority() {
            return this.priority;
        }

        public long getTimeToLive() {
            return this.timeToLive > 0L ? this.timeToLive : -1L;
        }

        public long getTimeToDeliver() {
            return this.timeToDeliver > 0L ? this.timeToDeliver : -1L;
        }

        public int getRedeliveryLimit() {
            return this.redeliveryLimit;
        }
    }
}

