/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.safclient.jms;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.w3c.dom.Document;
import weblogic.jms.common.IllegalStateException;
import weblogic.jms.extensions.JMSMessageFactoryImpl;
import weblogic.jms.extensions.WLAcknowledgeInfo;
import weblogic.jms.extensions.WLMessageFactory;
import weblogic.jms.extensions.WLQueueSession;
import weblogic.jms.extensions.WLTopicSession;
import weblogic.jms.extensions.XMLMessage;
import weblogic.jms.safclient.ClientSAFDelegate;
import weblogic.jms.safclient.agent.AgentManager;
import weblogic.jms.safclient.agent.DestinationImpl;
import weblogic.jms.safclient.jms.ConnectionImpl;
import weblogic.jms.safclient.jms.MessageProducerImpl;
import weblogic.transaction.ClientTransactionManager;
import weblogic.transaction.TransactionHelper;

public final class SessionImpl
implements WLQueueSession,
WLTopicSession {
    private static final WLMessageFactory MESSAGEFACTORY = JMSMessageFactoryImpl.getFactory();
    private int id;
    private ConnectionImpl connection;
    private boolean closed = false;
    private ExceptionListener exceptionListener;
    private boolean transacted;
    private int acknowledgeMode;
    private int currentID;
    private HashMap producers = new HashMap();
    private boolean inTx = false;
    private Transaction transaction;

    public SessionImpl(ConnectionImpl connectionImpl, int n, boolean bl, int n2) {
        this.connection = connectionImpl;
        this.id = n;
        this.transacted = bl;
        this.acknowledgeMode = n2;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public int getMessagesMaximum() throws JMSException {
        throw new JMSException("No consumers allowed in client SAF");
    }

    public void setMessagesMaximum(int n) throws JMSException {
        throw new JMSException("No consumers allowed in client SAF");
    }

    public int getOverrunPolicy() throws JMSException {
        throw new JMSException("No consumers allowed in client SAF");
    }

    public void setOverrunPolicy(int n) throws JMSException {
        throw new JMSException("No consumers allowed in client SAF");
    }

    public long getRedeliveryDelay() throws JMSException {
        throw new JMSException("No consumers allowed in client SAF");
    }

    public void setRedeliveryDelay(long l) throws JMSException {
        throw new JMSException("No consumers allowed in client SAF");
    }

    public void acknowledge() throws JMSException {
        throw new JMSException("No consumers allowed in the client SAF implementation");
    }

    public void acknowledge(Message message) throws JMSException {
        throw new JMSException("No consumers allowed in the client SAF implementation");
    }

    public void acknowledge(WLAcknowledgeInfo wLAcknowledgeInfo) throws JMSException {
        throw new JMSException("No consumers allowed in the client SAF implementation");
    }

    public Topic createTopic(String string) throws JMSException {
        DestinationImpl destinationImpl = this.createDestination(string);
        if (!destinationImpl.isTopic()) {
            throw new JMSException(string + " is a queue");
        }
        return destinationImpl;
    }

    private DestinationImpl createDestination(String string) throws JMSException {
        this.checkClosed();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "!");
        if (stringTokenizer.countTokens() != 2) {
            throw new JMSException("Invalid format for createDestination.  Must beSAFImportedDestinationsName + '!' + DestinationName");
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        ClientSAFDelegate clientSAFDelegate = this.connection.getRoot();
        AgentManager agentManager = clientSAFDelegate.getAgentManager();
        return agentManager.getDestination(string2, string3);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        throw new JMSException("No subscriptions allowed in the client SAF implementation");
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        throw new JMSException("No subscriptions allowed in the client SAF implementation");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        throw new JMSException("No subscriptions allowed in the client SAF implementation");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        throw new JMSException("No subscriptions allowed in the client SAF implementation");
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return (TopicPublisher)this.createProducer((Destination)topic);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        throw new JMSException("No temporary destination allowed in the client SAF implementation");
    }

    public void unsubscribe(String string) throws JMSException {
        throw new JMSException("No subscriptions allowed in the client SAF implementation");
    }

    public void unsubscribe(Topic topic, String string) throws JMSException {
        throw new JMSException("No subscriptions allowed in the client SAF implementation");
    }

    public Queue createQueue(String string) throws JMSException {
        DestinationImpl destinationImpl = this.createDestination(string);
        if (!destinationImpl.isQueue()) {
            throw new JMSException(string + " is a topic");
        }
        return destinationImpl;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        throw new JMSException("No receiver allowed in the client SAF implementation");
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        throw new JMSException("No receiver allowed in the client SAF implementation");
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return (QueueSender)this.createProducer((Destination)queue);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        throw new JMSException("No browser allowed in the client SAF implementation");
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        throw new JMSException("No browser allowed in the client SAF implementation");
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        throw new JMSException("No temporary destination allowed in the client SAF implementation");
    }

    public XMLMessage createXMLMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createXMLMessage();
    }

    public XMLMessage createXMLMessage(String string) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createXMLMessage(string);
    }

    public XMLMessage createXMLMessage(Document document) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createXMLMessage(document);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        this.checkClosed();
        return MESSAGEFACTORY.createTextMessage(string);
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.transacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.acknowledgeMode;
    }

    synchronized void beginOrResume(TransactionHelper transactionHelper) throws JMSException {
        try {
            if (!this.inTx) {
                ClientTransactionManager clientTransactionManager = transactionHelper.getTransactionManager();
                clientTransactionManager.begin();
                this.inTx = true;
            } else if (this.transaction != null) {
                ClientTransactionManager clientTransactionManager = transactionHelper.getTransactionManager();
                clientTransactionManager.resume(this.transaction);
                this.transaction = null;
            }
        }
        catch (NotSupportedException notSupportedException) {
            throw new weblogic.jms.common.JMSException(notSupportedException);
        }
        catch (SystemException systemException) {
            throw new weblogic.jms.common.JMSException(systemException);
        }
        catch (InvalidTransactionException invalidTransactionException) {
            throw new weblogic.jms.common.JMSException(invalidTransactionException);
        }
    }

    synchronized void suspend(TransactionHelper transactionHelper) throws JMSException {
        if (!this.inTx) {
            return;
        }
        if (this.transaction != null) {
            return;
        }
        ClientTransactionManager clientTransactionManager = transactionHelper.getTransactionManager();
        try {
            this.transaction = clientTransactionManager.suspend();
        }
        catch (SystemException systemException) {
            throw new weblogic.jms.common.JMSException(systemException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws JMSException {
        if (!this.transacted) {
            throw new JMSException("This is not a transacted session");
        }
        ClientSAFDelegate clientSAFDelegate = this.getRoot();
        TransactionHelper transactionHelper = clientSAFDelegate.getTransactionHelper();
        TransactionHelper.pushTransactionHelper((TransactionHelper)transactionHelper);
        try {
            this.beginOrResume(transactionHelper);
            ClientTransactionManager clientTransactionManager = transactionHelper.getTransactionManager();
            try {
                clientTransactionManager.commit();
            }
            catch (RollbackException rollbackException) {
                throw new weblogic.jms.common.JMSException(rollbackException);
            }
            catch (HeuristicMixedException heuristicMixedException) {
                throw new weblogic.jms.common.JMSException(heuristicMixedException);
            }
            catch (HeuristicRollbackException heuristicRollbackException) {
                throw new weblogic.jms.common.JMSException(heuristicRollbackException);
            }
            catch (SystemException systemException) {
                throw new weblogic.jms.common.JMSException(systemException);
            }
        }
        finally {
            this.inTx = false;
            TransactionHelper.popTransactionHelper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws JMSException {
        if (!this.transacted) {
            throw new JMSException("This is not a transacted session");
        }
        ClientSAFDelegate clientSAFDelegate = this.getRoot();
        TransactionHelper transactionHelper = clientSAFDelegate.getTransactionHelper();
        TransactionHelper.pushTransactionHelper((TransactionHelper)transactionHelper);
        try {
            this.beginOrResume(transactionHelper);
            ClientTransactionManager clientTransactionManager = transactionHelper.getTransactionManager();
            try {
                clientTransactionManager.rollback();
            }
            catch (SystemException systemException) {
                throw new weblogic.jms.common.JMSException(systemException);
            }
        }
        finally {
            this.inTx = false;
            TransactionHelper.popTransactionHelper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        HashMap hashMap = this.producers;
        synchronized (hashMap) {
            Collection collection = this.producers.values();
            for (MessageProducer messageProducer : collection) {
                messageProducer.close();
            }
            this.producers.clear();
        }
        this.connection.sessionClosed(this.id);
    }

    void preClose(JMSException jMSException) {
        if (this.exceptionListener != null) {
            try {
                this.exceptionListener.onException(jMSException);
            }
            catch (Throwable throwable) {
                int n = 0;
                for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
                    System.out.println("User onException listener threw an exception.  Level " + n++);
                    throwable2.printStackTrace();
                }
            }
        }
    }

    public void recover() throws JMSException {
        throw new JMSException("Not yet implemented");
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new JMSException("No listener allowed in client SAF implementation");
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        throw new JMSException("No listener allowed in client SAF implementation");
    }

    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkClosed();
        if (destination != null && !(destination instanceof DestinationImpl)) {
            throw new JMSException("The destination passed into the client SAF implementation must be from the file context.  This destination is of type " + destination.getClass().getName());
        }
        MessageProducerImpl messageProducerImpl = new MessageProducerImpl(this, this.currentID, (DestinationImpl)destination);
        HashMap hashMap = this.producers;
        synchronized (hashMap) {
            this.producers.put(new Integer(this.currentID), messageProducerImpl);
        }
        ++this.currentID;
        return messageProducerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeProducer(int n) {
        Integer n2 = new Integer(n);
        HashMap hashMap = this.producers;
        synchronized (hashMap) {
            this.producers.remove(n2);
        }
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        throw new JMSException("No consumer allowed in client SAF implementation");
    }

    public MessageConsumer createConsumer(Destination destination, String string) throws JMSException {
        throw new JMSException("No consumer allowed in client SAF implementation");
    }

    public MessageConsumer createConsumer(Destination destination, String string, boolean bl) throws JMSException {
        throw new JMSException("No consumer allowed in client SAF implementation");
    }

    private synchronized void checkClosed() throws JMSException {
        if (!this.closed) {
            return;
        }
        throw new IllegalStateException("The session has been closed");
    }

    String getDefaultTimeToDeliver() {
        return this.connection.getDefaultTimeToDeliver();
    }

    long getSendTimeout() {
        return this.connection.getSendTimeout();
    }

    String getDefaultUnitOfOrder() {
        return this.connection.getDefaultUnitOfOrder();
    }

    int getDefaultCompressionThreshold() {
        return this.connection.getDefaultCompressionThreshold();
    }

    String getDefaultDeliveryMode() {
        return this.connection.getDefaultDeliveryMode();
    }

    int getDefaultPriority() {
        return this.connection.getDefaultPriority();
    }

    long getDefaultTimeToLive() {
        return this.connection.getDefaultTimeToLive();
    }

    boolean getAttachJMSXUserId() {
        return this.connection.getAttachJMSXUserId();
    }

    ClientSAFDelegate getRoot() {
        return this.connection.getRoot();
    }
}

